/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.bean.SubjectOrgEntity;
import com.ejianc.foundation.share.service.ISubjectOrgService;
import com.ejianc.foundation.share.service.ISubjectProjectService;
import com.ejianc.foundation.share.vo.SubjectOrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"subjectOrg"})
public class SubjectOrgController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IBillTypeApi billTypeApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private ISubjectOrgService service;
    @Autowired
    private ISubjectProjectService subjectProjectService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SubjectOrgVO> saveOrUpdate(@RequestBody SubjectOrgVO saveorUpdateVO) {
        return this.service.saveOrUpdate(saveorUpdateVO);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SubjectOrgVO> queryDetail(Long id) {
        SubjectOrgEntity entity = (SubjectOrgEntity)((Object)this.service.selectById(id));
        SubjectOrgVO vo = (SubjectOrgVO)BeanMapper.map((Object)((Object)entity), SubjectOrgVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @GetMapping(value={"/queryByCodeAndName"})
    @ResponseBody
    public CommonResponse<SubjectOrgVO> queryByCodeAndName(@RequestParam(value="code") String code, @RequestParam(value="name") String name) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"subject_code", (Object)code);
        query.eq((Object)"subject_name", (Object)name);
        SubjectOrgEntity entity = (SubjectOrgEntity)((Object)this.service.getOne((Wrapper)query));
        if (null != entity) {
            return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)BeanMapper.map((Object)((Object)entity), SubjectOrgVO.class));
        }
        return CommonResponse.error((String)"\u914d\u627e\u5230\u5339\u914d\u7684\u96c6\u56e2\u6210\u672c\u79d1\u76ee\u4fe1\u606f\uff01");
    }

    @RequestMapping(value={"/updateEn"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SubjectOrgVO> updateEn(@RequestBody SubjectOrgVO saveorUpdateVO) {
        return this.service.updateEn(saveorUpdateVO);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody SubjectOrgVO vo) {
        List ids = vo.getIds();
        if (ListUtil.isNotEmpty((List)ids)) {
            for (Long id : ids) {
                CommonResponse resp = this.billTypeApi.checkQuote("EJCBT202206000016", id);
                if (resp.isSuccess()) continue;
                return CommonResponse.error((String)("\u5220\u9664\u5931\u8d25\uff01" + resp.getMsg()));
            }
            this.service.removeByIds(ids);
        }
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("subjectName");
        fuzzyFields.add("subjectCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("subjectCode", "asc");
        List list = this.service.queryList(param, false);
        List resultMapList = BeanMapper.mapList((Iterable)list, Map.class);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("records", (Object)ResultAsTree.createTreeData((List)resultMapList));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)jsonObject);
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"subjectOrg-export.xlsx", (String)"\u96c6\u56e2\u6210\u672c\u79d1\u76ee\u5bfc\u51fa\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        return this.service.excelImport(request, response);
    }

    @RequestMapping(value={"/saveImportExcel"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveImportExcel(HttpServletRequest request, @RequestBody List<SubjectOrgVO> importVOS) {
        return CommonResponse.success((String)((String)this.service.saveImportExcel(request, importVOS)));
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("SubjectOrg-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refSubjectOrgData"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Map<String, Object>> refSubjectOrgData(@RequestParam(value="searchText", required=false) String searchText, @RequestParam(value="condition", required=false) String condition) {
        JSONObject _con;
        QueryParam param = new QueryParam();
        param.setSearchText(searchText);
        param.getFuzzyFields().add("subjectName");
        param.getFuzzyFields().add("subjectCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("enabled", new Parameter("eq", (Object)1));
        if (StringUtils.isNotEmpty((CharSequence)condition) && (_con = JSONObject.parseObject((String)condition)).containsKey((Object)"innerCode")) {
            param.getParams().put("innerCode", new Parameter("like", _con.get((Object)"innerCode")));
        }
        param.getOrderMap().put("subjectCode", "asc");
        List list = this.service.queryList(param, false);
        ArrayList resultMapList = new ArrayList();
        HashMap<String, Object> map = null;
        for (SubjectOrgEntity entity : list) {
            map = new HashMap<String, Object>();
            map.put("id", entity.getId());
            map.put("key", entity.getId());
            map.put("name", entity.getSubjectName());
            map.put("code", entity.getSubjectCode());
            map.put("parentId", entity.getParentId());
            map.put("memo", entity.getMemo());
            map.put("innerCode", entity.getInnerCode());
            resultMapList.add(map);
        }
        return ResultAsTree.createTreeData(resultMapList);
    }
}

