/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.supplier.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.share.bean.SupplierCategoryEntity;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.supplier.service.ISuplCategoryService;
import com.ejianc.foundation.supplier.service.ISuplSupplierService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.service.IBankAccountService;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"sub/supplier"})
public class SubSupplierController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Integer BILL_TYPE = 2;
    @Autowired
    private ISuplSupplierService supplierService;
    @Autowired
    private ISuplCategoryService categoryService;
    @Autowired
    private IBankAccountService bankAccountService;
    @Autowired
    private IBillTypeApi billTypeApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SupplierVO> saveOrUpdate(@RequestBody SupplierVO supplierVo) {
        if (supplierVo.getCategoryId() == null) {
            return CommonResponse.error((String)"\u4f9b\u65b9\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        CommonResponse<SupplierVO> response = this.supplierService.saveOrUpdate(supplierVo);
        return response;
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SupplierVO> queryDetail(@RequestParam Long id) {
        SupplierVO supplierVo = this.supplierService.queryDetail(id);
        JSONObject parent = new JSONObject();
        SupplierCategoryEntity e = (SupplierCategoryEntity)((Object)this.categoryService.selectById(supplierVo.getCategoryId()));
        parent.put("id", (Object)e.getId());
        parent.put("code", (Object)e.getCode());
        parent.put("name", (Object)e.getName());
        supplierVo.setParent(parent);
        return CommonResponse.success((Object)supplierVo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        if (ListUtil.isNotEmpty(ids)) {
            this.bankAccountService.delBySuppAndCustomIds("supplierId", ids);
            for (Long id : ids) {
                CommonResponse response = this.billTypeApi.checkQuote("BT200422000000028", id);
                if (response.isSuccess()) continue;
                return CommonResponse.error((String)("\u5220\u9664\u5931\u8d25\uff1a" + response.getMsg()));
            }
        } else {
            return CommonResponse.error((String)"\u5220\u9664\u5931\u8d25\uff1a\u4e3b\u952e\u4e3a\u7a7a!");
        }
        this.supplierService.deleteSupplier(ids);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/pageList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam queryParam) {
        IPage<SupplierVO> pageData = this.supplierService.queryPageList(queryParam, BILL_TYPE);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", pageData);
        return CommonResponse.success((Object)jsonObject);
    }

    @RequestMapping(value={"/refSupplierPage"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SupplierVO>> refSupplierPage(@RequestParam(defaultValue="1") int pageNumber, @RequestParam(defaultValue="10") int pageSize, @RequestParam(required=false) String relyCondition, @RequestParam(required=false) String searchText, @RequestParam(required=false) String condition) {
        Long categoryId;
        SupplierCategoryEntity supplierCategoryEntity;
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        queryParam.getFuzzyFields().add("code");
        queryParam.getFuzzyFields().add("name");
        queryParam.getFuzzyFields().add("socialCreditCode");
        queryParam.getFuzzyFields().add("legal");
        if (StringUtils.isNotBlank((CharSequence)relyCondition) && (supplierCategoryEntity = this.categoryService.queryDetail(categoryId = Long.valueOf(Long.parseLong(relyCondition.split("=")[1])))) != null) {
            queryParam.getParams().put("categoryId", new Parameter("eq", (Object)categoryId));
        }
        queryParam.getParams().put("insideOrgId", new Parameter("eq", null));
        IPage<SupplierVO> pageData = this.supplierService.queryPageList(queryParam, BILL_TYPE);
        return CommonResponse.success((String)"\u53c2\u7167\u67e5\u8be2\u6210\u529f\uff01", pageData);
    }

    @RequestMapping(value={"/refInsideSupplierPage"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SupplierVO>> refInsideSupplierPage(@RequestParam(defaultValue="1") int pageNumber, @RequestParam(defaultValue="10") int pageSize, @RequestParam(required=false) String relyCondition, @RequestParam(required=false) String searchText, @RequestParam(required=false) String condition) {
        Long categoryId;
        SupplierCategoryEntity supplierCategoryEntity;
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        queryParam.getFuzzyFields().add("code");
        queryParam.getFuzzyFields().add("name");
        queryParam.getFuzzyFields().add("socialCreditCode");
        queryParam.getFuzzyFields().add("legal");
        if (StringUtils.isNotBlank((CharSequence)relyCondition) && (supplierCategoryEntity = this.categoryService.queryDetail(categoryId = Long.valueOf(Long.parseLong(relyCondition.split("=")[1])))) != null) {
            queryParam.getParams().put("categoryId", new Parameter("eq", (Object)categoryId));
        }
        queryParam.getParams().put("insideOrgId", new Parameter("ne", null));
        IPage<SupplierVO> pageData = this.supplierService.queryPageList(queryParam, BILL_TYPE);
        return CommonResponse.success((String)"\u53c2\u7167\u67e5\u8be2\u6210\u529f\uff01", pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        List<SupplierVO> list = this.supplierService.excelExport(queryParam, BILL_TYPE);
        HashMap<String, List<SupplierVO>> beans = new HashMap<String, List<SupplierVO>>();
        beans.put("records", list);
        ExcelExport.getInstance().export("supl-supplier-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/saveBlackList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveBlackList(@RequestBody List<Long> ids) {
        if (!ListUtil.isNotEmpty(ids)) {
            return CommonResponse.error((String)"\u79fb\u5165\u9ed1\u540d\u5355\u5931\u8d25\uff1a\u4e3b\u952e\u4e3a\u7a7a!");
        }
        this.supplierService.saveBlackList(ids);
        return CommonResponse.success((String)"\u79fb\u5165\u9ed1\u540d\u5355\u6210\u529f");
    }

    @RequestMapping(value={"/delBlackList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delBlackList(@RequestBody List<SupplierVO> vos) {
        List<Long> ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        if (!ListUtil.isNotEmpty(ids)) {
            return CommonResponse.error((String)"\u79fb\u51fa\u9ed1\u540d\u5355\u5931\u8d25\uff1a\u4e3b\u952e\u4e3a\u7a7a!");
        }
        this.supplierService.delBlackList(ids);
        return CommonResponse.success((String)"\u79fb\u51fa\u9ed1\u540d\u5355\u6210\u529f");
    }

    @RequestMapping(value={"/saveRedList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveRedList(@RequestBody List<Long> ids) {
        if (!ListUtil.isNotEmpty(ids)) {
            return CommonResponse.error((String)"\u52a0\u5165\u7ea2\u540d\u5355\u5931\u8d25\uff1a\u4e3b\u952e\u4e3a\u7a7a!");
        }
        this.supplierService.saveRedList(ids);
        return CommonResponse.success((String)"\u52a0\u5165\u7ea2\u540d\u5355\u6210\u529f");
    }

    @RequestMapping(value={"/delRedList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delRedList(@RequestBody List<Long> ids) {
        if (!ListUtil.isNotEmpty(ids)) {
            return CommonResponse.error((String)"\u79fb\u51fa\u7ea2\u540d\u5355\u5931\u8d25\uff1a\u4e3b\u952e\u4e3a\u7a7a!");
        }
        this.supplierService.delRedList(ids);
        return CommonResponse.success((String)"\u79fb\u51fa\u7ea2\u540d\u5355\u6210\u529f");
    }

    @RequestMapping(value={"/queryBlackList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SupplierVO>> queryBlackList(@RequestBody QueryParam param) {
        IPage<SupplierVO> pageData = this.supplierService.queryBlackList(param, BILL_TYPE);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", pageData);
    }

    @RequestMapping(value={"/blackExcelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void blackExcelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        List<SupplierVO> list = this.supplierService.blackExcelExport(queryParam, BILL_TYPE);
        HashMap<String, List<SupplierVO>> beans = new HashMap<String, List<SupplierVO>>();
        beans.put("records", list);
        ExcelExport.getInstance().export("blackList-export.xlsx", beans, response);
    }
}

