package com.ejianc.foundation.share.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.share.vo.LabsubItemVO;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.foundation.share.bean.LabsubItemEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 劳务分包档案
 * 
 * @author generator
 * 
 */
@Mapper
public interface LabsubItemMapper extends BaseCrudMapper<LabsubItemEntity> {

    int updateByCategoryId(@Param("categoryId") Long categoryId, @Param("subjectId") Long subjectId, @Param("subjectName") String subjectName);

    List<LabsubItemVO> queryProsubItemList(Page<LabsubItemVO> page, @Param(Constants.WRAPPER) QueryWrapper wrapper);

    // 根据ID查询数据，left join劳务分包档案分类表"ejc_share_labsub_category"
    List<Map<String, Object>> queryLabItemListByIds(@Param("idList") List<Long> idList, @Param("tenantId") Long tenantId);

    // 根据分类ID查询分类表数据
    List<Map<String, Object>> queryLabCategoryListByCategoryIds(@Param("categoryIdList") List<Long> categoryIdList, @Param("tenantId") Long tenantId);
}
