/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.share.bean.EjcCloudSystemEntity;
import com.ejianc.foundation.share.bean.SubleadersEntity;
import com.ejianc.foundation.share.bean.SupplierEntity;
import com.ejianc.foundation.share.service.IEjcCloudSystemService;
import com.ejianc.foundation.share.service.ISubleadersService;
import com.ejianc.foundation.share.service.ISupplierService;
import com.ejianc.foundation.share.vo.PunishVO;
import com.ejianc.foundation.share.vo.SubleadersPushVO;
import com.ejianc.foundation.share.vo.SubleadersVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/shareSupplierApi/"})
public class SupplierApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISupplierService supplierService;
    @Autowired
    private IEjcCloudSystemService ejcCloudSystemService;
    @Autowired
    private ISubleadersService subleadersService;

    @GetMapping(value={"queryById"})
    CommonResponse<SupplierVO> queryById(@RequestParam(value="id") Long id) {
        SupplierVO vo = this.supplierService.queryDetail(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)vo);
    }

    @GetMapping(value={"querySupplierByIds"})
    CommonResponse<List<SupplierVO>> querySupplierByIds(@RequestParam(value="ids") List<Long> ids) {
        List vos = new ArrayList();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.in((Object)"id", ids);
        List entitys = this.supplierService.list((Wrapper)queryWrapper);
        if (entitys != null) {
            vos = BeanMapper.mapList((Iterable)entitys, SupplierVO.class);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", vos);
    }

    @GetMapping(value={"findOneByName"})
    CommonResponse<SupplierVO> findOneByName(@RequestParam(value="name") String name, @RequestParam(value="tenantId") Long tenantId) {
        SupplierVO vo = null;
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("name", new Parameter("eq", (Object)name));
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)tenantId));
        List list = this.supplierService.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            vo = (SupplierVO)BeanMapper.map(list.get(0), SupplierVO.class);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", vo);
    }

    @PostMapping(value={"pushSupplierToShare"})
    public CommonResponse<String> pushSupplierToShare(@RequestBody byte[] supplyByte) {
        String supplyStr = new String(supplyByte, StandardCharsets.UTF_8);
        this.logger.info("\u63a8\u9001\uff0c\u751f\u6210\u4f01\u4e1a\u4f9b\u5e94\u5546pushSupplierToShare---{}", (Object)supplyStr);
        SupplierVO supplierVO = (SupplierVO)JSONObject.parseObject((String)supplyStr, SupplierVO.class);
        QueryParam param = new QueryParam();
        param.getParams().put("taxPayerIdentifier", new Parameter("eq", (Object)supplierVO.getTaxPayerIdentifier()));
        if (ListUtil.isNotEmpty((List)this.supplierService.queryList(param))) {
            if (supplierVO.getPersonal().equals("p")) {
                return CommonResponse.error((String)("\u4f9b\u5e94\u5546\u5e93\u5df2\u5b58\u5728\u8eab\u4efd\u8bc1\u53f7\u4e3a\u3010" + supplierVO.getTaxPayerIdentifier() + "\u3011\u7684\u4f9b\u5e94\u5546\uff01"));
            }
            return CommonResponse.error((String)("\u4f9b\u5e94\u5546\u5e93\u5df2\u5b58\u5728\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u4e3a\u3010" + supplierVO.getTaxPayerIdentifier() + "\u3011\u7684\u4f9b\u5e94\u5546\uff01"));
        }
        supplierVO.setEnabled(Integer.valueOf(1));
        supplierVO.setInsideOrg(Boolean.valueOf(false));
        SupplierEntity se = (SupplierEntity)((Object)BeanMapper.map((Object)supplierVO, SupplierEntity.class));
        Boolean coordination = se.getCoordination();
        if (coordination == null) {
            se.setCoordination(false);
        }
        this.supplierService.saveOrUpdate((Object)se, false);
        se = this.supplierService.generateSupplierTenant(se);
        this.supplierService.saveOrUpdate((Object)se, false);
        if ("laborSub".equals(se.getSupplyQueryType()) && ListUtil.isNotEmpty(se.getSubLeaders())) {
            for (SubleadersEntity subLeader : se.getSubLeaders()) {
                this.supplierService.generateSubSupplierTenant(subLeader, se);
                this.subleadersService.saveOrUpdate((Object)subLeader);
            }
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @PostMapping(value={"judgeTaxpayerNumIsRepeat"})
    public CommonResponse<String> judgeTaxpayerNumIsRepeat(@RequestParam String taxpayerNum, @RequestParam String personal) {
        QueryParam param = new QueryParam();
        param.getParams().put("taxPayerIdentifier", new Parameter("eq", (Object)taxpayerNum));
        if (ListUtil.isNotEmpty((List)this.supplierService.queryList(param))) {
            if ("p".equals(personal)) {
                return CommonResponse.error((String)("\u4f9b\u5e94\u5546\u5e93\u5df2\u5b58\u5728\u8eab\u4efd\u8bc1\u53f7\u4e3a\u3010" + taxpayerNum + "\u3011\u7684\u4e2a\u4eba\u4f9b\u5e94\u5546\uff01"));
            }
            return CommonResponse.error((String)("\u4f9b\u5e94\u5546\u5e93\u5df2\u5b58\u5728\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u4e3a\u3010" + taxpayerNum + "\u3011\u7684\u4f01\u4e1a\u4f9b\u5e94\u5546\uff01"));
        }
        return CommonResponse.success((String)"\u4f9b\u5e94\u5546\u4e0d\u91cd\u590d\uff01");
    }

    @PostMapping(value={"pushSubLeadersToShare"})
    public CommonResponse<String> pushSubLeadersToShare(@RequestBody SubleadersPushVO pushVO) {
        this.logger.info("\u5206\u5305\u8d1f\u8d23\u4eba\u63a8\u9001\uff0c\u751f\u6210\u4f01\u4e1a\u4f9b\u5e94\u5546pushSupplierToShare---{}", (Object)JSONObject.toJSONString((Object)pushVO));
        SupplierEntity se = (SupplierEntity)((Object)this.supplierService.selectById(pushVO.getSupplierId()));
        if (se == null) {
            return CommonResponse.error((String)"\u6ca1\u6709\u627e\u5230\u5206\u5305\u8d1f\u8d23\u4eba\u6240\u5728\u4f9b\u5e94\u5546");
        }
        if (ListUtil.isEmpty((List)pushVO.getSubLeaders())) {
            return CommonResponse.error((String)"\u8981\u51c6\u5165\u7684\u5206\u5305\u8d1f\u8d23\u4eba\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Boolean coordination = se.getCoordination();
        if (coordination == null) {
            se.setCoordination(false);
        }
        for (SubleadersVO subleadersVO : pushVO.getSubLeaders()) {
            SubleadersEntity subLeader = (SubleadersEntity)((Object)BeanMapper.map((Object)subleadersVO, SubleadersEntity.class));
            this.supplierService.generateSubSupplierTenant(subLeader, se);
            subLeader.setPid(se.getId());
            this.subleadersService.saveOrUpdate((Object)subLeader);
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @PostMapping(value={"punishSupplier"})
    public CommonResponse<String> punishSupplier(@RequestBody PunishVO punishVO) {
        SupplierEntity supplierEntity = (SupplierEntity)((Object)this.supplierService.selectById(punishVO.getSupplierId()));
        if (supplierEntity == null) {
            return CommonResponse.error((String)"\u4f9b\u5e94\u5546\u4e0d\u5b58\u5728\uff01");
        }
        if (punishVO.getSubLeaderId() == null) {
            BeanUtils.copyProperties((Object)punishVO, (Object)((Object)supplierEntity));
            supplierEntity.setGradeId(punishVO.getPunishGradeId());
            supplierEntity.setGradeName(punishVO.getPunishGrade());
            supplierEntity.setInException(true);
            this.supplierService.saveOrUpdate((Object)supplierEntity, false);
        } else {
            if (ListUtil.isEmpty(supplierEntity.getSubLeaders())) {
                return CommonResponse.error((String)"\u5206\u5305\u8d1f\u8d23\u4eba\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u5904\u7f6e\uff01");
            }
            SubleadersEntity leader = null;
            for (SubleadersEntity subLeader : supplierEntity.getSubLeaders()) {
                if (!punishVO.getSubLeaderId().equals(subLeader.getId())) continue;
                leader = subLeader;
            }
            if (leader == null) {
                return CommonResponse.error((String)"\u5206\u5305\u8d1f\u8d23\u4eba\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u5904\u7f6e\uff01");
            }
            BeanUtils.copyProperties((Object)punishVO, leader);
            leader.setGrade(punishVO.getPunishGradeId());
            leader.setGradeName(punishVO.getPunishGrade());
            leader.setInException(true);
            this.subleadersService.saveOrUpdate((Object)leader, false);
        }
        return CommonResponse.success((String)"\u5904\u7f6e\u6210\u529f\uff01");
    }

    @GetMapping(value={"upgradeSupplier"})
    public CommonResponse<String> upgradeSupplier(@RequestParam(value="supplierId") Long supplierId, @RequestParam(value="gradeId") Long gradeId, @RequestParam(value="gradeName") String gradeName) {
        SupplierEntity supplierEntity = (SupplierEntity)((Object)this.supplierService.selectById(supplierId));
        if (supplierEntity == null) {
            return CommonResponse.error((String)"\u4f9b\u5e94\u5546\u4e0d\u5b58\u5728\uff01");
        }
        supplierEntity.setGradeId(gradeId);
        supplierEntity.setGradeName(gradeName);
        this.supplierService.saveOrUpdate((Object)supplierEntity, false);
        return CommonResponse.success((String)"\u4f9b\u5e94\u5546\u8bc4\u7ea7\u8bbe\u7f6e\u6210\u529f\uff01");
    }

    @GetMapping(value={"getEjcCloudSystemCode"})
    public CommonResponse<String> getEjcCloudSystemCode() {
        QueryParam param = new QueryParam();
        List list = this.ejcCloudSystemService.queryList(param, false);
        if (ListUtil.isNotEmpty((List)list)) {
            return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", (Object)((EjcCloudSystemEntity)((Object)list.get(0))).getCode());
        }
        System.out.println("\u76ca\u4f01\u8054\u516c\u6709\u4e91\u5e73\u53f0\u5185\u7684\u7cfb\u7edf\u6807\u8bc6\u7f16\u7801 \u5c1a\u672a\u914d\u7f6e\uff01");
        return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25");
    }
}

