package com.ejianc.foundation.util;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.Map.Entry;


public class DataToYzwUtil {
	private static final String CHARSET_UTF8 = "utf-8";

 	/**
 	 *  云筑网2.0调用方式
 	 * 拉取云筑网对应的映射
 	 * @param
 	 * @return
 	 * @throws Exception
 	 */
 	public static String queryByYzw(JSONObject object,String url,String method,String version,String appKey,String appSecret)
 			throws Exception {
         // 业务参数
         String jsonBody = object.toJSONString();
         // 构建请求
         String timestamp = gettime();
         String sign = generateSign(appKey, timestamp, appSecret, method, version, null, jsonBody);
         System.err.println("time: " + timestamp + "   sign: " + sign);
         Map<String, String> queryParam = new HashMap<String, String>();
         queryParam.put("method", method);
         queryParam.put("sign", sign);
         queryParam.put("appkey", appKey);
         queryParam.put("version", version);
         queryParam.put("timestamp", timestamp);
         // http://api.jc.yzw.cn/open.api
         url = StringUtils.isNotBlank(url)? url : "http://api.jc.yzw.cn/open.api";
//         String response = callApi(new URL(url + "?" + buildParamQuery(queryParam)), queryParam,jsonBody.toString());
       String response = callApi_ceshi(new URL(url + "?" + buildParamQuery(queryParam)), queryParam,jsonBody.toString());


         System.out.println(response);
 		return response;
 	}

    private static String callApi_ceshi(URL url, Map<String, String> params,String body) throws Exception {
//		String data = "username=xiaomi&password=Ultrasafe_123";
        String returnStr = post(url.toString(), params, body);

//    	HttpURLConnection connection;
//		try {
//			connection = createConnection(url);
//			connection.setDoOutput(true);
//	    	connection.setDoInput(true);
//	    	connection.setRequestMethod("POST");
//	    	connection.setUseCaches(false);
//	    	connection.setInstanceFollowRedirects(true);
//	    	connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
//
//	    	connection.connect();
//	    	//POST请求
//			OutputStreamWriter os = null;
//
//	    	os = new OutputStreamWriter(connection.getOutputStream());
//			os.write(body);
//			os.flush();
//			json=getResponse(connection);
//			System.out.println(json);
//
//
//			 if (connection != null) {
//	    	        connection.disconnect();
//	    	    }
//		} catch (IOException e) {
//			e.printStackTrace();
//		}
        return returnStr;
    }

    /**
     * POST请求
     */
    public static String post(String address,Map<String, String> headerParameters, String body) throws Exception {
    	return proxyHttpRequest(address, "POST", headerParameters,body);
    }

    /**
     * HTTP请求
     */
    public static String proxyHttpRequest(String address, String method,Map<String, String> headerParameters, String body) throws Exception {
        String result = null;
        HttpURLConnection httpConnection = null;

        try {
            httpConnection = createConnection(address, method,headerParameters, body);
            String encoding = "UTF-8";
            if (httpConnection.getContentType() != null&& httpConnection.getContentType().indexOf("charset=") >= 0) {
                encoding = httpConnection.getContentType().substring( httpConnection.getContentType().indexOf("charset=") + 8);
            }
            result = inputStream2String(httpConnection.getInputStream(), encoding);
        } catch (Exception e) {
            throw e;
        } finally {
            if (httpConnection != null) {
                httpConnection.disconnect();
            }
        }
        return result;
    }

    private static final int TIMEOUT = 45000;
    public static final String ENCODING = "UTF-8";


    /**
     * 创建HTTP连接
     *
     */
    private static HttpURLConnection createConnection(String url,String method, Map<String, String> headerParameters, String body)throws Exception {
        URL Url = new URL(url);
        trustAllHttpsCertificates();
        System.setProperty("https.protocols", "TLSv1");//核心 关键点   IBM版本JDK访问HTTPS请求
        HttpURLConnection httpConnection = (HttpURLConnection) Url.openConnection();
        // 设置请求时间
        httpConnection.setConnectTimeout(TIMEOUT);
        // 设置 header
        if (headerParameters != null) {
            Iterator<String> iteratorHeader = headerParameters.keySet().iterator();
            while (iteratorHeader.hasNext()) {
                String key = iteratorHeader.next();
                httpConnection.setRequestProperty(key,headerParameters.get(key));
            }
        }
       // httpConnection.setRequestProperty("Content-Type","application/x-www-form-urlencoded;charset=" + ENCODING);
        httpConnection.addRequestProperty("Content-Type", "application/json;charset=utf-8");
        httpConnection.addRequestProperty("accept","*/*");

        // 设置请求方法
        httpConnection.setRequestMethod(method);
        httpConnection.setDoOutput(true);
        httpConnection.setDoInput(true);
        // 写query数据流
        if (!(body == null || body.trim().equals(""))) {
            OutputStream writer = httpConnection.getOutputStream();
            try {
                writer.write(body.getBytes(ENCODING));
            } finally {
                if (writer != null) {
                    writer.flush();
                    writer.close();
                }
            }
        }
        return httpConnection;
    }


    /**
     * 读取inputStream 到 string
     * @param input
     * @param encoding
     * @return
     * @throws IOException
     */
    private static String inputStream2String(InputStream input, String encoding)throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(input,encoding));
        StringBuilder result = new StringBuilder();
        String temp = null;
        while ((temp = reader.readLine()) != null) {
            result.append(temp);
        }
        return result.toString();

    }

    /**
     * 设置 https 请求
     * @throws Exception
     */
    private static void trustAllHttpsCertificates() throws Exception {
        HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier() {
            public boolean verify(String str, SSLSession session) {
                return true;
            }
        });
        javax.net.ssl.TrustManager[] trustAllCerts = new javax.net.ssl.TrustManager[1];
        javax.net.ssl.TrustManager tm = new miTM();
        trustAllCerts[0] = tm;
        javax.net.ssl.SSLContext sc = javax.net.ssl.SSLContext.getInstance("SSL");;//javax.net.ssl.SSLContext.getInstance("SSL");
        sc.init(null, trustAllCerts, null);
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
      //不过有些程序会有如下代码，SSLSocketFactory又重新设置了一遍， SSLContext.getInstance("ssl");获取的是TLSv1.0协议，这样又使用了TLS1.0协议进行通讯了，就不会起到效果，其实下面这点代码就是第一种方式介绍的。
//		SSLContext sc = SSLContext.getInstance("ssl");
//		sc.init(null, null, new java.security.SecureRandom());
//		javax.net.ssl.HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());

    }


    //设置 https 请求证书
    static class miTM implements javax.net.ssl.TrustManager,javax.net.ssl.X509TrustManager {

        public java.security.cert.X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        public boolean isServerTrusted(
                java.security.cert.X509Certificate[] certs) {
            return true;
        }

        public boolean isClientTrusted(
                java.security.cert.X509Certificate[] certs) {
            return true;
        }

        public void checkServerTrusted(
                java.security.cert.X509Certificate[] certs, String authType)
                throws java.security.cert.CertificateException {
            return;
        }

        public void checkClientTrusted(
                java.security.cert.X509Certificate[] certs, String authType)
                throws java.security.cert.CertificateException {
            return;
        }
    }

    public static String generateSign(String appKey, String timestamp, String appSecret, String method, String version, Map<String, String> requestParam, String jsonBody) throws UnsupportedEncodingException {
        String signContent = buildSignContent(appKey, timestamp, method, version, requestParam, jsonBody);
        // 签名
        return sign(signContent, appSecret);
    }

    public static String buildSignContent(String appKey, String timestamp, String method, String version, Map<String, String> requestParam, String jsonBody) {
        // 公共参数

        Map<String, String> params = new HashMap<String, String>();
        params.put("appkey", appKey);
        params.put("method", method);
        params.put("version", version);
        params.put("timestamp", timestamp); //时间戳，格式为yyyyMMddHHmmss

        if (requestParam != null && CollUtil.isNotEmpty(requestParam) ) {
            params.putAll(requestParam);
        }

        //post请求的jsonbody
        if (jsonBody != null && jsonBody.length() > 0) {
            params.put("", jsonBody);
        }

     // 第一步：检查参数是否已经排序
        List<String> list = new ArrayList<String>();
        Set<Entry<String, String>> entrySet = params.entrySet();
        for (Entry<String, String> entry : entrySet) {
        	String key = entry.getKey() + entry.getValue();
        	list.add(key);
		}
        Collections.sort(list);

        // 第二步：把所有参数名和参数值串在一起
        StringBuilder sourceWithSecret = new StringBuilder();
        for (String key : list) {
        	sourceWithSecret.append(key + "&");
        }
        return sourceWithSecret.toString();
    }

	// 参数生成sign
    private static String sign(String source, String appsecret) throws UnsupportedEncodingException {
    	String sourceWithSecret = source + appsecret;
        // 3. 使用MD5加密,返回十六进制结果
        String sign = DigestUtils.md5Hex(sourceWithSecret.getBytes(CHARSET_UTF8));
        System.out.println("YzwSigner sourceStr:" + sourceWithSecret + ", sign:" + sign);
        return sign;
    }

    public static String buildParamQuery(Map<String, String> params) {
        StringBuilder sb = new StringBuilder();
        for (Entry<String, String> entry : params.entrySet()) {
            sb.append("&").append(entry.getKey()).append("=").append(entry.getValue());
        }
        return sb.substring(1);
    }

    /**
     * 取得时间
     * @return
     */
    public static String gettime(){

    	//2，获取当前时间字符串
        long l = System.currentTimeMillis();
        Date date = new Date(l);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
        String time = formatter.format(date);

		return time;
    }

}
