/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.share.bean.EquipmentCategoryEntity;
import com.ejianc.foundation.share.bean.EquipmentEntity;
import com.ejianc.foundation.share.service.IEquipmentCategoryService;
import com.ejianc.foundation.share.service.IEquipmentService;
import com.ejianc.foundation.share.vo.EquipmentCategoryVO;
import com.ejianc.foundation.share.vo.EquipmentVO;
import com.ejianc.foundation.share.vo.MaterialImportVO;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.util.DataToYzwUtil;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.client.RestHighLevelClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"/equipment/"})
public class EquipmentController
implements Serializable {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final long serialVersionUID = 1L;
    private static final String EQUIPMENT_BILL_CODE = "SUPPORT_EQUIPMENT";
    @Value(value="${oms.tenantid}")
    private String OMS_TENANT;
    @Autowired
    private IEquipmentService equipmentService;
    @Autowired
    private IEquipmentCategoryService equipmentCategoryService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired(required=false)
    private RestHighLevelClient client;
    @Value(value="${yzwSignUrl:https://zyq-rpc.yzwqa.cn/api/e-sign/rpc}")
    private String yzwSignUrl;
    @Value(value="${yzwUrl1:http://api-jc.yzwqa.cn/open.api}")
    private String yzwUrl1;
    @Value(value="${yzwVersion:1.0}")
    private String yzwVersion;
    @Value(value="${yzwAppKey1:T000101000111}")
    private String yzwAppKey1;
    @Value(value="${yzwAppSecret1:fffe9bcba10f4abf8816b358d4d4a4d1}")
    private String yzwAppSecret1;
    @Value(value="${yzwUrl2:https://open.yzwqa.cn/api}")
    private String yzwUrl2;
    @Value(value="${yzwAppKey2:ltCIIzc0}")
    private String yzwAppKey2;
    @Value(value="${yzwAppSecret2:3pr152viev63r91q2o2ahduf9q3wielt}")
    private String yzwAppSecret2;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveOrUpdate(@RequestBody EquipmentVO equipmentVo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        Long id = null;
        if (equipmentVo.getId() != null && equipmentVo.getId() > 0L) {
            id = equipmentVo.getId();
            EquipmentVO uniqueBean = this.equipmentService.queryDetail(equipmentVo.getId());
            uniqueBean.setCode(equipmentVo.getCode());
            uniqueBean.setName(equipmentVo.getName());
            uniqueBean.setSpec(equipmentVo.getSpec());
            uniqueBean.setUnitName(equipmentVo.getUnitName());
            uniqueBean.setDescription(equipmentVo.getDescription());
            uniqueBean.setSequence(equipmentVo.getSequence());
            uniqueBean.setProperty(equipmentVo.getProperty());
            uniqueBean.setPropertyName(equipmentVo.getPropertyName());
            uniqueBean.setUpdateUserCode(InvocationInfoProxy.getUsercode());
            uniqueBean.setUpdateTime(new Date());
            uniqueBean.setTenantId(InvocationInfoProxy.getTenantid());
            this.equipmentService.update(uniqueBean);
        } else {
            CommonResponse codeBatchByRuleCode = this.billCodeApi.getCodeBatchByRuleCode(EQUIPMENT_BILL_CODE, tenantId);
            equipmentVo.setId(Long.valueOf(IdWorker.getId()));
            if (codeBatchByRuleCode.isSuccess()) {
                equipmentVo.setCode((String)codeBatchByRuleCode.getData());
            }
            equipmentVo.setCreateUserCode(InvocationInfoProxy.getUsercode());
            equipmentVo.setCreateTime(new Date());
            equipmentVo.setTenantId(InvocationInfoProxy.getTenantid());
            equipmentVo.setEnabled(Integer.valueOf(1));
            this.equipmentService.save(equipmentVo);
        }
        JSONObject mainObject = new JSONObject();
        mainObject.put("sourceSystem", (Object)99001);
        JSONArray eBillMateList = new JSONArray();
        JSONObject mateObject = new JSONObject();
        EquipmentCategoryVO equipmentCategoryVO = this.equipmentCategoryService.queryDetail(equipmentVo.getCategoryId());
        mateObject.put("categoryCode", (Object)equipmentCategoryVO.getCode());
        mateObject.put("code", (Object)equipmentVo.getCode());
        mateObject.put("model", (Object)equipmentVo.getSpec());
        mateObject.put("name", (Object)equipmentVo.getName());
        mateObject.put("unitName", (Object)equipmentVo.getUnitName());
        eBillMateList.add((Object)mateObject);
        mainObject.put("sskuList", (Object)eBillMateList);
        JSONObject result = new JSONObject();
        String method = null;
        method = id != null ? "ymc.co.material.update" : "ymc.co.material.push";
        try {
            this.logger.info("\u53c2\u6570\uff1a{}", (Object)mainObject.toJSONString());
            String response = DataToYzwUtil.queryByYzw(mainObject, this.yzwUrl2, method, this.yzwVersion, this.yzwAppKey2, this.yzwAppSecret2);
            this.logger.info("\u8bbe\u5907\u6863\u6848\u65b0\u589e\u63a8\u9001\u8fd4\u56de\u63a5\u53e3:{}", (Object)response);
            JSONObject respone = JSONObject.parseObject((String)response);
            if (0 != (Integer)respone.get((Object)"Code") || null == respone.getJSONObject("Data").getJSONArray("Rows")) {
                this.logger.info(respone.toJSONString());
            }
        }
        catch (Exception e) {
            this.logger.info(e.getMessage());
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u6210\u529f");
    }

    @RequestMapping(value={"/amend"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> amend(@RequestBody List<MaterialVO> materialVo) {
        if (ListUtil.isNotEmpty(materialVo)) {
            for (MaterialVO e : materialVo) {
                this.equipmentService.amend(e.getId(), e.getProperty(), e.getPropertyName());
            }
        }
        return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f");
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<EquipmentVO> queryDetail(@RequestParam Long id) {
        EquipmentVO equipmentVo = this.equipmentService.queryDetail(id);
        return CommonResponse.success((Object)equipmentVo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        if (ListUtil.isNotEmpty(ids)) {
            for (Long id : ids) {
                CommonResponse response = this.billTypeApi.checkQuote("BT200422000000026", id);
                if (response.isSuccess()) continue;
                return CommonResponse.error((String)("\u5220\u9664\u5931\u8d25\uff1a" + response.getMsg()));
            }
        } else {
            return CommonResponse.error((String)"\u5220\u9664\u5931\u8d25\uff1a\u4e3b\u952e\u4e3a\u7a7a!");
        }
        this.equipmentService.delete(ids);
        JSONObject mainObject = new JSONObject();
        mainObject.put("sourceSystem", (Object)99001);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("id", new Parameter("in", ids));
        List<EquipmentEntity> materialEntities = this.equipmentService.queryList(queryParam);
        JSONArray eBillMateList = new JSONArray();
        for (EquipmentEntity materialEntity : materialEntities) {
            JSONObject mateObject = new JSONObject();
            mateObject.put("categoryCode", (Object)materialEntity.getCategoryCode());
            mateObject.put("code", (Object)materialEntity.getCode());
            mateObject.put("model", (Object)materialEntity.getSpec());
            mateObject.put("name", (Object)materialEntity.getName());
            mateObject.put("unitName", (Object)materialEntity.getUnitName());
            mateObject.put("isDelete", (Object)true);
            eBillMateList.add((Object)mateObject);
        }
        mainObject.put("sskuList", (Object)eBillMateList);
        JSONObject result = new JSONObject();
        String method = "ymc.co.material.update";
        try {
            this.logger.info("\u53c2\u6570\uff1a{}", (Object)mainObject.toJSONString());
            String response = DataToYzwUtil.queryByYzw(mainObject, this.yzwUrl2, method, this.yzwVersion, this.yzwAppKey2, this.yzwAppSecret2);
            this.logger.info("\u8bbe\u5907\u5220\u9664\u63a8\u9001\u8fd4\u56de\u63a5\u53e3:{}", (Object)response);
            JSONObject respone = JSONObject.parseObject((String)response);
            if (0 != (Integer)respone.get((Object)"Code") || null == respone.getJSONObject("Data").getJSONArray("Rows")) {
                this.logger.info(respone.toJSONString());
            }
        }
        catch (Exception e) {
            this.logger.info(e.getMessage());
        }
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/pageList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam queryParam) {
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage<EquipmentEntity> pageData = this.equipmentService.queryPage(queryParam);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", pageData);
        return CommonResponse.success((Object)jsonObject);
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"equipment-import.xlsx", (String)"\u8bbe\u5907\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    public CommonResponse<Object> excelImport(HttpServletRequest request, HttpServletResponse response) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        ArrayList<String> errorList = new ArrayList<String>();
        if (result != null && result.size() > 0) {
            for (int i = 0; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                EquipmentVO equipmentVo = null;
                List<EquipmentCategoryEntity> equipmentCategoryVo = this.equipmentCategoryService.queryByCode(String.valueOf(datas.get(0)));
                if (ListUtil.isNotEmpty(equipmentCategoryVo)) {
                    equipmentVo = new EquipmentVO();
                    equipmentVo.setId(Long.valueOf(IdWorker.getId()));
                    equipmentVo.setCategoryId(equipmentCategoryVo.get(0).getId());
                    if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(1)))) {
                        CommonResponse codeBatchByRuleCode = this.billCodeApi.getCodeBatchByRuleCode(EQUIPMENT_BILL_CODE, tenantId);
                        if (codeBatchByRuleCode.isSuccess()) {
                            equipmentVo.setCode((String)codeBatchByRuleCode.getData());
                        } else {
                            equipmentVo.setCode(new Date().getTime() + "");
                        }
                    } else {
                        equipmentVo.setCode((String)datas.get(1));
                    }
                    equipmentVo.setName((String)datas.get(2));
                    equipmentVo.setSpec((String)datas.get(3));
                    equipmentVo.setUnitName((String)datas.get(4));
                    EquipmentVO equipmentBean = this.equipmentService.queryExitFlag(equipmentVo.getName(), equipmentVo.getSpec(), equipmentVo.getUnitName(), equipmentCategoryVo.get(0).getId());
                    if (equipmentBean != null) continue;
                    equipmentVo.setCreateUserCode(InvocationInfoProxy.getUsercode());
                    equipmentVo.setCreateTime(new Date());
                    equipmentVo.setTenantId(InvocationInfoProxy.getTenantid());
                    equipmentVo.setEnabled(Integer.valueOf(1));
                    this.equipmentService.save(equipmentVo);
                    continue;
                }
                errorList.add("\u7b2c" + i + "\u884c\u6570\u636e\uff1a" + datas.toString() + "\u5bfc\u5165\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u8bbe\u5907\u5206\u7c7b\u7f16\u53f7\u4e0d\u6b63\u786e\uff01");
            }
        }
        if (errorList.size() > 0) {
            errorList.add("\u5bfc\u5165\u6210\u529f\uff1a" + (result.size() - errorList.size() - 1) + "\u6761, \u5931\u8d25\uff1a" + errorList.size() + "\u6761");
            return CommonResponse.error((String)"\u5bfc\u5165\u5931\u8d25", errorList);
        }
        return CommonResponse.success((String)"\u5bfc\u5165\u6210\u529f");
    }

    @RequestMapping(value={"/excelEquipmentImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelEquipmentImport(HttpServletRequest request) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        ArrayList<MaterialImportVO> successList = new ArrayList<MaterialImportVO>();
        ArrayList<MaterialImportVO> errorList = new ArrayList<MaterialImportVO>();
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            if (result.size() > 10000) {
                return CommonResponse.error((String)"\u8bbe\u5907\u6570\u636e\u8d85\u8fc710000\u6761\uff0c\u8bf7\u5206\u6279\u4e0a\u4f20\uff01");
            }
            HashMap caListMap = new HashMap();
            HashMap entityMap = new HashMap();
            HashMap<String, EquipmentVO> materialBeanMap = new HashMap<String, EquipmentVO>();
            for (int i = 0; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                MaterialImportVO materialVo = new MaterialImportVO();
                materialVo.setId(IdWorker.getId());
                materialVo.setCategoryCode((String)datas.get(0));
                materialVo.setCode((String)datas.get(1));
                materialVo.setName((String)datas.get(2));
                materialVo.setSpec((String)datas.get(3));
                materialVo.setUnitName((String)datas.get(4));
                materialVo.setPropertyName((String)datas.get(5));
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(5)))) {
                    materialVo.setDescription("\u7269\u8d44\u5c5e\u6027\u4e3a\u7a7a\uff01");
                    errorList.add(materialVo);
                    continue;
                }
                if (!"\u8bbe\u5907".equals(datas.get(5))) {
                    materialVo.setDescription("\u7269\u8d44\u5c5e\u6027\u4e0d\u5408\u6cd5\uff01");
                    errorList.add(materialVo);
                    continue;
                }
                materialVo.setProperty(4L);
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(0)))) {
                    materialVo.setDescription("\u8bbe\u5907\u5206\u7c7b\u7f16\u53f7\u4e3a\u7a7a\uff01");
                    errorList.add(materialVo);
                    continue;
                }
                List<EquipmentCategoryEntity> materialCategoryVo = (List<EquipmentCategoryEntity>)caListMap.get(datas.get(0));
                if (ListUtil.isEmpty((List)materialCategoryVo) && ListUtil.isNotEmpty(materialCategoryVo = this.equipmentCategoryService.queryByCode(String.valueOf(datas.get(0))))) {
                    caListMap.put(datas.get(0), materialCategoryVo);
                }
                if (ListUtil.isNotEmpty((List)materialCategoryVo)) {
                    materialVo.setCategoryId(((EquipmentCategoryEntity)materialCategoryVo.get(0)).getId());
                    if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(1)))) {
                        CommonResponse codeBatchByRuleCode = this.billCodeApi.getCodeBatchByRuleCode(EQUIPMENT_BILL_CODE, tenantId);
                        if (codeBatchByRuleCode.isSuccess()) {
                            materialVo.setCode((String)codeBatchByRuleCode.getData());
                        } else {
                            materialVo.setCode(new Date().getTime() + "");
                        }
                    } else {
                        EquipmentVO vo = (EquipmentVO)entityMap.get(datas.get(1));
                        if (vo == null && (vo = this.equipmentService.queryByCode((String)datas.get(1))) != null) {
                            entityMap.put(datas.get(1), vo);
                        }
                        if (vo != null) {
                            materialVo.setDescription("\u8bbe\u5907\u7f16\u53f7\u91cd\u590d\uff01");
                            errorList.add(materialVo);
                            continue;
                        }
                    }
                    EquipmentVO materialBean = (EquipmentVO)materialBeanMap.get(materialVo.getName() + materialVo.getSpec() + materialVo.getUnitName() + materialCategoryVo.get(0).getId());
                    if (materialBean == null && (materialBean = this.equipmentService.queryExitFlag(materialVo.getName(), materialVo.getSpec(), materialVo.getUnitName(), materialCategoryVo.get(0).getId())) != null) {
                        materialBeanMap.put(materialVo.getName() + materialVo.getSpec() + materialVo.getUnitName() + materialCategoryVo.get(0).getId(), materialBean);
                    }
                    if (materialBean != null) {
                        materialVo.setDescription("\u91cd\u590d\u8bbe\u5907\uff01");
                        errorList.add(materialVo);
                        continue;
                    }
                    materialVo.setCreateUserCode(InvocationInfoProxy.getUsercode());
                    materialVo.setCreateTime(new Date());
                    materialVo.setTenantId(InvocationInfoProxy.getTenantid());
                    materialVo.setEnabled(1);
                    successList.add(materialVo);
                    continue;
                }
                materialVo.setDescription("\u8bbe\u5907\u5206\u7c7b\u7f16\u53f7\u4e0d\u5b58\u5728\uff01");
                errorList.add(materialVo);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success((Object)json);
    }

    @RequestMapping(value={"/saveImportExcelEquipment"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveImportExcelEquipment(@RequestBody List<MaterialImportVO> importVOS) {
        if (ListUtil.isEmpty(importVOS)) {
            return CommonResponse.error((String)"\u5bfc\u5165\u7684\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        ArrayList<EquipmentVO> list = new ArrayList<EquipmentVO>();
        importVOS.forEach(importVO -> list.add((EquipmentVO)BeanMapper.map((Object)importVO, EquipmentVO.class)));
        this.equipmentService.insertBatch(list);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List<EquipmentEntity> resultList = this.equipmentService.queryList(queryParam);
        HashMap<String, List<EquipmentEntity>> beans = new HashMap<String, List<EquipmentEntity>>();
        beans.put("records", resultList);
        ExcelExport.getInstance().export("equipment-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/sync"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> syncEquipmentList() {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (this.OMS_TENANT.equals(tenantId.toString())) {
            return CommonResponse.error((String)"\u5e73\u53f0\u8fd0\u8425\u4eba\u5458\u4e0d\u80fd\u64cd\u4f5c\u6b64\u529f\u80fd");
        }
        this.equipmentService.insertEquipmentListFromPlatform();
        return CommonResponse.success((String)"\u540c\u6b65\u6210\u529f");
    }

    @RequestMapping(value={"refEquipmentPage"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<EquipmentEntity>> refEquipmentPage(@RequestParam(defaultValue="1") int pageNumber, @RequestParam(defaultValue="10") int pageSize, @RequestParam(required=false) String relyCondition, @RequestParam(required=false) String searchText, @RequestParam(required=false) String condition) {
        Long categoryId;
        EquipmentCategoryVO equipmentCategoryVo;
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((CharSequence)relyCondition) && StringUtils.isBlank((CharSequence)searchText) && (equipmentCategoryVo = this.equipmentCategoryService.queryDetail(categoryId = Long.valueOf(Long.parseLong(relyCondition.split("=")[1])))) != null) {
            params.put("innerCode", equipmentCategoryVo.getInnerCode());
        }
        params.put("pageIndex", pageNumber <= 0 ? 0 : (pageNumber - 1) * pageSize);
        params.put("pageSize", pageSize);
        params.put("searchText", searchText);
        params.put("tenantId", InvocationInfoProxy.getTenantid());
        IPage<EquipmentEntity> pageData = this.equipmentService.queryRefEquipmentPage(params);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", pageData);
    }
}

