/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.share.bean.MaterialCategoryEntity;
import com.ejianc.foundation.share.service.IMaterialCategoryService;
import com.ejianc.foundation.share.service.IMaterialService;
import com.ejianc.foundation.share.vo.MaterialCategoryImportVO;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.share.vo.SyncMaterialCategoryParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.usercenter.api.IThirdSystemApi;
import com.ejianc.foundation.usercenter.vo.ThirdSystemVO;
import com.ejianc.foundation.util.DataToYzwUtil;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"/material/category/"})
public class MaterialCategoryController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String MATERIAL_CATEGORY_BILL_CODE = "SUPPORT_MATERIAL_CATEGORY";
    @Value(value="${oms.tenantid}")
    private String OMS_TENANT;
    @Autowired
    private IMaterialCategoryService materialCategoryService;
    @Autowired
    private IMaterialService materialService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IThirdSystemApi thirdSystemApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${yzwSignUrl:https://zyq-rpc.yzwqa.cn/api/e-sign/rpc}")
    private String yzwSignUrl;
    @Value(value="${yzwUrl1:http://api-jc.yzwqa.cn/open.api}")
    private String yzwUrl1;
    @Value(value="${yzwVersion:1.0}")
    private String yzwVersion;
    @Value(value="${yzwAppKey1:T000101000111}")
    private String yzwAppKey1;
    @Value(value="${yzwAppSecret1:fffe9bcba10f4abf8816b358d4d4a4d1}")
    private String yzwAppSecret1;
    @Value(value="${yzwUrl2:https://open.yzwqa.cn/api}")
    private String yzwUrl2;
    @Value(value="${yzwAppKey2:ltCIIzc0}")
    private String yzwAppKey2;
    @Value(value="${yzwAppSecret2:3pr152viev63r91q2o2ahduf9q3wielt}")
    private String yzwAppSecret2;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveOrUpdate(@RequestBody MaterialCategoryVO materialCategoryVo) {
        MaterialCategoryEntity entity;
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (materialCategoryVo.getId() != null && materialCategoryVo.getId() > 0L) {
            MaterialCategoryVO uniqueBean = this.materialCategoryService.queryDetail(materialCategoryVo.getId());
            uniqueBean.setName(materialCategoryVo.getName());
            uniqueBean.setUnitName(materialCategoryVo.getUnitName());
            uniqueBean.setDescription(materialCategoryVo.getDescription());
            uniqueBean.setSequence(materialCategoryVo.getSequence());
            uniqueBean.setUpdateUserCode(InvocationInfoProxy.getUsercode());
            uniqueBean.setUpdateTime(materialCategoryVo.getUpdateTime());
            entity = (MaterialCategoryEntity)BeanMapper.map((Object)uniqueBean, MaterialCategoryEntity.class);
            this.materialCategoryService.update(entity);
        } else {
            CommonResponse codeBatchByRuleCode = this.billCodeApi.getCodeBatchByRuleCode(MATERIAL_CATEGORY_BILL_CODE, tenantId);
            if (codeBatchByRuleCode.isSuccess()) {
                materialCategoryVo.setCode((String)codeBatchByRuleCode.getData());
            }
            entity = (MaterialCategoryEntity)BeanMapper.map((Object)materialCategoryVo, MaterialCategoryEntity.class);
            entity.setId(IdWorker.getId());
            if (entity.getParentId() != null && entity.getParentId() > 0L) {
                MaterialCategoryVO uniqueBean = this.materialCategoryService.queryDetail(entity.getParentId());
                entity.setInnerCode(uniqueBean.getInnerCode() + "|" + entity.getId());
            } else {
                entity.setInnerCode(entity.getId().toString());
            }
            entity.setEnabled(1);
            entity.setCreateUserCode(InvocationInfoProxy.getUsercode());
            entity.setCreateTime(new Date());
            entity.setTenantId(InvocationInfoProxy.getTenantid());
            this.materialCategoryService.save(entity);
        }
        JSONObject param = new JSONObject();
        param.put("categoryCode", (Object)materialCategoryVo.getCode());
        param.put("categoryName", (Object)materialCategoryVo.getName());
        if (materialCategoryVo.getParentId() != null) {
            MaterialCategoryVO materialCategoryVO = this.materialCategoryService.queryDetail(materialCategoryVo.getParentId());
            param.put("parentCategoryCode", (Object)materialCategoryVO.getCode());
        }
        param.put("sourceSystem", (Object)99001);
        param.put("status", (Object)1);
        JSONObject result = new JSONObject();
        String method = null;
        method = materialCategoryVo.getId() != null ? "ymc.co.material.category.update" : "ymc.co.material.category.push";
        try {
            this.logger.info("\u53c2\u6570\uff1a{}", (Object)param.toJSONString());
            String response = DataToYzwUtil.queryByYzw(param, this.yzwUrl2, method, this.yzwVersion, this.yzwAppKey2, this.yzwAppSecret2);
            this.logger.info("\u7269\u8d44\u5206\u7c7b\u65b0\u589eor\u4fee\u6539\u63a8\u9001\u8fd4\u56de\u63a5\u53e3:{}", (Object)response);
            JSONObject respone = JSONObject.parseObject((String)response);
            if (0 != (Integer)respone.get((Object)"Code") || null == respone.getJSONObject("Data").getJSONArray("Rows")) {
                this.logger.info(respone.toJSONString());
            }
        }
        catch (Exception e) {
            this.logger.info(e.getMessage());
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\u6216\u4fee\u6539\u6210\u529f!");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam queryParam) {
        List<MaterialCategoryEntity> dataList = this.materialCategoryService.queryList(queryParam);
        List resultMapList = BeanMapper.mapList(dataList, Map.class);
        resultMapList.forEach(l -> {
            if (l.get("isLeaf").equals(false)) {
                l.put("children", new ArrayList());
            }
        });
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", (Object)ResultAsTree.createTreeData((List)resultMapList));
        return CommonResponse.success((Object)jsonObject);
    }

    @RequestMapping(value={"/bandSubject"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> bandSubject(@RequestBody Map map) {
        List ids = (List)map.get("ids");
        Long subjectId = Long.valueOf(map.get("subjectId").toString());
        String subjectName = (String)map.get("subjectName");
        this.materialCategoryService.updateSubject(subjectId, subjectName, ids);
        return CommonResponse.success((String)"\u7ed1\u5b9a\u6210\u529f!");
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<MaterialCategoryVO> queryDetail(@RequestParam Long id) {
        MaterialCategoryVO materialCategoryVo = this.materialCategoryService.queryDetail(id);
        return CommonResponse.success((Object)materialCategoryVo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> delete(@RequestParam Long id) {
        List<MaterialCategoryVO> children = this.materialCategoryService.queryListByPid(id, null);
        if (children != null && children.size() > 0) {
            return CommonResponse.error((String)"\u8be5\u5206\u7c7b\u4e0b\u6709\u5b50\u5206\u7c7b\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        List<MaterialVO> materialList = this.materialService.queryListByCategoryId(id);
        if (materialList != null && materialList.size() > 0) {
            return CommonResponse.error((String)"\u8be5\u5206\u7c7b\u4e0b\u6709\u7269\u6599\u4e86\uff0c\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        MaterialCategoryVO entity = this.materialCategoryService.queryDetail(id);
        this.materialCategoryService.delete(id);
        JSONObject param = new JSONObject();
        param.put("categoryCode", (Object)entity.getCode());
        param.put("categoryName", (Object)entity.getName());
        param.put("categoryName", (Object)entity.getName());
        param.put("isDelete", (Object)true);
        param.put("sourceSystem", (Object)99001);
        param.put("status", (Object)1);
        JSONObject result = new JSONObject();
        String method = "ymc.co.material.category.update";
        try {
            this.logger.info("\u53c2\u6570\uff1a{}", (Object)param.toJSONString());
            String response = DataToYzwUtil.queryByYzw(param, this.yzwUrl2, method, this.yzwVersion, this.yzwAppKey2, this.yzwAppSecret2);
            this.logger.info("\u7269\u8d44\u5206\u7c7b\u5220\u9664\u63a8\u9001\u8fd4\u56de\u63a5\u53e3:{}", (Object)response);
            JSONObject respone = JSONObject.parseObject((String)response);
            if (0 != (Integer)respone.get((Object)"Code") || null == respone.getJSONObject("Data").getJSONArray("Rows")) {
                this.logger.info(respone.toJSONString());
            }
        }
        catch (Exception e) {
            this.logger.info(e.getMessage());
        }
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/enabled/update"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> updateEnabled(@RequestBody MaterialCategoryVO materialCategoryVo) {
        MaterialCategoryVO condition = this.materialCategoryService.queryDetail(materialCategoryVo.getId());
        this.materialCategoryService.updateEnabled(materialCategoryVo.getEnabled(), condition.getTenantId(), condition.getInnerCode());
        return CommonResponse.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @RequestMapping(value={"/sync"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> syncMaterialCategoryList() {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (this.OMS_TENANT.equals(tenantId.toString())) {
            return CommonResponse.error((String)"\u5e73\u53f0\u8fd0\u8425\u4eba\u5458\u4e0d\u80fd\u64cd\u4f5c\u6b64\u529f\u80fd");
        }
        this.materialCategoryService.insertCategoryListFromPlatform();
        return CommonResponse.success((String)"\u540c\u6b65\u6210\u529f");
    }

    @RequestMapping(value={"/queryMaterialRefTree"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Map<String, Object>> queryMaterialRefTree(@RequestParam(required=false) String searchText) {
        List<MaterialCategoryVO> dataList = null;
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            if (StringUtils.isNotBlank((CharSequence)searchText)) {
                params.put("searchText", searchText);
            }
            params.put("tenantId", InvocationInfoProxy.getTenantid());
            dataList = this.materialCategoryService.queryListTree(params);
            List map = BeanMapper.mapList(dataList, Map.class);
            return ResultAsTree.createTreeData((List)map);
        }
        catch (Exception e) {
            return null;
        }
    }

    @RequestMapping(value={"/lazyMaterialCategoryTree"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Map<String, Object>> lazyMaterialCategoryTree(@RequestParam(required=false) String condition, @RequestParam(required=false) Long pid, @RequestParam(required=false) String searchText) {
        List<MaterialCategoryVO> dataList = null;
        try {
            JSONObject conditionJson;
            String categoryCode = null;
            HashMap<String, Object> params = new HashMap<String, Object>();
            if (StringUtils.isNotBlank((CharSequence)condition) && null != (conditionJson = JSON.parseObject((String)condition)).get((Object)"categoryCode")) {
                categoryCode = conditionJson.get((Object)"categoryCode").toString();
                params.put("categoryCode", conditionJson.get((Object)"categoryCode"));
            }
            if (StringUtils.isNotBlank((CharSequence)searchText)) {
                params.put("searchText", searchText);
                params.put("tenantId", InvocationInfoProxy.getTenantid());
                dataList = this.materialCategoryService.queryListTree(params);
            } else {
                dataList = this.materialCategoryService.queryListByPid(pid, categoryCode);
            }
            List map = BeanMapper.mapList(dataList, Map.class);
            return ResultAsTree.createTreeData((List)map);
        }
        catch (Exception e) {
            return null;
        }
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"material-category-import.xlsx", (String)"\u7269\u6599\u5206\u7c7b\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        ArrayList successList = new ArrayList();
        ArrayList<MaterialCategoryImportVO> processList = new ArrayList<MaterialCategoryImportVO>();
        ArrayList<MaterialCategoryImportVO> errorList = new ArrayList<MaterialCategoryImportVO>();
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            if (result.size() > 10000) {
                return CommonResponse.error((String)"\u5206\u7c7b\u6570\u636e\u8d85\u8fc710000\u6761\uff0c\u8bf7\u5206\u6279\u4e0a\u4f20\uff01");
            }
            HashMap<String, ArrayList<MaterialCategoryImportVO>> mapChildren = new HashMap<String, ArrayList<MaterialCategoryImportVO>>();
            HashMap<String, MaterialCategoryImportVO> codeToData = new HashMap<String, MaterialCategoryImportVO>();
            HashMap codeNotExistData = new HashMap();
            for (int i = 0; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                MaterialCategoryImportVO materialVo = new MaterialCategoryImportVO();
                materialVo.setId(IdWorker.getId());
                materialVo.setCode((String)datas.get(0));
                materialVo.setParentCode((String)datas.get(1));
                materialVo.setName((String)datas.get(2));
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(0)))) {
                    materialVo.setDescription("\u5206\u7c7b\u7f16\u7801\u4e3a\u7a7a\uff01");
                    errorList.add(materialVo);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(2)))) {
                    materialVo.setDescription("\u5206\u7c7b\u540d\u79f0\u4e3a\u7a7a\uff01");
                    errorList.add(materialVo);
                    continue;
                }
                List<MaterialCategoryEntity> list = this.materialCategoryService.queryByCode(String.valueOf(datas.get(0)));
                if (ListUtil.isEmpty(list)) {
                    List<MaterialCategoryImportVO> list1;
                    list = this.materialCategoryService.queryByName(String.valueOf(datas.get(2)));
                    if (ListUtil.isNotEmpty(list)) {
                        materialVo.setDescription("\u5206\u7c7b\u540d\u79f0\u91cd\u590d\uff01");
                        errorList.add(materialVo);
                        continue;
                    }
                    if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(1)))) {
                        materialVo.setInnerCode(materialVo.getId().toString());
                    }
                    materialVo.setEnabled(1);
                    materialVo.setCreateUserCode(InvocationInfoProxy.getUsercode());
                    materialVo.setCreateTime(new Date());
                    materialVo.setTenantId(InvocationInfoProxy.getTenantid());
                    processList.add(materialVo);
                    codeToData.put(materialVo.getCode(), materialVo);
                    if (StringUtils.isBlank((CharSequence)materialVo.getParentCode())) {
                        list1 = (ArrayList<MaterialCategoryImportVO>)mapChildren.get("null");
                        if (ListUtil.isEmpty((List)list1)) {
                            list1 = new ArrayList<MaterialCategoryImportVO>();
                            mapChildren.put("null", (ArrayList<MaterialCategoryImportVO>)list1);
                        }
                        list1.add(materialVo);
                        continue;
                    }
                    list1 = (List)mapChildren.get(materialVo.getParentCode());
                    if (ListUtil.isEmpty((List)list1)) {
                        list1 = new ArrayList();
                        mapChildren.put(materialVo.getParentCode(), (ArrayList<MaterialCategoryImportVO>)list1);
                    }
                    list1.add(materialVo);
                    continue;
                }
                materialVo.setDescription("\u5206\u7c7b\u7f16\u7801\u91cd\u590d\uff01");
                errorList.add(materialVo);
            }
            if (ListUtil.isNotEmpty(processList)) {
                processList.forEach(p -> {
                    if (StringUtils.isNotEmpty((CharSequence)p.getParentCode())) {
                        MaterialCategoryImportVO parentVo = (MaterialCategoryImportVO)codeToData.get(p.getParentCode());
                        if (parentVo == null) {
                            if (StringUtils.isNotEmpty((CharSequence)((CharSequence)codeNotExistData.get(p.getParentCode())))) {
                                p.setDescription("\u7236\u5206\u7c7b\u7f16\u7801\u4e0d\u5b58\u5728");
                                errorList.add((MaterialCategoryImportVO)p);
                            } else {
                                List<MaterialCategoryEntity> list = this.materialCategoryService.queryByCode(p.getParentCode());
                                if (ListUtil.isEmpty(list)) {
                                    codeNotExistData.put(p.getParentCode(), p.getParentCode());
                                    p.setDescription("\u7236\u5206\u7c7b\u7f16\u7801\u4e0d\u5b58\u5728");
                                    errorList.add((MaterialCategoryImportVO)p);
                                } else {
                                    p.setInnerCode(list.get(0).getInnerCode() + "|" + p.getId());
                                    p.setParentId(list.get(0).getId());
                                    successList.add(p);
                                }
                            }
                        } else if (StringUtils.isEmpty((CharSequence)parentVo.getInnerCode())) {
                            this.setInnerCodeAndParentId(parentVo, codeToData, codeNotExistData);
                            if (StringUtils.isEmpty((CharSequence)parentVo.getInnerCode())) {
                                p.setDescription("\u7236\u5206\u7c7b\u7f16\u7801\u4e0d\u5b58\u5728");
                                errorList.add((MaterialCategoryImportVO)p);
                            } else {
                                p.setInnerCode(parentVo.getInnerCode() + "|" + p.getId());
                                p.setParentId(parentVo.getId());
                                successList.add(p);
                            }
                        } else {
                            p.setInnerCode(parentVo.getInnerCode() + "|" + p.getId());
                            p.setParentId(parentVo.getId());
                            successList.add(p);
                        }
                    } else {
                        successList.add(p);
                    }
                });
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success((Object)json);
    }

    private void setInnerCodeAndParentId(MaterialCategoryImportVO vo, Map<String, MaterialCategoryImportVO> codeToData, Map<String, String> codeNotExistData) {
        MaterialCategoryImportVO parentVo = codeToData.get(vo.getParentCode());
        if (parentVo == null) {
            if (StringUtils.isNotEmpty((CharSequence)codeNotExistData.get(vo.getParentCode()))) {
                vo.setDescription("\u7236\u5206\u7c7b\u7f16\u7801\u4e0d\u5b58\u5728");
            } else {
                List<MaterialCategoryEntity> list = this.materialCategoryService.queryByCode(vo.getParentCode());
                if (ListUtil.isEmpty(list)) {
                    codeNotExistData.put(vo.getParentCode(), vo.getParentCode());
                    vo.setDescription("\u7236\u5206\u7c7b\u7f16\u7801\u4e0d\u5b58\u5728");
                } else {
                    vo.setInnerCode(list.get(0).getInnerCode() + "|" + vo.getId());
                    vo.setParentId(list.get(0).getId());
                }
            }
        } else if (StringUtils.isEmpty((CharSequence)parentVo.getInnerCode())) {
            this.setInnerCodeAndParentId(parentVo, codeToData, codeNotExistData);
            if (StringUtils.isEmpty((CharSequence)parentVo.getInnerCode())) {
                vo.setDescription("\u7236\u5206\u7c7b\u7f16\u7801\u4e0d\u5b58\u5728");
            } else {
                vo.setInnerCode(parentVo.getInnerCode() + "|" + vo.getId());
                vo.setParentId(parentVo.getId());
            }
        } else {
            vo.setInnerCode(parentVo.getInnerCode() + "|" + vo.getId());
            vo.setParentId(parentVo.getId());
        }
    }

    @RequestMapping(value={"/saveImportExcelMaterialCategory"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveImportExcelMaterialCategory(@RequestBody List<MaterialCategoryImportVO> importVOS) {
        if (ListUtil.isEmpty(importVOS)) {
            return CommonResponse.error((String)"\u5bfc\u5165\u7684\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        ArrayList<MaterialCategoryEntity> toSave = new ArrayList<MaterialCategoryEntity>();
        importVOS.forEach(importVO -> toSave.add((MaterialCategoryEntity)BeanMapper.map((Object)importVO, MaterialCategoryEntity.class)));
        this.materialCategoryService.insertBatch(toSave);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequestMapping(value={"/syncMaterialCategory"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> syncMaterialCategory(@RequestBody List<SyncMaterialCategoryParam> categoryList) {
        if (categoryList == null || categoryList.size() == 0) {
            return CommonResponse.error((String)"\u540c\u6b65\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long systemId = null;
        CommonResponse sysVO = this.thirdSystemApi.getOneByCode(categoryList.get(0).getSystemCode());
        if (!sysVO.isSuccess()) return CommonResponse.error((String)("\u540c\u6b65\u6210\u5931\u8d25\uff0c\u7f16\u7801\u3010systemCode: " + categoryList.get(0).getSystemCode() + "\u3011\u65e0\u5339\u914d\u7684\u7cfb\u7edf\u4fe1\u606f\u3002"));
        if (sysVO.getData() == null) {
            return CommonResponse.error((String)("\u540c\u6b65\u6210\u5931\u8d25\uff0c\u7f16\u7801\u3010systemCode: " + categoryList.get(0).getSystemCode() + "\u3011\u65e0\u5339\u914d\u7684\u7cfb\u7edf\u4fe1\u606f\u3002"));
        }
        systemId = ((ThirdSystemVO)sysVO.getData()).getId();
        ArrayList<String> errorMsg = new ArrayList<String>();
        for (SyncMaterialCategoryParam syncMaterialCategoryParam : categoryList) {
            try {
                MaterialCategoryEntity entity;
                MaterialCategoryVO vo;
                if (1 == syncMaterialCategoryParam.getSyncType()) {
                    block15: {
                        vo = this.materialCategoryService.queryBySourceId(syncMaterialCategoryParam.getId());
                        if (vo != null) {
                            errorMsg.add("\u7269\u8d44\u5206\u7c7b:" + syncMaterialCategoryParam.getName() + "\u5df2\u5b58\u5728");
                            continue;
                        }
                        entity = new MaterialCategoryEntity();
                        entity.setId(IdWorker.getId());
                        entity.setCode(syncMaterialCategoryParam.getCode());
                        entity.setName(syncMaterialCategoryParam.getName());
                        entity.setSourceId(syncMaterialCategoryParam.getId());
                        entity.setSystemId(systemId);
                        entity.setEnabled(1);
                        entity.setCreateUserCode(InvocationInfoProxy.getUsercode());
                        entity.setCreateTime(new Date());
                        entity.setTenantId(InvocationInfoProxy.getTenantid());
                        if (StringUtils.isNotBlank((CharSequence)syncMaterialCategoryParam.getParentId())) {
                            MaterialCategoryVO uniqueBean = this.materialCategoryService.queryBySourceId(syncMaterialCategoryParam.getParentId());
                            if (uniqueBean != null) {
                                entity.setInnerCode(uniqueBean.getInnerCode() + "|" + entity.getId());
                                break block15;
                            } else {
                                errorMsg.add("\u7269\u8d44\u5206\u7c7b: " + syncMaterialCategoryParam.getName() + "\u7684\u4e0a\u7ea7\u5206\u7c7b\uff08parentId\uff1a" + syncMaterialCategoryParam.getParentId() + "\uff09\u672a\u5b58\u5728,\u8bf7\u5148\u540c\u6b65\u8be5\u5206\u7c7b\u4e0a\u7ea7\u5206\u7c7b");
                                continue;
                            }
                        }
                        entity.setInnerCode(entity.getId().toString());
                    }
                    this.materialCategoryService.save(entity);
                    continue;
                }
                if (2 == syncMaterialCategoryParam.getSyncType()) {
                    MaterialCategoryVO uniqueBean = this.materialCategoryService.queryBySourceId(syncMaterialCategoryParam.getId());
                    if (uniqueBean == null) {
                        errorMsg.add("\u7269\u8d44\u5206\u7c7b:" + syncMaterialCategoryParam.getName() + "\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u540c\u6b65\u8be5\u7269\u8d44\u5206\u7c7b\u518d\u8fdb\u884c\u4fee\u6539\u64cd\u4f5c");
                        continue;
                    }
                    uniqueBean.setCode(syncMaterialCategoryParam.getCode());
                    uniqueBean.setName(syncMaterialCategoryParam.getName());
                    uniqueBean.setUpdateUserCode(InvocationInfoProxy.getUsercode());
                    entity = (MaterialCategoryEntity)BeanMapper.map((Object)uniqueBean, MaterialCategoryEntity.class);
                    this.materialCategoryService.update(entity);
                    continue;
                }
                if (3 != syncMaterialCategoryParam.getSyncType()) continue;
                vo = this.materialCategoryService.queryBySourceId(syncMaterialCategoryParam.getId());
                if (vo == null) {
                    errorMsg.add("\u7269\u8d44\u5206\u7c7b:" + syncMaterialCategoryParam.getName() + "\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u540c\u6b65\u8be5\u7269\u8d44\u5206\u7c7b\u518d\u8fdb\u884c\u5220\u9664\u64cd\u4f5c");
                    continue;
                }
                entity = this.materialCategoryService.queryBySourceId(syncMaterialCategoryParam.getId());
                this.materialCategoryService.delete(entity.getId());
            }
            catch (Exception e) {
                errorMsg.add("\u7269\u8d44\u5206\u7c7b: " + syncMaterialCategoryParam.getName() + "\u540c\u6b65\u9519\u8bef\uff0c\u5177\u4f53\u9519\u8bef\uff1a" + e);
            }
        }
        String msg = "";
        for (String m : errorMsg) {
            if (msg.length() > 0) {
                msg = msg + ";" + m;
                continue;
            }
            msg = msg + m;
        }
        String string = "\u540c\u6b65\u5b8c\u6210\uff0c\u5df2\u540c\u6b65\u6210\u529f" + (categoryList.size() - errorMsg.size()) + "\u6761\uff0c\u5931\u8d25" + errorMsg.size() + "\u6761\u3002" + (errorMsg.size() > 0 ? "\u5931\u8d25\u5177\u4f53\u539f\u56e0\u5982\u4e0b\uff1a" + msg : "");
        return CommonResponse.success((String)string);
    }
}

