package com.ejianc.foundation.share.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.share.bean.MaterialEntity;
import com.ejianc.foundation.share.service.IMaterialCategoryCr12gService;
import com.ejianc.foundation.share.service.IMaterialCr12gService;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/**
 * 物料controller
 *
 * @author guominga
 *
 */
@RestController
@RequestMapping("/materialCr12g/")
public class MaterialCr12gController implements Serializable {
	private Logger logger = LoggerFactory.getLogger(this.getClass());

	private static final long serialVersionUID = 1L;
	@Autowired
	private IMaterialCr12gService materialService;
	@Autowired
	private IMaterialCategoryCr12gService materialCategoryService;


	/**
	 * 材料列表
	 *
	 * @param pageNumber
	 * @param pageSize
	 * @param relyCondition
	 * @param searchText
	 * @param condition
	 * @return
	 */
	@RequestMapping(value = "refMaterialPageAsset", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<IPage<MaterialEntity>> refMaterialPageAsset(@RequestParam(defaultValue = "1") int pageNumber, @RequestParam(defaultValue = "10") int pageSize,
																 @RequestParam(required=false) String relyCondition,
																 @RequestParam(required=false) String searchText,
																 @RequestParam(required=false) String condition,
																 @RequestParam(required=false) String searchObject
	) {
		Map<String,Object> params = new HashMap<>();
		if(StringUtils.isNotBlank(relyCondition)){
			Long categoryId = Long.parseLong(relyCondition.split("=")[1]);
			MaterialCategoryVO materialCategoryVo = materialCategoryService.queryDetail(categoryId);
			if(materialCategoryVo != null) {
				params.put("innerCode", materialCategoryVo.getInnerCode());
			}
		}
		if(StringUtils.isNotBlank(searchObject)){
			JSONObject search = JSONObject.parseObject(searchObject);
			if(search.get("categoryName")!=null){
				params.put("categoryName", search.get("categoryName").toString());
			}
			if(search.get("code")!=null){
				params.put("code", search.get("code").toString());
			}
			if(search.get("name")!=null){
				params.put("name", search.get("name").toString());
			}
			if(search.get("spec")!=null){
				params.put("spec", search.get("spec").toString());
			}
			if(search.get("unitName")!=null){
				params.put("unitName", search.get("unitName").toString());
			}
		}
		params.put("pageIndex", pageNumber <= 0 ? 0:(pageNumber-1)*pageSize);
		params.put("pageSize", pageSize);
		params.put("searchText", searchText);
		params.put("tenantId", InvocationInfoProxy.getTenantid());
		IPage<MaterialEntity> pageData = materialService.queryRefMaterialPageAsset(params);
		pageData.setCurrent(pageNumber);
		pageData.setSize(pageSize);

		return CommonResponse.success("查询成功！", pageData);
	}

}
