/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.bean.SupplierCategoryEntity;
import com.ejianc.foundation.share.bean.SupplierEntity;
import com.ejianc.foundation.share.service.ICertsService;
import com.ejianc.foundation.share.service.ISubleadersService;
import com.ejianc.foundation.share.service.ISupplierCategoryService;
import com.ejianc.foundation.share.service.ISupplierLinkerService;
import com.ejianc.foundation.share.service.ISupplierService;
import com.ejianc.foundation.share.vo.CertsVO;
import com.ejianc.foundation.share.vo.SubleadersVO;
import com.ejianc.foundation.share.vo.SupplierCategoryVO;
import com.ejianc.foundation.share.vo.SupplierLinkerVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.service.IBankAccountService;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.foundation.util.ExcelReader;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"/supplier/"})
public class SupplierController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String SUPPLIER_BILL_CODE = "SUPPORT_SUPPLIER";
    @Value(value="${eachLink.host}")
    private String eachLinkHost;
    @Value(value="${eachLink.appId}")
    private String appId;
    @Value(value="${eachLink.secret}")
    private String secret;
    @Autowired
    private ISupplierService supplierService;
    @Autowired
    private ISupplierCategoryService supplierCategoryService;
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private ISupplierLinkerService supplierLinkerService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBankAccountService bankAccountService;
    @Autowired
    private ICertsService certsService;
    @Autowired
    private ISubleadersService subleadersService;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SupplierVO> saveOrUpdate(@RequestBody SupplierVO supplierVo) {
        if (supplierVo.getCategoryId() == null) {
            return CommonResponse.error((String)"\u4f9b\u65b9\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        CommonResponse<SupplierVO> response = this.supplierService.saveOrUpdate(supplierVo);
        return response;
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SupplierVO> queryDetail(@RequestParam Long id) {
        SupplierVO supplierVo = this.supplierService.queryDetail(id);
        JSONObject parent = new JSONObject();
        if (supplierVo.getCategoryId() != null) {
            SupplierCategoryEntity e = (SupplierCategoryEntity)((Object)this.supplierCategoryService.selectById(supplierVo.getCategoryId()));
            parent.put("id", (Object)e.getId());
            parent.put("code", (Object)e.getCode());
            parent.put("name", (Object)e.getName());
            supplierVo.setParent(parent);
        }
        return CommonResponse.success((Object)supplierVo);
    }

    @RequestMapping(value={"/queryDetails"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SupplierVO> queryDetails(@RequestParam Long id) {
        SupplierEntity supplierEntity = (SupplierEntity)((Object)this.supplierService.selectById(id));
        if (supplierEntity == null) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25");
        }
        SupplierVO supplierVo = (SupplierVO)BeanMapper.map((Object)((Object)supplierEntity), SupplierVO.class);
        return CommonResponse.success((Object)supplierVo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        if (ListUtil.isNotEmpty(ids)) {
            this.bankAccountService.delBySuppAndCustomIds("supplierId", ids);
            for (Long id : ids) {
                CommonResponse response = this.billTypeApi.checkQuote("BT200422000000028", id);
                if (response.isSuccess()) continue;
                return CommonResponse.error((String)("\u5220\u9664\u5931\u8d25\uff1a" + response.getMsg()));
            }
        } else {
            return CommonResponse.error((String)"\u5220\u9664\u5931\u8d25\uff1a\u4e3b\u952e\u4e3a\u7a7a!");
        }
        this.supplierService.deleteSupplier(ids);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SupplierVO>> queryList(@RequestBody QueryParam queryParam) {
        queryParam.getFuzzyFields().add("name");
        queryParam.getFuzzyFields().add("code");
        queryParam.getFuzzyFields().add("material_content");
        queryParam.getFuzzyFields().add("equipment_content");
        queryParam.getFuzzyFields().add("major_content");
        queryParam.getFuzzyFields().add("punish_apply_org");
        queryParam.getFuzzyFields().add("apply_org_name");
        if (queryParam.getParams().get("insideOrg") != null) {
            if ("true".equals(((Parameter)queryParam.getParams().get("insideOrg")).getValue())) {
                queryParam.getParams().put("insideOrg", new Parameter("eq", (Object)true));
            } else {
                queryParam.getParams().put("insideOrg", new Parameter("eq", (Object)false));
            }
        }
        IPage page = this.supplierService.queryPage(queryParam, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SupplierVO.class));
        return CommonResponse.success((Object)pageData);
    }

    @RequestMapping(value={"/querySubLeaderList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SubleadersVO>> querySubLeaderList(@RequestBody QueryParam queryParam) {
        IPage page = this.subleadersService.queryPage(queryParam, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        HashMap<Long, SupplierEntity> supplierEntityMap = new HashMap<Long, SupplierEntity>();
        List records = BeanMapper.mapList((Iterable)page.getRecords(), SubleadersVO.class);
        if (ListUtil.isNotEmpty((List)records)) {
            for (SubleadersVO record : records) {
                SupplierEntity supplier = (SupplierEntity)((Object)supplierEntityMap.get(record.getPid()));
                if (supplierEntityMap.get(record.getPid()) != null) {
                    supplier = (SupplierEntity)((Object)supplierEntityMap.get(record.getPid()));
                } else {
                    supplier = (SupplierEntity)((Object)this.supplierService.selectById(record.getPid()));
                    supplierEntityMap.put(supplier.getId(), supplier);
                }
                String content = "";
                if (StringUtils.isNotEmpty((CharSequence)supplier.getLaborContent())) {
                    content = content + supplier.getLaborContent() + ",";
                }
                if (StringUtils.isNotEmpty((CharSequence)supplier.getMajorContent())) {
                    content = content + supplier.getMajorContent();
                }
                record.setSupplierContent(content);
                record.setSupplierName(supplier.getName());
                record.setSupplierGrade(supplier.getGradeName());
                record.setArea(supplier.getAreaName());
                record.setSupplierCode(supplier.getCode());
                record.setPersonal(supplier.getPersonal());
            }
        }
        pageData.setRecords(records);
        return CommonResponse.success((Object)pageData);
    }

    @RequestMapping(value={"/subLeaderRef"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SubleadersVO>> subLeaderRef(@RequestParam(defaultValue="1") int pageNumber, @RequestParam(defaultValue="10") int pageSize, @RequestParam(required=false) String searchText, @RequestParam(required=false) String condition) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageSize(pageSize);
        queryParam.setPageIndex(pageNumber);
        queryParam.setSearchText(searchText);
        if (StringUtils.isEmpty((CharSequence)condition)) {
            return CommonResponse.error((String)"\u7f3a\u5c11condition\u53c2\u6570\uff01");
        }
        JSONObject con = JSONObject.parseObject((String)condition);
        if (con.getLong("supplierId") == null) {
            return CommonResponse.error((String)"condition\u7f3a\u5c11\u4f9b\u5e94\u5546id\u53c2\u6570supplierId\uff01");
        }
        queryParam.getParams().put("pid", new Parameter("eq", (Object)con.getLong("supplierId")));
        queryParam.getParams().put("inException", new Parameter("sql", (Object)" in_exception is not true "));
        IPage page = this.subleadersService.queryPage(queryParam, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List records = BeanMapper.mapList((Iterable)page.getRecords(), SubleadersVO.class);
        if (ListUtil.isNotEmpty((List)records)) {
            HashMap supplierEntityMap = new HashMap();
            for (SubleadersVO record : records) {
                if (supplierEntityMap.get(record.getPid()) == null) continue;
                SupplierEntity supplier = (SupplierEntity)((Object)supplierEntityMap.get(record.getPid()));
                String content = "";
                if (StringUtils.isNotEmpty((CharSequence)supplier.getLaborContent())) {
                    content = content + supplier.getLaborContent() + ",";
                }
                if (StringUtils.isNotEmpty((CharSequence)supplier.getMajorContent())) {
                    content = content + supplier.getMajorContent();
                }
                record.setSupplierContent(content);
                record.setSupplierName(supplier.getName());
                record.setSupplierGrade(supplier.getGradeName());
                record.setArea(supplier.getAreaName());
            }
        }
        pageData.setRecords(records);
        return CommonResponse.success((Object)pageData);
    }

    @RequestMapping(value={"/pageList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam queryParam) {
        IPage<SupplierVO> pageData = this.supplierService.queryPageList(queryParam);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", pageData);
        return CommonResponse.success((Object)jsonObject);
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"supplier-import.xlsx", (String)"\u4f9b\u65b9\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        Long tenantId = InvocationInfoProxy.getTenantid();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List<List<String>> result = ExcelReader.readExcel(mf);
        ArrayList<String> errorList = new ArrayList<String>();
        if (result != null && result.size() > 0) {
            Map<Object, Object> taxDefCodeMap = new HashMap();
            CommonResponse taxDefCode = this.defdocApi.getDefDocByDefCode("tax_payer_type");
            if (taxDefCode.isSuccess() && taxDefCode.getData() != null) {
                taxDefCodeMap = ((List)taxDefCode.getData()).stream().collect(Collectors.toMap(DefdocDetailVO::getName, BaseVO::getId));
            }
            for (int i = 0; i < result.size(); ++i) {
                List<String> datas = result.get(i);
                SupplierVO supplierVo = null;
                SupplierCategoryVO supplierCategoryVo = this.supplierCategoryService.queryByCode(String.valueOf(datas.get(0)));
                if (supplierCategoryVo != null) {
                    if (StringUtils.isEmpty((CharSequence)datas.get(2))) {
                        errorList.add("\u7b2c" + i + "\u884c\u6570\u636e\uff1a" + datas.toString() + "\u5bfc\u5165\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                        continue;
                    }
                    supplierVo = this.supplierService.queryDetailBySocialCode(String.valueOf(datas.get(2)));
                    if (supplierVo != null) {
                        errorList.add("\u7b2c" + i + "\u884c\u6570\u636e\uff1a" + datas.toString() + "\u5bfc\u5165\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u5b58\u5728\u76f8\u540c\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u7684\u4f9b\u5e94\u5546\uff01");
                        continue;
                    }
                    supplierVo = new SupplierVO();
                    CommonResponse codeBatchByRuleCode = this.billCodeApi.getCodeBatchByRuleCode(SUPPLIER_BILL_CODE, tenantId);
                    if (codeBatchByRuleCode.isSuccess()) {
                        supplierVo.setCode((String)codeBatchByRuleCode.getData());
                    } else {
                        supplierVo.setCode(String.valueOf(new Date().getTime()));
                    }
                    if (StringUtils.isEmpty((CharSequence)datas.get(1))) {
                        errorList.add("\u7b2c" + i + "\u884c\u6570\u636e\uff1a" + datas.toString() + "\u5bfc\u5165\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u4f9b\u65b9\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                        continue;
                    }
                    supplierVo.setName(String.valueOf(datas.get(1)));
                    supplierVo.setCategoryId(supplierCategoryVo.getId());
                    supplierVo.setSocialCreditCode(String.valueOf(datas.get(2)));
                    supplierVo.setLegal(String.valueOf(datas.get(3)));
                    if (StringUtils.isNotEmpty((CharSequence)datas.get(4))) {
                        supplierVo.setTaxPayerTypeName(datas.get(4));
                        if (taxDefCodeMap.get(datas.get(4)) != null) {
                            supplierVo.setTaxPayerType((Long)taxDefCodeMap.get(datas.get(4)));
                        }
                    }
                    supplierVo.setBusinessScope(datas.get(5));
                    supplierVo.setTelephone(datas.get(6));
                    supplierVo.setArea(datas.get(7));
                    supplierVo.setAddress(datas.get(8));
                    supplierVo.setBankName(datas.get(9));
                    supplierVo.setBankAccount(datas.get(10));
                    supplierVo.setBankCode(datas.get(11));
                    if (StringUtils.isNotEmpty((CharSequence)datas.get(12))) {
                        ArrayList<SupplierLinkerVO> gridheaders = new ArrayList<SupplierLinkerVO>();
                        String linkman = String.valueOf(datas.get(12));
                        SupplierLinkerVO supplierLinkerVo = this.supplierLinkerService.queryBySupplierIdAndLinkman(supplierVo.getId(), linkman);
                        if (supplierLinkerVo == null) {
                            supplierLinkerVo = new SupplierLinkerVO();
                            supplierLinkerVo.setRowState("add");
                        } else {
                            supplierLinkerVo.setRowState("edit");
                        }
                        supplierLinkerVo.setSupplierId(supplierVo.getId());
                        supplierLinkerVo.setLinkman(datas.get(12));
                        supplierLinkerVo.setCellphone(datas.get(13));
                        gridheaders.add(supplierLinkerVo);
                        supplierVo.setGridheaders(gridheaders);
                    }
                    supplierVo.setEnabled(Integer.valueOf(1));
                    this.supplierService.saveOrUpdate(supplierVo);
                    continue;
                }
                errorList.add("\u7b2c" + i + "\u884c\u6570\u636e\uff1a" + datas.toString() + "\u5bfc\u5165\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u4f9b\u65b9\u5206\u7c7b\u7f16\u53f7\u4e0d\u6b63\u786e\uff01");
            }
        }
        if (errorList.size() > 0) {
            errorList.add("\u5bfc\u5165\u6210\u529f\uff1a" + (result.size() - errorList.size() - 1) + "\u6761, \u5931\u8d25\uff1a" + errorList.size() + "\u6761");
            return CommonResponse.error((String)"\u5bfc\u5165\u5931\u8d25", errorList);
        }
        return CommonResponse.success((String)"\u5bfc\u5165\u6210\u529f");
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        List<Object> supplierVos = new ArrayList();
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        supplierVos = this.supplierService.queryExportList(queryParam);
        HashMap beans = new HashMap();
        beans.put("records", supplierVos);
        ExcelExport.getInstance().export("supplier-export.xlsx", beans, response);
    }

    @RequestMapping(value={"refSupplierPage"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SupplierVO>> refSupplierPage(@RequestParam(defaultValue="1") int pageNumber, @RequestParam(defaultValue="10") int pageSize, @RequestParam(required=false) String relyCondition, @RequestParam(required=false) String searchText, @RequestParam(required=false) String condition) {
        Long categoryId;
        SupplierCategoryEntity supplierCategoryEntity;
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((CharSequence)relyCondition) && (supplierCategoryEntity = this.supplierCategoryService.queryDetail(categoryId = Long.valueOf(Long.parseLong(relyCondition.split("=")[1])))) != null) {
            params.put("innerCode", supplierCategoryEntity.getInnerCode());
        }
        params.put("pageIndex", pageNumber <= 0 ? 0 : (pageNumber - 1) * pageSize);
        params.put("pageSize", pageSize);
        params.put("searchText", searchText);
        params.put("range", "outside");
        params.put("enabled", 1);
        params.put("tenantId", InvocationInfoProxy.getTenantid());
        IPage<SupplierVO> pageData = this.supplierService.queryRefMaterialPage(params);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", pageData);
    }

    @RequestMapping(value={"refProSupplier"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SupplierVO>> refProSupplier(@RequestParam(defaultValue="1") int pageNumber, @RequestParam(defaultValue="10") int pageSize, @RequestParam(required=false) String searchText, @RequestParam(required=false) String condition) {
        QueryParam param = new QueryParam();
        param.setPageIndex(pageNumber);
        param.setPageSize(pageSize);
        param.setSearchText(searchText);
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("tax_payer_identifier");
        param.getParams().put("inException", new Parameter("sql", (Object)" in_exception is not true "));
        if (StringUtils.isNotBlank((CharSequence)condition)) {
            String supplyType = JSONObject.parseObject((String)condition).getString("supplyType");
            String supplyQueryType = JSONObject.parseObject((String)condition).getString("supplyQueryType");
            String personal = JSONObject.parseObject((String)condition).getString("personal");
            String enabled = JSONObject.parseObject((String)condition).getString("enabled");
            Boolean inException = JSONObject.parseObject((String)condition).getBoolean("inException");
            Boolean insideOrg = JSONObject.parseObject((String)condition).getBoolean("insideOrg");
            if (StringUtils.isNotBlank((CharSequence)supplyType)) {
                String[] types = supplyType.split(",");
                if (types.length == 1) {
                    param.getParams().put("supplyType", new Parameter("like", (Object)types[0]));
                } else {
                    ComplexParam complexParam = new ComplexParam();
                    complexParam.setLogic("and");
                    ArrayList<ComplexParam> complexParams = new ArrayList<ComplexParam>();
                    for (String type : types) {
                        ComplexParam complex = new ComplexParam();
                        complex.setLogic("or");
                        HashMap<String, Parameter> inP = new HashMap<String, Parameter>();
                        inP.put("supplyType", new Parameter("like", (Object)type));
                        complex.setParams(inP);
                        complexParams.add(complex);
                    }
                    complexParam.setComplexParams(complexParams);
                    param.getComplexParams().add(complexParam);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)supplyQueryType)) {
                param.getParams().put("supplyQueryType", new Parameter("eq", (Object)supplyQueryType));
            }
            if (StringUtils.isNotBlank((CharSequence)enabled)) {
                param.getParams().put("enabled", new Parameter("eq", (Object)enabled));
            } else {
                param.getParams().put("enabled", new Parameter("eq", (Object)1));
            }
            if (StringUtils.isNotBlank((CharSequence)personal)) {
                param.getParams().put("personal", new Parameter("eq", (Object)personal));
            }
            if (inException != null && inException.booleanValue()) {
                param.getParams().remove("inException");
            }
            if (insideOrg != null) {
                param.getParams().put("insideOrg", new Parameter("eq", (Object)insideOrg));
            }
        } else {
            param.getParams().put("enabled", new Parameter("eq", (Object)1));
        }
        param.getOrderMap().put("createTime", "desc");
        IPage page = this.supplierService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SupplierVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"refProSupplierCerts"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<CertsVO>> refProSupplierCerts(@RequestParam(defaultValue="1") int pageNumber, @RequestParam(defaultValue="10") int pageSize, @RequestParam(required=false) String searchText, @RequestParam(required=false) String condition) {
        String supplyId;
        QueryParam param = new QueryParam();
        param.setPageIndex(pageNumber);
        param.setPageSize(pageSize);
        param.setSearchText(searchText);
        param.getFuzzyFields().add("certName");
        param.getFuzzyFields().add("certCode");
        if (StringUtils.isNotBlank((CharSequence)condition)) {
            supplyId = JSONObject.parseObject((String)condition).getString("supplyId");
            if (!StringUtils.isNotBlank((CharSequence)supplyId)) {
                return CommonResponse.error((String)"\u7f3a\u5c11supplyId\u53c2\u6570\uff01");
            }
        } else {
            return CommonResponse.error((String)"\u7f3a\u5c11supplyId\u53c2\u6570\uff01");
        }
        param.getParams().put("pid", new Parameter("eq", (Object)supplyId));
        IPage page = this.certsService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CertsVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"refInsideSupplierPage"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SupplierVO>> refInsideSupplierPage(@RequestParam(defaultValue="1") int pageNumber, @RequestParam(defaultValue="10") int pageSize, @RequestParam(required=false) String relyCondition, @RequestParam(required=false) String searchText, @RequestParam(required=false) String condition) {
        Long categoryId;
        SupplierCategoryEntity supplierCategoryEntity;
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((CharSequence)relyCondition) && (supplierCategoryEntity = this.supplierCategoryService.queryDetail(categoryId = Long.valueOf(Long.parseLong(relyCondition.split("=")[1])))) != null) {
            params.put("innerCode", supplierCategoryEntity.getInnerCode());
        }
        params.put("pageIndex", pageNumber <= 0 ? 0 : (pageNumber - 1) * pageSize);
        params.put("pageSize", pageSize);
        params.put("searchText", searchText);
        params.put("range", "inside");
        params.put("enabled", 1);
        params.put("tenantId", InvocationInfoProxy.getTenantid());
        IPage<SupplierVO> pageData = this.supplierService.queryRefMaterialPage(params);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", pageData);
    }

    @RequestMapping(value={"/enableSupplierOrNot"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> enableSupplierOrNot(@RequestBody Map<String, Object> data) {
        if (data == null) {
            return CommonResponse.error((String)"\u6ca1\u6709\u53ef\u5904\u7406\u7684\u6570\u636e\uff01");
        }
        List ids = (List)data.get("ids");
        String state = (String)data.get("state");
        if (ListUtil.isEmpty((List)ids) || StringUtils.isEmpty((CharSequence)state)) {
            return CommonResponse.error((String)"\u6ca1\u6709\u53ef\u5904\u7406\u7684\u6570\u636e\uff01");
        }
        if (!state.equals("0") && !state.equals("1")) {
            return CommonResponse.error((String)"\u5408\u4f5c\u72b6\u6001\u4e0d\u6b63\u786e\uff01");
        }
        data.put("tenantId", InvocationInfoProxy.getTenantid());
        data.put("ids", StringUtils.join((Object[])ids.toArray(), (String)","));
        this.supplierService.enableSupplierOrNot(data);
        return CommonResponse.success((String)"\u5904\u7406\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/querySupplierByTenantId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SupplierVO> querySupplierByTenantId(@RequestParam Long tenant) {
        SupplierVO supplierVo = this.supplierService.querySupplierByTenantId(tenant);
        return CommonResponse.success((Object)supplierVo);
    }

    @RequestMapping(value={"/querySupplierByCode"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SupplierVO> querySupplierByCode(@RequestParam String code) {
        SupplierVO supplierVo = new SupplierVO();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"code", (Object)code);
        queryWrapper.eq((Object)"dr", (Object)0);
        List list = this.supplierService.list((Wrapper)queryWrapper);
        if (list != null && list.size() > 0) {
            supplierVo = (SupplierVO)BeanMapper.map(list.get(0), SupplierVO.class);
            return CommonResponse.success((Object)supplierVo);
        }
        return CommonResponse.success(null);
    }

    @RequestMapping(value={"/querySupplierBySourceId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SupplierVO> querySupplierBySourceId(@RequestParam String sourceId) {
        SupplierVO supplierVo = new SupplierVO();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"source_id", (Object)sourceId);
        queryWrapper.eq((Object)"enabled", (Object)1);
        queryWrapper.eq((Object)"dr", (Object)0);
        List list = this.supplierService.list((Wrapper)queryWrapper);
        if (list != null && list.size() > 0) {
            supplierVo = (SupplierVO)BeanMapper.map(list.get(0), SupplierVO.class);
            return CommonResponse.success((Object)supplierVo);
        }
        return CommonResponse.error((String)"\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u4f9b\u5e94\u5546");
    }

    @RequestMapping(value={"/generateInsideSupplierAndCustomer"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> generateInsideSupplierAndCustomer(@RequestBody List<OrgVO> orgList) {
        return this.supplierService.generateInsideSupplierAndCustomer(orgList);
    }

    @RequestMapping(value={"/updateInsideSupplierAndCustomer"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<OrgVO> updateInsideSupplierAndCustomer(@RequestBody OrgVO orgVO) {
        return this.supplierService.updateInsideSupplierAndCustomer(orgVO);
    }

    @RequestMapping(value={"/generateSupplierAccount"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> generateSupplierAccount(@RequestParam(value="supplierId") Long supplierId, @RequestParam(value="name") String name, @RequestParam(value="telephone") String telephone) {
        return this.supplierService.generateSupplierTenant(supplierId, name, telephone);
    }

    @RequestMapping(value={"/generateAccessToken"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> generateAccessToken(@RequestParam(value="id") Long supplierId) {
        if (this.redisTemplate.opsForValue().get((Object)("EachLink-Open-Api-Info-" + supplierId)) != null) {
            return CommonResponse.success((String)"\u5904\u7406\u6210\u529f\uff01");
        }
        SupplierEntity se = (SupplierEntity)((Object)this.supplierService.selectById(supplierId));
        if (se == null) {
            return CommonResponse.error((String)"\u6ca1\u6709\u67e5\u8be2\u5230\u6b64\u4f9b\u5e94\u5546\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)se.getSystemId())) {
            return CommonResponse.error((String)"\u8be5\u4f9b\u5e94\u5546\u5c1a\u672a\u751f\u6210\u534f\u540c\u8d26\u53f7\uff01");
        }
        CommonResponse res = this.systemDataPushService.exchangeDataWithUniversal("/ejc-idm-web/openapi/enterprise/queryAuthInfo?id=" + se.getSystemId(), RequestMethod.GET, null, this.appId, this.secret, this.eachLinkHost);
        if (res.isSuccess()) {
            JSONObject object = JSONObject.parseObject((String)((String)res.getData()));
            if (object.getInteger("code") == 0) {
                this.redisTemplate.opsForValue().set((Object)("EachLink-Open-Api-Info-" + supplierId), (Object)(this.eachLinkHost + "------" + object.getString("data")));
                return CommonResponse.success((String)"\u5904\u7406\u6210\u529f\uff01");
            }
            return CommonResponse.error((String)object.getString("msg"));
        }
        return res;
    }
}

