package com.ejianc.foundation.share.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.bean.ProsubCategoryEntity;
import com.ejianc.foundation.share.bean.ProsubItemEntity;
import com.ejianc.foundation.share.service.IProsubCategoryService;
import com.ejianc.foundation.share.service.IProsubItemService;
import com.ejianc.foundation.share.vo.ProsubCategoryVO;
import com.ejianc.foundation.share.vo.RefProsubCategoryVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.core.util.ResultAsTree;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 专业分包分类
 *
 * @author generator
 */
@Controller
@RequestMapping("/majorSub/category")
public class ProsubCategoryController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IProsubCategoryService service;
    @Autowired
    private IProsubItemService prosubItemService;
    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ProsubCategoryVO> saveOrUpdate(@RequestBody ProsubCategoryVO saveorUpdateVO) {
        CommonResponse<ProsubCategoryVO> response = service.saveOrUpdateProsubCategory(saveorUpdateVO);
        return response;
    }
    /**
     * 绑定科目
     *
     * @param map
     * @return
     */
    @RequestMapping(value = "/bandSubject", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> bandSubject(@RequestBody Map map) {
        List<Long> ids = (List<Long>) map.get("ids");
        Long subjectId = Long.valueOf(map.get("subjectId").toString());
        String subjectName = (String) map.get("subjectName");
        service.updateSubject(subjectId,subjectName,ids);
        return CommonResponse.success("绑定成功!");
    }
    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProsubCategoryVO> queryDetail(Long id) {
        ProsubCategoryEntity entity = service.selectById(id);
        ProsubCategoryVO vo = BeanMapper.map(entity, ProsubCategoryVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProsubCategoryVO> vos) {
        CommonResponse<String> msg = service.deleteById(vos);
        return msg;
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<Map<String, Object>>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        List<ProsubCategoryVO> dataList = service.queryProsubCategoryList(param);
        List<Map> resultMapList = BeanMapper.mapList(dataList, Map.class);
        resultMapList.forEach(l-> {
            if(l.get("isLeaf").equals(false)){
                l.put("children", new ArrayList<>());
            }
        });
        List<Map<String, Object>> treeData = ResultAsTree.createTreeData(resultMapList);
        return CommonResponse.success(treeData);
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ProsubCategoryEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>(list.size());
        beans.put("records", list);
        ExcelExport.getInstance().export("ProsubCategory-export.xlsx", beans, response);
    }

    /**
     * @param
     * @Description 专业分包分类树
     * @Return void
     */
    @RequestMapping(value = "/refProsubCategoryData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<Map<String, Object>>> refProsubCategoryData( Integer pageNumber, Integer pageSize,
                                                           String condition,
                                                           String searchObject,
                                                           String searchText) {
        QueryParam param = new QueryParam();
        param.getFuzzyFields().add("categoryCode");
        param.getFuzzyFields().add("categoryName");
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject con = JSONObject.parseObject(condition);
        }
        List<ProsubCategoryEntity> prosubCategoryEntities = null;
        try {
            prosubCategoryEntities = service.queryList(param, false);
            List<Map> map = BeanMapper.mapList(prosubCategoryEntities, Map.class);
            map.forEach(t->{
                t.put("detailCode",t.get("categoryCode"));
                t.put("detailName",t.get("categoryName"));
            });
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("enabled", new Parameter(QueryParam.EQ, 0));
            List<ProsubItemEntity> list = prosubItemService.queryList(queryParam);
            List<Map> itemMap = BeanMapper.mapList(list, Map.class);
            itemMap.forEach(t->{
                t.put("parentId", t.get("categoryId"));
                t.put("detailCode",t.get("trawlingCode"));
                t.put("detailName",t.get("trawlingName"));
                map.add(t);
            });
            List<Map<String, Object>> treeData = ResultAsTree.createTreeData(map);
           return  CommonResponse.success("查询参照数据成功！",treeData);
        } catch (Exception e) {
            return null;
        }
    }

    /**
     * 参照异步（懒加载）树----专业分包分类树
     *
     * @param condition
     * @param searchText lazyProsubCategoryTree
     * @return
     */
    @RequestMapping(value = "/lazyProSubCategoryTree", method = RequestMethod.GET)
    @ResponseBody
    public List<Map<String, Object>> lazyProsubCategoryTree(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                            String condition,
                                                            String searchObject,
                                                            String searchText,
                                                            Long pid
    ) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (pid != null) {
            param.getParams().put("parent_id", new Parameter(QueryParam.EQ, pid));
        }
        List<ProsubCategoryEntity> prosubCategoryEntities = service.queryList(param, false);
        List<RefProsubCategoryVO> prosubCategoryVOS = BeanMapper.mapList(prosubCategoryEntities, RefProsubCategoryVO.class);
        List<Map> map = BeanMapper.mapList(prosubCategoryVOS, Map.class);
        List<Map<String, Object>> treeData = ResultAsTree.createTreeData(map);
        if (CollectionUtils.isNotEmpty(treeData)) {
            map.forEach(item -> {
                QueryParam queryParam = new QueryParam();
                queryParam.getParams().put("parent_id", new Parameter(QueryParam.EQ, item.get("id")));
                List<ProsubCategoryEntity> prosubCategoryEntities1 = service.queryList(queryParam);
                if (CollectionUtils.isNotEmpty(prosubCategoryEntities1)) {
                    item.put("isLeaf", false);
                } else {
                    item.put("isLeaf", true);
                }
            });
        }
        return treeData;
    }


    /**
     * @Author wangyouchun
     * @Date 2021/12/8 专业分包分类导入模板下载
     * @Description download
     * @Param [request, response]
     * @Return void
     */
    @RequestMapping(value = "/download")
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "prosub-category-import.xlsx", "专业分包分类导入模板");
    }


    @RequestMapping(value = "/excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request) {
        CommonResponse<JSONObject> response = service.excelImport(request);
        return response;
    }

    @RequestMapping(value = "/saveImportExcelProsubCategory", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> saveImportExcelProsubCategory(@RequestBody List<ProsubCategoryEntity> importVos) {
        if (ListUtil.isEmpty(importVos)) {
            return CommonResponse.error("导入的数据为空！");
        }
        List<ProsubCategoryEntity> toSave = new ArrayList<>();
        importVos.forEach(importVO -> {
            ProsubCategoryEntity entity = BeanMapper.map(importVO, ProsubCategoryEntity.class);
            entity.setOrgId(sessionManager.getUserContext().getOrgId());
            entity.setOrgName(sessionManager.getUserContext().getOrgName());
            toSave.add(entity);
        });
        service.saveBatch(toSave, toSave.size());
        return CommonResponse.success("保存成功！");
    }
}
