/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.bean.CustomerCategoryEntity;
import com.ejianc.foundation.share.bean.CustomerEntity;
import com.ejianc.foundation.share.bean.EjcCloudSystemEntity;
import com.ejianc.foundation.share.bean.SubleadersEntity;
import com.ejianc.foundation.share.bean.SupplierCategoryEntity;
import com.ejianc.foundation.share.bean.SupplierEntity;
import com.ejianc.foundation.share.bean.SupplierLinkerEntity;
import com.ejianc.foundation.share.mapper.SupplierCategoryMapper;
import com.ejianc.foundation.share.mapper.SupplierMapper;
import com.ejianc.foundation.share.service.ICustomerCategoryService;
import com.ejianc.foundation.share.service.ICustomerService;
import com.ejianc.foundation.share.service.IEjcCloudSystemService;
import com.ejianc.foundation.share.service.ISubleadersService;
import com.ejianc.foundation.share.service.ISupplierCategoryService;
import com.ejianc.foundation.share.service.ISupplierLinkerService;
import com.ejianc.foundation.share.service.ISupplierService;
import com.ejianc.foundation.share.vo.PushToPublicSupplierInfoVO;
import com.ejianc.foundation.share.vo.SupplierLinkerVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.foundation.tenant.api.IEnterpriseApi;
import com.ejianc.foundation.tenant.vo.EnterpriseVO;
import com.ejianc.foundation.tenant.vo.TenantVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.conn.ConnectTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;

@Service
@Transactional
public class SupplierServiceImpl
extends BaseServiceImpl<SupplierMapper, SupplierEntity>
implements ISupplierService {
    private static final String SUPPLIER_BILL_CODE = "SUPPORT_SUPPLIER";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private SupplierMapper supplierMapper;
    @Autowired
    private SupplierCategoryMapper supplierCategoryMapper;
    @Autowired
    private ISupplierLinkerService supplierLinkerService;
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private ISupplierCategoryService categoryService;
    @Autowired
    private IEnterpriseApi enterpriseApi;
    @Autowired
    private IOrgApi orgApi;
    @Value(value="${sendMessageTemplateCode}")
    private String sendMessageTemplateCode;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Value(value="${insideSupplierCategoryCode:SPC-inside}")
    private String insideSupplierCategoryCode;
    @Value(value="${insideCustomerCategoryCode:CC-inside}")
    private String insideCustomerCategoryCode;
    @Value(value="${eachLink.host}")
    private String eachLinkHost;
    @Value(value="${eachLink.appId}")
    private String appId;
    @Value(value="${eachLink.secret}")
    private String secret;
    @Autowired
    private ICustomerCategoryService customerCategoryService;
    @Autowired
    private ICustomerService customerService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ISupplierCategoryService supplierCategoryService;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private IEjcCloudSystemService ejcCloudSystemService;
    @Autowired
    private ISubleadersService subleadersService;
    @Autowired
    private IOrgApi iOrgApi;

    @Override
    public List<SupplierVO> queryListByCategoryId(Long categoryId) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"category_id", (Object)categoryId);
        List entities = this.supplierMapper.selectList((Wrapper)wrapper);
        if (entities != null) {
            return BeanMapper.mapList((Iterable)entities, SupplierVO.class);
        }
        return null;
    }

    private List<Long> getOrgIds() {
        ArrayList<Long> orgIds = new ArrayList<Long>();
        CommonResponse nowOrg = this.orgApi.getOneById(InvocationInfoProxy.getOrgId());
        if (nowOrg.isSuccess() && nowOrg.getData() != null) {
            if (((OrgVO)nowOrg.getData()).getOrgType() == 1) {
                CommonResponse list = this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
                if (list.isSuccess() && list.getData() != null && ((List)list.getData()).size() > 0) {
                    for (OrgVO vo : (List)list.getData()) {
                        orgIds.add(vo.getId());
                    }
                    return orgIds;
                }
            } else {
                CommonResponse parentlist = this.orgApi.findParentsByOrgId(InvocationInfoProxy.getOrgId());
                if (parentlist.isSuccess() && parentlist.getData() != null && ((List)parentlist.getData()).size() > 0) {
                    CommonResponse list;
                    Long parentId = InvocationInfoProxy.getOrgId();
                    for (int i = ((List)parentlist.getData()).size() - 1; i >= 0; --i) {
                        OrgVO vo = (OrgVO)((List)parentlist.getData()).get(i);
                        if (vo.getOrgType() != 2) continue;
                        parentId = vo.getId();
                        break;
                    }
                    if ((list = this.orgApi.findChildrenByParentId(parentId)).isSuccess() && list.getData() != null && ((List)list.getData()).size() > 0) {
                        for (OrgVO vo : (List)list.getData()) {
                            orgIds.add(vo.getId());
                        }
                        return orgIds;
                    }
                }
            }
        }
        return null;
    }

    @Override
    public CommonResponse<SupplierVO> saveOrUpdate(SupplierVO supplierVo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        SupplierEntity entity = null;
        String operateType = null;
        this.check(supplierVo);
        if (supplierVo.getId() != null && supplierVo.getId() > 0L) {
            entity = (SupplierEntity)((Object)this.supplierMapper.selectById(supplierVo.getId()));
            entity.setCode(supplierVo.getCode());
            entity.setName(supplierVo.getName());
            entity.setCategoryId(supplierVo.getCategoryId());
            entity.setCategoryName(supplierVo.getCategoryName());
            entity.setSocialCreditCode(supplierVo.getSocialCreditCode());
            entity.setLegal(supplierVo.getLegal());
            entity.setTaxPayerType(supplierVo.getTaxPayerType());
            entity.setBusinessScope(supplierVo.getBusinessScope());
            entity.setArea(supplierVo.getArea());
            entity.setAddress(supplierVo.getAddress());
            entity.setTelephone(supplierVo.getTelephone());
            entity.setBankName(supplierVo.getBankName());
            entity.setBankAccount(supplierVo.getBankAccount());
            entity.setBankCode(supplierVo.getBankCode());
            entity.setDescription(supplierVo.getDescription());
            entity.setEnabled(supplierVo.getEnabled());
            entity.setEnterpriseNature(supplierVo.getEnterpriseNature());
            entity.setEnterpriseNatureName(supplierVo.getEnterpriseNatureName());
            operateType = "edit";
        } else {
            CommonResponse codeBatchByRuleCode = this.billCodeApi.getCodeBatchByRuleCode(SUPPLIER_BILL_CODE, tenantId);
            if (codeBatchByRuleCode.isSuccess()) {
                supplierVo.setCode((String)codeBatchByRuleCode.getData());
            }
            entity = (SupplierEntity)((Object)BeanMapper.map((Object)supplierVo, SupplierEntity.class));
            entity.setOrgId(InvocationInfoProxy.getOrgId());
            entity.setOrgName(this.sessionManager.getUserContext().getOrgName());
            operateType = "add";
        }
        if (StringUtils.isNotBlank((CharSequence)entity.getArea())) {
            String regex = "((?<provinceAndCity>[^\u5e02]+\u5e02|.*?\u81ea\u6cbb\u5dde|.*?\u533a|.*\u53bf)(?<town>[^\u533a]+\u533a|.*?\u5e02|.*?\u53bf|.*?\u8def|.*?\u8857|.*?\u9053|.*?\u9547|.*?\u65d7)(?<detailAddress>.*))";
            Matcher matcher = Pattern.compile(regex).matcher(entity.getArea());
            while (matcher.find()) {
                try {
                    entity.setRegion(matcher.group("town"));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                String regex2 = "((?<province>[^\u7701]+\u7701|.+\u81ea\u6cbb\u533a|\u4e0a\u6d77\u5e02|\u5317\u4eac\u5e02|\u5929\u6d25\u5e02|\u91cd\u5e86\u5e02|\u4e0a\u6d77|\u5317\u4eac|\u5929\u6d25|\u91cd\u5e86|\u9999\u6e2f\u7279\u522b\u884c\u653f\u533a|\u6fb3\u95e8\u7279\u522b\u884c\u653f\u533a)(?<city>.*))";
                Object provinceAndCity = "";
                try {
                    provinceAndCity = matcher.group("provinceAndCity");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                Matcher matcher2 = Pattern.compile(regex2).matcher((CharSequence)provinceAndCity);
                while (matcher2.find()) {
                    try {
                        entity.setProvince(matcher.group("province"));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    try {
                        String city = matcher2.group("city");
                        if (StringUtils.isBlank((CharSequence)city)) {
                            entity.setCity(entity.getProvince());
                            continue;
                        }
                        entity.setCity(matcher.group("city"));
                    }
                    catch (IllegalArgumentException city) {}
                }
            }
        }
        super.saveOrUpdate((Object)entity);
        List supplierLinkerVos = supplierVo.getGridheaders();
        ArrayList<SupplierLinkerEntity> saveOrUpldates = new ArrayList<SupplierLinkerEntity>();
        ArrayList<Long> deleteIds = new ArrayList<Long>();
        for (SupplierLinkerVO supplierLinkerVo : supplierLinkerVos) {
            SupplierLinkerEntity supplierLinkerEntity;
            if ("add".equals(supplierLinkerVo.getRowState())) {
                supplierLinkerEntity = (SupplierLinkerEntity)((Object)BeanMapper.map((Object)supplierLinkerVo, SupplierLinkerEntity.class));
                supplierLinkerEntity.setSupplierId(entity.getId());
                saveOrUpldates.add(supplierLinkerEntity);
                continue;
            }
            if ("edit".equals(supplierLinkerVo.getRowState())) {
                supplierLinkerEntity = (SupplierLinkerEntity)((Object)BeanMapper.map((Object)supplierLinkerVo, SupplierLinkerEntity.class));
                saveOrUpldates.add(supplierLinkerEntity);
                continue;
            }
            if (!"del".equals(supplierLinkerVo.getRowState())) continue;
            deleteIds.add(supplierLinkerVo.getId());
        }
        if (saveOrUpldates.size() > 0) {
            this.supplierLinkerService.saveOrUpdateBatch(saveOrUpldates, saveOrUpldates.size(), false);
        }
        if (deleteIds.size() > 0) {
            this.supplierLinkerService.removeByIds(deleteIds, false);
        }
        SupplierVO vo = this.queryDetail(entity.getId());
        JSONObject parent = new JSONObject();
        SupplierCategoryEntity e = (SupplierCategoryEntity)((Object)this.supplierCategoryService.selectById(vo.getCategoryId()));
        parent.put("id", (Object)e.getId());
        parent.put("code", (Object)e.getCode());
        parent.put("name", (Object)e.getName());
        vo.setParent(parent);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f", (Object)vo);
    }

    private void check(SupplierVO supplierVo) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (supplierVo.getId() != null) {
            queryWrapper.ne((Object)"id", (Object)supplierVo.getId());
        }
        queryWrapper.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.eq((Object)"social_credit_code", (Object)supplierVo.getSocialCreditCode());
        List list = this.list((Wrapper)queryWrapper);
        if (list != null && list.size() > 0) {
            throw new BusinessException("\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u5df2\u5b58\u5728\uff01\uff01\uff01");
        }
    }

    @Override
    public SupplierVO queryDetail(Long id) {
        SupplierEntity entity = (SupplierEntity)((Object)this.supplierMapper.selectById(id));
        if (entity != null) {
            SupplierVO supplierVo = (SupplierVO)BeanMapper.map((Object)((Object)entity), SupplierVO.class);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("supplierId", new Parameter("eq", (Object)supplierVo.getId()));
            queryParam.getOrderMap().put("createTime", "desc");
            List supplierLinkers = this.supplierLinkerService.queryList(queryParam, false);
            if (supplierLinkers != null && supplierLinkers.size() > 0) {
                List supplierLinkerVos = BeanMapper.mapList((Iterable)supplierLinkers, SupplierLinkerVO.class);
                supplierVo.setGridheaders(supplierLinkerVos);
            }
            return supplierVo;
        }
        return null;
    }

    @Override
    public void deleteSupplier(List<Long> ids) {
        for (Long id : ids) {
            this.supplierLinkerService.deleteBySupplierId(id);
            this.supplierMapper.deleteById(id);
        }
    }

    @Override
    public void enableSupplierOrNot(Map<String, Object> data) {
        this.supplierMapper.enableSupplierOrNot(data);
    }

    @Override
    public IPage<SupplierVO> queryPageList(QueryParam queryParam) {
        Map paramMap = queryParam.getParams();
        HashMap<String, Object> condition = new HashMap<String, Object>();
        for (Map.Entry entry : paramMap.entrySet()) {
            if ("categoryId".equals(entry.getKey())) {
                SupplierCategoryEntity categoryEntity;
                if (!StringUtils.isNotBlank((CharSequence)((Parameter)entry.getValue()).getValue().toString()) || (categoryEntity = this.categoryService.queryDetail(Long.parseLong(((Parameter)entry.getValue()).getValue().toString()))) == null) continue;
                condition.put("innerCode", categoryEntity.getInnerCode());
                continue;
            }
            condition.put((String)entry.getKey(), ((Parameter)entry.getValue()).getValue());
        }
        condition.put("pageIndex", (queryParam.getPageIndex() - 1) * queryParam.getPageSize());
        condition.put("pageSize", queryParam.getPageSize());
        condition.put("tenantId", InvocationInfoProxy.getTenantid());
        List<SupplierEntity> supplierEntities = this.supplierMapper.queryList(condition);
        Long count = this.supplierMapper.queryCount(condition);
        ArrayList<SupplierVO> supplierVos = new ArrayList<SupplierVO>();
        SupplierVO supplierVo = null;
        for (SupplierEntity entity : supplierEntities) {
            supplierVo = (SupplierVO)BeanMapper.map((Object)((Object)entity), SupplierVO.class);
            CommonResponse defDocById = this.defdocApi.getDefDocById(supplierVo.getTaxPayerType());
            if (defDocById.isSuccess() && defDocById.getData() != null) {
                supplierVo.setTaxPayerTypeName(((DefdocDetailVO)defDocById.getData()).getName());
            }
            supplierVos.add(supplierVo);
        }
        Page resultPage = new Page();
        resultPage.setCurrent((long)queryParam.getPageIndex());
        resultPage.setRecords(supplierVos);
        resultPage.setTotal(count.longValue());
        return resultPage;
    }

    @Override
    public List<SupplierVO> queryExportList(QueryParam queryParam) {
        Map paramMap = queryParam.getParams();
        HashMap<String, Object> condition = new HashMap<String, Object>();
        for (Map.Entry entry : paramMap.entrySet()) {
            condition.put((String)entry.getKey(), ((Parameter)entry.getValue()).getValue());
        }
        List<SupplierEntity> supplierEntities = this.supplierMapper.queryExportList(condition);
        ArrayList<SupplierVO> supplierVos = new ArrayList<SupplierVO>();
        SupplierVO supplierVo = null;
        for (SupplierEntity entity : supplierEntities) {
            supplierVo = (SupplierVO)BeanMapper.map((Object)((Object)entity), SupplierVO.class);
            CommonResponse defDocById = this.defdocApi.getDefDocById(supplierVo.getTaxPayerType());
            if (defDocById.isSuccess() && defDocById.getData() != null) {
                supplierVo.setTaxPayerTypeName(((DefdocDetailVO)defDocById.getData()).getName());
            }
            QueryParam linkerQueryParam = new QueryParam();
            linkerQueryParam.getParams().put("supplierId", new Parameter("eq", (Object)supplierVo.getId()));
            List linkerEntities = this.supplierLinkerService.queryList(linkerQueryParam, false);
            if (linkerEntities != null && linkerEntities.size() > 0) {
                SupplierLinkerEntity linkerEntity = (SupplierLinkerEntity)((Object)linkerEntities.get(0));
                supplierVo.setLinkman(linkerEntity.getLinkman());
                supplierVo.setCellphone(linkerEntity.getCellphone());
            }
            supplierVos.add(supplierVo);
        }
        return supplierVos;
    }

    @Override
    public SupplierVO queryDetailBySocialCode(String socialCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"social_credit_code", (Object)socialCode);
        queryWrapper.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        List entities = this.supplierMapper.selectList((Wrapper)queryWrapper);
        if (entities != null && entities.size() > 0) {
            return (SupplierVO)BeanMapper.map(entities.get(0), SupplierVO.class);
        }
        return null;
    }

    @Override
    public IPage<SupplierVO> queryRefMaterialPage(Map<String, Object> params) {
        List<SupplierEntity> supplierEntities = this.supplierMapper.queryList(params);
        Long count = this.supplierMapper.queryCount(params);
        ArrayList<SupplierVO> supplierVos = new ArrayList<SupplierVO>();
        SupplierVO supplierVo = null;
        for (SupplierEntity entity : supplierEntities) {
            supplierVo = (SupplierVO)BeanMapper.map((Object)((Object)entity), SupplierVO.class);
            CommonResponse defDocById = this.defdocApi.getDefDocById(supplierVo.getTaxPayerType());
            if (defDocById.isSuccess() && defDocById != null) {
                supplierVo.setTaxPayerTypeName(((DefdocDetailVO)defDocById.getData()).getName());
            }
            supplierVos.add(supplierVo);
        }
        Page resultPage = new Page();
        resultPage.setRecords(supplierVos);
        resultPage.setTotal(count.longValue());
        return resultPage;
    }

    @Override
    public CommonResponse<String> supplierCollaboration(SupplierVO supplierVO) {
        EnterpriseVO enterpriseVO = new EnterpriseVO();
        enterpriseVO.setName(supplierVO.getName());
        enterpriseVO.setId(Long.valueOf(IdWorker.getId()));
        enterpriseVO.setCode(String.valueOf(enterpriseVO.getId() + 1L));
        enterpriseVO.setTelephone(supplierVO.getTelephone());
        enterpriseVO.setSocialCreditCode(supplierVO.getSocialCreditCode());
        enterpriseVO.setExamineState("1");
        enterpriseVO.setAuditName(supplierVO.getLegal());
        enterpriseVO.setRegisterPhoneNum(supplierVO.getTelephone());
        CommonResponse back = this.enterpriseApi.supplierCollaboration(enterpriseVO);
        if (back.isSuccess()) {
            if (StringUtils.isNotBlank((CharSequence)this.sendMessageTemplateCode)) {
                JSONObject messageParam = new JSONObject();
                messageParam.put("phone", (Object)supplierVO.getTelephone());
                if (StringUtils.isBlank((CharSequence)this.sendMessageTemplateCode)) {
                    messageParam.put("templateCode", (Object)"SMS_195335074");
                } else {
                    messageParam.put("templateCode", (Object)this.sendMessageTemplateCode);
                }
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("account", supplierVO.getTelephone());
                params.put("password", "a123456");
                messageParam.put("params", params);
                String messageUrl = this.baseHost + "/ejc-message-web/no_auth/sms/sendMessage";
                try {
                    String responseStr = HttpTookit.postByJson((String)messageUrl, (String)JSON.toJSONString((Object)messageParam));
                    this.logger.info("\u5411\u624b\u673a\u53f7[{}]\u53d1\u9001\u6d88\u606f\u7ed3\u679c\uff1a[{}]", (Object)supplierVO.getTelephone(), (Object)responseStr);
                    CommonResponse response = (CommonResponse)JSON.parseObject((String)responseStr, CommonResponse.class);
                    if (response.isSuccess()) {
                        this.logger.info("\u77ed\u4fe1\u53d1\u9001\u6210\u529f");
                    }
                }
                catch (ConnectTimeoutException e) {
                    this.logger.info(e.toString());
                    e.printStackTrace();
                }
                catch (SocketTimeoutException e) {
                    this.logger.info(e.toString());
                    e.printStackTrace();
                }
                catch (Exception e) {
                    this.logger.info(e.toString());
                    e.printStackTrace();
                }
            }
            this.logger.info("\u56de\u5199\u4f9b\u65b9\u79df\u6237\u4fe1\u606f\u5f00\u59cb----------->");
            EnterpriseVO enterprise = (EnterpriseVO)back.getData();
            SupplierEntity entity = (SupplierEntity)((Object)this.getById(supplierVO.getId()));
            entity.setTelephone(supplierVO.getTelephone());
            entity.setTenant(enterprise.getTenantId());
            entity.setTenantName(supplierVO.getName());
            entity.setTenantPhone(supplierVO.getTelephone());
            entity.setTenantUserName(supplierVO.getLegal());
            this.saveOrUpdate((Object)entity, false);
            this.logger.info("----------->\u56de\u5199\u4f9b\u65b9\u79df\u6237\u4fe1\u606f\u7ed3\u675f");
            return CommonResponse.success((String)"\u751f\u6210\u4f01\u4e1a\u8d26\u53f7\u6210\u529f\uff01");
        }
        return CommonResponse.error((String)back.getMsg());
    }

    @Override
    public SupplierVO querySupplierByTenantId(Long tenant) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"tenant", (Object)tenant);
        List entities = this.supplierMapper.selectList((Wrapper)wrapper);
        if (entities != null && entities.size() > 0) {
            return (SupplierVO)BeanMapper.map(entities.get(0), SupplierVO.class);
        }
        return null;
    }

    @Override
    public CommonResponse<String> generateInsideSupplierAndCustomer(List<OrgVO> orgList) {
        if (orgList != null && orgList.size() > 0) {
            QueryWrapper querySupplierCategoryWrapper = new QueryWrapper();
            querySupplierCategoryWrapper.eq((Object)"code", (Object)this.insideSupplierCategoryCode);
            querySupplierCategoryWrapper.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
            List supplierCategoryList = this.categoryService.list((Wrapper)querySupplierCategoryWrapper);
            SupplierCategoryEntity supplierCategory = null;
            if (supplierCategoryList != null && supplierCategoryList.size() > 0) {
                supplierCategory = (SupplierCategoryEntity)((Object)supplierCategoryList.get(0));
            } else {
                supplierCategory = new SupplierCategoryEntity();
                Long id = IdWorker.getId();
                supplierCategory.setCode(this.insideSupplierCategoryCode);
                supplierCategory.setName("\u5185\u90e8\u4f9b\u5e94\u5546");
                supplierCategory.setId(id);
                supplierCategory.setInnerCode(id.toString());
                this.categoryService.saveOrUpdate((Object)supplierCategory, false);
            }
            QueryWrapper queryCustomerCategoryWrapper = new QueryWrapper();
            queryCustomerCategoryWrapper.eq((Object)"code", (Object)this.insideCustomerCategoryCode);
            queryCustomerCategoryWrapper.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
            List customerCategoryList = this.customerCategoryService.list((Wrapper)queryCustomerCategoryWrapper);
            CustomerCategoryEntity customerCategory = null;
            if (customerCategoryList != null && customerCategoryList.size() > 0) {
                customerCategory = (CustomerCategoryEntity)((Object)customerCategoryList.get(0));
            } else {
                customerCategory = new CustomerCategoryEntity();
                Long id = IdWorker.getId();
                customerCategory.setCode(this.insideCustomerCategoryCode);
                customerCategory.setName("\u5185\u90e8\u5ba2\u6237");
                customerCategory.setId(id);
                customerCategory.setInnerCode(id.toString());
                this.customerCategoryService.saveOrUpdate((Object)customerCategory, false);
            }
            ArrayList<Long> orgIds = new ArrayList<Long>();
            for (OrgVO orgVO : orgList) {
                orgIds.add(orgVO.getId());
            }
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.in((Object)"inside_org_id", orgIds);
            queryWrapper.eq((Object)"dr", (Object)0);
            List exitList = this.list((Wrapper)queryWrapper);
            String exitmsg = "";
            List<Object> addVO = new ArrayList();
            if (exitList != null && exitList.size() > 0) {
                ArrayList<Long> exitOrgIds = new ArrayList<Long>();
                for (SupplierEntity supplierEntity : exitList) {
                    exitOrgIds.add(supplierEntity.getInsideOrgId());
                    if (exitmsg.length() > 0) {
                        exitmsg = exitmsg + "," + supplierEntity.getName();
                        continue;
                    }
                    exitmsg = exitmsg + supplierEntity.getName();
                }
                if (exitList.size() == orgList.size()) {
                    return CommonResponse.success((String)("\u7ec4\u7ec7\uff1a" + exitmsg + "\u5df2\u751f\u6210\u5ba2\u5546\u6863\u6848"));
                }
                for (OrgVO orgVO : orgList) {
                    if (exitOrgIds.contains(orgVO.getId())) continue;
                    addVO.add(orgVO);
                }
            } else {
                addVO = orgList;
            }
            ArrayList<SupplierEntity> addSupplierEntity = new ArrayList<SupplierEntity>();
            ArrayList<CustomerEntity> addCustomerEntity = new ArrayList<CustomerEntity>();
            for (OrgVO orgVO : addVO) {
                SupplierEntity supplierEntity = new SupplierEntity();
                supplierEntity.setCode(orgVO.getCode());
                supplierEntity.setName(orgVO.getName());
                supplierEntity.setLegal(orgVO.getManager());
                supplierEntity.setTelephone(orgVO.getPhone());
                supplierEntity.setCategoryId(supplierCategory.getId());
                supplierEntity.setCategoryName(supplierCategory.getName());
                supplierEntity.setId(orgVO.getId());
                supplierEntity.setInsideOrgId(orgVO.getId());
                supplierEntity.setInsideOrg(true);
                supplierEntity.setPersonal("p");
                supplierEntity.setGroupInOrOut("in");
                supplierEntity.setApplyOrgId(InvocationInfoProxy.getOrgId());
                supplierEntity.setApplyOrgName(((OrgVO)this.iOrgApi.getOneById(InvocationInfoProxy.getOrgId()).getData()).getName());
                supplierEntity.setEnabled(1);
                supplierEntity.setOrgId(orgVO.getId());
                supplierEntity.setSupplierFlag(1);
                supplierEntity.setSubFlag(1);
                supplierEntity.setBlacklistFlag(0);
                supplierEntity.setRedlistFlag(0);
                addSupplierEntity.add(supplierEntity);
                CustomerEntity customerEntity = new CustomerEntity();
                customerEntity.setCode(orgVO.getCode());
                customerEntity.setName(orgVO.getName());
                customerEntity.setLegal(orgVO.getManager());
                customerEntity.setTelephone(orgVO.getPhone());
                customerEntity.setCategoryId(customerCategory.getId());
                customerEntity.setCategoryName(customerCategory.getName());
                customerEntity.setId(orgVO.getId());
                customerEntity.setInsideOrg(true);
                customerEntity.setEnabled(1);
                customerEntity.setInsideOrgId(orgVO.getId());
                customerEntity.setOrgId(orgVO.getId());
                customerEntity.setOrgName(orgVO.getName());
                addCustomerEntity.add(customerEntity);
            }
            if (addSupplierEntity != null && addSupplierEntity.size() > 0) {
                this.saveOrUpdateBatch(addSupplierEntity, addSupplierEntity.size(), false);
                this.customerService.saveOrUpdateBatch(addCustomerEntity, addCustomerEntity.size(), false);
            }
            if (exitmsg.length() > 0) {
                return CommonResponse.success((String)("\u751f\u6210\u5185\u90e8\u5ba2\u5546\u6210\u529f\uff0c\u5176\u4e2d\u4ee5\u4e0b\u7ec4\u7ec7\uff1a" + exitmsg + "\u5df2\u751f\u6210\u5ba2\u5546\u6863\u6848"));
            }
        } else {
            return CommonResponse.error((String)"\u8bf7\u9009\u62e9\u751f\u6210\u5ba2\u5546\u7684\u7ec4\u7ec7\uff01\uff01\uff01");
        }
        return CommonResponse.success((String)"\u751f\u6210\u5185\u90e8\u5ba2\u5546\u6210\u529f\uff01");
    }

    @Override
    public CommonResponse<OrgVO> updateInsideSupplierAndCustomer(OrgVO orgVO) {
        List addCustomerEntity;
        QueryParam param = new QueryParam();
        param.getParams().put("insideOrgId", new Parameter("eq", (Object)orgVO.getId()));
        List exitList = this.queryList(param, false);
        if (ListUtil.isNotEmpty((List)exitList)) {
            SupplierEntity supplierEntity = (SupplierEntity)((Object)exitList.get(0));
            supplierEntity.setCode(orgVO.getCode());
            supplierEntity.setName(orgVO.getName());
            supplierEntity.setLegal(orgVO.getManager());
            supplierEntity.setTelephone(orgVO.getPhone());
            supplierEntity.setInsideOrg(true);
            supplierEntity.setEnabled(orgVO.getState());
            this.saveOrUpdate((Object)supplierEntity, false);
        }
        if (ListUtil.isNotEmpty((List)(addCustomerEntity = this.customerService.queryList(param, false)))) {
            CustomerEntity customerEntity = (CustomerEntity)((Object)addCustomerEntity.get(0));
            customerEntity.setCode(orgVO.getCode());
            customerEntity.setName(orgVO.getName());
            customerEntity.setLegal(orgVO.getManager());
            customerEntity.setTelephone(orgVO.getPhone());
            customerEntity.setInsideOrg(true);
            customerEntity.setEnabled(orgVO.getState());
            customerEntity.setOrgName(orgVO.getName());
            this.customerService.saveOrUpdate((Object)customerEntity, false);
        }
        return CommonResponse.success((Object)orgVO);
    }

    @Override
    public SupplierEntity generateSupplierTenant(SupplierEntity se) {
        PushToPublicSupplierInfoVO pushVo = this.getPushVo(se);
        CommonResponse res = this.systemDataPushService.exchangeDataWithUniversal("/ejc-oms-web/openapi/enterprise/createGfmhTenant", RequestMethod.POST, JSONObject.toJSONString((Object)((Object)pushVo)), this.appId, this.secret, this.eachLinkHost);
        if (res.isSuccess()) {
            JSONObject object = JSONObject.parseObject((String)((String)res.getData()));
            if (object.getInteger("code") == 0) {
                TenantVO tenantVO = (TenantVO)JSONObject.parseObject((String)object.getString("data"), TenantVO.class);
                se.setSystemId(tenantVO.getEnterpriseId().toString());
                se.setTenant(tenantVO.getId());
                se.setTenantName(tenantVO.getName());
                se.setTenantUserId(tenantVO.getManagerId());
                se.setCoordination(true);
                se.setTenantPhone(tenantVO.getManagerPhone());
                se.setTenantUserName(tenantVO.getManagerName());
            } else {
                se.setTenantName(object.getString("msg"));
                se.setCoordination(false);
            }
        } else {
            se.setTenantName(res.getMsg());
            se.setCoordination(false);
        }
        return se;
    }

    @Override
    public SupplierEntity generateSubSupplierTenant(SubleadersEntity subLeader, SupplierEntity se) {
        SupplierEntity sub = (SupplierEntity)((Object)BeanMapper.map((Object)((Object)se), SupplierEntity.class));
        sub.setId(subLeader.getId());
        sub.setTenant(null);
        sub.setTenantUserName(subLeader.getName());
        sub.setTenantPhone(subLeader.getPhone());
        sub.setPersonal("s");
        sub.setTaxPayerIdentifier(subLeader.getIdNum());
        sub.setName(subLeader.getName());
        sub.setLegal(subLeader.getName());
        sub.setCategoryId(null);
        sub.setLoadTenantId(se.getTenant());
        sub = this.generateSupplierTenant(sub);
        subLeader.setEjcTenantId(sub.getTenant());
        subLeader.setEjcUserId(sub.getCategoryId());
        subLeader.setSystemId(sub.getSystemId());
        subLeader.setCoordination(sub.getCoordination());
        if (sub.getCoordination().booleanValue()) {
            subLeader.setName(sub.getTenantUserName());
            subLeader.setPhone(sub.getTenantPhone());
        }
        return sub;
    }

    @Override
    public CommonResponse<String> generateSupplierTenant(Long supplierId, String name, String telephone) {
        SupplierEntity se = (SupplierEntity)((Object)this.selectById(supplierId));
        if (se == null) {
            return CommonResponse.error((String)"\u6ca1\u6709\u67e5\u8be2\u5230\u6b64\u4f9b\u5e94\u5546\uff01");
        }
        if (se.getCoordination() != null && se.getCoordination().booleanValue()) {
            return CommonResponse.success((String)"\u5df2\u534f\u540c\uff0c\u65e0\u9700\u518d\u534f\u540c\uff0c\u4fee\u6539\u5417\uff1f");
        }
        se.setTenantPhone(telephone);
        se.setTenantUserName(name);
        se.setCoordination(true);
        se = this.generateSupplierTenant(se);
        CommonResponse res = CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
        if (se.getCoordination().booleanValue()) {
            this.saveOrUpdate((Object)se, false);
            if ("laborSub".equals(se.getSupplyQueryType()) && ListUtil.isNotEmpty(se.getSubLeaders())) {
                for (SubleadersEntity subLeader : se.getSubLeaders()) {
                    this.generateSubSupplierTenant(subLeader, se);
                    this.subleadersService.saveOrUpdate((Object)subLeader);
                }
            }
        } else {
            res = CommonResponse.error((String)se.getTenantName());
        }
        return res;
    }

    @Override
    public void syncYzwSupplierList(List<SupplierVO> list) {
        ArrayList<String> codes = new ArrayList<String>();
        for (SupplierVO supplierVO : list) {
            codes.add(supplierVO.getSocialCreditCode());
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.in((Object)"social_credit_code", codes);
        List data = this.list((Wrapper)wrapper);
        HashMap<String, SupplierEntity> map = new HashMap<String, SupplierEntity>();
        if (data != null && data.size() > 0) {
            for (SupplierEntity datum : data) {
                map.put(datum.getSocialCreditCode(), datum);
            }
        }
        QueryWrapper categoryWrapper = new QueryWrapper();
        categoryWrapper.isNull((Object)"parent_id");
        List entities = this.categoryService.list((Wrapper)categoryWrapper);
        Long categoryId = null;
        String categoryName = null;
        if (entities != null && entities.size() > 0) {
            categoryId = ((SupplierCategoryEntity)((Object)entities.get(0))).getId();
            categoryName = ((SupplierCategoryEntity)((Object)entities.get(0))).getName();
        }
        ArrayList<SupplierEntity> saveData = new ArrayList<SupplierEntity>();
        for (SupplierVO supplierVO : list) {
            SupplierEntity entity = null;
            if (map.get(supplierVO.getSocialCreditCode()) != null) {
                entity = (SupplierEntity)((Object)map.get(supplierVO.getSocialCreditCode()));
                if (StringUtils.isBlank((CharSequence)entity.getYzwSupplierCode())) {
                    entity.setYzwSupplierCode(supplierVO.getYzwSupplierCode());
                    saveData.add(entity);
                } else if (!entity.getYzwSupplierCode().equals(supplierVO.getYzwSupplierCode())) {
                    entity.setYzwSupplierCode(supplierVO.getYzwSupplierCode());
                    saveData.add(entity);
                }
                if (entity.getCategoryId() == null) {
                    entity.setCategoryId(categoryId);
                    entity.setCategoryName(categoryName);
                }
                entity.setEnabled(1);
                saveData.add(entity);
                continue;
            }
            entity = (SupplierEntity)((Object)BeanMapper.map((Object)supplierVO, SupplierEntity.class));
            entity.setCategoryId(categoryId);
            entity.setCategoryName(categoryName);
            entity.setEnabled(1);
            saveData.add(entity);
        }
        if (saveData != null && saveData.size() > 0) {
            this.saveOrUpdateBatch(saveData, saveData.size(), false);
        }
    }

    @Override
    public List<SupplierVO> getYzwSupplierList(List<String> codes) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.in((Object)"yzw_supplier_code", codes);
        List data = this.list((Wrapper)wrapper);
        List<Object> vos = new ArrayList<SupplierVO>();
        if (data != null && data.size() > 0) {
            vos = BeanMapper.mapList((Iterable)data, SupplierVO.class);
        }
        return vos;
    }

    private PushToPublicSupplierInfoVO getPushVo(SupplierEntity se) {
        PushToPublicSupplierInfoVO pushVo = new PushToPublicSupplierInfoVO();
        pushVo.setArea(se.getAreaName());
        pushVo.setEnterpriseType("1");
        pushVo.setBusinessType("2");
        pushVo.setRegisterPhoneNum(se.getTenantPhone());
        pushVo.setName(se.getName());
        pushVo.setFullName(se.getName());
        pushVo.setTaxCode(se.getSocialCreditCode());
        pushVo.setLegalName(se.getLegal());
        pushVo.setTelephone(se.getTenantPhone());
        pushVo.setAuditName(se.getTenantUserName());
        pushVo.setCommitTime(se.getRegisterTime());
        pushVo.setSocialCreditCode(se.getSocialCreditCode());
        pushVo.setRegistCapital(se.getRegisteredCapital() == null ? "0.00" : se.getRegisteredCapital().toPlainString());
        pushVo.setDescription(se.getBusinessScope());
        pushVo.setSupplierId(se.getId());
        QueryParam param = new QueryParam();
        List list = this.ejcCloudSystemService.queryList(param, false);
        pushVo.setSystemId(((EjcCloudSystemEntity)((Object)list.get(0))).getCode());
        pushVo.setUserId(se.getTenantUserId());
        return pushVo;
    }
}

