package com.ejianc.foundation.share.controller;

import java.io.Serializable;
import java.util.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.util.DataToYzwUtil;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.Parameter;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.impl.execchain.TunnelRefusedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.share.bean.MaterialCategoryEntity;
import com.ejianc.foundation.share.service.IMaterialCategoryService;
import com.ejianc.foundation.share.service.IMaterialService;
import com.ejianc.foundation.share.vo.MaterialCategoryImportVO;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.share.vo.SyncMaterialCategoryParam;
import com.ejianc.foundation.usercenter.api.IThirdSystemApi;
import com.ejianc.foundation.usercenter.vo.ThirdSystemVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.support.idworker.util.IdWorker;

@SuppressWarnings("rawtypes")
@RestController
@RequestMapping("/material/category/")
public class MaterialCategoryController implements Serializable {

	private static final long serialVersionUID = 1L;
	private static final String MATERIAL_CATEGORY_BILL_CODE = "SUPPORT_MATERIAL_CATEGORY";

	@Value("${oms.tenantid}")
	private String OMS_TENANT;

	@Autowired
	private IMaterialCategoryService materialCategoryService;
	@Autowired
	private IMaterialService materialService;
	@Autowired
	private IBillCodeApi billCodeApi;
	@Autowired
	private IThirdSystemApi thirdSystemApi;
	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Value("${yzwSignUrl}")
	private String yzwSignUrl;
	@Value("${yzwUrl1}")
	private String yzwUrl1;
	@Value("${yzwVersion}")
	private String yzwVersion;
	@Value("${yzwAppKey1}")
	private String yzwAppKey1;
	@Value("${yzwAppSecret1}")
	private String yzwAppSecret1;
	@Value("${yzwUrl2}")
	private String yzwUrl2;
	@Value("${yzwAppKey2}")
	private String yzwAppKey2;
	@Value("${yzwAppSecret2}")
	private String yzwAppSecret2;






	/**
	 * 新增或修改
	 *
	 * @param materialCategoryVo
	 * @return
	 */
	@RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> saveOrUpdate(@RequestBody MaterialCategoryVO materialCategoryVo) throws Exception {
		Long tenantId = InvocationInfoProxy.getTenantid();
		if(materialCategoryVo.getId() == null) {
		CommonResponse<String> codeBatchByRuleCode = billCodeApi.getCodeBatchByRuleCode(MATERIAL_CATEGORY_BILL_CODE, tenantId);
		if(codeBatchByRuleCode.isSuccess()) {
			materialCategoryVo.setCode(codeBatchByRuleCode.getData());
		}
		}

		//推送新增物料档案到云筑
		JSONObject param = new JSONObject();
		param.put("categoryCode", materialCategoryVo.getCode());
		param.put("categoryName", materialCategoryVo.getName());
		if (materialCategoryVo.getParentId() != null){
			MaterialCategoryVO materialCategoryVO = materialCategoryService.queryDetail(materialCategoryVo.getParentId());
			param.put("parentCategoryCode", materialCategoryVO.getCode());
		}
		param.put("sourceSystem", 1800);
		param.put("status", 1);

		JSONObject result = new JSONObject();
		String method = null;
		if (materialCategoryVo.getId() != null){
			method = "ymc.co.material.category.update";
		}else {
			method = "ymc.co.material.category.push";
		}

		logger.info("参数：{}",param.toJSONString());
		String response = DataToYzwUtil.queryByYzw(param,yzwUrl2,method,yzwVersion,yzwAppKey2,yzwAppSecret2);
		logger.info("物资分类新增or修改推送返回接口:{}" , response);
		JSONObject respone = JSONObject.parseObject(response);
		boolean success = respone.getBoolean("success");
		if(success){
			//更新推送状态
			materialCategoryVo.setPushStatus(1);
		}else{
			materialCategoryVo.setPushStatus(0);
			logger.info(respone.toJSONString());
			throw new BusinessException(respone.toJSONString());
		}

		if(materialCategoryVo.getId() != null && materialCategoryVo.getId() > 0) {
			MaterialCategoryVO uniqueBean = materialCategoryService.queryDetail(materialCategoryVo.getId());
			uniqueBean.setName(materialCategoryVo.getName());
			uniqueBean.setUnitName(materialCategoryVo.getUnitName());
			uniqueBean.setDescription(materialCategoryVo.getDescription());
			uniqueBean.setSequence(materialCategoryVo.getSequence());
			uniqueBean.setUpdateUserCode(InvocationInfoProxy.getUsercode());
			uniqueBean.setUpdateTime(materialCategoryVo.getUpdateTime());
			uniqueBean.setPushStatus(materialCategoryVo.getPushStatus());
			MaterialCategoryEntity entity = BeanMapper.map(uniqueBean, MaterialCategoryEntity.class);
			materialCategoryService.update(entity);
		} else {
			MaterialCategoryEntity entity = BeanMapper.map(materialCategoryVo, MaterialCategoryEntity.class);
			entity.setId(IdWorker.getId());
			if(entity.getParentId() != null && entity.getParentId() > 0) {
				MaterialCategoryVO uniqueBean = materialCategoryService.queryDetail(entity.getParentId());
				entity.setInnerCode(uniqueBean.getInnerCode()+"|"+entity.getId());
			}else{
				entity.setInnerCode(entity.getId().toString());
			}
			entity.setEnabled(1);
			entity.setCreateUserCode(InvocationInfoProxy.getUsercode());
			entity.setCreateTime(new Date());
			entity.setTenantId(InvocationInfoProxy.getTenantid());
			entity.setPushStatus(materialCategoryVo.getPushStatus());

			materialCategoryService.save(entity);
		}

		return CommonResponse.success("保存成功或修改成功!");

	}


	/**
	 * 批量同步物资分类接口
	 *
	 * @param
	 * @return
	 */
	@RequestMapping(value = "/syncData", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<String> syncData() throws Exception {

		//查询出所有未推送的数据
		QueryParam queryParam = new QueryParam();
//		queryParam.getParams().put("pushStatus", new Parameter(QueryParam.EQ, 0));

		List<MaterialCategoryEntity> dataList = materialCategoryService.queryListYz();
		logger.info("所有未推送物资分类条数:{}",dataList.size());
		logger.info("dataList:{}",JSONObject.toJSON(dataList));
		for (MaterialCategoryEntity materialCategoryVo : dataList){
			//推送新增物料档案到云筑
			JSONObject param = new JSONObject();
			param.put("categoryCode", materialCategoryVo.getCode());
			param.put("categoryName", materialCategoryVo.getName());
			if (materialCategoryVo.getParentId() != null){
				MaterialCategoryVO materialCategoryVO = materialCategoryService.queryDetail(materialCategoryVo.getParentId());
				param.put("parentCategoryCode", materialCategoryVO.getCode());
			}
			param.put("sourceSystem", 1800);
			param.put("status", 1);

			JSONObject result = new JSONObject();
			String method = null;
//			if (materialCategoryVo.getId() != null){
//				method = "ymc.co.material.category.update";
//			}else {
				method = "ymc.co.material.category.push";
//			}

			logger.info("参数：{}",param.toJSONString());
			String response = DataToYzwUtil.queryByYzw(param,yzwUrl2,method,yzwVersion,yzwAppKey2,yzwAppSecret2);
			logger.info("物资分类新增or修改推送返回接口:{}" , response);
			JSONObject respone = JSONObject.parseObject(response);
			boolean success = respone.getBoolean("success");
			if(success){
				//更新推送状态
				materialCategoryVo.setPushStatus(1);
			}else{
				materialCategoryVo.setPushStatus(0);
				logger.info(respone.toJSONString());
//				throw new BusinessException(respone.toJSONString());
			}
			MaterialCategoryVO uniqueBean = materialCategoryService.queryDetail(materialCategoryVo.getId());
			MaterialCategoryEntity entity = BeanMapper.map(uniqueBean, MaterialCategoryEntity.class);
			if (success){
				entity.setPushStatus(1);
				materialCategoryService.update(entity);
			}


		}

		return CommonResponse.success("推送成功!");

	}

	/**
	 * 查询列表
	 *
	 * @param queryParam
	 * @return
	 */
	@RequestMapping(value = "/queryList", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<JSONObject> queryList(@RequestBody QueryParam queryParam) {
		List<MaterialCategoryEntity> dataList = materialCategoryService.queryList(queryParam);
		List<Map> resultMapList = BeanMapper.mapList(dataList, Map.class);
		resultMapList.forEach(l-> {
			if(l.get("isLeaf").equals(false)){
				l.put("children", new ArrayList<>());
			}
		});
		JSONObject jsonObject = new JSONObject();
		jsonObject.put("data", ResultAsTree.createTreeData(resultMapList));
		return CommonResponse.success(jsonObject);
	}
	/**
	 * 绑定科目
	 *
	 * @param map
	 * @return
	 */
	@RequestMapping(value = "/bandSubject", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<JSONObject> bandSubject(@RequestBody Map map) {
		List<Long> ids = (List<Long>) map.get("ids");
		Long subjectId = Long.valueOf(map.get("subjectId").toString());
		String subjectName = (String) map.get("subjectName");
		materialCategoryService.updateSubject(subjectId,subjectName,ids);
		return CommonResponse.success("绑定成功!");
	}

	/**
	 * 根据主键查询物料分类详情
	 *
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<MaterialCategoryVO> queryDetail(@RequestParam Long id) {
		MaterialCategoryVO materialCategoryVo = materialCategoryService.queryDetail(id);
		return CommonResponse.success(materialCategoryVo);
	}

	/**
	 * 删除
	 *
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/delete", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<String> delete(@RequestParam Long id) {
		//有子节点不允许删除
		List<MaterialCategoryVO> children = materialCategoryService.queryListByPid(id,null);
		if(children != null && children.size() > 0) {
			return CommonResponse.error("该分类下有子分类不允许删除");
		}
		//分类下有物料了不允许删除
		List<MaterialVO> materialList = materialService.queryListByCategoryId(id);
		if(materialList != null && materialList.size() > 0) {
			return CommonResponse.error("该分类下有物料了，不允许删除");
		}
		MaterialCategoryVO entity = materialCategoryService.queryDetail(id);
		materialCategoryService.delete(id);


		//推送新增物料档案到云筑
		JSONObject param = new JSONObject();
		param.put("categoryCode", entity.getCode());
		param.put("categoryName", entity.getName());
		param.put("categoryName", entity.getName());
		param.put("isDelete", true);
//		if (entity.getParentId() != null){
//			MaterialCategoryVO materialCategoryVO = materialCategoryService.queryDetail(entity.getParentId());
//			param.put("parentCategoryCode", materialCategoryVO.getCode());
//		}
//			param.put("priority", entity.getName());
		param.put("sourceSystem", 1800);
		param.put("status", 1);

		JSONObject result = new JSONObject();
		String method = "ymc.co.material.category.update";;

		try {
			logger.info("参数：{}",param.toJSONString());
			String response = DataToYzwUtil.queryByYzw(param,yzwUrl2,method,yzwVersion,yzwAppKey2,yzwAppSecret2);
			logger.info("物资分类删除推送返回接口:{}" , response);
			JSONObject respone = JSONObject.parseObject(response);
			if(0 == ((Integer)respone.get("Code")) && null != respone.getJSONObject("Data").getJSONArray("Rows")){
//					JSONArray jsonArrayjsonArray = respone.getJSONArray("Data");
//					result = jsonArrayjsonArray.getJSONObject(0);
			}else{
				logger.info(respone.toJSONString());
			}
		} catch (Exception e) {
			logger.info(e.getMessage());
		}

		return CommonResponse.success("删除成功");
	}

	/**
	 * 更新父节点状态，同时更新子节点状态
	 *
	 * @return
	 */
	@RequestMapping(value = "/enabled/update", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> updateEnabled(@RequestBody MaterialCategoryVO materialCategoryVo) {
		MaterialCategoryVO condition = materialCategoryService.queryDetail(materialCategoryVo.getId());
		materialCategoryService.updateEnabled(materialCategoryVo.getEnabled(), condition.getTenantId(), condition.getInnerCode());
		return CommonResponse.success("更新成功");
	}

	/**
	 * 同步平台物料分类
	 *
	 * @return
	 */
	@RequestMapping(value = "/sync", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<String> syncMaterialCategoryList() {
		Long tenantId = InvocationInfoProxy.getTenantid();
		if(OMS_TENANT.equals(tenantId.toString())) {
			return CommonResponse.error("平台运营人员不能操作此功能");
		}
		materialCategoryService.insertCategoryListFromPlatform();
		return CommonResponse.success("同步成功");
	}

	/**
	 * 物资分类树
	 *
	 * @param searchText
	 * @return
	 */
	@RequestMapping(value = "/queryMaterialRefTree", method = RequestMethod.GET)
	@ResponseBody
    public List<Map<String, Object>> queryMaterialRefTree(@RequestParam(required = false) String searchText) {
        List<MaterialCategoryVO> dataList = null;
        try {
        	Map<String,Object> params = new HashMap<>();
        	if(StringUtils.isNotBlank(searchText)) {
        		params.put("searchText", searchText);
        	}
        	params.put("tenantId", InvocationInfoProxy.getTenantid());
        	dataList = materialCategoryService.queryListTree(params);
    		List<Map> map = BeanMapper.mapList(dataList, Map.class);
    		return ResultAsTree.createTreeData(map);
        } catch (Exception e) {
            return null;
        }
    }

	/**
	 * 参照异步（懒加载）树----物资分类树
	 *
	 * @param condition
	 * @param searchText
	 * @return
	 */
	@RequestMapping(value = "/lazyMaterialCategoryTree", method = RequestMethod.GET)
	@ResponseBody
    public List<Map<String, Object>> lazyMaterialCategoryTree(@RequestParam(required=false) String condition,
    		@RequestParam(required=false) Long pid, @RequestParam(required = false) String searchText) {
        List<MaterialCategoryVO> dataList = null;
        try {
    		String categoryCode = null;
        	Map<String,Object> params = new HashMap<>();
            if (StringUtils.isNotBlank(condition)) {
                //郑州一建环境根据分类Id进行过滤物资
                JSONObject conditionJson = JSON.parseObject(condition);
                if (null != conditionJson.get("categoryCode")) {
                	categoryCode = conditionJson.get("categoryCode").toString();
                	params.put("categoryCode", conditionJson.get("categoryCode"));
                }
            }
        	if(StringUtils.isNotBlank(searchText)) {
        		params.put("searchText", searchText);
            	params.put("tenantId", InvocationInfoProxy.getTenantid());
            	dataList = materialCategoryService.queryListTree(params);
        	}else{
        		dataList = materialCategoryService.queryListByPid(pid,categoryCode);
        	}
    		List<Map> map = BeanMapper.mapList(dataList, Map.class);
    		return ResultAsTree.createTreeData(map);
        } catch (Exception e) {
            return null;
        }
    }
    /**
     * @Author mrsir_wxp
     * @Date 2020/6/30 物料分类导入模板下载
     * @Description download
     * @Param [request, response]
     * @Return void
     */
	@RequestMapping(value = "/download")
	@ResponseBody
	public void download(HttpServletRequest request, HttpServletResponse response){
		ImportTemplate.initialize(response);
		ImportTemplate.templetdownload(request, "material-category-import.xlsx", "物料分类导入模板");
	}

	@RequestMapping(value = "/excelImport", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<JSONObject> excelImport(HttpServletRequest request ) {
		MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
		Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
		boolean isFailed = false;
		MultipartFile mf = null;
		List<MaterialCategoryImportVO> successList = new ArrayList<>();
		List<MaterialCategoryImportVO> processList = new ArrayList<>();
		List<MaterialCategoryImportVO> errorList = new ArrayList<>();
		for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
			mf = entity.getValue();
			String originalFileName = mf.getOriginalFilename();
			String extName = null;
			originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
			originalFileName.replaceAll("00.", "");
			extName = FileUtils.getFileExt(originalFileName, false);
			if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
				isFailed = true;
				break;
			}
		}
		if(isFailed) {
			return CommonResponse.error("文件格式不合法");
		}else{
			List<List<String>> result = ExcelReader.readExcel(mf);
			if(result != null && result.size() > 0) {
				if(result.size() > 10000) {
					return CommonResponse.error("分类数据超过10000条，请分批上传！");
				}
				Map<String,List<MaterialCategoryImportVO>> mapChildren = new HashMap<>();
				Map<String,MaterialCategoryImportVO> codeToData = new HashMap<>();
				Map<String,String> codeNotExistData = new HashMap<>();
				for(int i = 0;i < result.size(); i++) {
					List<String> datas = result.get(i);
					MaterialCategoryImportVO materialVo = new MaterialCategoryImportVO();
					materialVo.setId(IdWorker.getId());
					materialVo.setCode(datas.get(0));
					materialVo.setParentCode(datas.get(1));
					materialVo.setName(datas.get(2));
					if(StringUtils.isBlank(datas.get(0))){
						materialVo.setDescription("分类编码为空！");
						errorList.add(materialVo);
						continue;
					}
					if(StringUtils.isBlank(datas.get(2))){
						materialVo.setDescription("分类名称为空！");
						errorList.add(materialVo);
						continue;
					}
					//通过物料分类Code获取物料分类
					List<MaterialCategoryEntity> list = materialCategoryService.queryByCode(String.valueOf(datas.get(0)));
					if(ListUtil.isEmpty(list)) {
						//通过物料分类name获取物料分类
						list = materialCategoryService.queryByName(String.valueOf(datas.get(2)));
						if(ListUtil.isNotEmpty(list)) {
							materialVo.setDescription("分类名称重复！");
							errorList.add(materialVo);
							continue;
						}
						if(StringUtils.isBlank(datas.get(1))){
							materialVo.setInnerCode(materialVo.getId().toString());
						}
						materialVo.setEnabled(1);
						materialVo.setCreateUserCode(InvocationInfoProxy.getUsercode());
						materialVo.setCreateTime(new Date());
						materialVo.setTenantId(InvocationInfoProxy.getTenantid());
						processList.add(materialVo);
						codeToData.put(materialVo.getCode(),materialVo);
						if(StringUtils.isBlank(materialVo.getParentCode())){
							List<MaterialCategoryImportVO> list1 = mapChildren.get("null");
							if(ListUtil.isEmpty(list1)){
								list1=new ArrayList<>();
								mapChildren.put("null",list1);
							}
							list1.add(materialVo);
						}else {
							List<MaterialCategoryImportVO> list1 = mapChildren.get(materialVo.getParentCode());
							if(ListUtil.isEmpty(list1)){
								list1=new ArrayList<>();
								mapChildren.put(materialVo.getParentCode(),list1);
							}
							list1.add(materialVo);
						}
					}else{
						materialVo.setDescription("分类编码重复！");
						errorList.add(materialVo);
					}
				}
				if(ListUtil.isNotEmpty(processList)){
					processList.forEach(p->{
						if(StringUtils.isNotEmpty(p.getParentCode())){
							MaterialCategoryImportVO parentVo = codeToData.get(p.getParentCode());
							if(parentVo == null){
								if(StringUtils.isNotEmpty(codeNotExistData.get(p.getParentCode()))){
									p.setDescription("父分类编码不存在");
									errorList.add(p);
								}else {
									List<MaterialCategoryEntity> list = materialCategoryService.queryByCode(p.getParentCode());
									if(ListUtil.isEmpty(list)){
										codeNotExistData.put(p.getParentCode(),p.getParentCode());
										p.setDescription("父分类编码不存在");
										errorList.add(p);
									}else {
										p.setInnerCode(list.get(0).getInnerCode()+"|"+p.getId());
										p.setParentId(list.get(0).getId());
										successList.add(p);
									}
								}
							}else {
								if(StringUtils.isEmpty(parentVo.getInnerCode())){
									setInnerCodeAndParentId(parentVo,codeToData,codeNotExistData);
									if(StringUtils.isEmpty(parentVo.getInnerCode())){
										p.setDescription("父分类编码不存在");
										errorList.add(p);
									}else {
										p.setInnerCode(parentVo.getInnerCode()+"|"+p.getId());
										p.setParentId(parentVo.getId());
										successList.add(p);
									}
								}else {
									p.setInnerCode(parentVo.getInnerCode()+"|"+p.getId());
									p.setParentId(parentVo.getId());
									successList.add(p);
								}
							}
						}else {
							successList.add(p);
						}
					});
				}
			}
		}
		JSONObject json = new JSONObject();
		json.put("successList", successList);
		json.put("errorList", errorList);
		return CommonResponse.success(json);
	}

	private void setInnerCodeAndParentId(MaterialCategoryImportVO vo,Map<String,MaterialCategoryImportVO> codeToData,Map<String,String> codeNotExistData){
		MaterialCategoryImportVO parentVo = codeToData.get(vo.getParentCode());
		if(parentVo == null ){
			if(StringUtils.isNotEmpty(codeNotExistData.get(vo.getParentCode()))){
				vo.setDescription("父分类编码不存在");
			}else {
				List<MaterialCategoryEntity> list = materialCategoryService.queryByCode(vo.getParentCode());
				if(ListUtil.isEmpty(list)){
					codeNotExistData.put(vo.getParentCode(),vo.getParentCode());
					vo.setDescription("父分类编码不存在");
				}else {
					vo.setInnerCode(list.get(0).getInnerCode()+"|"+vo.getId());
					vo.setParentId(list.get(0).getId());
				}
			}
		}else {
			if(StringUtils.isEmpty(parentVo.getInnerCode())){
				setInnerCodeAndParentId(parentVo,codeToData,codeNotExistData);
				if(StringUtils.isEmpty(parentVo.getInnerCode())){
					vo.setDescription("父分类编码不存在");
				}else {
					vo.setInnerCode(parentVo.getInnerCode()+"|"+vo.getId());
					vo.setParentId(parentVo.getId());
				}
			}else {
				vo.setInnerCode(parentVo.getInnerCode()+"|"+vo.getId());
				vo.setParentId(parentVo.getId());
			}

		}
	}

	@RequestMapping(value = "/saveImportExcelMaterialCategory", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> saveImportExcelMaterialCategory(@RequestBody List<MaterialCategoryImportVO> importVOS){
		if(ListUtil.isEmpty(importVOS)){
			return CommonResponse.error("导入的数据为空！");
		}
		List<MaterialCategoryEntity> toSave = new ArrayList<>();
		importVOS.forEach(importVO->toSave.add(BeanMapper.map(importVO,MaterialCategoryEntity.class)));
		materialCategoryService.insertBatch(toSave);
		return CommonResponse.success("保存成功！");
	}
	/************************水电八局接口start************************/

	@RequestMapping(value = "/syncMaterialCategory", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> syncMaterialCategory(@RequestBody List<SyncMaterialCategoryParam> categoryList) {
		if(categoryList==null||categoryList.size()==0){
			return CommonResponse.error("同步数据不能为空");
		}
		//获取来源系统id
		Long systemId = null;
		CommonResponse<ThirdSystemVO> sysVO = thirdSystemApi.getOneByCode(categoryList.get(0).getSystemCode());
		if(sysVO.isSuccess()&&sysVO.getData()!=null){
			systemId = sysVO.getData().getId();
		}else{
			return CommonResponse.error("同步成失败，编码【systemCode: "+categoryList.get(0).getSystemCode() + "】无匹配的系统信息。");
		}
		List<String> errorMsg = new ArrayList<>();
		for(SyncMaterialCategoryParam param : categoryList){
			try{
				if(1==param.getSyncType()){
					MaterialCategoryVO vo = materialCategoryService.queryBySourceId(param.getId());
					if(vo!=null){
						errorMsg.add("物资分类:" + param.getName() + "已存在");
						continue;
					}
					//新增
					MaterialCategoryEntity entity = new MaterialCategoryEntity();
					entity.setId(IdWorker.getId());
					entity.setCode(param.getCode());
					entity.setName(param.getName());
					entity.setSourceId(param.getId());
					entity.setSystemId(systemId);
					entity.setEnabled(1);
					entity.setCreateUserCode(InvocationInfoProxy.getUsercode());
					entity.setCreateTime(new Date());
					entity.setTenantId(InvocationInfoProxy.getTenantid());
					if(StringUtils.isNotBlank(param.getParentId())){
						MaterialCategoryVO uniqueBean = materialCategoryService.queryBySourceId(param.getParentId());
						if(uniqueBean!=null){
							entity.setInnerCode(uniqueBean.getInnerCode()+"|"+entity.getId());
						}else{
							errorMsg.add("物资分类: "+param.getName() + "的上级分类（parentId："+param.getParentId()+"）未存在,请先同步该分类上级分类");
							continue;
						}
					}else{
						entity.setInnerCode(entity.getId().toString());
					}
					materialCategoryService.save(entity);
				}else if(2==param.getSyncType()){
					MaterialCategoryVO uniqueBean = materialCategoryService.queryBySourceId(param.getId());
					if(uniqueBean==null){
						errorMsg.add("物资分类:" + param.getName() + "不存在，请先同步该物资分类再进行修改操作");
						continue;
					}
					uniqueBean.setCode(param.getCode());
					uniqueBean.setName(param.getName());
					uniqueBean.setUpdateUserCode(InvocationInfoProxy.getUsercode());

					MaterialCategoryEntity entity = BeanMapper.map(uniqueBean, MaterialCategoryEntity.class);
					materialCategoryService.update(entity);
				}else if(3==param.getSyncType()){
					MaterialCategoryVO vo = materialCategoryService.queryBySourceId(param.getId());
					if(vo==null){
						errorMsg.add("物资分类:" + param.getName() + "不存在，请先同步该物资分类再进行删除操作");
						continue;
					}
					//删除
					MaterialCategoryVO entity = materialCategoryService.queryBySourceId(param.getId());
					materialCategoryService.delete(entity.getId());
				}
			}catch (Exception e){
				errorMsg.add("物资分类: "+param.getName() + "同步错误，具体错误：" + e);
			}
		}
		String msg = "";
		for(String m : errorMsg){
			if(msg.length()>0){
				msg += (";"+m);
			}else{
				msg += m;
			}
		}
		String message = "同步完成，已同步成功"+(categoryList.size()-errorMsg.size())+"条，失败"+errorMsg.size()+ "条。"+ (errorMsg.size()>0?("失败具体原因如下："+msg):"");
		return CommonResponse.success(message);
	}

	/************************水电八局接口end************************/
}
