package com.ejianc.foundation.share.controller.api;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.share.bean.EjcCloudSystemEntity;
import com.ejianc.foundation.share.bean.SubleadersEntity;
import com.ejianc.foundation.share.bean.SupplierEntity;
import com.ejianc.foundation.share.service.IEjcCloudSystemService;
import com.ejianc.foundation.share.service.ISubleadersService;
import com.ejianc.foundation.share.service.ISupplierService;
import com.ejianc.foundation.share.utils.SupplierQueryType;
import com.ejianc.foundation.share.vo.PunishVO;
import com.ejianc.foundation.share.vo.SubleadersPushVO;
import com.ejianc.foundation.share.vo.SubleadersVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

/**
 * @author CJ
 * @Description:
 * @date 2020/6/30 15:03
 */
@RestController
@RequestMapping("/api/shareSupplierApi/")
public class SupplierApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISupplierService supplierService;
    @Autowired
    private IEjcCloudSystemService ejcCloudSystemService;
    @Autowired
    private ISubleadersService subleadersService;

    /**
     * 根据供应商Id查询供应商信息
     *
     * @param id 供应商Id
     * @return
     */
    @GetMapping("queryById")
    CommonResponse<SupplierVO> queryById(@RequestParam(value = "id") Long id) {
        SupplierVO vo = supplierService.queryDetail(id);

        return CommonResponse.success("查询成功！", vo);
    }

    /**
     * 根据供应商Ids查询供应商信息
     *
     * @param ids 供应商Id
     * @return
     */
    @GetMapping("querySupplierByIds")
    CommonResponse<List<SupplierVO>> querySupplierByIds(@RequestParam(value = "ids") List<Long> ids) {
        List<SupplierVO> vos = new ArrayList<>();
        QueryWrapper<SupplierEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("dr", 0);
        queryWrapper.in("id", ids);
        List<SupplierEntity> entitys = supplierService.list(queryWrapper);
        if(entitys != null){
            vos = BeanMapper.mapList(entitys, SupplierVO.class);
        }
        return CommonResponse.success("查询成功！", vos);
    }

    /**
     * 根据供应商名称查询供应商信息
     *
     * @param ids 供应商Id
     * @return
     */
    @GetMapping("findOneByName")
    CommonResponse<SupplierVO> findOneByName(@RequestParam(value = "name") String name,
            @RequestParam(value = "tenantId") Long tenantId) {
    	SupplierVO vo = null;
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("name", new Parameter(QueryParam.EQ, name));
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, tenantId));

        List<SupplierEntity> list = supplierService.queryList(queryParam, false);
        if(CollectionUtils.isNotEmpty(list)) {
            vo = BeanMapper.map(list.get(0), SupplierVO.class);
        }

        return CommonResponse.success("查询成功！", vo);
    }

    /**
     * 推送，生成企业供应商
     *
     * @return
     */
    @PostMapping(value = "pushSupplierToShare")
    public CommonResponse<String> pushSupplierToShare(@RequestBody byte[] supplyByte){
        String supplyStr = new String(supplyByte, StandardCharsets.UTF_8);
        logger.info("推送，生成企业供应商pushSupplierToShare---{}", supplyStr);
        /** 校验 纳税人识别号是否存在 不能乱增 */
        SupplierVO supplierVO = JSONObject.parseObject(supplyStr,SupplierVO.class);
        QueryParam param = new QueryParam();
        param.getParams().put("taxPayerIdentifier",new Parameter(QueryParam.EQ,supplierVO.getTaxPayerIdentifier()));
        if(ListUtil.isNotEmpty(supplierService.queryList(param))){
            if(supplierVO.getPersonal().equals("p")) {
                return CommonResponse.error("供应商库已存在身份证号为【"+supplierVO.getTaxPayerIdentifier()+"】的供应商！");
            }else {
                return CommonResponse.error("供应商库已存在纳税人识别号为【"+supplierVO.getTaxPayerIdentifier()+"】的供应商！");
            }

        }
        supplierVO.setEnabled(1);//默认启用
        supplierVO.setInsideOrg(false);//外部客商
        SupplierEntity se = BeanMapper.map(supplierVO,SupplierEntity.class);
        Boolean coordination = se.getCoordination();
        if(coordination == null){
            se.setCoordination(false);
        }
        supplierService.saveOrUpdate(se,false);
        se = supplierService.generateSupplierTenant(se);
        supplierService.saveOrUpdate(se,false);
        if(SupplierQueryType.laborSub.equals(se.getSupplyQueryType())){
            //分包供应商 分包负责人
            if(ListUtil.isNotEmpty(se.getSubLeaders()) ){
                for (SubleadersEntity subLeader : se.getSubLeaders()) {
                    supplierService.generateSubSupplierTenant(subLeader,se);
                    subleadersService.saveOrUpdate(subLeader);
                }
            }
        }

        return CommonResponse.success("保存成功！");
    }

    @PostMapping(value = "judgeTaxpayerNumIsRepeat")
    public CommonResponse<String> judgeTaxpayerNumIsRepeat(@RequestParam  String taxpayerNum, @RequestParam  String personal){
        QueryParam param = new QueryParam();
        param.getParams().put("taxPayerIdentifier",new Parameter(QueryParam.EQ,taxpayerNum));
        if(ListUtil.isNotEmpty(supplierService.queryList(param))){
            if("p".equals(personal)) {
                return CommonResponse.error("供应商库已存在身份证号为【"+taxpayerNum+"】的个人供应商！");
            }else {
                return CommonResponse.error("供应商库已存在纳税人识别号为【"+taxpayerNum+"】的企业供应商！");
            }

        }
        return CommonResponse.success("供应商不重复！");
    }

    /**
     * 推送，生成企业供应商
     *
     * @return
     */
    @PostMapping(value = "pushSubLeadersToShare")
    public CommonResponse<String> pushSubLeadersToShare(@RequestBody SubleadersPushVO pushVO){
        logger.info("分包负责人推送，生成企业供应商pushSupplierToShare---{}", JSONObject.toJSONString(pushVO));
        SupplierEntity se = supplierService.selectById(pushVO.getSupplierId());
        if(se == null){
            return CommonResponse.error("没有找到分包负责人所在供应商");
        }
        if(ListUtil.isEmpty(pushVO.getSubLeaders())){
            return CommonResponse.error("要准入的分包负责人不能为空！");
        }
        Boolean coordination = se.getCoordination();
        if(coordination == null){
            se.setCoordination(false);
        }
        //分包供应商 分包负责人
        for (SubleadersVO subleadersVO : pushVO.getSubLeaders()) {
            SubleadersEntity subLeader = BeanMapper.map(subleadersVO,SubleadersEntity.class);

            supplierService.generateSubSupplierTenant(subLeader,se);
            /** 更新主表id */
            subLeader.setPid(se.getId());
            subleadersService.saveOrUpdate(subLeader);
        }
        return CommonResponse.success("保存成功！");
    }

    /**
     * 供应商处置更新供应商库
     *
     * @return
     */
    @PostMapping(value = "punishSupplier")
    public CommonResponse<String> punishSupplier(@RequestBody PunishVO punishVO){
        SupplierEntity supplierEntity = supplierService.selectById(punishVO.getSupplierId());
        if(supplierEntity == null){
            return CommonResponse.error("供应商不存在！");
        }
        if(punishVO.getSubLeaderId()==null){
            //处置供应商
            BeanUtils.copyProperties(punishVO,supplierEntity);
            supplierEntity.setGradeId(punishVO.getPunishGradeId());
            supplierEntity.setGradeName(punishVO.getPunishGrade());
            supplierEntity.setInException(true);
            supplierService.saveOrUpdate(supplierEntity,false);
        }else {
            //处置分包负责人
            if(ListUtil.isEmpty(supplierEntity.getSubLeaders())){
                return CommonResponse.error("分包负责人不存在，无法处置！");
            }
            SubleadersEntity leader = null;
            for (SubleadersEntity subLeader : supplierEntity.getSubLeaders()) {
                if(punishVO.getSubLeaderId().equals(subLeader.getId())){
                    leader = subLeader;
                }
            }
            if(leader == null){
                return CommonResponse.error("分包负责人不存在，无法处置！");
            }
            BeanUtils.copyProperties(punishVO,leader);
            leader.setGrade(punishVO.getPunishGradeId());
            leader.setGradeName(punishVO.getPunishGrade());
            leader.setInException(true);
            subleadersService.saveOrUpdate(leader,false);
        }
        return CommonResponse.success("处置成功！");
    }

    /**
     * 供应商 评级更新供应商库
     * @param supplierId 供应商id
     * @param gradeId 评定等级id
     * @param gradeName 评定等级名称
     */
    @GetMapping(value = "upgradeSupplier")
    public CommonResponse<String> upgradeSupplier(@RequestParam("supplierId") Long supplierId,
                                                  @RequestParam("gradeId") Long gradeId,
                                                  @RequestParam("gradeName") String gradeName) {
        SupplierEntity supplierEntity = supplierService.selectById(supplierId);
        if(supplierEntity == null){
            return CommonResponse.error("供应商不存在！");
        }
        supplierEntity.setGradeId(gradeId);
        supplierEntity.setGradeName(gradeName);

        supplierService.saveOrUpdate(supplierEntity,false);
        return CommonResponse.success("供应商评级设置成功！");
    }
    /**
     * 获取本私有化平台在 益企联公有云平台内的系统标识编码
     */
    @GetMapping(value = "getEjcCloudSystemCode")
    public CommonResponse<String> getEjcCloudSystemCode(){
        QueryParam param = new QueryParam();
        List<EjcCloudSystemEntity> list =  ejcCloudSystemService.queryList(param,false);
        if(ListUtil.isNotEmpty(list)){
            return CommonResponse.success("查询成功",list.get(0).getCode());
        }
        System.out.println("益企联公有云平台内的系统标识编码 尚未配置！");
        return CommonResponse.error("查询失败");
    }


    /**
     * 供应商 更新云筑网数据
     */
    @PostMapping(value = "syncYzwSupplierList")
    @ResponseBody
    public CommonResponse<String> syncYzwSupplierList(@RequestBody List<SupplierVO> list) {
        supplierService.syncYzwSupplierList(list);
        return CommonResponse.success("更新供应商成功！");
    }

    /**
     * 供应商 更新云筑网数据
     */
    @PostMapping(value = "getYzwSupplierList")
    @ResponseBody
    public CommonResponse<List<SupplierVO>> getYzwSupplierList(@RequestBody List<String> codes) {
        List<SupplierVO> vos = supplierService.getYzwSupplierList(codes);
        return CommonResponse.success("获取供应商成功！",vos);
    }
}
