/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.bean.MaterialCategoryEntity;
import com.ejianc.foundation.share.bean.MaterialEntity;
import com.ejianc.foundation.share.bean.MaterialRelationEntity;
import com.ejianc.foundation.share.mapper.ImportDataMapper;
import com.ejianc.foundation.share.service.IMaterialCategoryService;
import com.ejianc.foundation.share.service.IMaterialService;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.share.vo.MaterialImportVO;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.share.vo.SyncMaterialParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.usercenter.api.IThirdSystemApi;
import com.ejianc.foundation.usercenter.vo.ThirdSystemVO;
import com.ejianc.foundation.util.DataToYzwUtil;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"/material/"})
public class MaterialController
implements Serializable {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final long serialVersionUID = 1L;
    private static final String MATERIAL_BILL_CODE = "SUPPORT_MATERIAL";
    private static final String MATERIAL_CATEGORY_BILL_CODE = "SUPPORT_MATERIAL_CATEGORY";
    @Value(value="${oms.tenantid}")
    private String OMS_TENANT;
    @Value(value="${common.env.base-host}")
    private String ENV_PROFILE;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IMaterialService materialService;
    @Autowired
    private IMaterialCategoryService materialCategoryService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IThirdSystemApi thirdSystemApi;
    @Autowired
    private ImportDataMapper importDataMapper;
    private static final Integer QUERY_TIMEOUT = 60;
    private static final String INDEX_NAME = "ejc_wj_org_material_relation_es";
    @Autowired(required=false)
    private RestHighLevelClient client;
    @Value(value="${yzwSignUrl}")
    private String yzwSignUrl;
    @Value(value="${yzwUrl1}")
    private String yzwUrl1;
    @Value(value="${yzwVersion}")
    private String yzwVersion;
    @Value(value="${yzwAppKey1}")
    private String yzwAppKey1;
    @Value(value="${yzwAppSecret1}")
    private String yzwAppSecret1;
    @Value(value="${yzwUrl2}")
    private String yzwUrl2;
    @Value(value="${yzwAppKey2}")
    private String yzwAppKey2;
    @Value(value="${yzwAppSecret2}")
    private String yzwAppSecret2;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveOrUpdate(@RequestBody MaterialVO materialVo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (materialVo.getId() == null || materialVo.getId() == 0L) {
            List<MaterialCategoryVO> materialCategoryList = this.materialCategoryService.queryListByPid(materialVo.getCategoryId(), null);
            if (materialCategoryList != null && materialCategoryList.size() > 0) {
                throw new BusinessException("\u8be5\u5206\u7c7b\u4e0d\u662f\u672b\u7ea7\u5206\u7c7b\uff0c\u4e0d\u652f\u6301\u65b0\u589e");
            }
            CommonResponse codeBatchByRuleCode = this.billCodeApi.getCodeBatchByRuleCode(MATERIAL_BILL_CODE, tenantId);
            if (codeBatchByRuleCode.isSuccess()) {
                materialVo.setCode((String)codeBatchByRuleCode.getData());
            }
        }
        JSONObject mainObject = new JSONObject();
        mainObject.put("sourceSystem", (Object)1800);
        JSONArray eBillMateList = new JSONArray();
        JSONObject mateObject = new JSONObject();
        MaterialCategoryVO materialCategoryVO = this.materialCategoryService.queryDetail(materialVo.getCategoryId());
        mateObject.put("categoryCode", (Object)materialCategoryVO.getCode());
        mateObject.put("code", (Object)materialVo.getCode());
        mateObject.put("model", (Object)materialVo.getSpec());
        mateObject.put("name", (Object)materialVo.getName());
        mateObject.put("unitName", (Object)materialVo.getUnitName());
        eBillMateList.add((Object)mateObject);
        mainObject.put("sskuList", (Object)eBillMateList);
        JSONObject result = new JSONObject();
        String method = null;
        method = materialVo.getId() != null ? "ymc.co.material.update" : "ymc.co.material.push";
        try {
            this.logger.info("\u53c2\u6570\uff1a{}", (Object)mainObject.toJSONString());
            String response = DataToYzwUtil.queryByYzw(mainObject, this.yzwUrl2, method, this.yzwVersion, this.yzwAppKey2, this.yzwAppSecret2);
            this.logger.info("\u7269\u8d44\u65b0\u589e\u63a8\u9001\u8fd4\u56de\u63a5\u53e3:{}", (Object)response);
            JSONObject respone = JSONObject.parseObject((String)response);
            if ("200".equals(respone.getString("code"))) {
                JSONArray jsonArray = respone.getJSONArray("data");
                result = jsonArray.getJSONObject(0);
                String yzwSkuNo = result.getString("yzwSkuNo");
                this.logger.info("yzwSkuNo:{}", (Object)yzwSkuNo);
                materialVo.setYzwSkuNo(yzwSkuNo);
            } else {
                this.logger.info(respone.toJSONString());
            }
        }
        catch (Exception e) {
            this.logger.info(e.getMessage());
        }
        if (materialVo.getId() != null && materialVo.getId() > 0L) {
            MaterialVO uniqueBean = this.materialService.queryDetail(materialVo.getId());
            uniqueBean.setCode(materialVo.getCode());
            uniqueBean.setName(materialVo.getName());
            uniqueBean.setSpec(materialVo.getSpec());
            uniqueBean.setUnitName(materialVo.getUnitName());
            uniqueBean.setDescription(materialVo.getDescription());
            uniqueBean.setSequence(materialVo.getSequence());
            uniqueBean.setProperty(materialVo.getProperty());
            uniqueBean.setPropertyName(materialVo.getPropertyName());
            uniqueBean.setUpdateUserCode(InvocationInfoProxy.getUsercode());
            uniqueBean.setUpdateTime(new Date());
            uniqueBean.setTenantId(InvocationInfoProxy.getTenantid());
            uniqueBean.setYzwSkuNo(materialVo.getYzwSkuNo());
            this.materialService.update(uniqueBean);
        } else {
            materialVo.setId(Long.valueOf(IdWorker.getId()));
            materialVo.setCreateUserCode(InvocationInfoProxy.getUsercode());
            materialVo.setCreateTime(new Date());
            materialVo.setTenantId(InvocationInfoProxy.getTenantid());
            materialVo.setEnabled(Integer.valueOf(1));
            materialVo.setOrgId(InvocationInfoProxy.getOrgId());
            this.materialService.save(materialVo);
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u6210\u529f");
    }

    @RequestMapping(value={"/syncDetailData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> syncDetailData() throws Exception {
        List<MaterialEntity> resultList = this.materialService.queryListYz();
        for (MaterialEntity materialVo : resultList) {
            JSONObject mainObject = new JSONObject();
            mainObject.put("sourceSystem", (Object)1800);
            JSONArray eBillMateList = new JSONArray();
            JSONObject mateObject = new JSONObject();
            MaterialCategoryVO materialCategoryVO = this.materialCategoryService.queryDetail(materialVo.getCategoryId());
            mateObject.put("categoryCode", (Object)materialCategoryVO.getCode());
            mateObject.put("code", (Object)materialVo.getCode());
            String spec = materialVo.getSpec();
            if (spec == null || spec.trim().isEmpty()) {
                spec = "/";
            }
            mateObject.put("model", (Object)spec);
            mateObject.put("name", (Object)materialVo.getName());
            String unitName = materialVo.getUnitName();
            if (unitName == null || unitName.trim().isEmpty()) {
                unitName = "/";
            }
            mateObject.put("unitName", (Object)unitName);
            eBillMateList.add((Object)mateObject);
            mainObject.put("sskuList", (Object)eBillMateList);
            JSONObject result = new JSONObject();
            String method = "ymc.co.material.push";
            this.logger.info("\u53c2\u6570\uff1a{}", (Object)mainObject.toJSONString());
            String response = DataToYzwUtil.queryByYzw(mainObject, this.yzwUrl2, method, this.yzwVersion, this.yzwAppKey2, this.yzwAppSecret2);
            this.logger.info("\u7269\u8d44\u65b0\u589e\u63a8\u9001\u8fd4\u56de\u63a5\u53e3:{}", (Object)response);
            JSONObject respone = JSONObject.parseObject((String)response);
            boolean success = respone.getBoolean("success");
            if ("200".equals(respone.getString("code"))) {
                JSONArray jsonArray = respone.getJSONArray("data");
                result = jsonArray.getJSONObject(0);
                String yzwSkuNo = result.getString("yzwSkuNo");
                this.logger.info("yzwSkuNo:{}", (Object)yzwSkuNo);
                materialVo.setYzwSkuNo(yzwSkuNo);
            } else {
                this.logger.info(respone.toJSONString());
            }
            MaterialVO materialVO = this.materialService.queryDetail(materialVo.getId());
            if (!success) continue;
            materialVO.setYzwSkuNo(materialVo.getYzwSkuNo());
            materialVO.setTenantId(Long.valueOf(999999L));
            this.materialService.update(materialVO);
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u6210\u529f");
    }

    @RequestMapping(value={"/amend"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> amend(@RequestBody List<MaterialVO> materialVo) {
        if (ListUtil.isNotEmpty(materialVo)) {
            for (MaterialVO e : materialVo) {
                this.materialService.amend(e.getId(), e.getProperty(), e.getPropertyName());
            }
        }
        return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f");
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<MaterialVO> queryDetail(@RequestParam Long id) {
        MaterialVO materialVo = this.materialService.queryDetail(id);
        return CommonResponse.success((Object)materialVo);
    }

    @RequestMapping(value={"/bandSubject"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> bandSubject(@RequestBody Map map) {
        List ids = (List)map.get("ids");
        Long subjectId = Long.valueOf(map.get("subjectId").toString());
        String subjectName = (String)map.get("subjectName");
        this.materialService.updateSubject(subjectId, subjectName, ids);
        return CommonResponse.success((String)"\u7ed1\u5b9a\u6210\u529f!");
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        if (ListUtil.isNotEmpty(ids)) {
            for (Long id : ids) {
                CommonResponse response = this.billTypeApi.checkQuote("BT200422000000025", id);
                if (response.isSuccess()) continue;
                return CommonResponse.error((String)("\u5220\u9664\u5931\u8d25\uff1a" + response.getMsg()));
            }
        } else {
            return CommonResponse.error((String)"\u5220\u9664\u5931\u8d25\uff1a\u4e3b\u952e\u4e3a\u7a7a!");
        }
        this.materialService.delete(ids);
        JSONObject mainObject = new JSONObject();
        mainObject.put("sourceSystem", (Object)1800);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("id", new Parameter("in", ids));
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List<MaterialEntity> materialEntities = this.materialService.queryList(queryParam);
        JSONArray eBillMateList = new JSONArray();
        for (MaterialEntity materialEntity : materialEntities) {
            JSONObject mateObject = new JSONObject();
            mateObject.put("categoryCode", (Object)materialEntity.getCategoryId());
            mateObject.put("code", (Object)materialEntity.getCode());
            mateObject.put("model", (Object)materialEntity.getSpec());
            mateObject.put("name", (Object)materialEntity.getName());
            mateObject.put("unitName", (Object)materialEntity.getUnitName());
            mateObject.put("isDelete", (Object)true);
            eBillMateList.add((Object)mateObject);
        }
        mainObject.put("sskuList", (Object)eBillMateList);
        JSONObject result = new JSONObject();
        String method = "ymc.co.material.update";
        try {
            this.logger.info("\u53c2\u6570\uff1a{}", (Object)mainObject.toJSONString());
            String response = DataToYzwUtil.queryByYzw(mainObject, this.yzwUrl2, method, this.yzwVersion, this.yzwAppKey2, this.yzwAppSecret2);
            this.logger.info("\u7269\u8d44\u65b0\u589e\u63a8\u9001\u8fd4\u56de\u63a5\u53e3:{}", (Object)response);
            JSONObject respone = JSONObject.parseObject((String)response);
            if (0 != (Integer)respone.get((Object)"Code") || null == respone.getJSONObject("Data").getJSONArray("Rows")) {
                this.logger.info(respone.toJSONString());
            }
        }
        catch (Exception e) {
            this.logger.info(e.getMessage());
        }
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/pageList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam queryParam) {
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage<MaterialEntity> pageData = this.materialService.queryPage(queryParam);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", pageData);
        return CommonResponse.success((Object)jsonObject);
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"material-import.xlsx", (String)"\u7269\u6599\u5bfc\u5165\u6a21\u677f");
    }

    @Deprecated
    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    public CommonResponse<Object> excelImport(HttpServletRequest request, HttpServletResponse response) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        ArrayList<String> errorList = new ArrayList<String>();
        if (result != null && result.size() > 0) {
            for (int i = 0; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                MaterialVO materialVo = null;
                List<MaterialCategoryEntity> materialCategoryVo = this.materialCategoryService.queryByCode(String.valueOf(datas.get(0)));
                if (materialCategoryVo != null) {
                    materialVo = new MaterialVO();
                    materialVo.setId(Long.valueOf(IdWorker.getId()));
                    materialVo.setCategoryId(materialCategoryVo.get(0).getId());
                    if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(1)))) {
                        CommonResponse codeBatchByRuleCode = this.billCodeApi.getCodeBatchByRuleCode(MATERIAL_BILL_CODE, tenantId);
                        if (codeBatchByRuleCode.isSuccess()) {
                            materialVo.setCode((String)codeBatchByRuleCode.getData());
                        } else {
                            materialVo.setCode(new Date().getTime() + "");
                        }
                    } else {
                        materialVo.setCode((String)datas.get(1));
                    }
                    materialVo.setName((String)datas.get(2));
                    materialVo.setSpec((String)datas.get(3));
                    materialVo.setUnitName((String)datas.get(4));
                    MaterialVO materialBean = this.materialService.queryExitFlag(materialVo.getName(), materialVo.getSpec(), materialVo.getUnitName(), materialCategoryVo.get(0).getId());
                    if (materialBean != null) continue;
                    materialVo.setCreateUserCode(InvocationInfoProxy.getUsercode());
                    materialVo.setCreateTime(new Date());
                    materialVo.setTenantId(InvocationInfoProxy.getTenantid());
                    materialVo.setEnabled(Integer.valueOf(1));
                    this.materialService.save(materialVo);
                    continue;
                }
                errorList.add("\u7b2c" + i + "\u884c\u6570\u636e\uff1a" + datas.toString() + "\u5bfc\u5165\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u7269\u6599\u5206\u7c7b\u7f16\u53f7\u4e0d\u6b63\u786e\uff01");
            }
        }
        if (errorList.size() > 0) {
            errorList.add("\u5bfc\u5165\u6210\u529f\uff1a" + (result.size() - errorList.size() - 1) + "\u6761, \u5931\u8d25\uff1a" + errorList.size() + "\u6761");
            return CommonResponse.error((String)"\u5bfc\u5165\u5931\u8d25", errorList);
        }
        return CommonResponse.success((String)"\u5bfc\u5165\u6210\u529f");
    }

    @RequestMapping(value={"/excelMaterialImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelMaterialImport(HttpServletRequest request) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        ArrayList<MaterialImportVO> successList = new ArrayList<MaterialImportVO>();
        ArrayList<MaterialImportVO> errorList = new ArrayList<MaterialImportVO>();
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            if (result.size() > 10000) {
                return CommonResponse.error((String)"\u7269\u6599\u8d85\u8fc710000\u6761\uff0c\u8bf7\u5206\u6279\u4e0a\u4f20\uff01");
            }
            HashMap caListMap = new HashMap();
            HashMap materialMap = new HashMap();
            HashMap<String, MaterialVO> materialBeanMap = new HashMap<String, MaterialVO>();
            block13: for (int i = 0; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                MaterialImportVO materialVo = new MaterialImportVO();
                materialVo.setId(IdWorker.getId());
                materialVo.setCategoryCode((String)datas.get(0));
                materialVo.setCode((String)datas.get(1));
                materialVo.setName((String)datas.get(2));
                materialVo.setSpec((String)datas.get(3));
                materialVo.setUnitName((String)datas.get(4));
                materialVo.setPropertyName((String)datas.get(5));
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(5)))) {
                    materialVo.setDescription("\u7269\u6599\u5c5e\u6027\u4e3a\u7a7a\uff01");
                    errorList.add(materialVo);
                    continue;
                }
                switch ((String)datas.get(5)) {
                    case "\u5de5\u7a0b\u6750\u6599": {
                        materialVo.setProperty(1L);
                        break;
                    }
                    case "\u5468\u8f6c\u6750": {
                        materialVo.setProperty(2L);
                        break;
                    }
                    case "\u4f4e\u503c\u6613\u8017\u54c1": {
                        materialVo.setProperty(3L);
                        break;
                    }
                    case "\u8bbe\u5907": {
                        materialVo.setProperty(4L);
                        break;
                    }
                    default: {
                        materialVo.setDescription("\u7269\u6599\u5c5e\u6027\u4e0d\u5408\u6cd5\uff01");
                        errorList.add(materialVo);
                        continue block13;
                    }
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(0)))) {
                    materialVo.setDescription("\u7269\u6599\u5206\u7c7b\u7f16\u53f7\u4e3a\u7a7a\uff01");
                    errorList.add(materialVo);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(2)))) {
                    materialVo.setDescription("\u7269\u6599\u540d\u79f0\u4e3a\u7a7a\uff01");
                    errorList.add(materialVo);
                    continue;
                }
                List<MaterialCategoryEntity> materialCategoryVo = (List<MaterialCategoryEntity>)caListMap.get(datas.get(0));
                if (ListUtil.isEmpty((List)materialCategoryVo) && ListUtil.isNotEmpty(materialCategoryVo = this.materialCategoryService.queryByCode(String.valueOf(datas.get(0))))) {
                    caListMap.put(datas.get(0), materialCategoryVo);
                }
                if (ListUtil.isNotEmpty((List)materialCategoryVo)) {
                    materialVo.setCategoryId(((MaterialCategoryEntity)materialCategoryVo.get(0)).getId());
                    if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(1)))) {
                        CommonResponse codeBatchByRuleCode = this.billCodeApi.getCodeBatchByRuleCode(MATERIAL_BILL_CODE, tenantId);
                        if (codeBatchByRuleCode.isSuccess()) {
                            materialVo.setCode((String)codeBatchByRuleCode.getData());
                        } else {
                            materialVo.setCode(new Date().getTime() + "");
                        }
                    } else {
                        MaterialVO vo = (MaterialVO)materialMap.get(datas.get(1));
                        if (vo == null && (vo = this.materialService.queryByCode((String)datas.get(1))) != null) {
                            materialMap.put(datas.get(1), vo);
                        }
                        if (vo != null) {
                            materialVo.setDescription("\u7269\u6599\u7f16\u53f7\u91cd\u590d\uff01");
                            errorList.add(materialVo);
                            continue;
                        }
                    }
                    MaterialVO materialBean = (MaterialVO)materialBeanMap.get(materialVo.getName() + materialVo.getSpec() + materialVo.getUnitName() + materialCategoryVo.get(0).getId());
                    if (materialBean == null && (materialBean = this.materialService.queryExitFlag(materialVo.getName(), materialVo.getSpec(), materialVo.getUnitName(), materialCategoryVo.get(0).getId())) != null) {
                        materialBeanMap.put(materialVo.getName() + materialVo.getSpec() + materialVo.getUnitName() + materialCategoryVo.get(0).getId(), materialBean);
                    }
                    if (materialBean != null) {
                        materialVo.setDescription("\u91cd\u590d\u7269\u6599\uff01");
                        errorList.add(materialVo);
                        continue;
                    }
                    materialVo.setCreateUserCode(InvocationInfoProxy.getUsercode());
                    materialVo.setCreateTime(new Date());
                    materialVo.setTenantId(InvocationInfoProxy.getTenantid());
                    materialVo.setEnabled(1);
                    successList.add(materialVo);
                    continue;
                }
                materialVo.setDescription("\u7269\u6599\u5206\u7c7b\u7f16\u53f7\u4e0d\u5b58\u5728\uff01");
                errorList.add(materialVo);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success((Object)json);
    }

    @RequestMapping(value={"/saveImportExcelMaterial"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveImportExcelMaterial(@RequestBody List<MaterialImportVO> importVOS) {
        if (ListUtil.isEmpty(importVOS)) {
            return CommonResponse.error((String)"\u5bfc\u5165\u7684\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        ArrayList<MaterialVO> list = new ArrayList<MaterialVO>();
        importVOS.forEach(importVO -> list.add((MaterialVO)BeanMapper.map((Object)importVO, MaterialVO.class)));
        this.materialService.insertBatch(list);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List<MaterialEntity> resultList = this.materialService.queryList(queryParam);
        HashMap<String, List<MaterialEntity>> beans = new HashMap<String, List<MaterialEntity>>();
        beans.put("records", resultList);
        ExcelExport.getInstance().export("material-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/sync"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> syncMaterialList() {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (this.OMS_TENANT.equals(tenantId.toString())) {
            return CommonResponse.error((String)"\u5e73\u53f0\u8fd0\u8425\u4eba\u5458\u4e0d\u80fd\u64cd\u4f5c\u6b64\u529f\u80fd");
        }
        this.materialService.insertMaterialListFromPlatform();
        return CommonResponse.success((String)"\u540c\u6b65\u6210\u529f");
    }

    @RequestMapping(value={"refMaterialPage"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<MaterialEntity>> refMaterialPage(@RequestParam(defaultValue="1") int pageNumber, @RequestParam(defaultValue="10") int pageSize, @RequestParam(required=false) String relyCondition, @RequestParam(required=false) String searchText, @RequestParam(required=false) String condition, @RequestParam(required=false) String searchObject) {
        Long categoryId;
        MaterialCategoryVO materialCategoryVo;
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((CharSequence)relyCondition) && (materialCategoryVo = this.materialCategoryService.queryDetail(categoryId = Long.valueOf(Long.parseLong(relyCondition.split("=")[1])))) != null) {
            params.put("innerCode", materialCategoryVo.getInnerCode());
        }
        if (StringUtils.isNotBlank((CharSequence)searchObject)) {
            JSONObject search = JSONObject.parseObject((String)searchObject);
            if (search.get((Object)"categoryCode") != null) {
                params.put("categoryCode", search.get((Object)"categoryCode").toString());
            }
            if (search.get((Object)"categoryName") != null) {
                params.put("categoryName", search.get((Object)"categoryName").toString());
            }
            if (search.get((Object)"code") != null) {
                params.put("code", search.get((Object)"code").toString());
            }
            if (search.get((Object)"name") != null) {
                params.put("name", search.get((Object)"name").toString());
            }
            if (search.get((Object)"spec") != null) {
                params.put("spec", search.get((Object)"spec").toString());
            }
            if (search.get((Object)"unitName") != null) {
                params.put("unitName", search.get((Object)"unitName").toString());
            }
        }
        params.put("pageIndex", pageNumber <= 0 ? 0 : (pageNumber - 1) * pageSize);
        params.put("pageSize", pageSize);
        params.put("searchText", searchText);
        params.put("tenantId", InvocationInfoProxy.getTenantid());
        IPage<MaterialEntity> pageData = this.materialService.queryRefMaterialPage(params);
        pageData.setCurrent((long)pageNumber);
        pageData.setSize((long)pageSize);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", pageData);
    }

    @RequestMapping(value={"refList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<MaterialEntity>> refList(@RequestParam(defaultValue="1") int pageNumber, @RequestParam(defaultValue="10") int pageSize, @RequestParam(required=false) String relyCondition, @RequestParam(required=false) String searchText, @RequestParam(required=false) String condition, @RequestParam(required=false) String searchObject) {
        JSONObject conditionJson;
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((CharSequence)this.ENV_PROFILE) && this.ENV_PROFILE.contains("qlh")) {
            params.put("orgId", InvocationInfoProxy.getOrgId());
            if (StringUtils.isNotBlank((CharSequence)condition) && null != (conditionJson = JSON.parseObject((String)condition)).get((Object)"orgId")) {
                long orgId = Long.parseLong(conditionJson.get((Object)"orgId").toString());
                params.put("orgId", orgId);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)condition)) {
            String categoryIds;
            conditionJson = JSON.parseObject((String)condition);
            if (null != conditionJson.get((Object)"categoryId")) {
                long categoryId = Long.parseLong(conditionJson.get((Object)"categoryId").toString());
                params.put("categoryId", categoryId);
            }
            if (null != conditionJson.get((Object)"categoryIds") && StringUtils.isNotEmpty((CharSequence)(categoryIds = conditionJson.get((Object)"categoryIds").toString()))) {
                String[] split = categoryIds.split(",");
                List<String> categoryList = Arrays.asList(split);
                params.put("categoryIds", categoryList);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)searchObject)) {
            JSONObject search = JSON.parseObject((String)searchObject);
            if (search.get((Object)"categoryName") != null) {
                params.put("categoryName", search.get((Object)"categoryName").toString());
            }
            if (search.get((Object)"code") != null) {
                params.put("code", search.get((Object)"code").toString());
            }
            if (search.get((Object)"name") != null) {
                params.put("name", search.get((Object)"name").toString());
            }
            if (search.get((Object)"spec") != null) {
                params.put("spec", search.get((Object)"spec").toString());
            }
            if (search.get((Object)"unitName") != null) {
                params.put("unitName", search.get((Object)"unitName").toString());
            }
        }
        params.put("pageIndex", pageNumber <= 0 ? 0 : (pageNumber - 1) * pageSize);
        params.put("pageSize", pageSize);
        params.put("searchText", searchText);
        params.put("tenantId", InvocationInfoProxy.getTenantid());
        IPage<MaterialEntity> pageData = this.materialService.queryRefMaterialPage(params);
        pageData.setCurrent((long)pageNumber);
        pageData.setSize((long)pageSize);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", pageData);
    }

    @RequestMapping(value={"/syncMaterial"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> syncMaterial(@RequestBody List<SyncMaterialParam> materialList) {
        if (materialList == null || materialList.size() == 0) {
            return CommonResponse.error((String)"\u540c\u6b65\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long systemId = null;
        CommonResponse sysVO = this.thirdSystemApi.getOneByCode(materialList.get(0).getSystemCode());
        if (!sysVO.isSuccess() || sysVO.getData() == null) {
            return CommonResponse.error((String)("\u540c\u6b65\u6210\u5931\u8d25\uff0c\u7f16\u7801\u3010systemCode: " + materialList.get(0).getSystemCode() + "\u3011\u65e0\u5339\u914d\u7684\u7cfb\u7edf\u4fe1\u606f\u3002"));
        }
        systemId = ((ThirdSystemVO)sysVO.getData()).getId();
        ArrayList<String> errorMsg = new ArrayList<String>();
        for (SyncMaterialParam syncMaterialParam : materialList) {
            try {
                CommonResponse orgVO;
                MaterialVO vo;
                MaterialEntity entity;
                Long categoryId = null;
                MaterialCategoryVO category = this.materialCategoryService.queryBySourceId(syncMaterialParam.getCategoryId());
                if (category == null) {
                    errorMsg.add("\u7269\u8d44\uff1a" + syncMaterialParam.getName() + "\u7684\u5206\u7c7b\u4e3a\u67e5\u8be2\u5230\uff0c\u8bf7\u5148\u540c\u6b65\u8be5\u5206\u7c7b");
                    continue;
                }
                categoryId = category.getId();
                if (1 == syncMaterialParam.getSyncType()) {
                    entity = this.materialService.queryBySourceId(syncMaterialParam.getId());
                    if (entity != null) {
                        errorMsg.add("\u7269\u8d44:" + syncMaterialParam.getName() + "\u5df2\u5b58\u5728");
                        continue;
                    }
                    vo = new MaterialVO();
                    vo.setId(Long.valueOf(IdWorker.getId()));
                    vo.setName(syncMaterialParam.getName());
                    vo.setCode(syncMaterialParam.getCode());
                    vo.setSpec(syncMaterialParam.getSpec());
                    vo.setUnitName(syncMaterialParam.getUnitName());
                    vo.setSourceId(syncMaterialParam.getId());
                    vo.setSystemId(systemId);
                    vo.setCategoryId(categoryId);
                    vo.setCreateUserCode(InvocationInfoProxy.getUsercode());
                    vo.setCreateTime(new Date());
                    vo.setTenantId(InvocationInfoProxy.getTenantid());
                    if (StringUtils.isNotBlank((CharSequence)syncMaterialParam.getProjectId()) && (orgVO = this.orgApi.findBySourceId(syncMaterialParam.getProjectId())).isSuccess() && orgVO.getData() != null) {
                        vo.setOrgId(((OrgVO)orgVO.getData()).getId());
                    }
                    vo.setDef1(syncMaterialParam.getProjectId());
                    this.materialService.save(vo);
                    continue;
                }
                if (2 == syncMaterialParam.getSyncType()) {
                    CommonResponse orgVO2;
                    entity = this.materialService.queryBySourceId(syncMaterialParam.getId());
                    if (entity == null) {
                        vo = new MaterialVO();
                        vo.setId(Long.valueOf(IdWorker.getId()));
                        vo.setName(syncMaterialParam.getName());
                        vo.setCode(syncMaterialParam.getCode());
                        vo.setSpec(syncMaterialParam.getSpec());
                        vo.setUnitName(syncMaterialParam.getUnitName());
                        vo.setSourceId(syncMaterialParam.getId());
                        vo.setSystemId(systemId);
                        vo.setCategoryId(categoryId);
                        vo.setCreateUserCode(InvocationInfoProxy.getUsercode());
                        vo.setCreateTime(new Date());
                        vo.setTenantId(InvocationInfoProxy.getTenantid());
                        if (StringUtils.isNotBlank((CharSequence)syncMaterialParam.getProjectId()) && (orgVO = this.orgApi.findBySourceId(syncMaterialParam.getProjectId())).isSuccess() && orgVO.getData() != null) {
                            vo.setOrgId(((OrgVO)orgVO.getData()).getId());
                        }
                        vo.setDef1(syncMaterialParam.getProjectId());
                        this.materialService.save(vo);
                        continue;
                    }
                    entity.setName(syncMaterialParam.getName());
                    entity.setCode(syncMaterialParam.getCode());
                    entity.setSpec(syncMaterialParam.getSpec());
                    entity.setUnitName(syncMaterialParam.getUnitName());
                    if (StringUtils.isNotBlank((CharSequence)syncMaterialParam.getProjectId()) && (orgVO2 = this.orgApi.findBySourceId(syncMaterialParam.getProjectId())).isSuccess() && orgVO2.getData() != null) {
                        entity.setOrgId(((OrgVO)orgVO2.getData()).getId());
                    }
                    entity.setDef1(syncMaterialParam.getProjectId());
                    entity.setUpdateUserCode(InvocationInfoProxy.getUsercode());
                    entity.setUpdateTime(new Date());
                    vo = (MaterialVO)BeanMapper.map((Object)entity, MaterialVO.class);
                    this.materialService.update(vo);
                    continue;
                }
                if (3 != syncMaterialParam.getSyncType()) continue;
                entity = this.materialService.queryBySourceId(syncMaterialParam.getId());
                if (entity == null) {
                    errorMsg.add("\u7269\u8d44:" + syncMaterialParam.getName() + "\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u540c\u6b65\u8be5\u7269\u8d44\u518d\u8fdb\u884c\u5220\u9664\u64cd\u4f5c");
                    continue;
                }
                ArrayList<Long> delList = new ArrayList<Long>();
                delList.add(entity.getId());
                this.materialService.delete(delList);
            }
            catch (Exception e) {
                errorMsg.add("\u7269\u8d44\u5206\u7c7b: " + syncMaterialParam.getName() + "\u540c\u6b65\u9519\u8bef\uff0c\u5177\u4f53\u9519\u8bef\uff1a" + e);
            }
        }
        String msg = "";
        for (String m : errorMsg) {
            if (msg.length() > 0) {
                msg = msg + ";" + m;
                continue;
            }
            msg = msg + m;
        }
        String string = "\u540c\u6b65\u5b8c\u6210\uff0c\u5df2\u540c\u6b65\u6210\u529f" + (materialList.size() - errorMsg.size()) + "\u6761\uff0c\u5931\u8d25" + errorMsg.size() + "\u6761\u3002" + (errorMsg.size() > 0 ? "\u5931\u8d25\u5177\u4f53\u539f\u56e0\u5982\u4e0b\uff1a" + msg : "");
        return CommonResponse.success((String)string);
    }

    @RequestMapping(value={"refZjwjMaterialPage"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<MaterialEntity>> refZjwjMaterialPage(@RequestParam(defaultValue="1") int pageNumber, @RequestParam(defaultValue="10") int pageSize, @RequestParam(required=false) String relyCondition, @RequestParam(required=false) String searchText, @RequestParam(required=false) String condition, @RequestParam(required=false) String searchObject) {
        JSONObject search;
        Page page = new Page();
        IPage<MaterialRelationEntity> relationEntityIPage = new IPage<MaterialRelationEntity>();
        SearchRequest searchRequest = new SearchRequest(new String[]{INDEX_NAME});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        if (StringUtils.isNotBlank((CharSequence)relyCondition)) {
            Long categoryId = Long.parseLong(relyCondition.split("=")[1]);
            boolQuery.must((QueryBuilder)QueryBuilders.prefixQuery((String)"innerCode", (String)String.valueOf(categoryId)));
        }
        if (StringUtils.isNotBlank((CharSequence)searchObject)) {
            search = JSONObject.parseObject((String)searchObject);
            if (search.get((Object)"categoryName") != null) {
                boolQuery.must((QueryBuilder)QueryBuilders.matchQuery((String)"categoryName", (Object)search.get((Object)"categoryName").toString()));
            }
            if (search.get((Object)"code") != null) {
                boolQuery.must((QueryBuilder)QueryBuilders.matchQuery((String)"code", (Object)search.get((Object)"code").toString()));
            }
            if (search.get((Object)"name") != null) {
                boolQuery.must((QueryBuilder)QueryBuilders.matchQuery((String)"name", (Object)search.get((Object)"name").toString()));
            }
            if (search.get((Object)"spec") != null) {
                boolQuery.must((QueryBuilder)QueryBuilders.matchQuery((String)"spec", (Object)search.get((Object)"spec").toString()));
            }
            if (search.get((Object)"unitName") != null) {
                boolQuery.must((QueryBuilder)QueryBuilders.matchQuery((String)"unitName", (Object)search.get((Object)"unitName").toString()));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)condition) && (search = JSONObject.parseObject((String)condition)).get((Object)"sourceOrgId") != null) {
            boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"sourceOrgId", (String)search.get((Object)"sourceOrgId").toString()));
        }
        if (StringUtils.isNotBlank((CharSequence)searchText)) {
            MatchQueryBuilder qb1 = QueryBuilders.matchQuery((String)"name", (Object)searchText);
            MatchQueryBuilder qb2 = QueryBuilders.matchQuery((String)"code", (Object)searchText);
            MatchQueryBuilder qb3 = QueryBuilders.matchQuery((String)"spec", (Object)searchText);
            MatchQueryBuilder qb4 = QueryBuilders.matchQuery((String)"unitName", (Object)searchText);
            MatchQueryBuilder qb5 = QueryBuilders.matchQuery((String)"categoryName", (Object)searchText);
            boolQuery.must((QueryBuilder)QueryBuilders.boolQuery().should((QueryBuilder)qb1).should((QueryBuilder)qb2).should((QueryBuilder)qb3).should((QueryBuilder)qb4).should((QueryBuilder)qb5));
        }
        sourceBuilder.from(pageNumber <= 0 ? 0 : (pageNumber - 1) * pageSize);
        sourceBuilder.size(pageSize);
        sourceBuilder.query((QueryBuilder)boolQuery);
        sourceBuilder.trackTotalHits(true);
        sourceBuilder.timeout(new TimeValue((long)QUERY_TIMEOUT.intValue(), TimeUnit.SECONDS));
        searchRequest.source(sourceBuilder);
        try {
            relationEntityIPage = this.refZjwjMaterialEsPage(searchRequest);
        }
        catch (IOException e) {
            try {
                relationEntityIPage = this.refZjwjMaterialEsPage(searchRequest);
            }
            catch (IOException e1) {
                this.logger.error(e1.getMessage());
                throw new BusinessException("\u6839\u636e parammap \u6761\u4ef6\uff0c\u67e5\u8be2\u5168\u90e8\u8bb0\u5f55\u7d22\u5f15\u5931\u8d25\uff0cMSG\uff1a" + e1.getMessage());
            }
        }
        List<Long> pklist = new ArrayList<Long>();
        if (CollectionUtils.isNotEmpty((Collection)relationEntityIPage.getRecords())) {
            pklist = relationEntityIPage.getRecords().stream().map(MaterialRelationEntity::getMaterialId).collect(Collectors.toList());
        }
        List<MaterialEntity> materialEntityList = null;
        if (CollectionUtils.isNotEmpty(pklist)) {
            materialEntityList = this.materialService.queryMaterialByIds(pklist);
        }
        page.setCurrent((long)pageNumber);
        page.setRecords(materialEntityList);
        page.setTotal(relationEntityIPage.getTotal());
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)page);
    }

    private IPage<MaterialRelationEntity> refZjwjMaterialEsPage(SearchRequest searchRequest) throws IOException {
        Page page = new Page();
        ArrayList<Object> list = new ArrayList<Object>();
        SearchResponse response = this.client.search(searchRequest, RequestOptions.DEFAULT);
        SearchHits hits = response.getHits();
        for (SearchHit hit : hits) {
            String sourceAsString = hit.getSourceAsString();
            list.add(JSON.parseObject((String)sourceAsString, MaterialRelationEntity.class));
        }
        page.setRecords(list);
        page.setTotal(hits.getTotalHits().value);
        return page;
    }
}

