package com.ejianc.foundation.share.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.bean.LabsubCategoryEntity;
import com.ejianc.foundation.share.bean.MaterialCategoryEntity;
import com.ejianc.foundation.share.bean.ProsubCategoryEntity;
import com.ejianc.foundation.share.bean.ProsubItemEntity;
import com.ejianc.foundation.share.mapper.ProsubCategoryMapper;
import com.ejianc.foundation.share.service.IProsubCategoryService;
import com.ejianc.foundation.share.service.IProsubItemService;
import com.ejianc.foundation.share.vo.ProsubCategoryImportVO;
import com.ejianc.foundation.share.vo.ProsubCategoryVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 专业分包分类
 *
 * @author generator
 */
@Service("prosubCategoryService")
public class ProsubCategoryServiceImpl extends BaseServiceImpl<ProsubCategoryMapper, ProsubCategoryEntity> implements IProsubCategoryService {
    @Autowired
    private IProsubCategoryService service;
    @Autowired
    private IProsubItemService prosubItemService;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "PSC_CODE";
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ProsubCategoryMapper prosubCategoryMapper;

    /**
     * 根据id 删除专业分包档案分类
     **/
    @Override
    public CommonResponse<String> deleteById(List<ProsubCategoryVO> vos) {
        List<Long> collect = vos.stream().map(ProsubCategoryVO::getId).collect(Collectors.toList());
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("category_id", new Parameter(QueryParam.IN, collect));
        List<ProsubItemEntity> prosubItemEntities = prosubItemService.queryList(queryParam);
        /**是否关联档案**/
        if (CollectionUtils.isNotEmpty(prosubItemEntities)) {
            return CommonResponse.error("分类下关联专业分包档案！");
        }
        /****/
        QueryParam queryClassifyParam = new QueryParam();
        queryClassifyParam.getParams().put("parent_id", new Parameter(QueryParam.IN, collect));
        List<ProsubCategoryEntity> prosubItems = service.queryList(queryClassifyParam);
        if (CollectionUtils.isNotEmpty(prosubItems)) {
            return CommonResponse.error("分类下关联子分类不允许删除！");
        }
        service.removeByIds(vos.stream().map(ProsubCategoryVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    @Override
    public List<ProsubCategoryVO> queryProsubCategoryList(QueryParam queryParam) {
        Map<String, Parameter> paramMap = queryParam.getParams();

        Map<String,Object> condition = new HashMap<>();
        for(Map.Entry<String, Parameter> entry:paramMap.entrySet()) {
            condition.put(entry.getKey(), entry.getValue().getValue());
        }
        //放入租户ID进map
        condition.put("tenantId", InvocationInfoProxy.getTenantid());
        List<ProsubCategoryVO> resultList = baseMapper.queryProsubCategoryList(condition);
        return resultList;
    }

    @Override
    public CommonResponse<ProsubCategoryVO> saveOrUpdateProsubCategory(ProsubCategoryVO saveorUpdateVO) {
        ProsubCategoryEntity entity = BeanMapper.map(saveorUpdateVO, ProsubCategoryEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setCategoryCode(billCode.getData());
                entity.setOrgId(sessionManager.getUserContext().getOrgId());
                entity.setOrgName(sessionManager.getUserContext().getOrgName());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        } else {
            LambdaUpdateWrapper<ProsubCategoryEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.eq(ProsubCategoryEntity::getId, saveorUpdateVO.getId());
            updateWrapper.set(ProsubCategoryEntity::getCategoryName, saveorUpdateVO.getCategoryName());
            updateWrapper.set(ProsubCategoryEntity::getOrgId, sessionManager.getUserContext().getOrgId());
            updateWrapper.set(ProsubCategoryEntity::getOrgName, sessionManager.getUserContext().getOrgName());
            updateWrapper.set(ProsubCategoryEntity::getRemarks, saveorUpdateVO.getRemarks());
            service.update(updateWrapper);
            return CommonResponse.success("保存或修改单据成功！");
        }
        entity.setId(IdWorker.getId());
        if (entity.getParentId() != null && entity.getParentId() > 0) {
            ProsubCategoryEntity prosubCategoryEntity = service.selectById(entity.getParentId());
            entity.setInnerCode(prosubCategoryEntity.getInnerCode() + "|" + entity.getId());
        } else {
            entity.setInnerCode(entity.getId().toString());
        }
        service.save(entity);
        ProsubCategoryVO vo = BeanMapper.map(entity, ProsubCategoryVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        List<ProsubCategoryImportVO> successList = new ArrayList<>();
        List<ProsubCategoryImportVO> processList = new ArrayList<>();
        List<ProsubCategoryImportVO> errorList = new ArrayList<>();
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                if (result.size() > 10000) {
                    return CommonResponse.error("分类数据超过10000条，请分批上传！");
                }
                Map<String, List<ProsubCategoryImportVO>> mapChildren = new HashMap<>();
                Map<String, ProsubCategoryImportVO> codeToData = new HashMap<>();
                Map<String, String> codeNotExistData = new HashMap<>();
                for (int i = 0; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    ProsubCategoryImportVO prosubCategoryImportVO = new ProsubCategoryImportVO();
                    prosubCategoryImportVO.setId(IdWorker.getId());
                    prosubCategoryImportVO.setCategoryCode(datas.get(0));
                    prosubCategoryImportVO.setParentCode(datas.get(1));
                    prosubCategoryImportVO.setCategoryName(datas.get(2));
                    prosubCategoryImportVO.setRemarks(datas.get(3));
                    if (StringUtils.isBlank(datas.get(0))) {
                        prosubCategoryImportVO.setRemarks("分类编码为空！");
                        errorList.add(prosubCategoryImportVO);
                        continue;
                    }
                    if (StringUtils.isBlank(datas.get(2))) {
                        prosubCategoryImportVO.setRemarks("分类名称为空！");
                        errorList.add(prosubCategoryImportVO);
                        continue;
                    }
                    //通过物料分类Code获取物料分类
                    QueryParam queryParam = new QueryParam();
                    queryParam.getParams().put("categoryCode", new Parameter(QueryParam.EQ, String.valueOf(datas.get(0))));
                    List<ProsubCategoryEntity> list = service.queryList(queryParam, false);
                    if (ListUtil.isEmpty(list)) {
                        //通过物料分类name获取物料分类
                        queryParam = new QueryParam();
                        queryParam.getParams().put("categoryName", new Parameter(QueryParam.EQ, String.valueOf(datas.get(2))));
                        list = service.queryList(queryParam, false);
                        if (ListUtil.isNotEmpty(list)) {
                            prosubCategoryImportVO.setRemarks("分类名称重复！");
                            errorList.add(prosubCategoryImportVO);
                            continue;
                        }
                        if (StringUtils.isBlank(datas.get(1))) {
                            prosubCategoryImportVO.setInnerCode(prosubCategoryImportVO.getId().toString());
                        }
                        prosubCategoryImportVO.setCreateUserCode(InvocationInfoProxy.getUsercode());
                        prosubCategoryImportVO.setCreateTime(new Date());
                        prosubCategoryImportVO.setTenantId(InvocationInfoProxy.getTenantid());
                        processList.add(prosubCategoryImportVO);
                        codeToData.put(prosubCategoryImportVO.getCategoryCode(), prosubCategoryImportVO);
                        if (StringUtils.isBlank(prosubCategoryImportVO.getParentCode())) {
                            List<ProsubCategoryImportVO> list1 = mapChildren.get("null");
                            if (ListUtil.isEmpty(list1)) {
                                list1 = new ArrayList<>();
                                mapChildren.put("null", list1);
                            }
                            list1.add(prosubCategoryImportVO);
                        } else {
                            List<ProsubCategoryImportVO> list1 = mapChildren.get(prosubCategoryImportVO.getParentCode());
                            if (ListUtil.isEmpty(list1)) {
                                list1 = new ArrayList<>();
                                mapChildren.put(prosubCategoryImportVO.getParentCode(), list1);
                            }
                            list1.add(prosubCategoryImportVO);
                        }
                    } else {
                        prosubCategoryImportVO.setRemarks("分类编码重复！");
                        errorList.add(prosubCategoryImportVO);
                    }
                }
                if (ListUtil.isNotEmpty(processList)) {
                    processList.forEach(p -> {
                        if (StringUtils.isNotEmpty(p.getParentCode())) {
                            ProsubCategoryImportVO parentVo = codeToData.get(p.getParentCode());
                            if (parentVo == null) {
                                if (StringUtils.isNotEmpty(codeNotExistData.get(p.getParentCode()))) {
                                    p.setRemarks("父分类编码不存在");
                                    errorList.add(p);
                                } else {
                                    QueryParam queryParam = new QueryParam();
                                    queryParam.getParams().put("categoryCode", new Parameter(QueryParam.EQ, p.getParentCode()));
                                    List<ProsubCategoryEntity> list = service.queryList(queryParam, false);
                                    if (ListUtil.isEmpty(list)) {
                                        codeNotExistData.put(p.getParentCode(), p.getParentCode());
                                        p.setRemarks("父分类编码不存在");
                                        errorList.add(p);
                                    } else {
                                        p.setInnerCode(list.get(0).getInnerCode() + "|" + p.getId());
                                        p.setParentId(list.get(0).getId());
                                        successList.add(p);
                                    }
                                }
                            } else {
                                if (StringUtils.isEmpty(parentVo.getInnerCode())) {
                                    setInnerCodeAndParentId(parentVo, codeToData, codeNotExistData);
                                    if (StringUtils.isEmpty(parentVo.getInnerCode())) {
                                        p.setRemarks("父分类编码不存在");
                                        errorList.add(p);
                                    } else {
                                        p.setInnerCode(parentVo.getInnerCode() + "|" + p.getId());
                                        p.setParentId(parentVo.getId());
                                        successList.add(p);
                                    }
                                } else {
                                    p.setInnerCode(parentVo.getInnerCode() + "|" + p.getId());
                                    p.setParentId(parentVo.getId());
                                    successList.add(p);
                                }
                            }
                        } else {
                            successList.add(p);
                        }
                    });
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success(json);
    }

    @Override
    public void updateSubject(Long subjectId, String subjectName, List<Long> ids) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<ProsubCategoryEntity> prosubCategoryEntities = prosubCategoryMapper.queryByInnerCodes(tenantId, ids);
        ids.clear();
        prosubCategoryEntities.forEach(item->{
            ids.add(item.getId());
        });
        prosubCategoryMapper.updateSubject(tenantId,subjectId,subjectName,ids);
    }

    private void setInnerCodeAndParentId(ProsubCategoryImportVO vo, Map<String, ProsubCategoryImportVO> codeToData, Map<String, String> codeNotExistData) {
        ProsubCategoryImportVO parentVo = codeToData.get(vo.getParentCode());
        if (parentVo == null) {
            if (StringUtils.isNotEmpty(codeNotExistData.get(vo.getParentCode()))) {
                vo.setRemarks("父分类编码不存在");
            } else {
                QueryParam queryParam = new QueryParam();
                queryParam.getParams().put("categoryCode", new Parameter(QueryParam.EQ, vo.getParentCode()));
                List<ProsubCategoryEntity> list = service.queryList(queryParam, false);
                if (ListUtil.isEmpty(list)) {
                    codeNotExistData.put(vo.getParentCode(), vo.getParentCode());
                    vo.setRemarks("父分类编码不存在");
                } else {
                    vo.setInnerCode(list.get(0).getInnerCode() + "|" + vo.getId());
                    vo.setParentId(list.get(0).getId());
                }
            }
        } else {
            if (StringUtils.isEmpty(parentVo.getInnerCode())) {
                setInnerCodeAndParentId(parentVo, codeToData, codeNotExistData);
                if (StringUtils.isEmpty(parentVo.getInnerCode())) {
                    vo.setRemarks("父分类编码不存在");
                } else {
                    vo.setInnerCode(parentVo.getInnerCode() + "|" + vo.getId());
                    vo.setParentId(parentVo.getId());
                }
            } else {
                vo.setInnerCode(parentVo.getInnerCode() + "|" + vo.getId());
                vo.setParentId(parentVo.getId());
            }

        }
    }
}
