/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.bean.ProsubCategoryEntity;
import com.ejianc.foundation.share.service.IProsubCategoryService;
import com.ejianc.foundation.share.service.IProsubItemService;
import com.ejianc.foundation.share.vo.ProsubCategoryVO;
import com.ejianc.foundation.share.vo.RefProsubCategoryVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.core.util.ResultAsTree;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/majorSub/category"})
public class ProsubCategoryController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IProsubCategoryService service;
    @Autowired
    private IProsubItemService prosubItemService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ProsubCategoryVO> saveOrUpdate(@RequestBody ProsubCategoryVO saveorUpdateVO) {
        CommonResponse<ProsubCategoryVO> response = this.service.saveOrUpdateProsubCategory(saveorUpdateVO);
        return response;
    }

    @RequestMapping(value={"/bandSubject"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> bandSubject(@RequestBody Map map) {
        List ids = (List)map.get("ids");
        Long subjectId = Long.valueOf(map.get("subjectId").toString());
        String subjectName = (String)map.get("subjectName");
        this.service.updateSubject(subjectId, subjectName, ids);
        return CommonResponse.success((String)"\u7ed1\u5b9a\u6210\u529f!");
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ProsubCategoryVO> queryDetail(Long id) {
        ProsubCategoryEntity entity = (ProsubCategoryEntity)((Object)this.service.selectById(id));
        ProsubCategoryVO vo = (ProsubCategoryVO)BeanMapper.map((Object)((Object)entity), ProsubCategoryVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProsubCategoryVO> vos) {
        CommonResponse<String> msg = this.service.deleteById(vos);
        return msg;
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<Map<String, Object>>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List<ProsubCategoryVO> dataList = this.service.queryProsubCategoryList(param);
        List resultMapList = BeanMapper.mapList(dataList, Map.class);
        resultMapList.forEach(l -> {
            if (l.get("isLeaf").equals(false)) {
                l.put("children", new ArrayList());
            }
        });
        List treeData = ResultAsTree.createTreeData((List)resultMapList);
        return CommonResponse.success((Object)treeData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>(list.size());
        beans.put("records", list);
        ExcelExport.getInstance().export("ProsubCategory-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refProsubCategoryData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<Map<String, Object>>> refProsubCategoryData(Integer pageNumber, Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.getFuzzyFields().add("categoryCode");
        param.getFuzzyFields().add("categoryName");
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        List prosubCategoryEntities = null;
        try {
            prosubCategoryEntities = this.service.queryList(param, false);
            List map = BeanMapper.mapList((Iterable)prosubCategoryEntities, Map.class);
            map.forEach(t -> {
                t.put("detailCode", t.get("categoryCode"));
                t.put("detailName", t.get("categoryName"));
            });
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("enabled", new Parameter("eq", (Object)0));
            List list = this.prosubItemService.queryList(queryParam);
            List itemMap = BeanMapper.mapList((Iterable)list, Map.class);
            itemMap.forEach(t -> {
                t.put("parentId", t.get("categoryId"));
                t.put("detailCode", t.get("trawlingCode"));
                t.put("detailName", t.get("trawlingName"));
                map.add(t);
            });
            List treeData = ResultAsTree.createTreeData((List)map);
            return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)treeData);
        }
        catch (Exception e) {
            return null;
        }
    }

    @RequestMapping(value={"/lazyProSubCategoryTree"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Map<String, Object>> lazyProsubCategoryTree(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText, Long pid) {
        List prosubCategoryEntities;
        List prosubCategoryVOS;
        List map;
        List treeData;
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (pid != null) {
            param.getParams().put("parent_id", new Parameter("eq", (Object)pid));
        }
        if (CollectionUtils.isNotEmpty((Collection)(treeData = ResultAsTree.createTreeData((List)(map = BeanMapper.mapList((Iterable)(prosubCategoryVOS = BeanMapper.mapList((Iterable)(prosubCategoryEntities = this.service.queryList(param, false)), RefProsubCategoryVO.class)), Map.class)))))) {
            map.forEach(item -> {
                QueryParam queryParam = new QueryParam();
                queryParam.getParams().put("parent_id", new Parameter("eq", item.get("id")));
                List prosubCategoryEntities1 = this.service.queryList(queryParam);
                if (CollectionUtils.isNotEmpty((Collection)prosubCategoryEntities1)) {
                    item.put("isLeaf", false);
                } else {
                    item.put("isLeaf", true);
                }
            });
        }
        return treeData;
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"prosub-category-import.xlsx", (String)"\u4e13\u4e1a\u5206\u5305\u5206\u7c7b\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request) {
        CommonResponse<JSONObject> response = this.service.excelImport(request);
        return response;
    }

    @RequestMapping(value={"/saveImportExcelProsubCategory"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveImportExcelProsubCategory(@RequestBody List<ProsubCategoryEntity> importVos) {
        if (ListUtil.isEmpty(importVos)) {
            return CommonResponse.error((String)"\u5bfc\u5165\u7684\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        ArrayList toSave = new ArrayList();
        importVos.forEach(importVO -> {
            ProsubCategoryEntity entity = (ProsubCategoryEntity)((Object)((Object)BeanMapper.map((Object)importVO, ProsubCategoryEntity.class)));
            entity.setOrgId(this.sessionManager.getUserContext().getOrgId());
            entity.setOrgName(this.sessionManager.getUserContext().getOrgName());
            toSave.add(entity);
        });
        this.service.saveBatch(toSave, toSave.size());
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }
}

