/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.supplierChange.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.share.bean.CertsEntity;
import com.ejianc.foundation.share.bean.SubleadersEntity;
import com.ejianc.foundation.share.bean.SupplierEntity;
import com.ejianc.foundation.share.service.ISupplierService;
import com.ejianc.foundation.supplierChange.bean.CertsChangeEntity;
import com.ejianc.foundation.supplierChange.bean.SubleadersChangeEntity;
import com.ejianc.foundation.supplierChange.bean.SupplierChangeEntity;
import com.ejianc.foundation.supplierChange.mapper.SupplierChangeMapper;
import com.ejianc.foundation.supplierChange.service.ISupplierChangeService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="supplierChangeService")
public class SupplierChangeServiceImpl
extends BaseServiceImpl<SupplierChangeMapper, SupplierChangeEntity>
implements ISupplierChangeService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISupplierService supplierService;
    @Autowired
    private IAttachmentApi attachmentApi;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void takeEffect(Long billId) {
        CommonResponse subFileCopyResp;
        SupplierChangeEntity changeEntity = (SupplierChangeEntity)((Object)super.selectById((Serializable)billId));
        SupplierEntity supplierEntity = (SupplierEntity)((Object)this.supplierService.selectById(changeEntity.getSourceSupplierId()));
        SupplierEntity updateEntity = (SupplierEntity)((Object)BeanMapper.map((Object)((Object)changeEntity), SupplierEntity.class));
        if (CollectionUtils.isNotEmpty(supplierEntity.getCerts())) {
            Map<String, CertsEntity> sourceCerts = supplierEntity.getCerts().stream().collect(Collectors.toMap(item -> item.getId().toString(), item -> item));
            ArrayList<CertsEntity> updateCerntList = new ArrayList<CertsEntity>();
            CertsEntity sourceCert = null;
            CertsEntity updateCert = null;
            for (CertsChangeEntity cert : changeEntity.getCerts()) {
                sourceCert = sourceCerts.get(cert.getSourceSupplierCertId().toString());
                updateCert = (CertsEntity)((Object)BeanMapper.map((Object)((Object)cert), CertsEntity.class));
                updateCert.setId(sourceCert.getId());
                updateCert.setCreateTime(sourceCert.getCreateTime());
                updateCert.setCreateUserCode(sourceCert.getCreateUserCode());
                updateCert.setPid(sourceCert.getPid());
                subFileCopyResp = this.attachmentApi.copyFiles(cert.getId().toString(), null, null, sourceCert.getId().toString(), null, null, true);
                if (!subFileCopyResp.isSuccess()) {
                    throw new BusinessException("\u4f9b\u5e94\u5546\u4fe1\u606f\u66f4\u65b0\u5931\u8d25\uff0c\u4f01\u4e1a\u8bc1\u4ef6\u590d\u5236\u5931\u8d25\uff01");
                }
                updateCerntList.add(updateCert);
            }
            updateEntity.setCerts(updateCerntList);
        } else {
            updateEntity.setCerts(new ArrayList<CertsEntity>());
        }
        if (CollectionUtils.isNotEmpty(supplierEntity.getSubLeaders())) {
            Map<String, SubleadersEntity> sourceLeaders = supplierEntity.getSubLeaders().stream().collect(Collectors.toMap(item -> item.getId().toString(), item -> item));
            ArrayList<SubleadersEntity> updaetLeaderList = new ArrayList<SubleadersEntity>();
            SubleadersEntity sourceSubleader = null;
            SubleadersEntity updateSubleadersEntity = null;
            for (SubleadersChangeEntity leaderChange : changeEntity.getSubLeaders()) {
                sourceSubleader = sourceLeaders.get(leaderChange.getSourceSupplierSubLeaderId().toString());
                updateSubleadersEntity = (SubleadersEntity)((Object)BeanMapper.map((Object)((Object)leaderChange), SubleadersEntity.class));
                updateSubleadersEntity.setId(sourceSubleader.getId());
                updateSubleadersEntity.setCreateTime(sourceSubleader.getCreateTime());
                updateSubleadersEntity.setCreateUserCode(sourceSubleader.getCreateUserCode());
                updateSubleadersEntity.setPid(sourceSubleader.getPid());
                subFileCopyResp = this.attachmentApi.copyFiles(leaderChange.getId().toString(), null, null, sourceSubleader.getId().toString(), null, null, true);
                if (!subFileCopyResp.isSuccess()) {
                    throw new BusinessException("\u4f9b\u5e94\u5546\u4fe1\u606f\u66f4\u65b0\u5931\u8d25\uff0c\u5206\u5305\u8d1f\u8d23\u4eba\u9644\u4ef6\u590d\u5236\u5931\u8d25\uff01");
                }
                updaetLeaderList.add(updateSubleadersEntity);
            }
            updateEntity.setSubLeaders(updaetLeaderList);
        } else {
            updateEntity.setSubLeaders(new ArrayList<SubleadersEntity>());
        }
        updateEntity.setId(supplierEntity.getId());
        updateEntity.setCreateTime(supplierEntity.getCreateTime());
        updateEntity.setCreateUserCode(supplierEntity.getCreateUserCode());
        updateEntity.setLabors(supplierEntity.getLabors());
        updateEntity.setHistory(supplierEntity.getHistory());
        updateEntity.setCode(supplierEntity.getCode());
        updateEntity.setVersion(supplierEntity.getVersion());
        CommonResponse subFileCopyResp2 = this.attachmentApi.copyFiles(changeEntity.getId().toString(), null, null, supplierEntity.getId().toString(), null, null, true);
        if (!subFileCopyResp2.isSuccess()) {
            throw new BusinessException("\u4f9b\u5e94\u5546\u4fe1\u606f\u66f4\u65b0\u5931\u8d25\uff0c\u4e3b\u5355\u636e\u9644\u4ef6\u590d\u5236\u5931\u8d25\uff01");
        }
        this.logger.info("\u672c\u6b21\u53d8\u66f4\u5355\u751f\u6548\u66f4\u65b0\u5185\u5bb9\uff1a{}", (Object)JSONObject.toJSONString((Object)((Object)updateEntity)));
        boolean rs = this.supplierService.saveOrUpdate((Object)updateEntity);
        if (!rs) {
            throw new RuntimeException("\u4f9b\u5e94\u5546\u4fe1\u606f\u53d8\u66f4\u66f4\u65b0\u5931\u8d25\uff01");
        }
    }
}

