package com.ejianc.foundation.share.controller;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;

import com.ejianc.foundation.share.bean.ProjectSetPoolEntity;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.share.controller.param.YnsbjMaterialAndEquipCategoryParam;
import com.ejianc.foundation.share.controller.param.YnsbjMaterialAndEquipParam;
import com.ejianc.foundation.share.controller.param.YnsbjProjectParam;
import com.ejianc.foundation.share.controller.resp.YnsbjDataInfo;
import com.ejianc.foundation.share.controller.resp.YnsbjDataInfos;
import com.ejianc.foundation.share.controller.resp.YnsbjResponse;
import com.ejianc.foundation.share.service.IMaterialService;
import com.ejianc.foundation.share.service.IProjectSetService;

@RestController
@RequestMapping("/ynsbj/mdm/")
public class YnsbjMdmController {
	private Logger logger = LoggerFactory.getLogger(getClass());
	
	@Autowired
	private IMaterialService materialService;
	@Autowired
	private IProjectSetService projectSetService;
	
	/**
	 * 项目信息中  施工项目部更新
	 * 生产环境
	 * @param paramStr
	 * @return
	 */
	@RequestMapping(value = "/project/deptId/sync", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> projectDeptIdSync(@RequestBody(required = true) String paramStr) {
		if(StringUtils.isBlank(paramStr)) {
			return CommonResponse.error("参数不能为空");
		}
		logger.info("更新项目池施工项目部信息，{}",paramStr);
		JSONObject jsonObject = JSON.parseObject(paramStr);
		JSONObject pOrg = jsonObject.getJSONObject("pOrg");
		JSONObject org = jsonObject.getJSONObject("org");
		QueryParam param = new QueryParam();
		if(StringUtils.isEmpty(org.getString("projectCode"))){
			logger.info("projectCode，为空，{}",paramStr);
			return CommonResponse.error("projectCode为空");
		}
		param.getParams().put("code",new Parameter(QueryParam.EQ,org.getString("projectCode")));
		List<ProjectSetPoolEntity> list = projectSetService.queryList(param);
		if(ListUtil.isNotEmpty(list)){
			ProjectSetPoolEntity entity = list.get(0);
			entity.setProjectDepartmentId(org.getLong("id"));
			entity.setProjectDepartmentName(org.getString("name"));
			entity.setOrgId(pOrg.getLong("id"));
			entity.setOrgName(pOrg.getString("name"));
			projectSetService.saveOrUpdateNoES(entity);
		}

		return CommonResponse.success("操作成功！");
	}

	/**
	 * 项目信息同步
	 * 生产环境
	 * @param paramStr
	 * @return
	 */
	@RequestMapping(value = "/project/receive/prod", method = RequestMethod.POST)
	@ResponseBody
	public Map<String, Object> receiveProjectsProd(@RequestBody(required = true) String paramStr) {
		return receiveProjects(paramStr);
	}

	/**
	 * 项目信息同步
	 *
	 * @param paramStr
	 * @return
	 */
	@RequestMapping(value = "/project/receive", method = RequestMethod.POST)
	@ResponseBody
	public Map<String, Object> receiveProjects(@RequestBody(required = true) String paramStr) {
		YnsbjResponse response = new YnsbjResponse();
		response.setCode("0");
		if(StringUtils.isBlank(paramStr)) {
			response.setCode("1");
			response.setDesc("项目参数不能为空");
			return YnsbjResponse.packageResp(response);
		}
		SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		logger.info(dateFormat.format(new Date()) + "：项目接收数据格式为"+paramStr);
		try {
			JSONObject jsonObject = JSON.parseObject(paramStr);
			JSONObject dataJson = jsonObject.getJSONObject("DATA");
			String uuid = dataJson.getString("UUID");
			JSONArray dataInfoList = dataJson.getJSONArray("DATAINFOS");
			if(dataInfoList != null && dataInfoList.size() > 0) {
				YnsbjDataInfos ynsbjDataInfos = new YnsbjDataInfos();
				ynsbjDataInfos.setUuid(uuid);
				for(int i=0;i<dataInfoList.size();i++) {
					YnsbjProjectParam projectParam = YnsbjProjectParam.packageYnsbjProjectParam(dataInfoList.getJSONObject(i));
					YnsbjDataInfo dataInfo = projectSetService.saveOrUpdateYnsbjProject(projectParam);
					ynsbjDataInfos.addYnsbjDataInfo(dataInfo);
				}
				response.setData(ynsbjDataInfos);
			}
		}catch(Exception e) {
			response.setCode("1");
			response.setDesc("项目参数数据格式错误");
			logger.error("项目参数数据格式错误----->",e);
		}
		Map<String, Object> resultMap = YnsbjResponse.packageResp(response);
		logger.info(dateFormat.format(new Date()) + "：项目响应数据格式为"+resultMap);
		return resultMap;
	}

	/**
	 * 物料、设备分类同步
	 * 生产环境
	 * @param paramStr
	 * @return
	 */
	@RequestMapping(value = "/materialAndEquipment/category/receive/prod", method = RequestMethod.POST)
	@ResponseBody
	public Map<String, Object> receiveMaterialAndEquipmentCategoryProd(@RequestBody(required = false) String paramStr) {
		return receiveMaterialAndEquipmentCategory(paramStr);
	}
	/**
	 * 物料、设备分类同步
	 *
	 * @param paramStr
	 * @return
	 */
	@RequestMapping(value = "/materialAndEquipment/category/receive", method = RequestMethod.POST)
	@ResponseBody
	public Map<String, Object> receiveMaterialAndEquipmentCategory(@RequestBody(required = false) String paramStr) {
		YnsbjResponse response = new YnsbjResponse();
		response.setCode("0");
		if(StringUtils.isBlank(paramStr)) {
			response.setCode("1");
			response.setDesc("分类参数不能为空");
			return YnsbjResponse.packageResp(response);
		}
		SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		logger.info(dateFormat.format(new Date()) + "：物料、设备分类接收数据格式为"+paramStr);
		try {
			JSONObject jsonObject = JSON.parseObject(paramStr);
			JSONObject dataJson = jsonObject.getJSONObject("DATA");
			String uuid = dataJson.getString("UUID");
			JSONArray dataInfoList = dataJson.getJSONArray("DATAINFOS");
			if(dataInfoList != null && dataInfoList.size() > 0) {
				YnsbjDataInfos ynsbjDataInfos = new YnsbjDataInfos();
				ynsbjDataInfos.setUuid(uuid);
				for(int i=0;i<dataInfoList.size();i++) {
					YnsbjMaterialAndEquipCategoryParam categoryParam = YnsbjMaterialAndEquipCategoryParam.packageYnsbjMaterialAndEquipCategoryParam(dataInfoList.getJSONObject(i));
					YnsbjDataInfo dataInfo = materialService.saveOrUpdateYnsbjMaterialAndEquipCategory(categoryParam);
					ynsbjDataInfos.addYnsbjDataInfo(dataInfo);
				}
				response.setData(ynsbjDataInfos);
			}
		} catch(Exception e) {
			response.setCode("1");
			response.setDesc("分类参数数据格式错误");
			logger.error("分类参数数据格式错误----->",e);
		}
		Map<String, Object> resultMap = YnsbjResponse.packageResp(response);
		logger.info(dateFormat.format(new Date()) + "：物料、设备分类响应数据格式为"+resultMap);
		return resultMap;
	}

	/**
	 * 物料、设备同步
	 * 生产环境
	 * @param paramStr
	 * @return
	 */
	@RequestMapping(value = "/materialAndEquipment/receive/prod", method = RequestMethod.POST)
	@ResponseBody
	public Map<String, Object> receiveMaterialAndEquipmentProd(@RequestBody(required = false) String paramStr) {
		return receiveMaterialAndEquipment(paramStr);
	}

	/**
	 * 物料、设备同步
	 *
	 * @param paramStr
	 * @return
	 */
	@RequestMapping(value = "/materialAndEquipment/receive", method = RequestMethod.POST)
	@ResponseBody
	public Map<String, Object> receiveMaterialAndEquipment(@RequestBody(required = false) String paramStr) {
		YnsbjResponse response = new YnsbjResponse();
		response.setCode("0");
		if(StringUtils.isBlank(paramStr)) {
			response.setCode("1");
			response.setDesc("物料、设备参数不能为空");
			return YnsbjResponse.packageResp(response);
		}
		SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		logger.info(dateFormat.format(new Date()) + "：物料、设备接收数据格式为"+paramStr);
		try {
			JSONObject jsonObject = JSON.parseObject(paramStr);
			JSONObject dataJson = jsonObject.getJSONObject("DATA");
			String uuid = dataJson.getString("UUID");
			JSONArray dataInfoList = dataJson.getJSONArray("DATAINFOS");
			if(dataInfoList != null && dataInfoList.size() > 0) {
				YnsbjDataInfos ynsbjDataInfos = new YnsbjDataInfos();
				ynsbjDataInfos.setUuid(uuid);
				for(int i=0;i<dataInfoList.size();i++) {
					YnsbjMaterialAndEquipParam ynsbjMaterialAndEquipParam = YnsbjMaterialAndEquipParam.packageYnsbjMaterialAndEquipParam(dataInfoList.getJSONObject(i));
					YnsbjDataInfo dataInfo = materialService.saveOrUpdateYnsbjMaterialAndEquip(ynsbjMaterialAndEquipParam);
					ynsbjDataInfos.addYnsbjDataInfo(dataInfo);
				}
				response.setData(ynsbjDataInfos);
			}
		} catch(Exception e) {
			response.setCode("1");
			response.setDesc("物料、设备参数数据格式错误");
			logger.error("物料、设备参数数据格式错误----->",e);
		}
		Map<String, Object> resultMap = YnsbjResponse.packageResp(response);
		logger.info(dateFormat.format(new Date()) + "：物料、设备响应数据格式为"+resultMap);
		return resultMap;
	}

}
