package com.ejianc.foundation.share.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.bean.SubleadersEntity;
import com.ejianc.foundation.share.bean.SupplierEntity;
import com.ejianc.foundation.share.vo.PunishVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.share.vo.dto.SubleadersDTO;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;
import java.util.Map;

public interface ISupplierService extends IBaseService<SupplierEntity> {


	/**
	 * 根据分类Id查询供方列表
	 * 
	 * @param id
	 * @return
	 */
	List<SupplierVO> queryListByCategoryId(Long categoryId);
	
	/**
	 * 保存或修改供方信息
	 * 
	 * @param SupplierVo
	 * @return
	 */
	CommonResponse<SupplierVO> saveOrUpdate(SupplierVO SupplierVo);

	/**
	 * 根据主键ID查询供方详情
	 * 
	 * @param id
	 * @return
	 */
	SupplierVO queryDetail(Long id);

	/**
	 * 删除供方信息
	 * 
	 * @param ids
	 */
	void deleteSupplier(List<Long> ids);

	/**
	 * 处理供方合租不合作状态
	 *
	 * @param data
	 */
	void enableSupplierOrNot(Map<String,Object> data);

	/**
	 * 查询供方列表（翻页）
	 * 
	 * @param queryParam
	 * @return
	 */
	IPage<SupplierVO> queryPageList(QueryParam queryParam);

	/**
	 * 查询供方列表
	 * 
	 * @param queryParam
	 * @return
	 */
	List<SupplierVO> queryExportList(QueryParam queryParam);

	/**
	 * 根据统一社会信用代码查询供方信息
	 * 
	 * @param socialCode
	 * @return
	 */
	SupplierVO queryDetailBySocialCode(String socialCode);

	/**
	 * 查询供方参照
	 * 
	 * @param params
	 * @return
	 */
	IPage<SupplierVO> queryRefMaterialPage(Map<String, Object> params);

	/**
	 * 
	 * 供方协同(生成租户)
	 * */
	CommonResponse<String> supplierCollaboration(SupplierVO supplierVO);

	/**
	 * 获取供应商信息
	 * 
	 * @param tenant
	 * @return
	 */
	SupplierVO querySupplierByTenantId(Long tenant);

	/**
	 *
	 * 组织调用----生成内部客商（客户供应商）
	 * */
	CommonResponse<String> generateInsideSupplierAndCustomer(List<OrgVO> orgList);

	/**
	 *
	 * 组织调用----更新内部客商（客户供应商）
	 * */
	CommonResponse<OrgVO> updateInsideSupplierAndCustomer(OrgVO orgList);


	/**
	 *
	 * 将供应商生成公有云租户
	 *
	 * */
	SupplierEntity generateSupplierTenant(SupplierEntity se);


	/**
	 *
	 * 将分包负责人生成公有云租户
	 *
	 * */
	SupplierEntity generateSubSupplierTenant(SubleadersEntity subLeader,SupplierEntity se);

	/**
	 *
	 * 将供应商生成公有云租户
	 *
	 * */
	CommonResponse<String> generateSupplierTenant(Long supplierId,String name,String telephone);

	/**
	 *
	 * 更新供方管理员手机号与姓名
	 *
	 * */
	CommonResponse<String> updateSupplierUserPhoneAndName(Long supplierId,String name,String telephone);


	IPage<SupplierEntity> queryMdmPage(QueryParam param);


	IPage<SupplierEntity> queryMdmCusPage(QueryParam param);

	List<SupplierDTO> selectByUpDate(String upDate);

	List<SubleadersDTO> selectByUpDateSubLeaders(String upDate);

    String punishSupplierBatch(List<PunishVO> punishVOs);

	String updateSupplierAndSubLeaderBatch(String updateParamsStr);

    List<Map<String, Object>> getSupplierNum(String year);
}
