package com.ejianc.foundation.share.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.bean.LabsubCategoryEntity;
import com.ejianc.foundation.share.bean.LabsubItemEntity;
import com.ejianc.foundation.share.bean.ProsubItemEntity;
import com.ejianc.foundation.share.service.ILabsubCategoryService;
import com.ejianc.foundation.share.service.ILabsubItemService;
import com.ejianc.foundation.share.service.ISubjectOrgService;
import com.ejianc.foundation.share.vo.LabsubItemImportVO;
import com.ejianc.foundation.share.vo.LabsubItemVO;
import com.ejianc.foundation.share.vo.ProsubItemVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 劳务分包档案
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("/labsubItem")
public class LabsubItemController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "LSI_CODE";
    @Autowired
    private ILabsubItemService service;
    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private ILabsubCategoryService labsubCategoryService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<LabsubItemVO> saveOrUpdate(@RequestBody LabsubItemVO saveorUpdateVO) {
        CommonResponse<LabsubItemVO> response= service.saveOrUpdateLabsubItem(saveorUpdateVO);
        return response;
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<LabsubItemVO> queryDetail(Long id) {
    	LabsubItemEntity entity = service.selectById(id);
    	LabsubItemVO vo = BeanMapper.map(entity, LabsubItemVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<LabsubItemVO> vos) {
        service.removeByIds(vos.stream().map(LabsubItemVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * 绑定科目
     *
     * @param map
     * @return
     */
    @RequestMapping(value = "/bandSubject", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> bandSubject(@RequestBody Map map) {
        List<Long> ids = (List<Long>) map.get("ids");
        Long subjectId = Long.valueOf(map.get("subjectId").toString());
        String subjectName = (String) map.get("subjectName");
        service.updateSubject(subjectId,subjectName,ids);
        return CommonResponse.success("绑定成功!");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/pageList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<LabsubItemVO>> pageList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        Map<String, Parameter> paramMap = param.getParams();
        paramMap.put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        if (paramMap.get("categoryId") != null) {
            Object categoryId = paramMap.get("categoryId").getValue();
            if(categoryId != null){
                LabsubCategoryEntity categoryEntity = labsubCategoryService.selectById(categoryId.toString());
                if (categoryEntity != null) {
                    paramMap.put("innerCode", new Parameter(QueryParam.LIKE_RIGHT, categoryEntity.getInnerCode()));
                    paramMap.remove("categoryId");
                }
            }
            else {
                param.getParams().remove("categoryId");
            }
        }

        Page<LabsubItemVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        QueryWrapper<LabsubItemEntity> wrapper = changeToQueryWrapper(param);
        List<LabsubItemVO> list = service.queryLabsubItemList(page, wrapper);
        IPage<LabsubItemVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(list, LabsubItemVO.class));
        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<LabsubItemEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("labsub-import.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refLabsubItemData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<LabsubItemVO>> refLabsubItemData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<LabsubItemEntity> page = service.queryPage(param,false);
        IPage<LabsubItemVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), LabsubItemVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/download")
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "prosub-import.xlsx", "劳务分包导入模板");
    }


    /**
     * @Author mrsir_wxp
     * @Date 2020/6/29 专业分包详情导入excel校验
     * @Description excelProsubImport
     * @Param [request, response]
     * @Return com.ejianc.framework.core.response.CommonResponse<com.alibaba.fastjson.JSONObject>
     */
    @RequestMapping(value = "/excelProsubImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelProsubImport(HttpServletRequest request) {
        CommonResponse<JSONObject> response= service.excelProsubImport(request);
        return  response;
    }

    @RequestMapping(value = "/saveImportExceLabsubItem", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> saveImportExcelProsubItem(@RequestBody List<LabsubItemImportVO> importVos) {
        if (ListUtil.isEmpty(importVos)) {
            return CommonResponse.error("导入的数据为空！");
        }
        List<LabsubItemEntity> list = new ArrayList<>();

        importVos.forEach(importVO -> {
            LabsubItemEntity entity = BeanMapper.map(importVO, LabsubItemEntity.class);
            entity.setOrgId(sessionManager.getUserContext().getOrgId());
            entity.setOrgName(sessionManager.getUserContext().getOrgName());
            entity.setEnabled(0);
            list.add(entity);
        });
        service.saveBatch(list,list.size());
        return CommonResponse.success("保存成功！");
    }
    /**
     * @Description 修改专业分包档案状态
     * @param saveorUpdateVO
     * @Return void
     *
     */
    @RequestMapping(value = "/changeState", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> changeState(@RequestBody ProsubItemVO saveorUpdateVO) {
        LabsubItemEntity entity = BeanMapper.map(saveorUpdateVO, LabsubItemEntity.class);
        LambdaUpdateWrapper<LabsubItemEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(LabsubItemEntity::getId,entity.getId());
        updateWrapper.set(LabsubItemEntity::getEnabled,entity.getEnabled());
        service.update(updateWrapper);
        return CommonResponse.success("保存或修改单据成功！");
    }
    /**
     * 劳务分包档案列表
     *
     * @param pageNumber
     * @param pageSize
     * @param relyCondition
     * @param searchText
     * @param condition
     * @return
     */
    @RequestMapping(value = "refLabSubItemPage", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<LabsubItemVO>> refLabSubItemPage(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                 @RequestParam(required = false) String relyCondition,
                                                                 @RequestParam(required = false) String searchText,
                                                                 @RequestParam(required = false) String condition,
                                                                 @RequestParam(required = false) String searchObject) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.setFuzzyFields(Arrays.asList("categoryName","trawlingCode", "trawlingName", "priceType", "unitName", "jobContent", "remarks"));
        /** 租户隔离 */
        if (StringUtils.isNotBlank(relyCondition)) {
            Long categoryId = Long.parseLong(relyCondition.split("=")[1]);
            LabsubCategoryEntity labsubCategoryEntity = labsubCategoryService.selectById(categoryId);
            if (labsubCategoryEntity != null) {
                String innerCode = labsubCategoryEntity.getInnerCode();
                QueryParam queryParam = new QueryParam();
                queryParam.getParams().put("inner_code", new Parameter(QueryParam.LIKE, innerCode));
                List<LabsubCategoryEntity> labsubCategoryEntitys = labsubCategoryService.queryList(queryParam);
                if (CollectionUtils.isNotEmpty(labsubCategoryEntitys)) {
                    List<Long> ids = labsubCategoryEntitys.stream().filter(s -> s.getId() != null).map(LabsubCategoryEntity::getId).collect(Collectors.toList());
                    param.getParams().put("category_id", new Parameter(QueryParam.IN, ids));
                }
            }else{
                return CommonResponse.error("当前分类不存在档案！");
            }
        }
//        if (StringUtils.isNotEmpty(condition)) {
//            /** 处理condition */
//            JSONObject con = JSONObject.parseObject(condition);
//            if (con.containsKey("enabled")){
//                Integer enable = (Integer)con.get("enabled");
//                param.getParams().put("enabled", new Parameter(QueryParam.EQ, enable));
//            }
//        }
        param.getParams().put("enabled", new Parameter(QueryParam.EQ, 1));
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("createTime",QueryParam.DESC);

        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject con = JSONObject.parseObject(condition);
            if (con.containsKey("enabled")){
                Integer enable = (Integer)con.get("enabled");
                if (enable == 1){
                    param.getParams().remove("enabled");
                }
            }
        }

        IPage<LabsubItemEntity> page = service.queryPage(param, false);
        IPage<LabsubItemVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), LabsubItemVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * 劳务分包档案列表-郑州一建
     *
     * @param pageNumber
     * @param pageSize
     * @param relyCondition
     * @param searchText
     * @param condition
     * @return
     */
    @RequestMapping(value = "refLabSubItemPageZzyj", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<LabsubItemVO>> refLabSubItemPageZzyj(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                 @RequestParam(required = false) String relyCondition,
                                                                 @RequestParam(required = false) String searchText,
                                                                 @RequestParam(required = false) String condition,
                                                                 @RequestParam(required = false) String searchObject) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.setFuzzyFields(Arrays.asList("categoryName","trawlingCode", "trawlingName", "priceType", "unitName", "jobContent", "remarks"));
        /** 租户隔离 */
        if (StringUtils.isNotBlank(relyCondition)) {
            Long categoryId = Long.parseLong(relyCondition.split("=")[1]);
            LabsubCategoryEntity labsubCategoryEntity = labsubCategoryService.selectById(categoryId);
            if (labsubCategoryEntity != null) {
                String innerCode = labsubCategoryEntity.getInnerCode();
                QueryParam queryParam = new QueryParam();
                queryParam.getParams().put("inner_code", new Parameter(QueryParam.LIKE, innerCode));
                List<LabsubCategoryEntity> labsubCategoryEntitys = labsubCategoryService.queryList(queryParam);
                if (CollectionUtils.isNotEmpty(labsubCategoryEntitys)) {
                    List<Long> ids = labsubCategoryEntitys.stream().filter(s -> s.getId() != null).map(LabsubCategoryEntity::getId).collect(Collectors.toList());
                    param.getParams().put("category_id", new Parameter(QueryParam.IN, ids));
                }
            }else{
                return CommonResponse.error("当前分类不存在档案！");
            }
        }
//        if (StringUtils.isNotEmpty(condition)) {
//            /** 处理condition */
//            JSONObject con = JSONObject.parseObject(condition);
//            if (con.containsKey("enabled")){
//                Integer enable = (Integer)con.get("enabled");
//                param.getParams().put("enabled", new Parameter(QueryParam.EQ, enable));
//            }
//        }
        param.getParams().put("enabled", new Parameter(QueryParam.EQ, 1));
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("createTime",QueryParam.DESC);

//        if (StringUtils.isNotEmpty(condition)) {
//            /** 处理condition */
//            JSONObject con = JSONObject.parseObject(condition);
//            if (con.containsKey("enabled")){
//                Integer enable = (Integer)con.get("enabled");
//                if (enable == 1){
//                    param.getParams().remove("enabled");
//                }
//            }
//        }
        List<Long> longs = labsubCategoryService.queryUnenabledCategoryListId();
        param.getParams().put("categoryId", new Parameter(QueryParam.NOT_IN,longs));
        IPage<LabsubItemEntity> page = service.queryPage(param, false);
        IPage<LabsubItemVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), LabsubItemVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * 劳务分包档案列表
     *
     * @param pageNumber
     * @param pageSize
     */
    @RequestMapping(value = "labSubItemPage", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<LabsubItemVO>> labSubItemPage(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                 @RequestParam(required = false) String categoryId,
                                                                 @RequestParam(required = false) String enabled) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setFuzzyFields(Arrays.asList("trawlingCode", "trawlingName", "priceType", "unitName", "jobContent", "remarks"));
        /** 租户隔离 */
        if (StringUtils.isNotBlank(categoryId)) {
            LabsubCategoryEntity labsubCategoryEntity = labsubCategoryService.selectById(categoryId);
            if (labsubCategoryEntity != null) {
                String innerCode = labsubCategoryEntity.getInnerCode();
                QueryParam queryParam = new QueryParam();
                queryParam.getParams().put("inner_code", new Parameter(QueryParam.LIKE, innerCode));
                List<LabsubCategoryEntity> labsubCategoryEntitys = labsubCategoryService.queryList(queryParam);
                if (CollectionUtils.isNotEmpty(labsubCategoryEntitys)) {
                    List<Long> ids = labsubCategoryEntitys.stream().filter(s -> s.getId() != null).map(LabsubCategoryEntity::getId).collect(Collectors.toList());
                    param.getParams().put("category_id", new Parameter(QueryParam.IN, ids));
                }
            }
        }
        if (StringUtils.isNotEmpty(enabled)) {
            param.getParams().put("enabled", new Parameter(QueryParam.EQ, enabled));
        }
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("createTime",QueryParam.DESC);
        IPage<LabsubItemEntity> page = service.queryPage(param, false);
        IPage<LabsubItemVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), LabsubItemVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * 根据叶子结点查询整棵树
     *
     * @param param 参数：
     *              idStr(string)：叶子主键ID，多个叶子结点ID直接使用英文逗号分隔
     *              type(string)：劳务分包还是专业分包标识：lab-劳务，pro-专业
     */
    @RequestMapping(value = "queryWholeTreeItemsById", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<Map<String, Object>>> queryWholeTreeItemsById(@RequestBody Map<String, String> param) {
        return service.queryWholeTreeItemsById(param.get("idStr"), param.get("type"));
    }


    /**
     * 更改  劳务分包档案 启停用状态
     * <p>
     * 需求：
     * 1、物资/设备分类和物资/设备列表档案都增加启停用
     * 2、当分类切换启停用状态时，该分类下的所有档案的启停用状态也同时切换，切换前系统给操作者提示
     * 3、当非末级节点的分类切换启停用状态时，该分类下所有的子孙分类的启停用也同时切换，切换前系统给操作者提示
     * 4、子分类的启停用状态不影响父分类；档案的启停用状态不影响分类的启停用（即便某分类下所有的档案都停用，也不影响该分类的启停用状态）
     */
    @RequestMapping(value = "/changeLabsubItemEnableState", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> changeLabsubItemEnableState(@RequestParam("id") Long id, @RequestParam("enabled") Integer enabled) {
        LabsubItemEntity entity = service.selectById(id);
        if (entity == null) {
            return CommonResponse.error("单据不存在！");
        }
        entity.setEnabled(enabled);
        service.saveOrUpdate(entity, false);
        return CommonResponse.success("操作成功！");
    }

}
