package com.ejianc.foundation.share.controller.desktop;

import com.ejianc.business.contractbase.utils.EJCDateUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.consts.ProjectBusinessStatusEnum;
import com.ejianc.foundation.share.service.IProjectSetService;
import com.ejianc.foundation.share.vo.ProjectDesktopVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * @author songlx
 * @version 1.0
 * @description: 项目桌面数据接口
 * @date 2022/4/26
 */
@RestController
@RequestMapping("/projectDesktop/")
public class ProjectDesktopController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IProjectSetService projectSetService;

    @GetMapping(value = "businessStatusCount")
    public CommonResponse<ProjectDesktopVO> businessStatusCount(@RequestParam(value = "orgId", required = false) Long orgId) {
        Long _orgId = orgId == null ? InvocationInfoProxy.getOrgId() : orgId;
        List<OrgVO> orgVOList = (List<OrgVO>) getRespData(orgApi.findChildrenByParentId(_orgId), true, "查询失败，获取当前本下组织信息失败。");
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        List<String> businessStatusList = new ArrayList<>();
        businessStatusList.add(ProjectBusinessStatusEnum.在施.getBusinessStatus());
        businessStatusList.add(ProjectBusinessStatusEnum.未开工.getBusinessStatus());
        businessStatusList.add(ProjectBusinessStatusEnum.停工.getBusinessStatus());
        businessStatusList.add(ProjectBusinessStatusEnum.待竣工.getBusinessStatus());
        businessStatusList.add(ProjectBusinessStatusEnum.竣工.getBusinessStatus());
        ProjectDesktopVO projectDesktopVO = null;
        /** 要求主表有orgId字段，保存单据所属组织 */
        String thisYear = EJCDateUtil.getYear() + "";
        BigDecimal thisYearProjectNum = BigDecimal.ZERO;
        if (commonOrgIds.size() != 0) {
            projectDesktopVO = projectSetService.queryProjectBusinessStatusCount(commonOrgIds, null, businessStatusList);
            thisYearProjectNum = projectSetService.queryThisYearProjectNum(commonOrgIds, null, thisYear);
        } else if (departmentIds.size() != 0) {
            projectDesktopVO = projectSetService.queryProjectBusinessStatusCount(null, departmentIds, businessStatusList);
            thisYearProjectNum = projectSetService.queryThisYearProjectNum(null, departmentIds, thisYear);
        }
        if(projectDesktopVO == null){
            projectDesktopVO = new ProjectDesktopVO(BigDecimal.ZERO, BigDecimal.ZERO);
        }
        projectDesktopVO.setThisYearProjectNum(ComputeUtil.nullToZero(thisYearProjectNum));
        return CommonResponse.success("查询成功！", projectDesktopVO);
    }


    @GetMapping(value = "businessStatusCountParent")
    public CommonResponse<ProjectDesktopVO> businessStatusCountParent(@RequestParam(value = "orgId", required = false) Long orgId) {
        Long _orgId = orgId == null ? InvocationInfoProxy.getOrgId() : orgId;
        List<OrgVO> orgVOList = (List<OrgVO>) getRespData(orgApi.findChildrenByParentId(_orgId), true, "查询失败，获取当前本下组织信息失败。");
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        List<String> businessStatusList = new ArrayList<>();
        businessStatusList.add(ProjectBusinessStatusEnum.在施.getBusinessStatus());
        businessStatusList.add(ProjectBusinessStatusEnum.未开工.getBusinessStatus());
        businessStatusList.add(ProjectBusinessStatusEnum.停工.getBusinessStatus());
        businessStatusList.add(ProjectBusinessStatusEnum.待竣工.getBusinessStatus());
        businessStatusList.add(ProjectBusinessStatusEnum.竣工.getBusinessStatus());
        ProjectDesktopVO projectDesktopVO = null;
        /** 要求主表有orgId字段，保存单据所属组织 */
        if (commonOrgIds.size() != 0) {
            projectDesktopVO = projectSetService.queryProjectBusinessStatusCountParent(commonOrgIds, null, businessStatusList);
        } else if (departmentIds.size() != 0) {
            projectDesktopVO = projectSetService.queryProjectBusinessStatusCountParent(null, departmentIds, businessStatusList);
        }
        if(projectDesktopVO == null){
            projectDesktopVO = new ProjectDesktopVO(BigDecimal.ZERO, BigDecimal.ZERO);
        }
        return CommonResponse.success("查询成功！", projectDesktopVO);
    }


    @GetMapping(value = "businessStatusCountZzyj")
    public CommonResponse<ProjectDesktopVO> businessStatusCountZzyj(@RequestParam(value = "orgId", required = false) Long orgId) {
        Long _orgId = orgId == null ? InvocationInfoProxy.getOrgId() : orgId;
        List<OrgVO> orgVOList = (List<OrgVO>) getRespData(orgApi.findChildrenByParentId(_orgId), true, "查询失败，获取当前本下组织信息失败。");
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        List<String> businessStatusList = new ArrayList<>();
        businessStatusList.add(ProjectBusinessStatusEnum.在施.getBusinessStatus());
        businessStatusList.add(ProjectBusinessStatusEnum.未开工.getBusinessStatus());
        businessStatusList.add(ProjectBusinessStatusEnum.停工.getBusinessStatus());
        businessStatusList.add(ProjectBusinessStatusEnum.待竣工.getBusinessStatus());
        businessStatusList.add(ProjectBusinessStatusEnum.竣工.getBusinessStatus());
        ProjectDesktopVO projectDesktopVO = null;
        /** 要求主表有orgId字段，保存单据所属组织 */
        if (commonOrgIds.size() != 0) {
            projectDesktopVO = projectSetService.queryProjectBusinessStatusCountZzyj(commonOrgIds, null, businessStatusList);
        } else if (departmentIds.size() != 0) {
            projectDesktopVO = projectSetService.queryProjectBusinessStatusCountZzyj(null, departmentIds, businessStatusList);
        }
        if(projectDesktopVO == null){
            projectDesktopVO = new ProjectDesktopVO(BigDecimal.ZERO, BigDecimal.ZERO);
        }
        return CommonResponse.success("查询成功！", projectDesktopVO);
    }


    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


}
