package com.ejianc.foundation.share.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.pro.income.vo.ContractReviewVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.vo.CustomerProVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.Utils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.foundation.share.mapper.CustomerProMapper;
import com.ejianc.foundation.share.bean.CustomerProEntity;
import com.ejianc.foundation.share.service.ICustomerProService;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 大企业客户
 * 
 * @author generator
 * 
 */
@Service("customerProService")
public class CustomerProServiceImpl extends BaseServiceImpl<CustomerProMapper, CustomerProEntity> implements ICustomerProService{
    @Autowired
    private IOrgApi iOrgApi;

    @Override
    public JSONObject pageList(QueryParam param) {
        int pageIndex = param.getPageIndex();
        int pageSize = param.getPageSize();
        long total = 0L; // 总条数
        long pages = 0; // 有几页

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("code");
        fuzzyFields.add("tax_payer_identifier");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        //supplierFlag 客商属性，1、供应商，2、客户，3、客商
        if(param.getParams().get("supplierFlag") == null){
            param.getParams().put("supplierFlag", new Parameter(QueryParam.IN, "2,3"));
        }
        List<CustomerProVO> voList = new ArrayList<>();
        if (param.getParams().containsKey("parentId")) {
            List<CustomerProEntity> customerProEntities = this.queryList(param);
            total = total + customerProEntities.size();
            List<CustomerProEntity> list = customerProEntities.stream().skip((pageIndex - 1) * pageSize).limit(pageSize).collect(Collectors.toList());
            voList = BeanMapper.mapList(list, CustomerProVO.class);
        }else{
            //主表数据个数<页面显示个数时使用
            QueryParam supplementParam = Utils.deepCopy(param);
            // 根据合同查出来补充协议
            QueryParam childrenParam = Utils.deepCopy(param);
            param.getParams().put("parentId", new Parameter(QueryParam.EQ, null));

            // 查出来非补充协议的合同
            List<CustomerProEntity> entityList = this.queryList(param);
            total = total + entityList.size();
            List<CustomerProEntity> list = entityList.stream().skip((pageIndex - 1) * pageSize).limit(pageSize).collect(Collectors.toList());
            voList = BeanMapper.mapList(list, CustomerProVO.class);
            List<Long> idList = voList.stream().map(BaseVO::getId).collect(Collectors.toList());
            List<Long> enList = entityList.stream().map(BaseEntity::getId).collect(Collectors.toList());


            //只有子表符合条件，父表不符合条件的单独筛选出来显示------------------------------------------
//        QueryParam otherParam = Utils.deepCopy(param);

            //主非空且以满足个数
            //主非空且不满足个数
            //主为空
            if (ListUtil.isNotEmpty(entityList)) {
                // if (idList.size()>=pageSize){
                if (ListUtil.isNotEmpty(idList)) {
                    //主合同数量已经饱和
                    childrenParam.getParams().put("parentId", new Parameter(QueryParam.IN, idList));
                    //childrenParam.getParams().put("supplementFlag", new Parameter(QueryParam.IN, Arrays.asList(1, 2)));
                    List<CustomerProEntity> childrenList = this.queryList(childrenParam);
                    List<CustomerProVO> childrenVoList = BeanMapper.mapList(childrenList, CustomerProVO.class);
                    Map<Long, List<CustomerProVO>> childrenMap = childrenVoList.stream().collect(Collectors.groupingBy(CustomerProVO::getParentId));

                    if (param.getSearchText() != null && ListUtil.isNotEmpty(childrenVoList)) {
                        List<Long> childrenIdList = new ArrayList<>(childrenMap.keySet());
                        param.getParams().put("id", new Parameter(QueryParam.IN, childrenIdList));
                        // 搜索补充协议编码，主合同为空。清空搜索条件
                        if (ListUtil.isEmpty(entityList)) {
                            param.setSearchText(null);
                        }
                        List<CustomerProEntity> newEntityList = this.queryList(param);
                        // 搜索非补充协议编码，两个结果合并
                        entityList.addAll(newEntityList);
                        entityList = entityList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() ->
                                new TreeSet<>(Comparator.comparing(CustomerProEntity::getId))), ArrayList::new));
                        entityList = entityList.stream().sorted(Comparator.comparing(CustomerProEntity::getCreateTime).reversed()).collect(Collectors.toList());
                        list = entityList.stream().skip((pageIndex - 1) * pageSize).limit(pageSize).collect(Collectors.toList());
                        voList = BeanMapper.mapList(list, CustomerProVO.class);
                    }

                    if (ListUtil.isNotEmpty(voList)) {
                        // 拼装数据
                        for (CustomerProVO vo : voList) {
                            if (childrenMap.containsKey(vo.getId())) {
                                vo.setChildren(childrenMap.get(vo.getId()));
                            }
                        }

                    }
                    //主合同数量未饱和
                    supplementParam.setPageIndex(1);
                    supplementParam.setPageSize(pageSize - idList.size());
                    supplementParam.getParams().put("parentId", new Parameter(QueryParam.NOT_IN, enList));
                    // supplementParam.getParams().put("supplementFlag", new Parameter(QueryParam.IN, Arrays.asList(1, 2)));
                    IPage<CustomerProEntity> contractReviewEntityIPage1 = this.queryPage(supplementParam);
                    total = total + contractReviewEntityIPage1.getTotal();
                    // }else {
                    if (idList.size() < pageSize) {
                        //主合同数量未饱和
//                supplementParam.setPageIndex(1);
//                supplementParam.setPageSize(pageSize-idList.size());
//                childrenParam.getParams().put("mainContractId", new Parameter(QueryParam.NOT_IN, idList));
//                supplementParam.getParams().put("supplementFlag", new Parameter(QueryParam.IN, Arrays.asList(1, 2)));
//                IPage<ContractReviewEntity> contractReviewEntityIPage1 = this.queryPage(supplementParam);
//                total = total+ contractReviewEntityIPage1.getTotal();
                        List<CustomerProEntity> records = contractReviewEntityIPage1.getRecords();
                        List<CustomerProVO> contractReviewVOS = BeanMapper.mapList(records, CustomerProVO.class);
                        voList.addAll(contractReviewVOS);
                    }
                } else {
                    supplementParam.getParams().put("parentId", new Parameter(QueryParam.NOT_IN, enList));
                    //supplementParam.getParams().put("supplementFlag", new Parameter(QueryParam.IN, Arrays.asList(1, 2)));
                    List<CustomerProEntity> contractReviewEntities = this.queryList(supplementParam);
                    total = total + contractReviewEntities.size();
                    List<CustomerProEntity> collect = contractReviewEntities.stream().skip(((pageIndex - 1) * pageSize) - entityList.size()).limit(pageSize).collect(Collectors.toList());
                    List<CustomerProVO> contractReviewVOS = BeanMapper.mapList(collect, CustomerProVO.class);
                    voList.addAll(contractReviewVOS);
                }
            } else {
                //查询补充协议满足条件的
                supplementParam.getParams().put("parentId", new Parameter(QueryParam.NE, null));
                IPage<CustomerProEntity> contractReviewEntityIPage1 = this.queryPage(supplementParam);
                total = total + contractReviewEntityIPage1.getTotal();
                List<CustomerProEntity> records = contractReviewEntityIPage1.getRecords();
                List<CustomerProVO> contractReviewVOS = BeanMapper.mapList(records, CustomerProVO.class);
                voList.addAll(contractReviewVOS);

            }

        }
//        total = entityList.size();
        if (total % pageSize > 0) {
            pages = (total / pageSize) + 1;
        } else if (total % pageSize == 0) {
            pages = total / pageSize;
        }

        JSONObject page = new JSONObject();
        page.put("records", voList);
        page.put("total", total);
        page.put("current", pageIndex);
        page.put("size", pageSize);
        page.put("pages", pages);


        return page;
    }
}
