package com.ejianc.foundation.share.controller;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.share.bean.ProjectSetPoolEntity;
import com.ejianc.foundation.share.bean.SupplierEntity;
import com.ejianc.foundation.share.service.IProjectSetService;
import com.ejianc.foundation.share.service.ISupplierService;
import com.ejianc.foundation.share.service.ISupplyBankService;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;


/**
 * 郑州一建主数据同步接口
 * 供应商、项目池、客户
 *
 * */

@RestController
@RequestMapping("/zzyj/mdm/")
public class ZzyjMdmController {
	private Logger logger = LoggerFactory.getLogger(getClass());
	
	@Autowired
	private IProjectSetService projectSetService;

	@Autowired
	private ISupplierService supplierService;

	@Autowired
	private ISupplyBankService supplyBankService;

	@Autowired
	private IDefdocApi iDefdocApi;
	/**
	 * 读取项目信息
	 * @param param
	 * @return
	 */
	@RequestMapping(value = "/project/sync", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<List<JSONObject>> projectSync(HttpServletRequest request, @RequestBody(required = true) QueryParam param) {
		if(param == null) {
			param = new QueryParam();
		}
		String syncMode = request.getParameter("syncMode");
		if("increment".equals(syncMode)) {
			SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
			Calendar calendar = Calendar.getInstance(); //创建Calendar 的实例
	        calendar.add(Calendar.DAY_OF_MONTH, -1);
	        String syncTime = dateFormat.format(calendar.getTime()) + " 00:00:00";
	        param.getParams().put("syncTime", new Parameter(QueryParam.EQ, syncTime));
		}
		logger.info("读取项目信息参数，{}",JSONObject.toJSONString(param));
		IPage<ProjectSetPoolEntity> list = projectSetService.queryMdmPage(param);
		List<JSONObject> res = new ArrayList<>();
		if(ListUtil.isNotEmpty(list.getRecords())){
			for (int i = 0; i < list.getRecords().size(); i++) {
				ProjectSetPoolEntity poolEntity = list.getRecords().get(i);
				JSONObject object = JSONObject.parseObject(JSONObject.toJSONString(poolEntity));

				object.put("taxType",poolEntity.getTaxType()!=null?("1".equals(poolEntity.getTaxType())?"一般计税":"简易征收"):"");
				CommonResponse<DefdocDetailVO> response = null;
				if(poolEntity.getProjectType()!=null){
					response = iDefdocApi.getDefDocById(poolEntity.getProjectType());
					if(response.isSuccess() && response.getData()!=null){
						DefdocDetailVO detailVO = response.getData();
						object.put("projectType",detailVO.getName());
					}
				}
				object.put("devType",poolEntity.getDevType()!=null?("1".equals(poolEntity.getDevType())?"自营":"联营"):"");
				if(poolEntity.getRunType()!=null){
					response = iDefdocApi.getDefDocById(poolEntity.getRunType());
					if(response.isSuccess() && response.getData()!=null){
						DefdocDetailVO detailVO = response.getData();
						object.put("runType",detailVO.getName());
					}
				}
				if(poolEntity.getFundsSource()!=null){
					response = iDefdocApi.getDefDocById(poolEntity.getFundsSource());
					if(response.isSuccess() && response.getData()!=null){
						DefdocDetailVO detailVO = response.getData();
						object.put("fundsSource",detailVO.getName());
					}
				}
				if(poolEntity.getStructureType()!=null){
					response = iDefdocApi.getDefDocById(poolEntity.getStructureType());
					if(response.isSuccess() && response.getData()!=null){
						DefdocDetailVO detailVO = response.getData();
						object.put("structureType",detailVO.getName());
					}
				}
				if(poolEntity.getUseFor()!=null){
					response = iDefdocApi.getDefDocById(poolEntity.getUseFor());
					if(response.isSuccess() && response.getData()!=null){
						DefdocDetailVO detailVO = response.getData();
						object.put("useFor",detailVO.getName());
					}
				}
				object.put("projectStatus",poolEntity.getProjectStatus()!=null?("1".equals(poolEntity.getProjectStatus())?"在建":("2".equals(poolEntity.getProjectStatus())?"项目中止":("3".equals(poolEntity.getProjectStatus())?"竣工":("4".equals(poolEntity.getProjectStatus())?"保修":"其他")))):"");
				object.put("businessStatus",poolEntity.getBusinessStatus()!=null?("1".equals(poolEntity.getBusinessStatus())?"开工准备":
						("2".equals(poolEntity.getBusinessStatus())?"正式开工":
								("3".equals(poolEntity.getBusinessStatus())?"停工":
										("4".equals(poolEntity.getBusinessStatus())?"复工":
												("5".equals(poolEntity.getBusinessStatus())?"完工":
														("6".equals(poolEntity.getBusinessStatus())?"竣工验收":
																("7".equals(poolEntity.getBusinessStatus())?"成本关门":
																		("8".equals(poolEntity.getBusinessStatus())?"决算中":
																				("9".equals(poolEntity.getBusinessStatus())?"已决算":
																						("10".equals(poolEntity.getBusinessStatus())?"资料未归档":
																								("11".equals(poolEntity.getBusinessStatus())?"资料已归档":
																										("12".equals(poolEntity.getBusinessStatus())?"保修中":
																												("13".equals(poolEntity.getBusinessStatus())?"保修结束":
																														("14".equals(poolEntity.getBusinessStatus())?"开账":
																																("15".equals(poolEntity.getBusinessStatus())?"资金冻结":
																																		("16".equals(poolEntity.getBusinessStatus())?"资金恢复":"已销账")))))))))))))))):"");
				res.add(object);
			}
			logger.info("读取项目信息，返回数据，{}",JSONObject.toJSONString(res));
			return CommonResponse.success(res);
		}
		return CommonResponse.success("操作成功！");
	}

	/**
	 * 读取供应商和客户信息
	 * @param param
	 * @return
	 */
	@RequestMapping(value = "/supplier/sync", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<List<SupplierEntity>> supplierSync(HttpServletRequest request, @RequestBody QueryParam param) {
		String syncMode = request.getParameter("syncMode");
		if("increment".equals(syncMode)) {
			SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
			Calendar calendar = Calendar.getInstance(); //创建Calendar 的实例
	        calendar.add(Calendar.DAY_OF_MONTH, -1);
	        String syncTime = dateFormat.format(calendar.getTime()) + " 00:00:00";
	        
	        if(param == null) {
	        	param = new QueryParam();
	        }
	        param.getParams().put("syncTime", new Parameter(QueryParam.EQ, syncTime));
		}
		IPage<SupplierEntity> list = supplierService.queryMdmPage(param);
		logger.info("读取供应商信息参数，{}  返回数据 list.size = {}",JSONObject.toJSONString(param),list.getRecords().size());
		if(ListUtil.isNotEmpty(list.getRecords())){
			for (int i = 0; i < list.getRecords().size(); i++) {
				SupplierEntity entity = list.getRecords().get(i);
				entity.setPersonal(entity.getPersonal()!=null?("e".equals(entity.getPersonal())?"企业":"个人"):"");
				entity.setGroupInOrOut(entity.getGroupInOrOut()!=null?("out".equals(entity.getGroupInOrOut())?"集团外":"集团内"):"");
				entity.setArea(entity.getAreaName());
			}
			return CommonResponse.success(list.getRecords());
		}
		return CommonResponse.success("操作成功！");
	}
	
	/**
	 * 读取银行信息
	 * @param param
	 * @return
	 */
	@RequestMapping(value = "/bank/sync", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<List<JSONObject>> supplierBankSync(HttpServletRequest request) {
		String syncMode = request.getParameter("syncMode");
		String syncTime = null;
		if("increment".equals(syncMode)) {
			SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
			Calendar calendar = Calendar.getInstance(); //创建Calendar 的实例
			calendar.add(Calendar.DAY_OF_MONTH, -1);

			syncTime = dateFormat.format(calendar.getTime()) + " 00:00:00";
		}
		List<JSONObject> supplierBankList = supplyBankService.querySupplyBankListBySyncTime(syncTime);
		return CommonResponse.success(supplierBankList);
	}

	/**
	 * 将未同步的银行数据的更新时间更新到最新时间，以便银行数据同步
	 */
	@RequestMapping(value = "/bank/syncUpdateTime", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> syncUpdateTime() {
		logger.info("开始---将未同步的银行数据的更新时间更新到最新时间....");
		supplyBankService.updateNoTransBankInfo();
		logger.info("...将未同步的银行数据的更新时间更新到最新时间---结束！");
		return CommonResponse.success("操作成功！");
	}
}
