package com.ejianc.foundation.share.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.share.bean.SupplyBankEntity;
import com.ejianc.foundation.share.mapper.SupplyBankMapper;
import com.ejianc.foundation.share.service.ISupplyBankService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 供应商准入---单位银行信息
 * 
 * @author generator
 * 
 */
@Service("supplyBankService")
public class SupplyBankServiceImpl extends BaseServiceImpl<SupplyBankMapper, SupplyBankEntity> implements ISupplyBankService {

	@Autowired
	private SupplyBankMapper supplyBankMapper;

	@Override
	public List<JSONObject> querySupplyBankListBySyncTime(String syncTime) {
		List<JSONObject> supplierBankList = supplyBankMapper.querySupplyBankListBySyncTime(syncTime);
		return supplierBankList;
	}

	@Override
	public void updateNoTransBankInfo() {
		supplyBankMapper.updateNoTransBankInfo();
	}

}
