/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.controller.api;

import com.alibaba.fastjson.JSON;
import com.ejianc.foundation.share.bean.MaterialCategoryEntity;
import com.ejianc.foundation.share.bean.MaterialEntity;
import com.ejianc.foundation.share.controller.SteelMaterialCategoryController;
import com.ejianc.foundation.share.service.ISteelMaterialCategoryService;
import com.ejianc.foundation.share.service.ISteelMaterialService;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.share.vo.SteelVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/steelMaterialApiNoAuth/"})
public class SteelMaterialApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISteelMaterialService materialService;
    @Autowired
    private ISteelMaterialCategoryService materialCategoryService;
    @Autowired
    private SteelMaterialCategoryController steelMaterialCategoryController;

    @RequestMapping(value={"kisSteelSync"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody String param) {
        this.logger.info("\u540c\u6b65\u94a2\u6784\u91d1\u8776\u6750\u6599\u5b57\u5178--\u5f00\u59cb\uff01");
        this.logger.info("\u63a5\u6536\u5230\u53c2\u6570:{}", (Object)param);
        List steelVOS = JSON.parseArray((String)param, SteelVO.class);
        List<Long> collect = steelVOS.stream().map(SteelVO::getFItemID).collect(Collectors.toList());
        List collect1 = null;
        if (((SteelVO)steelVOS.get(0)).getFParentID() == 0L) {
            List<MaterialCategoryVO> materialCategoryVOS = this.materialCategoryService.queryCategoryListByIds(collect);
            collect1 = materialCategoryVOS.stream().map(MaterialCategoryVO::getId).collect(Collectors.toList());
        } else {
            List<MaterialEntity> materialEntities = this.materialService.queryMaterialByIds(collect);
            collect1 = materialEntities.stream().map(MaterialEntity::getId).collect(Collectors.toList());
        }
        collect.removeAll(collect1);
        if (collect.size() > 0) {
            this.logger.info("\u672c\u6b21\u65b0\u589e:{}", (Object)collect.size());
            Map collect2 = steelVOS.stream().collect(Collectors.toMap(SteelVO::getFItemID, Function.identity(), (key1, key2) -> key2));
            for (Long aLong : collect) {
                SteelVO steelVO = (SteelVO)collect2.get(aLong);
                if (((SteelVO)steelVOS.get(0)).getFParentID() == 0L) {
                    MaterialCategoryVO materialCategoryVO = new MaterialCategoryVO();
                    materialCategoryVO.setId(steelVO.getFItemID());
                    if (steelVO.getFParentID() == 0L) {
                        materialCategoryVO.setParentId(null);
                        materialCategoryVO.setInnerCode(steelVO.getFItemID() + "");
                    } else {
                        materialCategoryVO.setParentId(steelVO.getFParentID());
                        materialCategoryVO.setInnerCode(steelVO.getFParentID() + "|" + steelVO.getFItemID());
                    }
                    materialCategoryVO.setName(steelVO.getFFullName());
                    materialCategoryVO.setCode(steelVO.getFNumber());
                    this.saveOrUpdate(materialCategoryVO);
                    continue;
                }
                MaterialVO materialVO = new MaterialVO();
                materialVO.setId(steelVO.getFItemID());
                materialVO.setCategoryId(steelVO.getFParentID());
                materialVO.setName(steelVO.getFFullName());
                materialVO.setCode(steelVO.getFNumber());
                materialVO.setSpec(steelVO.getFModel());
                materialVO.setOrgId(Long.valueOf(1406795679670312962L));
                materialVO.setUnitId(Long.valueOf(1506878704947564546L));
                materialVO.setUnitName("\u5428");
                materialVO.setProperty(Long.valueOf(1L));
                materialVO.setPropertyName("\u5de5\u7a0b\u6750\u6599");
                this.saveOrUpdateMaterial(materialVO);
            }
        }
    }

    public void saveOrUpdate(@RequestBody MaterialCategoryVO materialCategoryVo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (tenantId == null) {
            tenantId = 999999L;
        }
        MaterialCategoryEntity entity = (MaterialCategoryEntity)BeanMapper.map((Object)materialCategoryVo, MaterialCategoryEntity.class);
        entity.setEnabled(1);
        entity.setCreateUserCode(InvocationInfoProxy.getUsercode());
        entity.setCreateTime(new Date());
        entity.setTenantId(tenantId);
        this.materialCategoryService.save(entity);
    }

    public void saveOrUpdateMaterial(@RequestBody MaterialVO materialVo) {
        materialVo.setCreateUserCode(InvocationInfoProxy.getUsercode());
        materialVo.setCreateTime(new Date());
        materialVo.setTenantId(Long.valueOf(999999L));
        materialVo.setEnabled(Integer.valueOf(1));
        this.materialService.save(materialVo);
    }

    @PostMapping(value={"queryExitFlag"})
    public CommonResponse<MaterialVO> queryExitFlag(@RequestBody MaterialVO materialVO) {
        MaterialVO vo = this.materialService.queryExitFlag(materialVO.getName(), materialVO.getSpec(), materialVO.getUnitName(), materialVO.getCategoryId());
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)vo);
    }

    @GetMapping(value={"queryCategoryByCode"})
    public CommonResponse<MaterialCategoryVO> queryCategoryByCode(@RequestParam(value="code") String code) {
        List<MaterialCategoryEntity> list = this.materialCategoryService.queryByCode(String.valueOf(code));
        MaterialCategoryVO vo = null;
        if (ListUtil.isNotEmpty(list)) {
            vo = (MaterialCategoryVO)BeanMapper.map((Object)list.get(0), MaterialCategoryVO.class);
        }
        if (vo == null) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25,\u6ca1\u6709\u67e5\u8be2\u5230\u8be5\u7f16\u7801\u6240\u5c5e\u5206\u7c7b\uff01");
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", vo);
    }

    @GetMapping(value={"queryCategoryListByPid"})
    public CommonResponse<List<MaterialCategoryVO>> queryCategoryListByPid(@RequestParam(value="id") Long id) {
        List<MaterialCategoryVO> list = this.materialCategoryService.queryListByPid(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", list);
    }

    @GetMapping(value={"queryCategoryAllListByPid"})
    public CommonResponse<List<MaterialCategoryVO>> queryCategoryAllListByPid(@RequestParam(value="id") Long id) {
        List<MaterialCategoryVO> list = this.materialCategoryService.queryListAllByPid(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", list);
    }

    @GetMapping(value={"queryCategoryListByChildren"})
    public CommonResponse<List<MaterialCategoryVO>> queryCategoryListByChildren(@RequestParam(value="ids") List<Long> ids) {
        List<MaterialCategoryVO> list = this.materialCategoryService.queryCategoryListByChildren(ids);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", list);
    }

    @GetMapping(value={"queryMaterialBySourceId"})
    public CommonResponse<MaterialVO> queryMaterialBySourceId(String sourceId) {
        MaterialEntity entity = this.materialService.queryBySourceId(sourceId);
        if (entity != null) {
            return CommonResponse.success((Object)BeanMapper.map((Object)entity, MaterialVO.class));
        }
        return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25,\u672a\u67e5\u5230\u76f8\u5173\u7269\u8d44\u3002");
    }

    @GetMapping(value={"queryMaterialByIds"})
    CommonResponse<List<MaterialVO>> queryMaterialByIds(@RequestParam(value="ids") List<Long> ids) {
        List<MaterialEntity> entitys = this.materialService.queryMaterialByIds(ids);
        if (entitys != null && entitys.size() > 0) {
            return CommonResponse.success((Object)BeanMapper.mapList(entitys, MaterialVO.class));
        }
        return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25,\u672a\u67e5\u5230\u76f8\u5173\u7269\u8d44\u3002");
    }

    @GetMapping(value={"queryMaterialItemByIds"})
    CommonResponse<List<MaterialVO>> queryMaterialItemByIds(@RequestParam(value="ids") List<Long> ids) {
        List<MaterialVO> materialVOS = this.materialService.queryItem(ids);
        if (null != materialVOS && materialVOS.size() > 0) {
            return CommonResponse.success(materialVOS);
        }
        return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25,\u672a\u67e5\u5230\u76f8\u5173\u6570\u636e\u3002");
    }

    @GetMapping(value={"queryCategoryById"})
    public CommonResponse<MaterialCategoryVO> queryCategoryById(@RequestParam(value="id") Long id) {
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)this.materialCategoryService.queryDetail(id));
    }

    @PostMapping(value={"queryMaterialByCategoryId"})
    public CommonResponse<List<MaterialVO>> queryMaterialByCategoryId(@RequestBody List<Long> ids) {
        ArrayList res = new ArrayList();
        if (ListUtil.isNotEmpty(ids)) {
            ids.forEach(id -> {
                List<MaterialVO> materialVOS = this.materialService.queryListByCategoryId((Long)id);
                if (ListUtil.isNotEmpty(materialVOS)) {
                    res.addAll(materialVOS);
                }
            });
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", res);
    }

    @GetMapping(value={"queryMaterialByCode"})
    public CommonResponse<MaterialVO> queryMaterialByCode(@RequestParam(value="code") String code) {
        MaterialVO vo = this.materialService.queryByCode(String.valueOf(code));
        if (vo == null) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25,\u6ca1\u6709\u67e5\u8be2\u5230\u8be5\u7f16\u7801\u5bf9\u5e94\u7684\u7269\u6599\uff01");
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)vo);
    }

    @GetMapping(value={"queryCategoryListByMaterialId"})
    public CommonResponse<Map<Long, List<MaterialCategoryVO>>> queryCategoryListByMaterialId(@RequestParam(value="ids") List<Long> ids) {
        Map<Long, List<MaterialCategoryVO>> map = this.materialCategoryService.queryCategoryListByMaterialId(ids);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", map);
    }

    @GetMapping(value={"queryCategoryListByIds"})
    public CommonResponse<List<MaterialCategoryVO>> queryCategoryListByIds(@RequestParam(value="ids") List<Long> ids) {
        List<MaterialCategoryVO> list = this.materialCategoryService.queryCategoryListByIds(ids);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", list);
    }

    @GetMapping(value={"queryUnenabledCategoryListId"})
    public CommonResponse<List<Long>> queryUnenabledCategoryListId() {
        List<Long> list = this.materialCategoryService.queryUnenabledCategoryListId();
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", list);
    }
}

