/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.share.bean.EquipmentCategoryEntity;
import com.ejianc.foundation.share.bean.EquipmentEntity;
import com.ejianc.foundation.share.bean.MaterialCategoryEntity;
import com.ejianc.foundation.share.bean.MaterialEntity;
import com.ejianc.foundation.share.controller.param.YnsbjMaterialAndEquipCategoryParam;
import com.ejianc.foundation.share.controller.param.YnsbjMaterialAndEquipParam;
import com.ejianc.foundation.share.controller.resp.YnsbjDataInfo;
import com.ejianc.foundation.share.mapper.EquipmentCategoryMapper;
import com.ejianc.foundation.share.mapper.EquipmentMapper;
import com.ejianc.foundation.share.mapper.MaterialCategoryMapper;
import com.ejianc.foundation.share.mapper.MaterialMapper;
import com.ejianc.foundation.share.service.IMaterialService;
import com.ejianc.foundation.share.vo.EquipmentVO;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class MaterialServiceImpl
implements IMaterialService {
    @Autowired
    private MaterialMapper materialMapper;
    @Autowired
    private EquipmentMapper equipmentMapper;
    @Autowired
    private MaterialCategoryMapper materialCategoryMapper;
    @Autowired
    private EquipmentCategoryMapper equipmentCategoryMapper;

    @Override
    public List<MaterialVO> queryListByCategoryId(Long categoryId) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<MaterialEntity> entities = this.materialMapper.queryListByCategoryId(tenantId, categoryId);
        if (entities != null && entities.size() > 0) {
            return BeanMapper.mapList(entities, MaterialVO.class);
        }
        return null;
    }

    @Override
    public CommonResponse updateByCategoryId(Long categoryId, Long subjectId, String subjectName) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        int i = this.materialMapper.updateByCategoryId(tenantId, categoryId, subjectId, subjectName);
        return CommonResponse.success();
    }

    @Override
    public CommonResponse updateCategoryCodeByCategoryId(Long categoryId, String categoryCode) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        int i = this.materialMapper.updateCategoryCodeByCategoryId(tenantId, categoryId, categoryCode);
        return CommonResponse.success();
    }

    @Override
    public void updateStateByCategoryId(List<Long> categoryIds, Integer state, Long tenantId) {
        this.materialMapper.updateStateByCategoryId(tenantId, categoryIds, state);
    }

    @Override
    public MaterialVO queryDetail(Long id) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MaterialEntity entity = this.materialMapper.queryDetail(tenantId, id);
        if (entity != null) {
            return (MaterialVO)BeanMapper.map((Object)entity, MaterialVO.class);
        }
        return null;
    }

    @Override
    public List<MaterialVO> queryItem(List<Long> ids) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<MaterialEntity> materialEntities = this.materialMapper.queryItem(tenantId, ids);
        if (materialEntities != null && materialEntities.size() > 0) {
            return BeanMapper.mapList(materialEntities, MaterialVO.class);
        }
        return null;
    }

    @Override
    public void update(MaterialVO uniqueBean) {
        this.materialMapper.update(uniqueBean);
    }

    @Override
    public void updateSubject(Long subjectId, String subjectName, List<Long> ids) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<MaterialEntity> materialEntities = this.materialMapper.queryMaterialByIds(ids, tenantId);
        ArrayList list = new ArrayList();
        materialEntities.forEach(entity -> list.add(BeanMapper.map((Object)entity, MaterialVO.class)));
        list.forEach(vo -> {
            vo.setSubjectId(subjectId);
            vo.setSubjectName(subjectName);
        });
        list.forEach(vo -> this.materialMapper.update((MaterialVO)vo));
    }

    @Override
    public void save(MaterialVO materialVo) {
        this.materialMapper.save(materialVo);
    }

    @Override
    public void insertBatch(List<MaterialVO> materialVOList) {
        if (ListUtil.isNotEmpty(materialVOList)) {
            ArrayList<Object> toInsert = new ArrayList<MaterialVO>();
            for (MaterialVO materialVO : materialVOList) {
                if (toInsert.size() > 0 && toInsert.size() % 1000 == 0) {
                    this.materialMapper.insertBatch(InvocationInfoProxy.getTenantid(), toInsert);
                    toInsert = new ArrayList();
                }
                toInsert.add(materialVO);
            }
            if (toInsert.size() > 0) {
                this.materialMapper.insertBatch(InvocationInfoProxy.getTenantid(), toInsert);
            }
        }
    }

    @Override
    public void amend(Long id, Long property, String propertyName) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        this.materialMapper.amend(id, property, propertyName, tenantId);
    }

    @Override
    public void delete(List<Long> ids) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        for (Long id : ids) {
            this.materialMapper.delete(tenantId, id);
        }
    }

    @Override
    public IPage<MaterialEntity> queryPage(QueryParam queryParam) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        Map paramMap = queryParam.getParams();
        HashMap<String, Object> condition = new HashMap<String, Object>();
        for (Map.Entry entry : paramMap.entrySet()) {
            if ("categoryId".equals(entry.getKey())) {
                MaterialCategoryEntity categoryEntity;
                Object value;
                Parameter parameter = (Parameter)entry.getValue();
                if (StringUtils.isBlank((CharSequence)(parameter.getValue() + "")) || (value = parameter.getValue()) == null || (categoryEntity = this.materialCategoryMapper.queryDetail(tenantId, Long.parseLong(parameter.getValue().toString()))) == null) continue;
                condition.put("innerCode", categoryEntity.getInnerCode());
                continue;
            }
            condition.put((String)entry.getKey(), ((Parameter)entry.getValue()).getValue());
        }
        condition.put("pageIndex", (queryParam.getPageIndex() - 1) * queryParam.getPageSize());
        condition.put("pageSize", queryParam.getPageSize());
        List<MaterialEntity> records = this.materialMapper.queryList(condition);
        Long count = this.materialMapper.queryCount(condition);
        Page page = new Page();
        page.setCurrent((long)queryParam.getPageIndex());
        page.setSize((long)queryParam.getPageSize());
        page.setTotal(count.longValue());
        page.setRecords(records);
        return page;
    }

    @Override
    public MaterialVO queryExitFlag(String name, String spec, String unitName, Long categoryId) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MaterialVO materialVo = this.materialMapper.queryExitFlag(tenantId, name, spec, unitName, categoryId);
        return materialVo;
    }

    @Override
    public List<MaterialVO> queryExcelFlag(String name, String spec, String unitName, String categoryName) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<MaterialVO> list = this.materialMapper.queryExcelFlag(tenantId, name, spec, unitName, categoryName);
        return list;
    }

    @Override
    public MaterialVO queryByCode(String code) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        return this.materialMapper.queryByCode(tenantId, code);
    }

    @Override
    public List<MaterialEntity> queryList(QueryParam queryParam) {
        Map paramMap = queryParam.getParams();
        HashMap<String, Object> condition = new HashMap<String, Object>();
        for (Map.Entry entry : paramMap.entrySet()) {
            condition.put((String)entry.getKey(), ((Parameter)entry.getValue()).getValue());
        }
        List<MaterialEntity> records = this.materialMapper.queryExportList(condition);
        return records;
    }

    @Override
    public void insertMaterialListFromPlatform() {
        Long tenantId = InvocationInfoProxy.getTenantid();
        this.materialMapper.insertMaterialListFromPlatform(tenantId);
    }

    @Override
    public IPage<MaterialVO> queryRefMaterialPage(Map<String, Object> params) {
        List<MaterialEntity> dataList = this.materialMapper.queryRefMaterialList(params);
        Long dataCount = this.materialMapper.queryRefMaterialCount(params);
        List materialVOS = BeanMapper.mapList(dataList, MaterialVO.class);
        Page page = new Page();
        page.setRecords(materialVOS);
        page.setTotal(dataCount.longValue());
        return page;
    }

    @Override
    public IPage<MaterialVO> queryRefMaterialPageZzyj(Map<String, Object> params) {
        List<MaterialEntity> dataList = this.materialMapper.queryRefMaterialListZzyj(params);
        Long dataCount = this.materialMapper.queryRefMaterialCountZzyj(params);
        List materialVOS = BeanMapper.mapList(dataList, MaterialVO.class);
        Page page = new Page();
        page.setRecords(materialVOS);
        page.setTotal(dataCount.longValue());
        return page;
    }

    @Override
    public MaterialEntity queryBySourceId(String sourceId) {
        return this.materialMapper.queryBySourceId(sourceId, InvocationInfoProxy.getTenantid());
    }

    @Override
    public List<MaterialEntity> queryMaterialByIds(List<Long> ids) {
        return this.materialMapper.queryMaterialByIds(ids, InvocationInfoProxy.getTenantid());
    }

    @Override
    public IPage<MaterialEntity> queryZjwjRefMaterialPage(Map<String, Object> params) {
        Page page = new Page();
        if (params.containsKey("sourceOrgId") && null != params.get("sourceOrgId")) {
            List<MaterialEntity> dataList = this.materialMapper.queryZjwjRefMaterialList(params);
            Long dataCount = this.materialMapper.queryZjwjRefMaterialCount(params);
            page.setRecords(dataList);
            page.setTotal(dataCount.longValue());
        }
        return page;
    }

    @Override
    public YnsbjDataInfo saveOrUpdateYnsbjMaterialAndEquipCategory(YnsbjMaterialAndEquipCategoryParam categoryParam) {
        String categoryCode = categoryParam.getCategoryCode();
        System.out.println("\u4e91\u5357\u7269\u8d44\u8bbe\u5907\u5206\u7c7b\u53c2\u6570\uff1a---" + JSONObject.toJSONString((Object)categoryParam));
        if (StringUtils.isNotBlank((CharSequence)categoryCode)) {
            String prefixCode = categoryCode.substring(0, 1);
            if ("1".equals(prefixCode)) {
                List<MaterialCategoryEntity> materialCategoryList = this.materialCategoryMapper.queryByCode(999999L, categoryCode);
                MaterialCategoryEntity materialCategory = null;
                String operateMethod = "";
                if (materialCategoryList != null && materialCategoryList.size() > 0) {
                    materialCategory = materialCategoryList.get(0);
                    materialCategory.setName(categoryParam.getCategoryName());
                    materialCategory.setDescription(categoryParam.getDescription());
                    if (StringUtils.isNotBlank((CharSequence)categoryParam.getState())) {
                        if ("\u6b63\u5e38".equals(categoryParam.getState())) {
                            materialCategory.setEnabled(1);
                        } else {
                            materialCategory.setEnabled(2);
                        }
                    } else {
                        materialCategory.setEnabled(1);
                    }
                    operateMethod = "update";
                } else {
                    materialCategory = new MaterialCategoryEntity();
                    materialCategory.setId(IdWorker.getId());
                    materialCategory.setCode(categoryParam.getCategoryCode());
                    materialCategory.setName(categoryParam.getCategoryName());
                    materialCategory.setDescription(categoryParam.getDescription());
                    if (StringUtils.isNotBlank((CharSequence)categoryParam.getState())) {
                        if ("\u6b63\u5e38".equals(categoryParam.getState())) {
                            materialCategory.setEnabled(1);
                        } else {
                            materialCategory.setEnabled(2);
                        }
                    } else {
                        materialCategory.setEnabled(1);
                    }
                    operateMethod = "add";
                }
                MaterialCategoryEntity parentMaterialCategory = null;
                if (StringUtils.isNotBlank((CharSequence)categoryParam.getParentCode())) {
                    List<MaterialCategoryEntity> parentMaterialCategoryList = this.materialCategoryMapper.queryByCode(999999L, categoryParam.getParentCode());
                    if (parentMaterialCategoryList != null && parentMaterialCategoryList.size() > 0) {
                        parentMaterialCategory = parentMaterialCategoryList.get(0);
                    }
                    if (parentMaterialCategory != null) {
                        materialCategory.setParentId(parentMaterialCategory.getId());
                        materialCategory.setInnerCode(parentMaterialCategory.getInnerCode() + "|" + materialCategory.getId());
                    } else {
                        materialCategory.setInnerCode("\u6709\u4e0a\u7ea7\uff0c\u4f46\u662f\u6ca1\u6709\u5148\u63a8\u8fc7\u6765\uff0c\u6ca1\u67e5\u5230\uff0c\u6240\u4ee5\u6210\u4e86\u73b0\u5728\u8fd9\u6837\u5b50");
                    }
                } else {
                    materialCategory.setInnerCode(materialCategory.getId() + "");
                }
                materialCategory.setTenantId(999999L);
                if ("add".equals(operateMethod)) {
                    this.materialCategoryMapper.insert(materialCategory);
                } else {
                    this.materialCategoryMapper.update(materialCategory);
                }
            } else {
                List<EquipmentCategoryEntity> equipmentCategoryList = this.equipmentCategoryMapper.queryByCode(999999L, categoryCode);
                EquipmentCategoryEntity equipmentCategory = null;
                String operateMethod = "";
                if (equipmentCategoryList != null && equipmentCategoryList.size() > 0) {
                    equipmentCategory = equipmentCategoryList.get(0);
                    equipmentCategory.setName(categoryParam.getCategoryName());
                    equipmentCategory.setDescription(categoryParam.getDescription());
                    if (StringUtils.isNotBlank((CharSequence)categoryParam.getState())) {
                        if ("\u6b63\u5e38".equals(categoryParam.getState())) {
                            equipmentCategory.setEnabled(1);
                        } else {
                            equipmentCategory.setEnabled(2);
                        }
                    } else {
                        equipmentCategory.setEnabled(1);
                    }
                    operateMethod = "update";
                } else {
                    equipmentCategory = new EquipmentCategoryEntity();
                    equipmentCategory.setId(IdWorker.getId());
                    equipmentCategory.setCode(categoryParam.getCategoryCode());
                    equipmentCategory.setName(categoryParam.getCategoryName());
                    equipmentCategory.setDescription(categoryParam.getDescription());
                    if (StringUtils.isNotBlank((CharSequence)categoryParam.getState())) {
                        if ("\u6b63\u5e38".equals(categoryParam.getState())) {
                            equipmentCategory.setEnabled(1);
                        } else {
                            equipmentCategory.setEnabled(2);
                        }
                    } else {
                        equipmentCategory.setEnabled(1);
                    }
                    operateMethod = "add";
                }
                EquipmentCategoryEntity parentEquipmentCategory = null;
                if (StringUtils.isNotBlank((CharSequence)categoryParam.getParentCode())) {
                    System.out.println("\u4e91\u5357\u8bbe\u5907\u5206\u7c7b\u4e0a\u7ea71\uff1a---" + parentEquipmentCategory);
                    List<EquipmentCategoryEntity> parentMaterialCategoryList = this.equipmentCategoryMapper.queryByCode(999999L, categoryParam.getParentCode());
                    if (parentMaterialCategoryList != null && parentMaterialCategoryList.size() > 0) {
                        parentEquipmentCategory = parentMaterialCategoryList.get(0);
                    }
                    System.out.println("\u4e91\u5357\u8bbe\u5907\u5206\u7c7b\u4e0a\u7ea72\uff1a---" + JSONObject.toJSONString(parentMaterialCategoryList));
                    if (parentEquipmentCategory != null) {
                        System.out.println("\u4e91\u5357\u8bbe\u5907\u5206\u7c7b\u4e0a\u7ea73\uff1a---" + JSONObject.toJSONString((Object)parentEquipmentCategory));
                        equipmentCategory.setParentId(parentEquipmentCategory.getId());
                        equipmentCategory.setInnerCode(parentEquipmentCategory.getInnerCode() + "|" + equipmentCategory.getId());
                        System.out.println("\u4e91\u5357\u8bbe\u5907\u5206\u7c7b\u4e0a\u7ea74InnerCode\uff1a---" + equipmentCategory.getInnerCode());
                    } else {
                        equipmentCategory.setInnerCode("\u6709\u4e0a\u7ea7\uff0c\u4f46\u662f\u6ca1\u6709\u5148\u63a8\u8fc7\u6765\uff0c\u6ca1\u67e5\u5230\uff0c\u6240\u4ee5\u6210\u4e86\u73b0\u5728\u8fd9\u6837\u5b50");
                    }
                } else {
                    System.out.println("\u4e91\u5357\u8bbe\u5907\u5206\u7c7b\u6ca1\u6709\u4e0a\u7ea7\uff1a---");
                    equipmentCategory.setInnerCode("" + equipmentCategory.getId());
                    System.out.println("\u4e91\u5357\u8bbe\u5907\u5206\u7c7b\u6ca1\u6709\u4e0a\u7ea7InnerCode\uff1a---" + equipmentCategory.getInnerCode());
                }
                equipmentCategory.setTenantId(999999L);
                equipmentCategory.setSystemId("ZHUSHUJU");
                equipmentCategory.setSourceId(categoryParam.getCategoryCode());
                if ("add".equals(operateMethod)) {
                    System.out.println("\u4e91\u5357\u8bbe\u5907\u5206\u7c7b\u4fdd\u5b58\uff1a---" + JSONObject.toJSONString((Object)equipmentCategory));
                    this.equipmentCategoryMapper.insert(equipmentCategory);
                } else {
                    System.out.println("\u4e91\u5357\u8bbe\u5907\u5206\u7c7b\u66f4\u65b0\uff1a---" + JSONObject.toJSONString((Object)equipmentCategory));
                    this.equipmentCategoryMapper.update(equipmentCategory);
                }
            }
        }
        YnsbjDataInfo dataInfo = new YnsbjDataInfo(categoryParam.getUuid(), categoryParam.getMasterDataCode(), "0", "");
        return dataInfo;
    }

    @Override
    public YnsbjDataInfo saveOrUpdateYnsbjMaterialAndEquip(YnsbjMaterialAndEquipParam ynsbjMaterialAndEquipParam) {
        YnsbjDataInfo dataInfo = null;
        String materialAndEquipCode = ynsbjMaterialAndEquipParam.getMaterialAndEquipCode();
        if (StringUtils.isNotBlank((CharSequence)materialAndEquipCode)) {
            String prefixCode = materialAndEquipCode.substring(0, 1);
            if ("1".equals(prefixCode)) {
                String categoryCode = ynsbjMaterialAndEquipParam.getCategoryCode();
                List<MaterialCategoryEntity> materialCategoryList = this.materialCategoryMapper.queryByCode(999999L, categoryCode);
                if (materialCategoryList != null && materialCategoryList.size() > 0) {
                    MaterialCategoryEntity materialCategoryEntity = materialCategoryList.get(0);
                    String sourceId = ynsbjMaterialAndEquipParam.getMasterDataCode();
                    MaterialEntity materialEntity = this.materialMapper.queryBySourceId(sourceId, 999999L);
                    if (materialEntity != null) {
                        materialEntity.setCategoryId(materialCategoryEntity.getId());
                        materialEntity.setCategoryCode(materialCategoryEntity.getCode());
                        materialEntity.setCategoryName(materialCategoryEntity.getName());
                        materialEntity.setCode(ynsbjMaterialAndEquipParam.getMaterialAndEquipCode());
                        materialEntity.setName(ynsbjMaterialAndEquipParam.getMaterialAndEquipName());
                        materialEntity.setSpec(ynsbjMaterialAndEquipParam.getMaterialAndEquipModel());
                        materialEntity.setUnitName(ynsbjMaterialAndEquipParam.getUnitName());
                        materialEntity.setTenantId(999999L);
                        MaterialVO materialVo = (MaterialVO)BeanMapper.map((Object)materialEntity, MaterialVO.class);
                        this.materialMapper.update(materialVo);
                    } else {
                        materialEntity = new MaterialEntity();
                        materialEntity.setId(IdWorker.getId());
                        materialEntity.setTenantId(999999L);
                        materialEntity.setCategoryId(materialCategoryEntity.getId());
                        materialEntity.setCategoryCode(materialCategoryEntity.getCode());
                        materialEntity.setCategoryName(materialCategoryEntity.getName());
                        materialEntity.setCode(ynsbjMaterialAndEquipParam.getMaterialAndEquipCode());
                        materialEntity.setName(ynsbjMaterialAndEquipParam.getMaterialAndEquipName());
                        materialEntity.setSpec(ynsbjMaterialAndEquipParam.getMaterialAndEquipModel());
                        materialEntity.setUnitName(ynsbjMaterialAndEquipParam.getUnitName());
                        materialEntity.setSourceId(ynsbjMaterialAndEquipParam.getMasterDataCode());
                        MaterialVO materialVo = (MaterialVO)BeanMapper.map((Object)materialEntity, MaterialVO.class);
                        this.materialMapper.save(materialVo);
                    }
                    dataInfo = new YnsbjDataInfo(ynsbjMaterialAndEquipParam.getUuid(), ynsbjMaterialAndEquipParam.getMasterDataCode(), "0", "");
                } else {
                    dataInfo = new YnsbjDataInfo(ynsbjMaterialAndEquipParam.getUuid(), ynsbjMaterialAndEquipParam.getMasterDataCode(), "1", "\u7269\u6599\uff1a" + ynsbjMaterialAndEquipParam.getMaterialAndEquipName() + "\u6240\u5c5e\u5206\u7c7b\u4e3a\u7a7a\uff01");
                }
            } else {
                String categoryCode = ynsbjMaterialAndEquipParam.getCategoryCode();
                List<EquipmentCategoryEntity> equipmentCategoryList = this.equipmentCategoryMapper.queryByCode(999999L, categoryCode);
                if (equipmentCategoryList != null && equipmentCategoryList.size() > 0) {
                    EquipmentCategoryEntity equipmentCategoryEntity = equipmentCategoryList.get(0);
                    String sourceId = ynsbjMaterialAndEquipParam.getMasterDataCode();
                    EquipmentEntity equipmentEntity = this.equipmentMapper.queryBySourceId(sourceId, 999999L);
                    if (equipmentEntity != null) {
                        equipmentEntity.setCategoryId(equipmentCategoryEntity.getId());
                        equipmentEntity.setCategoryName(equipmentCategoryEntity.getName());
                        equipmentEntity.setCode(ynsbjMaterialAndEquipParam.getMaterialAndEquipCode());
                        equipmentEntity.setName(ynsbjMaterialAndEquipParam.getMaterialAndEquipName());
                        equipmentEntity.setSpec(ynsbjMaterialAndEquipParam.getMaterialAndEquipModel());
                        equipmentEntity.setUnitName(ynsbjMaterialAndEquipParam.getUnitName());
                        equipmentEntity.setTenantId(999999L);
                        EquipmentVO equipmentVo = (EquipmentVO)BeanMapper.map((Object)equipmentEntity, EquipmentVO.class);
                        this.equipmentMapper.update(equipmentVo);
                    } else {
                        equipmentEntity = new EquipmentEntity();
                        equipmentEntity.setId(IdWorker.getId());
                        equipmentEntity.setCategoryId(equipmentCategoryEntity.getId());
                        equipmentEntity.setCategoryName(equipmentCategoryEntity.getName());
                        equipmentEntity.setCode(ynsbjMaterialAndEquipParam.getMaterialAndEquipCode());
                        equipmentEntity.setName(ynsbjMaterialAndEquipParam.getMaterialAndEquipName());
                        equipmentEntity.setSpec(ynsbjMaterialAndEquipParam.getMaterialAndEquipModel());
                        equipmentEntity.setUnitName(ynsbjMaterialAndEquipParam.getUnitName());
                        equipmentEntity.setSourceId(ynsbjMaterialAndEquipParam.getMasterDataCode());
                        equipmentEntity.setSystemId("ZHUSHUJU");
                        equipmentEntity.setTenantId(999999L);
                        EquipmentVO equipmentVo = (EquipmentVO)BeanMapper.map((Object)equipmentEntity, EquipmentVO.class);
                        this.equipmentMapper.save(equipmentVo);
                    }
                    dataInfo = new YnsbjDataInfo(ynsbjMaterialAndEquipParam.getUuid(), ynsbjMaterialAndEquipParam.getMasterDataCode(), "0", "");
                } else {
                    dataInfo = new YnsbjDataInfo(ynsbjMaterialAndEquipParam.getUuid(), ynsbjMaterialAndEquipParam.getMasterDataCode(), "1", "\u7269\u6599\uff1a" + ynsbjMaterialAndEquipParam.getMaterialAndEquipName() + "\u6240\u5c5e\u5206\u7c7b\u4e3a\u7a7a\uff01");
                }
            }
        }
        return dataInfo;
    }
}

