/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.share.bean.MaterialCategoryEntity;
import com.ejianc.foundation.share.bean.MaterialEntity;
import com.ejianc.foundation.share.mapper.SteelMaterialCategoryMapper;
import com.ejianc.foundation.share.mapper.SteelMaterialMapper;
import com.ejianc.foundation.share.service.ISteelMaterialService;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class SteelMaterialServiceImpl
implements ISteelMaterialService {
    @Autowired
    private SteelMaterialMapper materialMapper;
    @Autowired
    private SteelMaterialCategoryMapper materialCategoryMapper;

    @Override
    public List<MaterialVO> queryListByCategoryId(Long categoryId) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<MaterialEntity> entities = this.materialMapper.queryListByCategoryId(tenantId, categoryId);
        if (entities != null && entities.size() > 0) {
            return BeanMapper.mapList(entities, MaterialVO.class);
        }
        return null;
    }

    @Override
    public CommonResponse updateByCategoryId(Long categoryId, Long subjectId, String subjectName) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        int i = this.materialMapper.updateByCategoryId(tenantId, categoryId, subjectId, subjectName);
        return CommonResponse.success();
    }

    @Override
    public CommonResponse updateCategoryCodeByCategoryId(Long categoryId, String categoryCode) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        int i = this.materialMapper.updateCategoryCodeByCategoryId(tenantId, categoryId, categoryCode);
        return CommonResponse.success();
    }

    @Override
    public void updateStateByCategoryId(List<Long> categoryIds, Integer state, Long tenantId) {
        this.materialMapper.updateStateByCategoryId(tenantId, categoryIds, state);
    }

    @Override
    public MaterialVO queryDetail(Long id) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MaterialEntity entity = this.materialMapper.queryDetail(tenantId, id);
        if (entity != null) {
            return (MaterialVO)BeanMapper.map((Object)entity, MaterialVO.class);
        }
        return null;
    }

    @Override
    public List<MaterialVO> queryItem(List<Long> ids) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<MaterialEntity> materialEntities = this.materialMapper.queryItem(tenantId, ids);
        if (materialEntities != null && materialEntities.size() > 0) {
            return BeanMapper.mapList(materialEntities, MaterialVO.class);
        }
        return null;
    }

    @Override
    public void update(MaterialVO uniqueBean) {
        this.materialMapper.update(uniqueBean);
    }

    @Override
    public void updateSubject(Long subjectId, String subjectName, List<Long> ids) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<MaterialEntity> materialEntities = this.materialMapper.queryMaterialByIds(ids, tenantId);
        ArrayList list = new ArrayList();
        materialEntities.forEach(entity -> list.add(BeanMapper.map((Object)entity, MaterialVO.class)));
        list.forEach(vo -> {
            vo.setSubjectId(subjectId);
            vo.setSubjectName(subjectName);
        });
        list.forEach(vo -> this.materialMapper.update((MaterialVO)vo));
    }

    @Override
    public void save(MaterialVO materialVo) {
        this.materialMapper.save(materialVo);
    }

    @Override
    public void insertBatch(List<MaterialVO> materialVOList) {
        if (ListUtil.isNotEmpty(materialVOList)) {
            ArrayList<Object> toInsert = new ArrayList<MaterialVO>();
            for (MaterialVO materialVO : materialVOList) {
                if (toInsert.size() > 0 && toInsert.size() % 1000 == 0) {
                    this.materialMapper.insertBatch(InvocationInfoProxy.getTenantid(), toInsert);
                    toInsert = new ArrayList();
                }
                toInsert.add(materialVO);
            }
            if (toInsert.size() > 0) {
                this.materialMapper.insertBatch(InvocationInfoProxy.getTenantid(), toInsert);
            }
        }
    }

    @Override
    public void amend(Long id, Long property, String propertyName) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        this.materialMapper.amend(id, property, propertyName, tenantId);
    }

    @Override
    public void delete(List<Long> ids) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        for (Long id : ids) {
            this.materialMapper.delete(tenantId, id);
        }
    }

    @Override
    public IPage<MaterialEntity> queryPage(QueryParam queryParam) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        Map paramMap = queryParam.getParams();
        HashMap<String, Object> condition = new HashMap<String, Object>();
        for (Map.Entry entry : paramMap.entrySet()) {
            if ("categoryId".equals(entry.getKey())) {
                MaterialCategoryEntity categoryEntity;
                Object value;
                Parameter parameter = (Parameter)entry.getValue();
                if (StringUtils.isBlank((CharSequence)(parameter.getValue() + "")) || (value = parameter.getValue()) == null || (categoryEntity = this.materialCategoryMapper.queryDetail(tenantId, Long.parseLong(parameter.getValue().toString()))) == null) continue;
                condition.put("innerCode", categoryEntity.getInnerCode());
                continue;
            }
            condition.put((String)entry.getKey(), ((Parameter)entry.getValue()).getValue());
        }
        condition.put("pageIndex", (queryParam.getPageIndex() - 1) * queryParam.getPageSize());
        condition.put("pageSize", queryParam.getPageSize());
        List<MaterialEntity> records = this.materialMapper.queryList(condition);
        Long count = this.materialMapper.queryCount(condition);
        Page page = new Page();
        page.setCurrent((long)queryParam.getPageIndex());
        page.setSize((long)queryParam.getPageSize());
        page.setTotal(count.longValue());
        page.setRecords(records);
        return page;
    }

    @Override
    public MaterialVO queryExitFlag(String name, String spec, String unitName, Long categoryId) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MaterialVO materialVo = this.materialMapper.queryExitFlag(tenantId, name, spec, unitName, categoryId);
        return materialVo;
    }

    @Override
    public MaterialVO queryByCode(String code) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        return this.materialMapper.queryByCode(tenantId, code);
    }

    @Override
    public List<MaterialEntity> queryList(QueryParam queryParam) {
        Map paramMap = queryParam.getParams();
        HashMap<String, Object> condition = new HashMap<String, Object>();
        for (Map.Entry entry : paramMap.entrySet()) {
            condition.put((String)entry.getKey(), ((Parameter)entry.getValue()).getValue());
        }
        List<MaterialEntity> records = this.materialMapper.queryExportList(condition);
        return records;
    }

    @Override
    public void insertMaterialListFromPlatform() {
        Long tenantId = InvocationInfoProxy.getTenantid();
        this.materialMapper.insertMaterialListFromPlatform(tenantId);
    }

    @Override
    public IPage<MaterialVO> queryRefMaterialPage(Map<String, Object> params) {
        List<MaterialEntity> dataList = this.materialMapper.queryRefMaterialList(params);
        Long dataCount = this.materialMapper.queryRefMaterialCount(params);
        List materialVOS = BeanMapper.mapList(dataList, MaterialVO.class);
        Page page = new Page();
        page.setRecords(materialVOS);
        page.setTotal(dataCount.longValue());
        return page;
    }

    @Override
    public IPage<MaterialVO> queryRefMaterialPageZzyj(Map<String, Object> params) {
        List<MaterialEntity> dataList = this.materialMapper.queryRefMaterialListZzyj(params);
        Long dataCount = this.materialMapper.queryRefMaterialCountZzyj(params);
        List materialVOS = BeanMapper.mapList(dataList, MaterialVO.class);
        Page page = new Page();
        page.setRecords(materialVOS);
        page.setTotal(dataCount.longValue());
        return page;
    }

    @Override
    public MaterialEntity queryBySourceId(String sourceId) {
        return this.materialMapper.queryBySourceId(sourceId, InvocationInfoProxy.getTenantid());
    }

    @Override
    public List<MaterialEntity> queryMaterialByIds(List<Long> ids) {
        Long tenantid = InvocationInfoProxy.getTenantid();
        if (tenantid == null) {
            tenantid = 999999L;
        }
        return this.materialMapper.queryMaterialByIds(ids, tenantid);
    }
}

