/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.share.bean.SupplyBankEntity;
import com.ejianc.foundation.share.mapper.SupplyBankMapper;
import com.ejianc.foundation.share.service.ISupplyBankService;
import com.ejianc.foundation.util.http.HttpTookitNew;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="supplyBankService")
public class SupplyBankServiceImpl
extends BaseServiceImpl<SupplyBankMapper, SupplyBankEntity>
implements ISupplyBankService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Autowired
    private SupplyBankMapper supplyBankMapper;

    @Override
    public List<JSONObject> querySupplyBankListBySyncTime(String syncTime) {
        List<JSONObject> supplierBankList = this.supplyBankMapper.querySupplyBankListBySyncTime(syncTime);
        return supplierBankList;
    }

    @Override
    public void updateNoTransBankInfo() {
        this.supplyBankMapper.updateNoTransBankInfo();
    }

    @Override
    public String syncMdmBankInfoZzyj(List<Long> accountIds) {
        this.logger.info(">>>>\u90d1\u5dde\u4e00\u5efa \u4e1a\u52a1\u540c\u6b65\u4f9b\u5e94\u5546\u94f6\u884c\u8d26\u6237\u6570\u636estartsupplierId = {}", (Object)accountIds.toString());
        String syncUrl = this.baseHost + "ejc-mdm-web/zzyj/sync/bankInfos/synczzyj";
        List<JSONObject> jsonObjects = ((SupplyBankMapper)this.baseMapper).querySupplyBankListById(accountIds);
        if (jsonObjects != null && jsonObjects.size() > 0) {
            try {
                String resp = HttpTookitNew.postJson(syncUrl, JSONObject.toJSONString(jsonObjects));
                this.logger.info(">>>>\u90d1\u5dde\u4e00\u5efa \u4e1a\u52a1\u540c\u6b65\u4f9b\u5e94\u5546\u94f6\u884c\u8d26\u6237\u6570\u636e...syncUrl = {},resp:{}", (Object)syncUrl, (Object)resp);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.error(">>>>\u90d1\u5dde\u4e00\u5efa\u4e1a\u52a1\u540c\u6b65 \u4f9b\u5e94\u5546\u94f6\u884c\u8d26\u6237\u62a5\u9519---------", (Throwable)e);
            }
        } else {
            this.logger.error(">>>>\u90d1\u5dde\u4e00\u5efa\u4e1a\u52a1\u540c\u6b65 \u65e0\u4f9b\u5e94\u5546\u94f6\u884c\u8d26\u6237\u6570\u636e---------{}", accountIds);
        }
        return ">>>>\u90d1\u5dde\u4e00\u5efa\u4e1a\u52a1\u540c\u6b65 \u4f9b\u5e94\u5546\u94f6\u884c\u8d26\u6237\u6267\u884c\u5b8c\u6bd5!";
    }
}

