package com.ejianc.foundation.share.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 标准工序档案分类表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_share_standard_process_category")
public class StandardProcessCategoryEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="create_user_name")
    private String createUserName; // 创建人
    @TableField(value="update_user_name")
    private String updateUserName; // 修改人
    @TableField(value="parent_id")
    private Long parentId; // 父ID
    @TableField(value="parent_code")
    private String parentCode; // 父分类编号
    @TableField(value="parent_name")
    private String parentName; // 父分类名称
    @TableField(value="code_plan")
    private String codePlan; // 编码方案
    @TableField(value="inner_code")
    private String innerCode; // 标准工序分类树内码
    @TableField(value="code")
    private String code; // 标准工序分类编号
    @TableField(value="name")
    private String name; // 标准工序分类名称
    @TableField(value="description")
    private String description; // 描述
    @TableField(value="sequence")
    private Integer sequence; // 排序
    @TableField(value="source_id")
    private String sourceId; // 来源id
    @TableField(value="source_code")
    private String sourceCode; // 来源编码
    @TableField(value="leaf_flag")
    private Boolean leafFlag; // 是否末级

    @TableField(value="enabled")
    private Integer enabled;// 1启用/2停用
    @TableField(exist=false)
    private Boolean isLeaf; // 是否是叶子节点

    @TableField(exist=false)
    private List<StandardProcessCategoryEntity> children = new ArrayList<>();

    public List<StandardProcessCategoryEntity> getChildren() {
        return children;
    }

    public void setChildren(List<StandardProcessCategoryEntity> children) {
        this.children = children;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }
    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }
    public String getParentCode() {
        return parentCode;
    }

    public void setParentCode(String parentCode) {
        this.parentCode = parentCode;
    }
    public String getParentName() {
        return parentName;
    }

    public void setParentName(String parentName) {
        this.parentName = parentName;
    }
    public String getCodePlan() {
        return codePlan;
    }

    public void setCodePlan(String codePlan) {
        this.codePlan = codePlan;
    }
    public String getInnerCode() {
        return innerCode;
    }

    public void setInnerCode(String innerCode) {
        this.innerCode = innerCode;
    }
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
    public Integer getSequence() {
        return sequence;
    }

    public void setSequence(Integer sequence) {
        this.sequence = sequence;
    }
    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }
    public String getSourceCode() {
        return sourceCode;
    }

    public void setSourceCode(String sourceCode) {
        this.sourceCode = sourceCode;
    }

    public Boolean getLeafFlag() {
        return leafFlag;
    }

    public void setLeafFlag(Boolean leafFlag) {
        this.leafFlag = leafFlag;
    }

    public Integer getEnabled() {
        return enabled;
    }

    public void setEnabled(Integer enabled) {
        this.enabled = enabled;
    }

    public Boolean getIsLeaf() {
        return isLeaf;
    }

    public void setIsLeaf(Boolean leaf) {
        isLeaf = leaf;
    }
}
