/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.bean.StandardProcessCategoryEntity;
import com.ejianc.foundation.share.bean.StandardProcessEntity;
import com.ejianc.foundation.share.service.IStandardProcessCategoryService;
import com.ejianc.foundation.share.service.IStandardProcessService;
import com.ejianc.foundation.share.vo.StandardProcessCategoryVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.util.StandardProcessCategoryAsTree;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"standardProcessCategory"})
public class StandardProcessCategoryController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "STANDARD_PROCESS_CATEGORY";
    @Autowired
    private IStandardProcessCategoryService service;
    @Autowired
    private IStandardProcessService standardProcessService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<StandardProcessCategoryVO> saveOrUpdate(@RequestBody StandardProcessCategoryVO saveOrUpdateVO) {
        List<StandardProcessCategoryEntity> codeData;
        StandardProcessCategoryEntity entity = (StandardProcessCategoryEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, StandardProcessCategoryEntity.class));
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{entity.getCode()}) && (codeData = this.service.queryByCode(entity.getCode(), entity.getId())) != null && codeData.size() > 0) {
            throw new BusinessException("\u5206\u7c7b\u7f16\u7801\u5df2\u5b58\u5728,\u8bf7\u91cd\u65b0\u586b\u5199");
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            if (null == entity.getCode()) {
                BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
                CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
                if (billCode.isSuccess()) {
                    entity.setCode((String)billCode.getData());
                } else {
                    throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
            }
            entity.setId(IdWorker.getId());
            if (entity.getParentId() != null && entity.getParentId() > 0L) {
                StandardProcessCategoryEntity uniqueBean = (StandardProcessCategoryEntity)((Object)this.service.selectById(entity.getParentId()));
                entity.setInnerCode(uniqueBean.getInnerCode() + "|" + entity.getId());
            } else {
                entity.setInnerCode(entity.getId().toString());
            }
        } else {
            StandardProcessCategoryEntity standardProcessCategoryEntity = (StandardProcessCategoryEntity)((Object)this.service.selectById(entity.getId()));
            standardProcessCategoryEntity.setName(saveOrUpdateVO.getName());
            standardProcessCategoryEntity.setCode(saveOrUpdateVO.getCode());
            standardProcessCategoryEntity.setCodePlan(saveOrUpdateVO.getCodePlan());
            standardProcessCategoryEntity.setDescription(saveOrUpdateVO.getDescription());
            standardProcessCategoryEntity.setSequence(saveOrUpdateVO.getSequence());
            entity = standardProcessCategoryEntity;
        }
        this.service.saveOrUpdate((Object)entity, false);
        StandardProcessCategoryVO vo = (StandardProcessCategoryVO)BeanMapper.map((Object)this.service.selectById(entity.getId()), StandardProcessCategoryVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<StandardProcessCategoryVO> queryDetail(Long id) {
        StandardProcessCategoryEntity entity = (StandardProcessCategoryEntity)((Object)this.service.selectById(id));
        StandardProcessCategoryVO vo = (StandardProcessCategoryVO)BeanMapper.map((Object)((Object)entity), StandardProcessCategoryVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        if (ListUtil.isNotEmpty(ids)) {
            for (Long id : ids) {
                StandardProcessCategoryVO standardProcessCategoryVO = (StandardProcessCategoryVO)BeanMapper.map((Object)this.service.selectById(id), StandardProcessCategoryVO.class);
                List<StandardProcessEntity> standardProcessList = this.standardProcessService.queryListByCategoryId(id);
                if (standardProcessList != null && standardProcessList.size() > 0) {
                    return CommonResponse.error((String)("\u5206\u7c7b\u3010" + standardProcessCategoryVO.getName() + "\u3011\u4e0b\u6709\u6807\u51c6\u5de5\u5e8f\u6863\u6848\u4e86\uff0c\u4e0d\u5141\u8bb8\u5220\u9664"));
                }
                List<StandardProcessCategoryVO> children = this.service.queryListByPid(id);
                if (children == null || children.size() <= 0) continue;
                for (StandardProcessCategoryVO child : children) {
                    if (ids.contains(child.getId())) continue;
                    return CommonResponse.error((String)("\u5206\u7c7b\u3010" + standardProcessCategoryVO.getName() + "\u3011\u4e0b\u6709\u5b50\u5206\u7c7b\u4e0d\u5141\u8bb8\u5220\u9664"));
                }
            }
        } else {
            return CommonResponse.error((String)"\u5220\u9664\u5931\u8d25\uff1a\u4e3b\u952e\u4e3a\u7a7a!");
        }
        this.service.removeByIds(ids);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam queryParam) {
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getOrderMap().put("sequence", "asc");
        List<StandardProcessCategoryEntity> dataList = this.service.queryProcessCategoryList(queryParam);
        List resultMapList = BeanMapper.mapList(dataList, Map.class);
        resultMapList.forEach(l -> {
            if (l.get("isLeaf").equals(false)) {
                l.put("children", new ArrayList());
            }
        });
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", (Object)ResultAsTree.createTreeData((List)resultMapList));
        return CommonResponse.success((Object)jsonObject);
    }

    @RequestMapping(value={"/pageList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam queryParam) {
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage pageData = this.service.queryPage(queryParam);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", (Object)pageData);
        return CommonResponse.success((Object)jsonObject);
    }

    @RequestMapping(value={"/enabled/update"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> updateEnabled(@RequestBody StandardProcessCategoryVO standardProcessCategoryVO) {
        StandardProcessCategoryEntity condition = (StandardProcessCategoryEntity)((Object)this.service.selectById(standardProcessCategoryVO.getId()));
        this.service.updateEnabled(standardProcessCategoryVO.getEnabled(), condition.getInnerCode());
        return CommonResponse.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @RequestMapping(value={"/changeCategoryEnableState"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> changeCategoryEnableState(@RequestParam(value="id") Long id, @RequestParam(value="enabled") Integer enabled) {
        this.service.changeCategoryEnableState(id, enabled);
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryStandardProcessRefTree"}, method={RequestMethod.GET})
    @ResponseBody
    public List<StandardProcessCategoryEntity> queryStandardProcessRefTree(@RequestParam(required=false) String searchText) {
        List<StandardProcessCategoryEntity> dataList = null;
        long start = System.currentTimeMillis();
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            if (StringUtils.isNotBlank((CharSequence)searchText)) {
                params.put("searchText", searchText);
            }
            params.put("tenantId", InvocationInfoProxy.getTenantid());
            dataList = this.service.queryListEntityTree(params);
            System.out.println("\u67e5\u8be2\u8017\u65f6:" + (System.currentTimeMillis() - start));
            if (dataList != null && dataList.size() > 0) {
                List<StandardProcessCategoryEntity> resultList = StandardProcessCategoryAsTree.createTreeData(dataList);
                System.out.println("\u603b\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
                return resultList;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @RequestMapping(value={"/queryStandardProcessCategoryRefTree"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Map<String, Object>> queryStandardProcessCategoryRefTree(@RequestParam(required=false) String searchText) {
        try {
            QueryParam queryParam = new QueryParam();
            if (StringUtils.isNotBlank((CharSequence)searchText)) {
                queryParam.getParams().put("name", new Parameter("like", (Object)searchText));
            }
            queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
            queryParam.getOrderMap().put("sequence", "asc");
            List dataList = this.service.queryList(queryParam, false);
            ArrayList resultMapList = new ArrayList();
            HashMap<String, Object> map = null;
            for (StandardProcessCategoryEntity entity : dataList) {
                map = new HashMap<String, Object>();
                map.put("id", entity.getId());
                map.put("key", entity.getId());
                map.put("code", entity.getCode());
                map.put("name", entity.getName());
                map.put("title", entity.getName());
                map.put("parentId", entity.getParentId());
                resultMapList.add(map);
            }
            List result = ResultAsTree.createTreeData(resultMapList);
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("StandardProcessCategory-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refStandardProcessCategoryData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<StandardProcessCategoryVO>> refStandardProcessCategoryData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), StandardProcessCategoryVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/lazyStandardProcessCategoryTree"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Map<String, Object>> lazyStandardProcessCategoryTree(@RequestParam(required=false) String condition, @RequestParam(required=false) Long pid, @RequestParam(required=false) String searchText) {
        List dataList = null;
        try {
            JSONObject con;
            HashMap<String, Object> params = new HashMap<String, Object>();
            if (StringUtils.isNotBlank((CharSequence)searchText)) {
                List<StandardProcessCategoryEntity> standardProcessCategoryEntities;
                Object categoryIdObj;
                params.put("searchText", searchText);
                params.put("tenantId", InvocationInfoProxy.getTenantid());
                if (StringUtils.isNotBlank((CharSequence)condition) && null != (categoryIdObj = (con = JSONObject.parseObject((String)condition)).get((Object)"categoryId"))) {
                    List<Long> asList = new ArrayList<Long>();
                    String categoryId = (String)categoryIdObj;
                    if (categoryId.indexOf(",") > 0) {
                        String[] strings = categoryId.split(",");
                        for (String str : strings) {
                            asList.add(Long.valueOf(str));
                        }
                    } else {
                        asList.add(Long.valueOf(categoryId));
                    }
                    ArrayList<StandardProcessCategoryVO> categoryList = new ArrayList<StandardProcessCategoryVO>();
                    for (Long parentId : asList) {
                        categoryList.addAll(this.service.queryListByPid(parentId));
                    }
                    asList = categoryList.stream().map(BaseVO::getId).collect(Collectors.toList());
                    params.put("ids", asList);
                }
                if (CollectionUtils.isNotEmpty(standardProcessCategoryEntities = this.service.queryListEntityTree(params)) && standardProcessCategoryEntities.size() > 0) {
                    dataList = BeanMapper.mapList(standardProcessCategoryEntities, StandardProcessCategoryVO.class);
                }
            } else {
                Object categoryIdObj;
                dataList = this.service.queryListByPid(pid);
                if (StringUtils.isNotBlank((CharSequence)condition) && null != (categoryIdObj = (con = JSONObject.parseObject((String)condition)).get((Object)"categoryId")) && pid == null) {
                    ArrayList<Long> asList = new ArrayList<Long>();
                    String categoryId = (String)categoryIdObj;
                    if (categoryId.indexOf(",") > 0) {
                        String[] strings;
                        for (String str : strings = categoryId.split(",")) {
                            asList.add(Long.valueOf(str));
                        }
                    } else {
                        asList.add(Long.valueOf(categoryId));
                    }
                    QueryParam queryParam = new QueryParam();
                    queryParam.getParams().put("id", new Parameter("in", asList));
                    List standardProcessCategoryEntities = this.service.queryList(queryParam);
                    if (CollectionUtils.isNotEmpty((Collection)standardProcessCategoryEntities) && standardProcessCategoryEntities.size() > 0) {
                        dataList = BeanMapper.mapList((Iterable)standardProcessCategoryEntities, StandardProcessCategoryVO.class);
                    }
                }
            }
            List map = BeanMapper.mapList(dataList, Map.class);
            return ResultAsTree.createTreeData((List)map);
        }
        catch (Exception e) {
            return null;
        }
    }
}

