package com.ejianc.foundation.share.service;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.share.bean.ProjectArchiveEntity;
import com.ejianc.foundation.share.bean.ProjectWbsEntity;
import com.ejianc.foundation.share.vo.ProjectArchiveVO;
import com.ejianc.foundation.share.vo.ProjectWbsVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

/**
 * 项目WBS
 * 
 * @author generator
 * 
 */
public interface IProjectWbsService extends IBaseService<ProjectWbsEntity> {

    CommonResponse<ProjectWbsVO> saveOrUpdate(ProjectWbsVO projectWbsVO);

    List<ProjectWbsEntity> getChildrenByPid(Long id);

    CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response,Long projectId);

    Object saveImportExcel(HttpServletRequest request, List<ProjectWbsVO> importVOS);

    CommonResponse<List<Map<String, Object>>> queryWBSWholeTreeItemsById(String idStr);

    Page<ProjectArchiveVO> reportList(QueryParam param, boolean b);

    List<ProjectArchiveVO> getProjectIdsNoWbs();

    List<ProjectArchiveVO> getProjectIdsWbs(Long projectId);
}
