package com.ejianc.foundation.share.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.foundation.share.vo.ProjectArchiveVO;
import com.ejianc.foundation.usercenter.api.IJuliApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.foundation.share.mapper.ProjectArchiveMapper;
import com.ejianc.foundation.share.bean.ProjectArchiveEntity;
import com.ejianc.foundation.share.service.IProjectArchiveService;

import java.util.Date;
import java.util.Objects;

/**
 * 项目档案
 * 
 * @author generator
 * 
 */
@Service("projectArchiveService")
public class ProjectArchiveServiceImpl extends BaseServiceImpl<ProjectArchiveMapper, ProjectArchiveEntity> implements IProjectArchiveService{


    private Logger logger = LoggerFactory.getLogger(this.getClass());

    /** bip 同步相关参数 */
    @Value("${juli.bip.pkOrg:101}")
    private String juliBipPkOrg;
    @Value("${juli.bip.pkGroup:0001}")
    private String juliBipPkGroup;
    @Value("${juli.bip.busiCenter:JL03}")
    private String busiCenter;
    private static final String SYNC_PROJECT_URL = "nccloud/api/uapbd/projectmanage/project/add";
    @Autowired
    private IJuliApi juliApi;
    @Override
    public boolean checkSameBillCode(ProjectArchiveVO saveOrUpdateVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper<ProjectArchiveEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(ProjectArchiveEntity::getCode, saveOrUpdateVO.getCode());
        lambda.eq(ProjectArchiveEntity::getTenantId, tenantId);
        if (null != saveOrUpdateVO.getId() && saveOrUpdateVO.getId() > 0) {
            lambda.ne(ProjectArchiveEntity::getId, saveOrUpdateVO.getId());
        }
        return super.list(lambda).size() > 0;
    }

    @Override
    public String pushToBip(ProjectArchiveEntity entity) {
        JSONObject postData = new JSONObject();
        JSONObject ufinterface = new JSONObject();
        ufinterface.put("account", busiCenter);
        ufinterface.put("billtype", "project");
        ufinterface.put("groupcode", juliBipPkGroup);
        ufinterface.put("isexchange","Y");
        ufinterface.put("replace","Y");
        ufinterface.put("sender","pm");
        ufinterface.put("id", entity.getId());
        JSONObject bill = new JSONObject();
        JSONObject billhead = new JSONObject();
        billhead.put("memo", "益企联推送项目数据--"+ DateFormatUtil.formatDate(DateFormatUtil.PATTERN_DEFAULT_ON_SECOND,new Date()));
        billhead.put("pk_group", juliBipPkGroup);
        billhead.put("pk_org", juliBipPkOrg);
        billhead.put("project_code", entity.getCode());
        billhead.put("project_name", entity.getName());
        billhead.put("pk_eps", "003001");
        billhead.put("pk_projectclass", "003001");
        billhead.put("enablestate", "2");
        billhead.put("pk_project", entity.getId());
        if(entity.getProjectDate()!=null){
            billhead.put("initiation_date", DateFormatUtil.formatDate(DateFormatUtil.PATTERN_ISO_ON_DATE,entity.getProjectDate()));
        }
        bill.put("billhead", billhead);
        ufinterface.put("bill", bill);
        postData.put("ufinterface", ufinterface);

        JSONObject param = new JSONObject();
        param.put("url", SYNC_PROJECT_URL);
        param.put("postData", postData.toJSONString());
        CommonResponse<String> res = juliApi.getDataFromBip(param);
        logger.info("同步生成项目信息：请求地址：{}，请求参数：{}，响应：{}",SYNC_PROJECT_URL,postData.toJSONString(),JSONObject.toJSONString(res.getData()));
        if(res.isSuccess()){
            JSONObject projectResp = JSONObject.parseObject(res.getData());
            if(projectResp.getBoolean("success")){
                JSONObject projectObject = projectResp.getJSONObject("data");
                logger.info("项目立项推送响应数据：{}",projectObject.toJSONString());
                if(Objects.equals("Y",projectObject.getJSONObject("ufinterface").getString("successful"))){
                    entity.setSourceBillCode(projectObject.getJSONObject("ufinterface").getJSONArray("sendresult").getJSONObject(0).getString("content"));
                    return projectObject.getJSONObject("ufinterface").getJSONArray("sendresult").getJSONObject(0).getString("content");
                }else {
                    logger.error("项目立项推送响应数据失败，失败原因：{}",projectObject.getJSONObject("ufinterface").getJSONArray("sendresult").getJSONObject(0).getString("resultdescription"));
                }
            } else {
                logger.error("项目立项推送接口失败，失败原因：{}",projectResp.getString("message"));
            }
        }else {
            logger.error("项目立项推送内部调用失败，失败原因：{}",res.getMsg());
        }
        return null;
    }
}
