package com.ejianc.foundation.share.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.share.bean.CustomerEntity;
import com.ejianc.foundation.share.vo.CustomerVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;

public interface ICustomerService extends IBaseService<CustomerEntity> {


	/**
	 * 根据分类Id查询客户列表
	 * 
	 * @param id
	 * @return
	 */
	List<CustomerVO> queryListByCategoryId(Long categoryId);
	
	/**
	 * 保存或修改客户信息
	 * 
	 * @param customerVo
	 * @return
	 */
	CommonResponse<String> saveOrUpdate(CustomerVO customerVo);

	/**
	 * 根据主键ID查询客户详情
	 * 
	 * @param id
	 * @return
	 */
	CustomerVO queryDetail(Long id);

	/**
	 * 删除客户信息
	 * 
	 * @param ids
	 */
	void deleteCustomer(List<Long> ids);

	/**
	 * 查询客户列表（翻页）
	 * 
	 * @param queryParam
	 * @return
	 */
	IPage<CustomerVO> queryPageList(QueryParam queryParam);

	/**
	 * 查询客户列表
	 * 
	 * @param queryParam
	 * @return
	 */
	List<CustomerVO> queryExportList(QueryParam queryParam);

	/**
	 * 根据统一社会信用代码查询客户信息
	 * 
	 * @param socialCode
	 * @return
	 */
	CustomerVO queryDetailBySocialCode(String socialCode);

}
