/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.bean.ProjectSetPoolEntity;
import com.ejianc.foundation.share.service.IProjectSetService;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.share.vo.dto.ProjectPoolDTO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.usercenter.api.IJuliApi;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/projectPoolSetApi/"})
public class ProjectSetApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IProjectSetService projectSetService;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IOrgApi orgApi;
    @Value(value="${juli.bip.pkOrg:0001A11000000000NKRQ}")
    private String juliBipPkOrg;
    private static final String SYNC_PROJECT_URL = "nccloud/api/uapbd/projectmanage/project/add";
    @Autowired
    private IJuliApi juliApi;

    @PostMapping(value={"pushProjectPoolSet"})
    public CommonResponse<String> pushSupplierToShare(@RequestBody byte[] supplyByte) {
        String supplyStr = new String(supplyByte, StandardCharsets.UTF_8);
        this.logger.info("\u63a8\u9001\uff0c\u751f\u6210\u9879\u76ee\u6c60pushProjectPoolSet---{}", (Object)supplyStr);
        ProjectPoolSetVO projectPoolSetVO = (ProjectPoolSetVO)JSONObject.parseObject((String)supplyStr, ProjectPoolSetVO.class);
        ProjectSetPoolEntity entity = (ProjectSetPoolEntity)((Object)BeanMapper.map((Object)projectPoolSetVO, ProjectSetPoolEntity.class));
        entity.setProjectStatus("1");
        entity.setBusinessStatus("1");
        entity.setSettleStatus("1");
        entity.setArchiveStatus("10");
        entity.setCapitalStatus("14");
        entity.setReadNum("\u662f");
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(entity.getId());
        this.projectSetService.deleteProjectById(ids);
        this.projectSetService.saveOrUpdate((Object)entity, false);
        this.projectSetService.pushToBip(entity);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @PostMapping(value={"pushToBip"})
    @ResponseBody
    public CommonResponse<String> pushToBip(@RequestBody JSONObject postData) {
        JSONObject projectResp;
        JSONObject param = new JSONObject();
        param.put("url", (Object)SYNC_PROJECT_URL);
        param.put("postData", (Object)postData.toJSONString());
        CommonResponse res = this.juliApi.getDataFromBip(param);
        this.logger.info("\u540c\u6b65\u751f\u6210\u9879\u76ee\u4fe1\u606f\uff1a\u8bf7\u6c42\u5730\u5740\uff1a{}\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}\uff0c\u54cd\u5e94\uff1a{}", new Object[]{SYNC_PROJECT_URL, postData.toJSONString(), JSONObject.toJSONString((Object)res.getData())});
        if (res.isSuccess() && (projectResp = JSONObject.parseObject((String)((String)res.getData()))).getBoolean("success").booleanValue()) {
            JSONObject projectObject = projectResp.getJSONObject("data");
            this.logger.info("\u9879\u76ee\u7acb\u9879\u63a8\u9001\u54cd\u5e94\u6570\u636e\uff1a{}", (Object)projectObject.toJSONString());
            return CommonResponse.success((String)"\u63a8\u9001\u6210\u529f\uff01");
        }
        return res;
    }

    @GetMapping(value={"callBackProjectPool"})
    public CommonResponse<String> callBackProjectPool(@RequestParam Long id) {
        ProjectSetPoolEntity entity = (ProjectSetPoolEntity)((Object)this.projectSetService.selectById(id));
        if (entity == null) {
            return CommonResponse.error((String)"\u6ca1\u6709\u627e\u5230\u8be5\u9879\u76ee\u7acb\u9879\u5bf9\u5e94\u7684\u9879\u76ee\u4fe1\u606f\uff01");
        }
        CommonResponse resp = this.billTypeApi.checkQuote("BT220218000000001", entity.getId());
        if (!resp.isSuccess()) {
            return CommonResponse.error((String)resp.getMsg());
        }
        this.projectSetService.removeById(id);
        this.logger.info("\u9879\u76ee\u5df2\u88ab\u64a4\u56de\uff01" + JSONObject.toJSONString((Object)((Object)entity)));
        return CommonResponse.success((String)"\u5220\u9664\u9879\u76ee\u6c60\u5bf9\u5e94\u6570\u636e\u6210\u529f\uff01");
    }

    @Deprecated
    @GetMapping(value={"changeProjectBusinessStatus"})
    public CommonResponse<String> changeProjectBusinessStatus(@RequestParam(value="projectId") Long projectId, @RequestParam(value="businessStatus") String businessStatus) {
        if (projectId == null || StringUtils.isEmpty((CharSequence)businessStatus)) {
            return CommonResponse.error((String)"projectId\u548cbusinessStatus\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)projectId);
        updateWrapper.set(ProjectSetPoolEntity::getBusinessStatus, (Object)businessStatus);
        this.projectSetService.update((Wrapper)updateWrapper);
        ProjectSetPoolEntity poolEntity = (ProjectSetPoolEntity)((Object)this.projectSetService.selectById(projectId));
        if (poolEntity == null) {
            return CommonResponse.error((String)"\u9879\u76ee\u4e0d\u5b58\u5728\uff01");
        }
        this.changeOrgStatus(poolEntity.getProjectDepartmentId(), poolEntity.getProjectStatus());
        return CommonResponse.success((String)"\u66f4\u6539\u9879\u76ee\u4e1a\u52a1\u72b6\u6001\u6210\u529f\uff01");
    }

    @GetMapping(value={"changeProjectStatus"})
    public CommonResponse<String> changeProjectStatus(@RequestParam(value="projectId") Long projectId, @RequestParam(value="projectStatus", required=false) String projectStatus, @RequestParam(value="businessStatus", required=false) String businessStatus, @RequestParam(value="settleStatus", required=false) String settleStatus, @RequestParam(value="archiveStatus", required=false) String archiveStatus, @RequestParam(value="capitalStatus", required=false) String capitalStatus) {
        if (projectId == null) {
            return CommonResponse.error((String)"projectId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        ProjectSetPoolEntity poolEntity = (ProjectSetPoolEntity)((Object)this.projectSetService.selectById(projectId));
        if (poolEntity == null) {
            return CommonResponse.error((String)"\u9879\u76ee\u4e0d\u5b58\u5728\uff01");
        }
        boolean noChange = true;
        if (StringUtils.isNotEmpty((CharSequence)projectStatus)) {
            noChange = false;
            poolEntity.setProjectStatus(projectStatus);
        }
        if (StringUtils.isNotEmpty((CharSequence)businessStatus)) {
            noChange = false;
            poolEntity.setBusinessStatus(businessStatus);
        }
        if (StringUtils.isNotEmpty((CharSequence)settleStatus)) {
            noChange = false;
            poolEntity.setSettleStatus(settleStatus);
        }
        if (StringUtils.isNotEmpty((CharSequence)archiveStatus)) {
            noChange = false;
            poolEntity.setArchiveStatus(archiveStatus);
        }
        if (StringUtils.isNotEmpty((CharSequence)capitalStatus)) {
            noChange = false;
            poolEntity.setCapitalStatus(capitalStatus);
        }
        if (noChange) {
            return CommonResponse.error((String)"\u672a\u6539\u53d8\u4efb\u4f55\u72b6\u6001\uff01");
        }
        this.projectSetService.saveOrUpdate((Object)poolEntity, false);
        if (poolEntity.getParentProjectId() != null) {
            ProjectSetPoolEntity parent = (ProjectSetPoolEntity)((Object)this.projectSetService.selectById(poolEntity.getParentProjectId()));
            if (parent != null) {
                QueryParam param = new QueryParam();
                param.getParams().put("parentProjectId", new Parameter("eq", (Object)parent.getId()));
                List children = this.projectSetService.queryList(param);
                if (ListUtil.isNotEmpty((List)children)) {
                    List status = children.stream().map(ProjectSetPoolEntity::getProjectStatus).sorted(Comparator.comparingInt(Integer::valueOf)).collect(Collectors.toList());
                    this.logger.info("\u9879\u76ee\u72b6\u6001\uff1a{}", (Object)JSONObject.toJSONString(status));
                    parent.setProjectStatus((String)status.get(0));
                    status = children.stream().map(ProjectSetPoolEntity::getBusinessStatus).sorted(Comparator.comparingInt(Integer::valueOf)).collect(Collectors.toList());
                    this.logger.info("\u4e1a\u52a1\u72b6\u6001\uff1a{}", (Object)JSONObject.toJSONString(status));
                    parent.setBusinessStatus((String)status.get(0));
                    status = children.stream().map(ProjectSetPoolEntity::getSettleStatus).sorted(Comparator.comparingInt(Integer::valueOf)).collect(Collectors.toList());
                    this.logger.info("\u7ed3\u7b97\u72b6\u6001\uff1a{}", (Object)JSONObject.toJSONString(status));
                    parent.setSettleStatus((String)status.get(0));
                    status = children.stream().map(ProjectSetPoolEntity::getArchiveStatus).sorted(Comparator.comparingInt(Integer::valueOf)).collect(Collectors.toList());
                    this.logger.info("\u5f52\u6863\u72b6\u6001\uff1a{}", (Object)JSONObject.toJSONString(status));
                    parent.setArchiveStatus((String)status.get(0));
                    status = children.stream().map(ProjectSetPoolEntity::getCapitalStatus).sorted(Comparator.comparingInt(Integer::valueOf)).collect(Collectors.toList());
                    this.logger.info("\u8d44\u91d1\u7ba1\u63a7\u72b6\u6001\uff1a{}", (Object)JSONObject.toJSONString(status));
                    parent.setCapitalStatus((String)status.get(0));
                    this.projectSetService.saveOrUpdate((Object)parent);
                } else {
                    this.logger.info("\u5b50\u9879\u76ee\u5217\u8868\u4e3a\u7a7a\u4e0d\u5904\u7406 -- {} ", (Object)JSONObject.toJSONString((Object)((Object)poolEntity)));
                }
            } else {
                this.logger.info("\u7236\u9879\u76ee\u4e3a\u7a7a\u4e0d\u5904\u7406 -- {} ", (Object)JSONObject.toJSONString((Object)((Object)poolEntity)));
            }
        } else {
            this.logger.info("\u7236\u9879\u76eeid\u4e3a\u7a7a\u4e0d\u5904\u7406 -- {} ", (Object)JSONObject.toJSONString((Object)((Object)poolEntity)));
        }
        this.changeOrgStatus(poolEntity.getProjectDepartmentId(), poolEntity.getProjectStatus());
        return CommonResponse.success((String)"\u66f4\u6539\u9879\u76ee\u4e1a\u52a1\u72b6\u6001\u6210\u529f\uff01");
    }

    private void changeOrgStatus(Long orgId, String status) {
        CommonResponse response = this.orgApi.getOneById(orgId);
        if (response.isSuccess() && response.getData() != null) {
            OrgVO orgVO = (OrgVO)response.getData();
            if (!Objects.equals(1, orgVO.getProjectState()) || !Objects.equals("1", status)) {
                if (Objects.equals("1", status)) {
                    orgVO.setProjectState(Integer.valueOf(1));
                } else {
                    orgVO.setProjectState(Integer.valueOf(2));
                }
                this.orgApi.saveOrgInfo(orgVO);
            }
        }
    }

    @GetMapping(value={"getProjectId"})
    public CommonResponse<ProjectPoolSetVO> getProjectId(@RequestParam(value="projectId") Long projectId) {
        if (projectId == null) {
            return CommonResponse.error((String)"projectId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        ProjectSetPoolEntity projectSetPoolEntity = (ProjectSetPoolEntity)((Object)this.projectSetService.selectById(projectId));
        ProjectPoolSetVO vo = (ProjectPoolSetVO)BeanMapper.map((Object)((Object)projectSetPoolEntity), ProjectPoolSetVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f", (Object)vo);
    }

    @PostMapping(value={"getProjectListIds"})
    public CommonResponse<List<ProjectPoolDTO>> getProjectListIds(@RequestBody List<Long> projectIds) {
        QueryParam param = new QueryParam();
        param.getParams().put("id", new Parameter("in", projectIds));
        List list = this.projectSetService.queryList(param);
        List dtoList = BeanMapper.mapList((Iterable)list, ProjectPoolDTO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f", (Object)dtoList);
    }

    public static void main(String[] args) {
        ArrayList<String> sort = new ArrayList<String>();
        sort.add("10");
        sort.add("3");
        sort.add("12");
        sort.add("6");
        sort.add("22");
        sort.add("8");
        sort.sort(Comparator.comparingInt(Integer::valueOf));
        System.out.println(JSONObject.toJSONString(sort));
        sort.sort(Comparator.comparingInt(Integer::parseInt));
        System.out.println(JSONObject.toJSONString(sort));
    }
}

