package com.ejianc.foundation.share.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.bean.ProjectArchiveEntity;
import com.ejianc.foundation.share.bean.ProjectArchiveRecordEntity;
import com.ejianc.foundation.share.consts.ArchiveProjectStatusEnum;
//import com.ejianc.foundation.share.mapper.CustomerMapper;
import com.ejianc.foundation.share.service.IProjectArchiveRecordService;
import com.ejianc.foundation.share.service.IProjectArchiveService;
import com.ejianc.foundation.share.vo.CustomerProjectReportVO;
import com.ejianc.foundation.share.vo.ProjectArchiveVO;
import com.ejianc.foundation.share.vo.ProjectTypeReportVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.*;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;


@RestController
@RequestMapping("/api/projectArchiveApi/")
public class ProjectArchiveApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IProjectArchiveService projectArchiveService;
    @Autowired
    private IProjectArchiveRecordService recordService;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IBillCodeApi billCodeApi;
//    @Autowired
//    private CustomerMapper customerMapper;

    private static final String BILL_CODE = "Project_Archive";//此处需要根据实际修改

    /**
     * 推送，生成项目信息（商机登记、投标结果登记使用）
     *
     * @return
     */
    @PostMapping(value = "pushProjectArchive")
    @Transactional(rollbackFor = Exception.class)
    public CommonResponse<String> pushProjectArchive(@RequestBody ProjectArchiveVO projectArchiveVO){

        logger.info("接收数据，pushProjectArchive----" + JSONObject.toJSONString(projectArchiveVO));
        ProjectArchiveEntity entity = BeanMapper.map(projectArchiveVO, ProjectArchiveEntity.class);

        //生成单据编码
        if (null == entity.getSourceUpdateId()){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), projectArchiveVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        if (!ArchiveProjectStatusEnum.商机阶段.getCode().equals(entity.getProjectStatus())){
            //可能有旧数据
            if (null != entity.getSourceUpdateId()){
                QueryParam param = new QueryParam();
                param.getParams().put("sourceBillId", new Parameter(QueryParam.EQ, entity.getSourceBillId()));
                List<ProjectArchiveEntity> list =  projectArchiveService.queryList(param,false);
                if (CollectionUtils.isNotEmpty(list) && list.size() > 0){
                    entity = this.updateData(entity, list.get(0));
                }
            }
            if (ArchiveProjectStatusEnum.已中标.getCode().equals(entity.getProjectStatus())) {
                //生成项目部
                //项目部
                OrgVO projectDepartment = null;
                //创建项目部
                projectDepartment = this.generateProjectDepartment(entity);
                entity.setProjectDepartmentId(projectDepartment.getId());
                entity.setProjectDepartmentName(projectDepartment.getName());

                //保存更新项目部信息
                if(null != projectDepartment) {
                    CommonResponse<OrgVO> resp = orgApi.saveOrgInfo(projectDepartment);
                    if(!resp.isSuccess()) {
                        throw new BusinessException("提交项目信息失败，保存项目部信息出错: " + resp.getMsg());
                    }else {
                        entity.setProjectDepartmentCode(resp.getData().getCode());
                    }
                }
            }
        }

        projectArchiveService.saveOrUpdate(entity, false);
        String sourceBillId = projectArchiveService.pushToBip(entity);
        if(StringUtils.isNotEmpty(sourceBillId)){
            entity.setSourceBillCode(sourceBillId);
            logger.info("推送bip完毕，再保存一次....");
            projectArchiveService.saveOrUpdate(entity, false);
        }
        //新增一条子表记录信息
        ProjectArchiveRecordEntity recordEntity = new ProjectArchiveRecordEntity();
        recordEntity.setProjectArchiveId(entity.getId());
        recordEntity.setSourceId(projectArchiveVO.getSourceBillId());
        recordEntity.setProjectStatus(Integer.valueOf(entity.getProjectStatus()));
        recordService.saveOrUpdate(recordEntity);
        return CommonResponse.success("保存成功！");
    }


    private ProjectArchiveEntity updateData(ProjectArchiveEntity entity, ProjectArchiveEntity oldEntity) {
        //更新信息
        oldEntity.setProjectStatus(entity.getProjectStatus());
        oldEntity.setSourceUpdateId(entity.getSourceUpdateId());
        oldEntity.setName(entity.getName());
        oldEntity.setOrgId(entity.getOrgId());
        oldEntity.setOrgCode(entity.getOrgCode());
        oldEntity.setOrgName(entity.getOrgName());
        oldEntity.setProjectTypeId(entity.getProjectTypeId());
        oldEntity.setProjectTypeName(entity.getProjectTypeName());
        oldEntity.setProductType(entity.getProductType());
        oldEntity.setProductTypeName(entity.getProductTypeName());
        oldEntity.setProjectDate(entity.getProjectDate());

        oldEntity.setCustomName(entity.getCustomName());
        oldEntity.setCustomLinkName(entity.getCustomLinkName());
        oldEntity.setCustomLinkPhone(entity.getCustomLinkPhone());
        oldEntity.setDesignUnit(entity.getDesignUnit());
        oldEntity.setConstructUnit(entity.getConstructUnit());
        oldEntity.setArea(entity.getArea());
        oldEntity.setAreaName(entity.getAreaName());
        oldEntity.setAddress(entity.getAddress());
        oldEntity.setNationalId(entity.getNationalId());
        oldEntity.setNationalName(entity.getNationalName());
        oldEntity.setProjectHeight(entity.getProjectHeight());
        oldEntity.setProjectSpan(entity.getProjectSpan());
        oldEntity.setBidOpenDate(entity.getBidOpenDate());
        oldEntity.setBidDate(entity.getBidDate());
        oldEntity.setPlanProductDate(entity.getPlanProductDate());
        oldEntity.setPlanDeliverDate(entity.getPlanDeliverDate());
        oldEntity.setProductName(entity.getProductName());
        oldEntity.setSpec(entity.getSpec());
        oldEntity.setNum(entity.getNum());
        oldEntity.setSaleLeaderId(entity.getSaleLeaderId());
        oldEntity.setSaleLeaderName(entity.getSaleLeaderName());
        oldEntity.setSaleLeaderPhone(entity.getSaleLeaderPhone());
        oldEntity.setProjectSituation(entity.getProjectSituation());

        return oldEntity;
    }

    /**
     * 更新项目阶段
     * 更新项目阶段的接口（投标立项、投标文件评审，调用时传引用商机登记的id），只有投标阶段时调用
     * 合同等之后阶段调用时传项目信息id
     * @param projectStatus
     * @param sourceId 商机登记id
     * @return
     */
    @GetMapping(value = "updateProjectStatus")
    CommonResponse<String> updateProjectStatus(String projectStatus, Long sourceId) {
        logger.info("接收参数-projectStatus-{}，sourceId-{}", projectStatus, sourceId);
        LambdaUpdateWrapper<ProjectArchiveEntity> updateWrapper = new LambdaUpdateWrapper<>();
        if (Integer.valueOf(projectStatus) < Integer.valueOf(ArchiveProjectStatusEnum.合同阶段.getCode())){
            updateWrapper.eq(ProjectArchiveEntity::getSourceBillId, sourceId);
        }else {
            updateWrapper.eq(ProjectArchiveEntity::getId, sourceId);
        }

        updateWrapper.set(ProjectArchiveEntity::getProjectStatus, projectStatus);
        if (!projectArchiveService.update(updateWrapper)){
            return CommonResponse.error("修改项目阶段失败！");
        }
        return CommonResponse.success("修改项目阶段成功！");
    }


    /**
     * 更新商机阶段
     * @param businessRound 商机阶段
     * @param sourceId 商机登记id
     * @return
     */
    @GetMapping(value = "updateBusinessRound")
    CommonResponse<String> updateBusinessRound(Integer businessRound, Long sourceId) {
        logger.info("接收参数-businessRound-{}，sourceId-{}", businessRound, sourceId);
        LambdaUpdateWrapper<ProjectArchiveEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(ProjectArchiveEntity::getSourceBillId, sourceId);
        updateWrapper.set(ProjectArchiveEntity::getBusinessRound, businessRound);
        if (!projectArchiveService.update(updateWrapper)){
            return CommonResponse.error("修改项目信息-商机阶段失败！");
        }
        return CommonResponse.success("修改项目信息-商机阶段成功！");
    }

    /**
     * 更新项目阶段
     * @param projectStatus
     * @param sourceId 商机登记id
     * @return
     */
    @GetMapping(value = "updateArchiveProjectStatus")
    CommonResponse<String> updateArchiveProjectStatus(String projectStatus, Long sourceId, Long billId, Boolean manyFlag, Boolean updateFlag) {
        logger.info("接收参数-projectStatus-{}，sourceId-{}，billId-{}，manyFlag-{}，updateFlag-{}", projectStatus, sourceId, billId, manyFlag, updateFlag);
        /*
            可能调用位置
            投标阶段

            合同评审
            销售订单    出库单
            结算单
         */

        ProjectArchiveEntity projectArchiveEntity = new ProjectArchiveEntity();
        if (Integer.valueOf(projectStatus) < Integer.valueOf(ArchiveProjectStatusEnum.合同阶段.getCode())){
            QueryWrapper<ProjectArchiveEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("source_bill_id", sourceId);
            List<ProjectArchiveEntity> list = projectArchiveService.list(queryWrapper);
            projectArchiveEntity = list.get(0);
        }else {
            projectArchiveEntity = projectArchiveService.selectById(sourceId);
        }

        //记录表的最大状态是否比传入状态值大
        Boolean bigFlag = false;
        //记录表是否存在当前状态
        Boolean existFlag = false;

        QueryWrapper<ProjectArchiveRecordEntity> recordQueryWrapper = new QueryWrapper<>();
        recordQueryWrapper.eq("project_archive_id", projectArchiveEntity.getId());
        recordQueryWrapper.orderByDesc("project_status");
        List<ProjectArchiveRecordEntity> list = recordService.list(recordQueryWrapper);

        if (CollectionUtils.isNotEmpty(list) && list.size() > 0){
            Integer nowStatus = list.get(0).getProjectStatus();
            List<Integer> statusList = list.stream().map(ProjectArchiveRecordEntity::getProjectStatus).collect(Collectors.toList());
            if (nowStatus > Integer.valueOf(projectStatus)){
                bigFlag = true;
            }
            if (statusList.contains(Integer.valueOf(projectStatus))){
                existFlag = true;
            }
        }

        if (updateFlag) {
            //审批通过
            if (bigFlag){
                //有更高状态不更新项目信息
                if (existFlag){
                    //存在当前状态不生成子表记录

                }else {
                    //不存在当前状态，则生成子表记录，不更新项目信息状态
                    //新增一条子表记录信息
                    ProjectArchiveRecordEntity recordEntity = new ProjectArchiveRecordEntity();
                    recordEntity.setProjectArchiveId(projectArchiveEntity.getId());
                    recordEntity.setSourceId(billId);
                    recordEntity.setProjectStatus(Integer.valueOf(projectStatus));
                    recordService.saveOrUpdate(recordEntity);
                }
            }else {
                if (existFlag){
                    //存在当前状态不生成子表记录

                }else {
                    //不存在当前状态，则生成子表记录，更新项目信息状态
                    //新增一条子表记录信息
                    ProjectArchiveRecordEntity recordEntity = new ProjectArchiveRecordEntity();
                    recordEntity.setProjectArchiveId(projectArchiveEntity.getId());
                    recordEntity.setSourceId(billId);
                    recordEntity.setProjectStatus(Integer.valueOf(projectStatus));
                    recordService.saveOrUpdate(recordEntity);

                    //设置项目信息状态为传入状态
                    projectArchiveEntity.setProjectStatus(projectStatus);
                }
            }
        } else {
            //撤回
            if (bigFlag){
                //有更高状态不改项目状态
                //判断来源单据是否多份
                if (manyFlag){
                    //该阶段有多个单据，则不删除记录表信息

                }else {
                    //该阶段有一个单据，且撤回，则删除记录表信息
                    QueryWrapper<ProjectArchiveRecordEntity> recordDeleteWrapper = new QueryWrapper<>();
                    recordDeleteWrapper.eq("project_archive_id", projectArchiveEntity.getId());
                    recordDeleteWrapper.eq("project_status", Integer.valueOf(projectStatus));
                    recordService.remove(recordDeleteWrapper);
                }

            }else {
                //判断来源单据是否多份
                if (manyFlag){
                    //该阶段有多个单据，则不删除记录表信息

                }else {
                    //该阶段有一个单据，且撤回，则删除记录表信息
                    QueryWrapper<ProjectArchiveRecordEntity> recordDeleteWrapper = new QueryWrapper<>();
                    recordDeleteWrapper.eq("project_archive_id", projectArchiveEntity.getId());
                    recordDeleteWrapper.eq("project_status", Integer.valueOf(projectStatus));
                    recordService.remove(recordDeleteWrapper);

                    //设置项目信息状态为子表合集现在最大状态
                    projectArchiveEntity.setProjectStatus(list.size() > 1 ? list.get(1).getProjectStatus().toString() : ArchiveProjectStatusEnum.商机阶段.getCode());
                }
            }
        }
        projectArchiveService.saveOrUpdate(projectArchiveEntity);
        return CommonResponse.success("修改项目阶段成功！");
    }

    private OrgVO generateProjectDepartment(ProjectArchiveEntity projectArchiveEntity) {
        if(projectArchiveEntity.getOrgId() == null) {
            throw new BusinessException("提交项目信息失败，项目所属组织信息不存在。");
        }
        CommonResponse<OrgVO> response = orgApi.getOneById(projectArchiveEntity.getOrgId());
        OrgVO parentOrg = null;
        if(response.isSuccess()) {
            parentOrg = response.getData();
        } else {
            throw new BusinessException("提交项目信息失败，查询项目所属组织信息失败: " + response.getMsg() );
        }
        if(null == parentOrg) {
            throw new BusinessException("提交项目信息失败，项目所属组织信息不存在。");
        }
        OrgVO projectDepartment = new OrgVO();
        /** 先根据项目名称查询组织项目部 */
        OrgVO paramVo = new OrgVO();
        paramVo.setName(projectArchiveEntity.getName());
        paramVo.setOrgType(5);
        paramVo.setTenantId(InvocationInfoProxy.getTenantid());
        response = orgApi.findOneByOrgVO(paramVo);
        if(response.isSuccess()) {
            if(response.getData()!=null){
                projectDepartment = response.getData();
            }else {
                projectDepartment.setId(com.ejianc.support.idworker.util.IdWorker.getId());
                projectDepartment.setTenantId(parentOrg.getTenantId());
                projectDepartment.setName(projectArchiveEntity.getName());
                projectDepartment.setShortName(projectArchiveEntity.getShortName());
                projectDepartment.setState(1);
                //项目部类型
                projectDepartment.setOrgType(OrgVO.ORG_TYPE_DEPARTMENT);
            }
            projectDepartment.setIsParent(false);
            projectDepartment.setProjectCode(projectArchiveEntity.getCode());
            projectDepartment.setEnterpriseId(parentOrg.getEnterpriseId());
            projectDepartment.setParentId(projectArchiveEntity.getOrgId());
        } else {
            throw new BusinessException("提交项目信息失败，根据项目名称查询对应组织信息失败: " + response.getMsg() );
        }
        return projectDepartment;
    }



    @PostMapping(value = "updateProjectData")
    CommonResponse<String> updateProjectData(@RequestBody ProjectArchiveVO projectArchiveVO){
        logger.info("接收数据，pushProjectArchive----" + JSONObject.toJSONString(projectArchiveVO));
        //1、合同阶段回写客户信息
        ProjectArchiveEntity projectArchiveEntity = projectArchiveService.selectById(projectArchiveVO.getId());
        projectArchiveEntity.setCustomId(projectArchiveVO.getCustomId());
        projectArchiveEntity.setCustomName(projectArchiveVO.getCustomName());
        projectArchiveEntity.setCustomCode(projectArchiveVO.getCustomCode());
        projectArchiveEntity.setProjectStatus(projectArchiveVO.getProjectStatus());
        projectArchiveService.saveOrUpdate(projectArchiveEntity, false);
        return CommonResponse.success("修改成功！");
    }


    /**
     * 根据编码查询匹配项目
     * @param code
     * @return
     */
    @GetMapping(value = "getProjectArchiveByCode")
    CommonResponse<ProjectArchiveVO> getProjectArchiveByCode(@RequestParam String code){
        logger.info("接收参数-code-{}", code);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("code", new Parameter(QueryParam.EQ, code));
        List<ProjectArchiveEntity> projectArchiveEntityList = projectArchiveService.queryList(queryParam);
        if (CollectionUtils.isNotEmpty(projectArchiveEntityList) && projectArchiveEntityList.size() > 0){
            return CommonResponse.success("查询项目信息成功！", BeanMapper.map(projectArchiveEntityList.get(0), ProjectArchiveVO.class));
        }else {
            return CommonResponse.error("未查询到项目信息，请检查编码！");
        }
    }

    /**
     * 根据id查询匹配项目
     * @param id
     * @return
     */
    @GetMapping(value = "getProjectArchiveById")
    CommonResponse<ProjectArchiveVO> getProjectArchiveById(@RequestParam Long id){
        logger.info("接收参数-id-{}", id);
        ProjectArchiveEntity projectArchiveEntity = projectArchiveService.selectById(id);
        if (null != projectArchiveEntity && null != projectArchiveEntity.getId()){
            return CommonResponse.success("查询项目信息成功！", BeanMapper.map(projectArchiveEntity, ProjectArchiveVO.class));
        }else {
            return CommonResponse.error("未查询到项目信息，请检查传入参数！");
        }
    }

    /**
     * 根据来源Id查询匹配项目
     * @param sourceId
     * @return
     */
    @GetMapping(value = "getProjectArchiveBySourceId")
    CommonResponse<ProjectArchiveVO> getProjectArchiveBySourceId(@RequestParam Long sourceId){
        logger.info("接收参数-sourceId-{}", sourceId);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("sourceBillId", new Parameter(QueryParam.EQ, sourceId));
        List<ProjectArchiveEntity> projectArchiveEntityList = projectArchiveService.queryList(queryParam);
        if (CollectionUtils.isNotEmpty(projectArchiveEntityList) && projectArchiveEntityList.size() > 0){
            return CommonResponse.success("查询项目信息成功！", BeanMapper.map(projectArchiveEntityList.get(0), ProjectArchiveVO.class));
        }else {
            return CommonResponse.error("未查询到项目信息，请检查传入参数！");
        }
    }

    /**
     * 根据来源Id查询匹配项目
     * @return
     */
    @PostMapping(value = "getProjectArchiveByIds")
    CommonResponse<List<ProjectArchiveVO>> getProjectArchiveByIds(@RequestBody List<Long> ids){
        logger.info("接收参数-ids-{}", JSONObject.toJSONString(ids));
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("id", new Parameter(QueryParam.IN, ids));
        List<ProjectArchiveEntity> projectArchiveEntityList = projectArchiveService.queryList(queryParam);
        if (CollectionUtils.isNotEmpty(projectArchiveEntityList) && projectArchiveEntityList.size() > 0){
            return CommonResponse.success("查询项目信息成功！", BeanMapper.mapList(projectArchiveEntityList, ProjectArchiveVO.class));
        }else {
            return CommonResponse.error("未查询到项目信息，请检查传入参数！");
        }
    }


    /**
     * 根据来源Id查询匹配项目
     * @return
     */
    @PostMapping(value = "getProjectArchiveByOrgIds")
    CommonResponse<List<ProjectArchiveVO>> getProjectArchiveByOrgIds(@RequestBody QueryParam param){
        logger.info("接收参数-param-{}", JSONObject.toJSONString(param));
        List<ProjectArchiveEntity> projectArchiveEntityList = projectArchiveService.queryList(param);
        if (CollectionUtils.isNotEmpty(projectArchiveEntityList) && projectArchiveEntityList.size() > 0){
            return CommonResponse.success("查询项目信息成功！", BeanMapper.mapList(projectArchiveEntityList, ProjectArchiveVO.class));
        }else {
            return CommonResponse.error("未查询到项目信息，请检查传入参数！");
        }
    }

    /**
     * 根据查询语句查询项目信息
     * @return
     */
    @PostMapping("queryProjectArchivePage")
    @ResponseBody
    public CommonResponse<Page<ProjectArchiveVO>> queryProjectArchivePage(@RequestBody QueryParam param) {
        logger.info("接收参数-param-{}", JSONObject.toJSONString(param));
        List<Long> orgIds = orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList());

        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        if (param.getParams().containsKey("orgId")){
            param.getParams().put("orgId", new Parameter(QueryParam.IN, orgIds));
        }else {
            param.getParams().put("projectDepartmentId",new Parameter(QueryParam.IN, orgIds));
        }
        IPage<ProjectArchiveEntity> page = projectArchiveService.queryPage(param, false);
        Page<ProjectArchiveVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<ProjectArchiveVO> projectArchiveVOList = BeanMapper.mapList(page.getRecords(), ProjectArchiveVO.class);
        if (param.getParams().containsKey("orgId") && CollectionUtils.isNotEmpty(projectArchiveVOList)){
            List<ProjectArchiveRecordEntity> recordEntityList = recordService.list(new QueryWrapper<ProjectArchiveRecordEntity>().in("project_archive_id", projectArchiveVOList.stream().map(ProjectArchiveVO::getId).collect(Collectors.toList())));
            if (CollectionUtils.isNotEmpty(recordEntityList)){
                Map<Long, List<ProjectArchiveRecordEntity>> recordMap = recordEntityList.stream().filter(e -> null != e.getProjectStatus()).collect(Collectors.groupingBy(ProjectArchiveRecordEntity::getProjectArchiveId));
                for (ProjectArchiveVO projectArchiveVO : projectArchiveVOList) {
                    projectArchiveVO.setProjectStatusList(recordMap.get(projectArchiveVO.getId()).stream().filter(e -> e.getProjectStatus() <= Integer.valueOf(projectArchiveVO.getProjectStatus())).map(ProjectArchiveRecordEntity::getProjectStatus).sorted(Comparator.comparingInt(Integer::valueOf)).collect(Collectors.toList()));
                }
            }
        }
        pageData.setRecords(projectArchiveVOList);
        return CommonResponse.success("查询成功！", pageData);
    }


    /**
     * 获取客户画像分页
     * @return
     */
    @PostMapping("queryProjectCustomerPage")
    @ResponseBody
    public CommonResponse<Page<CustomerProjectReportVO>> queryProjectCustomerPage(@RequestBody QueryParam param) {
        logger.info("接收参数-param-{}", JSONObject.toJSONString(param));
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        Page<CustomerProjectReportVO> page = new Page<>((long) param.getPageIndex(), (long) param.getPageSize());
        QueryWrapper wrapper = changeToQueryWrapper(param);
//        List<CustomerProjectReportVO> list = customerMapper.queryCustomerReport(page,wrapper);
        Page<CustomerProjectReportVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
//        pageData.setRecords(list);
        return CommonResponse.success("查询成功！", pageData);
    }

    /**
     * @param customerId
     * @return
     */
    @GetMapping(value = "queryProjectTypeReport")
    CommonResponse<List<ProjectTypeReportVO>> queryProjectTypeReport(@RequestParam Long customerId){
        logger.info("接收参数-customerId-{}", customerId);
//        List<ProjectTypeReportVO> resList = customerMapper.queryProjectTypeReport(customerId);
        return CommonResponse.success("查询成功！", null);
    }

}
