package com.ejianc.foundation.share.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.share.bean.Customer1Entity;
import com.ejianc.foundation.share.vo.CustomerProjectReportVO;
import com.ejianc.foundation.share.vo.ProjectTypeReportVO;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

@Mapper
public interface Customer1Mapper extends BaseCrudMapper<Customer1Entity> {

	List<Customer1Entity> queryList(Map<String, Object> condition);

	Long queryCount(Map<String, Object> condition);

	List<Customer1Entity> queryExportList(Map<String, Object> condition);

	List<CustomerProjectReportVO> queryCustomerReport(Page pages, @Param(Constants.WRAPPER) QueryWrapper queryWrapper);

    List<ProjectTypeReportVO> queryProjectTypeReport(@Param("customerId") Long customerId);
}
