package com.ejianc.foundation.share.service;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.share.bean.SupplierEntity;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;
import java.util.Map;

public interface ISupplierService extends IBaseService<SupplierEntity> {


	/**
	 * 根据分类Id查询供方列表
	 * 
	 * @param id
	 * @return
	 */
	List<SupplierVO> queryListByCategoryId(Long categoryId);
	
	/**
	 * 保存或修改供方信息
	 * 
	 * @param SupplierVo
	 * @return
	 */
	CommonResponse<SupplierVO> saveOrUpdate(SupplierVO SupplierVo);
	CommonResponse<SupplierVO> saveOrUpdateReturn(SupplierVO SupplierVo);


	/**
	 * 根据主键ID查询供方详情
	 * 
	 * @param id
	 * @return
	 */
	SupplierVO queryDetail(Long id);

	/**
	 * 删除供方信息
	 * 
	 * @param ids
	 */
	void deleteSupplier(List<Long> ids);

	/**
	 * 处理供方合租不合作状态
	 *
	 * @param data
	 */
	void enableSupplierOrNot(Map<String, Object> data);

	/**
	 * 查询供方列表（翻页）
	 * 
	 * @param queryParam
	 * @return
	 */
	IPage<SupplierVO> queryPageList(QueryParam queryParam);

	/**
	 * 查询供方列表
	 * 
	 * @param queryParam
	 * @return
	 */
	List<SupplierVO> queryExportList(QueryParam queryParam);

	/**
	 * 根据统一社会信用代码查询供方信息
	 * 
	 * @param socialCode
	 * @return
	 */
	SupplierVO queryDetailBySocialCode(String socialCode);

	/**
	 * 查询供方参照
	 * 
	 * @param params
	 * @return
	 */
	IPage<SupplierVO> queryRefMaterialPage(Map<String, Object> params);


	/**
	 * 查询供方参照
	 *
	 * @param params 参数
	 *
	 * @return {@link List}<{@link SupplierVO}>
	 */
	List<SupplierVO> querySupplierList(Map<String, Object> params);

	/**
	 * 
	 * 供方协同(生成租户)
	 * */
	CommonResponse<String> supplierCollaboration(SupplierVO supplierVO);

	/**
	 * 获取供应商信息
	 * 
	 * @param tenant
	 * @return
	 */
	SupplierVO querySupplierByTenantId(Long tenant);
	/**
	 *  根据供应商名称或者纳税人识别号查询供应商
	 * @param supplierName
	 * @param socialCreditCode
	 * @return
	 */
	JSONObject querySupplierByNameOrSocialCreditCode(String supplierName, String socialCreditCode);
}
