/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.foundation.share.bean.CustomerCategoryEntity;
import com.ejianc.foundation.share.service.ICustomer1Service;
import com.ejianc.foundation.share.service.ICustomerCategoryService;
import com.ejianc.foundation.share.vo.CustomerCategoryVO;
import com.ejianc.foundation.share.vo.CustomerVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/customer/category/"})
public class CustomerCategoryController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String CUSTOMER_CATEGORY_BILL_CODE = "SUPPORT_CUSTOMER_CATEGORY";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private ICustomerCategoryService customerCategoryService;
    @Autowired
    private ICustomer1Service customerService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveOrUpdate(@RequestBody CustomerCategoryVO customerCategoryVo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (customerCategoryVo.getId() != null && customerCategoryVo.getId() > 0L) {
            CustomerCategoryEntity uniqueBean = this.customerCategoryService.queryDetail(customerCategoryVo.getId());
            uniqueBean.setCode(customerCategoryVo.getCode());
            uniqueBean.setName(customerCategoryVo.getName());
            uniqueBean.setSequence(customerCategoryVo.getSequence());
            uniqueBean.setDescription(customerCategoryVo.getDescription());
            this.customerCategoryService.saveOrUpdate((Object)uniqueBean, false);
            return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f");
        }
        if (StringUtils.isEmpty((CharSequence)customerCategoryVo.getCode())) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)CUSTOMER_CATEGORY_BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)customerCategoryVo);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                customerCategoryVo.setCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        CustomerCategoryEntity customerCategoryEntity = (CustomerCategoryEntity)((Object)BeanMapper.map((Object)customerCategoryVo, CustomerCategoryEntity.class));
        customerCategoryEntity.setId(IdWorker.getId());
        if (customerCategoryEntity.getParentId() != null && customerCategoryEntity.getParentId() > 0L) {
            CustomerCategoryEntity uniqueBean = this.customerCategoryService.queryDetail(customerCategoryEntity.getParentId());
            customerCategoryEntity.setInnerCode(uniqueBean.getInnerCode() + "|" + customerCategoryEntity.getId());
        } else {
            customerCategoryEntity.setInnerCode(customerCategoryEntity.getId().toString());
        }
        this.customerCategoryService.saveOrUpdate((Object)customerCategoryEntity, false);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CustomerCategoryVO> queryDetail(@RequestParam Long id) {
        CustomerCategoryEntity entity = this.customerCategoryService.queryDetail(id);
        if (entity != null) {
            return CommonResponse.success((Object)BeanMapper.map((Object)((Object)entity), CustomerCategoryVO.class));
        }
        return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u53c2\u6570\u9519\u8bef\uff01");
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> delete(@RequestParam Long id) {
        List<CustomerCategoryVO> children = this.customerCategoryService.queryListByPid(id);
        if (children != null && children.size() > 0) {
            return CommonResponse.error((String)"\u8be5\u5206\u7c7b\u6709\u5b50\u8282\u70b9\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        List<CustomerVO> customerList = this.customerService.queryListByCategoryId(id);
        if (customerList != null && customerList.size() > 0) {
            return CommonResponse.error((String)"\u8be5\u5206\u7c7b\u4e0b\u5df2\u6709\u5ba2\u6237\u4fe1\u606f\uff0c\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        this.customerCategoryService.delete(id);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam queryParam) {
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getOrderMap().put("sequence", "asc");
        List dataList = this.customerCategoryService.queryList(queryParam, false);
        List resultMapList = BeanMapper.mapList((Iterable)dataList, Map.class);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", (Object)ResultAsTree.createTreeData((List)resultMapList));
        return CommonResponse.success((Object)jsonObject);
    }

    @RequestMapping(value={"/queryRefTree"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Map<String, Object>> queryRefTree(@RequestParam(value="searchText", required=false) String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotBlank((CharSequence)searchText)) {
            queryParam.getParams().put("name", new Parameter("like", (Object)searchText));
        }
        queryParam.getOrderMap().put("sequence", "asc");
        List dataList = this.customerCategoryService.queryList(queryParam, false);
        if (ListUtil.isEmpty((List)dataList)) {
            return new ArrayList<Map<String, Object>>();
        }
        List resultMapList = BeanMapper.mapList((Iterable)dataList, Map.class);
        return ResultAsTree.createTreeData((List)resultMapList);
    }
}

