package com.ejianc.foundation.share.controller;

import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.share.bean.CustomerCategoryEntity;
import com.ejianc.foundation.share.bean.CustomerEntity;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.service.IBankAccountService;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.share.service.ICustomerCategoryService;
import com.ejianc.foundation.share.service.ICustomerLinkerService;
import com.ejianc.foundation.share.service.ICustomerService;
import com.ejianc.foundation.share.vo.CustomerCategoryVO;
import com.ejianc.foundation.share.vo.CustomerLinkerVO;
import com.ejianc.foundation.share.vo.CustomerVO;
import com.ejianc.foundation.util.ExcelReader;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;

/**
 * 客户controller
 * 
 * @author guoming
 */
@Controller
@RequestMapping("/customer/")
public class CustomerController implements Serializable {

	private static final long serialVersionUID = 1L;
	
	private static final String CUSTOMER_BILL_CODE = "SUPPORT_CUSTOMER";
	@Autowired
	private IBillTypeApi billTypeApi;
	@Autowired
	private ICustomerService customerService;
	@Autowired
	private ICustomerCategoryService customerCategoryService;
	@Autowired
	private IDefdocApi defdocApi;
	@Autowired
	private ICustomerLinkerService customerLinkerService;
	@Autowired
	private IBillCodeApi billCodeApi;
	@Autowired
	private IBankAccountService bankAccountService;
	
	/**
	 * 新增或者修改
	 *
	 * @return
	 */
	@RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<CustomerVO> saveOrUpdate(@RequestBody CustomerVO customerVo) {
		CommonResponse<CustomerVO> response = customerService.saveOrUpdate(customerVo);
		return response;
	}
	
	/**
	 * 根据主键ID查询客户详情
	 * 
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<CustomerVO> queryDetail(@RequestParam Long id) {
		CustomerVO customerVo = customerService.queryDetail(id);
		JSONObject parent = new JSONObject();
		CustomerCategoryEntity e = customerCategoryService.selectById(customerVo.getCategoryId());
		parent.put("id",e.getId());
		parent.put("code",e.getCode());
		parent.put("name",e.getName());
		customerVo.setParent(parent);
		return CommonResponse.success(customerVo);
	}
	
	/**
	 * 删除
	 * 
	 * @param ids
	 * @return
	 */
	@RequestMapping(value = "/delete", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> delete(@RequestBody List<Long> ids) {
		if(ListUtil.isNotEmpty(ids)){
			bankAccountService.delBySuppAndCustomIds("supplierId",ids);
			for (Long id : ids) {
				CommonResponse<String>  response = billTypeApi.checkQuote("BT200422000000027",id);
				if(!response.isSuccess()){
					return CommonResponse.error("删除失败："+response.getMsg());
				}
			}
		}else {
			return CommonResponse.error("删除失败：主键为空!");
		}
		customerService.deleteCustomer(ids);
		return CommonResponse.success("删除成功");
	}
	
	/**
	 * 查询客户分页列表
	 * 
	 * @param queryParam
	 * @return
	 */
	@RequestMapping(value = "/pageList", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<JSONObject> pageList(@RequestBody QueryParam queryParam) {
		IPage<CustomerVO> pageData = customerService.queryPageList(queryParam);
		
		JSONObject jsonObject = new JSONObject();
		jsonObject.put("data", pageData);
		return CommonResponse.success(jsonObject);
	}
	
	/**
	 * 导入模板 下载
	 * 
	 * @param request
	 * @param response
	 */
	@RequestMapping(value = "/download")
	@ResponseBody
	public void download(HttpServletRequest request, HttpServletResponse response){
		ImportTemplate.initialize(response);
		ImportTemplate.templetdownload(request, "customer-import.xlsx", "客户导入模板");
	}
	
	/**
	 * excel导入
	 * 
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "/excelImport", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<Object> excelImport(HttpServletRequest request, HttpServletResponse response) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
		Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
		boolean isFailed = false;
		MultipartFile mf = null;
		for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
			mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
        	extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
            	isFailed = true;
            	break;
            }
        }
		
		if(isFailed) {
			return CommonResponse.error("文件格式不合法");
		}else{
			List<List<String>> result = ExcelReader.readExcel(mf);
			List<String> errorList = new ArrayList<String>();
			CommonResponse<List<DefdocDetailVO>> commonResponse = defdocApi.getDefDocByDefCode("customer_type");
			CommonResponse<List<DefdocDetailVO>> defDocByDefCode = defdocApi.getDefDocByDefCode("tax_payer_type");
			if(result != null && result.size() > 0) {
				for(int i=0;i<result.size();i++) {
					List<String> datas = result.get(i);
					CustomerVO customerVo = new CustomerVO();
					CustomerCategoryVO customerCategoryVo = customerCategoryService.queryByName(String.valueOf(datas.get(0)));
					if(customerCategoryVo != null) {
						if(StringUtils.isEmpty(datas.get(2))) {
//							errorList.add("第"+i+"行数据：" + datas.toString()+"导入失败，原因：统一社会信用代码不能为空！");
//							continue;
						}else{
							if (StringUtils.isNotEmpty(datas.get(2))){
								CustomerVO	vo = customerService.queryDetailBySocialCode(String.valueOf(datas.get(2)));
								if(vo != null) {
									errorList.add("第"+i+"行数据：" + datas.toString()+"导入失败，原因：存在相同统一社会信用代码的客户！");
									continue;
								}
							}
						}
						CommonResponse<String> codeBatchByRuleCode = billCodeApi.getCodeBatchByRuleCode(CUSTOMER_BILL_CODE, tenantId);
						if(codeBatchByRuleCode.isSuccess()){
							customerVo.setCode(codeBatchByRuleCode.getData());
						} else {
							customerVo.setCode(String.valueOf(new Date().getTime()));
						}

						if(StringUtils.isEmpty(datas.get(1))) {
							errorList.add("第"+i+"行数据：" + datas.toString()+"导入失败，原因：客户名称不能为空！");
							continue;
						}
						customerVo.setName(String.valueOf(datas.get(1)));
						customerVo.setCategoryId(customerCategoryVo.getId());
						customerVo.setSocialCreditCode(String.valueOf(datas.get(2)));
						customerVo.setLegal(datas.get(3));
						if(StringUtils.isNotEmpty(datas.get(4))) {

							if(defDocByDefCode.isSuccess() && defDocByDefCode.getData() != null) {
								Map<String, List<DefdocDetailVO>> map = defDocByDefCode.getData().stream().collect(Collectors.groupingBy(DefdocDetailVO::getName));
								DefdocDetailVO defdocDetailVO = map.get(datas.get(4).toString()).get(0);
								customerVo.setTaxPayerType(defdocDetailVO.getId());
								customerVo.setTaxPayerTypeName(datas.get(4).toString());
							}
						}
						if(StringUtils.isNotEmpty(datas.get(5))) {
							String name=String.valueOf(datas.get(5));
							if(commonResponse.isSuccess() && commonResponse.getData() != null) {
								List<DefdocDetailVO> data = commonResponse.getData();
								Map<String, List<DefdocDetailVO>> collect = data.stream().collect(Collectors.groupingBy(DefdocDetailVO::getName));
								DefdocDetailVO defdocDetailVO = collect.get(datas.get(5).toString()).get(0);
								customerVo.setCustomerType(defdocDetailVO.getId());
							}
						}
						customerVo.setTelephone(datas.get(6));
						customerVo.setArea(datas.get(7));
						customerVo.setAddress(datas.get(8));
						customerVo.setBankName(datas.get(9));
						customerVo.setBankAccount(datas.get(10));
						customerVo.setBankCode(datas.get(11));
						//客户方联系人
						if(StringUtils.isNotEmpty(datas.get(12))) {
							List<CustomerLinkerVO> gridheaders = new ArrayList<CustomerLinkerVO>();
							
							String linkman = String.valueOf(datas.get(12));
							CustomerLinkerVO customerLinkerVo = customerLinkerService.queryByCustomerIdAndLinkman(customerVo.getId(), linkman);
							if(customerLinkerVo == null) {
								customerLinkerVo = new CustomerLinkerVO();
								customerLinkerVo.setRowState("add");
							}else{
								customerLinkerVo.setRowState("edit");
							}
							customerLinkerVo.setCustomerId(customerVo.getId());
							customerLinkerVo.setLinkman(datas.get(12));
							customerLinkerVo.setCellphone(datas.get(13));
							gridheaders.add(customerLinkerVo);
							customerVo.setGridheaders(gridheaders);
						}
						CustomerEntity entity = BeanMapper.map(customerVo, CustomerEntity.class);
						customerService.save(entity);
					}else{
						errorList.add("第"+i+"行数据：" + datas.toString()+"导入失败，原因：客户分类编号不正确！");
						continue;
					}
				}
			}
			if(errorList.size() > 0) {
				
				errorList.add("导入成功："+(result.size() - errorList.size() - 1)+"条, 失败：" +errorList.size()+"条");
				return CommonResponse.error("导入失败", errorList);
			}else{
				return CommonResponse.success("导入成功");
			}
		}
	}
	
	/**
	 * excel导出
	 *
	 * @return
	 */
	@RequestMapping(value = "/excelExport", method = RequestMethod.POST)
	@ResponseBody
	public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
		List<CustomerVO> customerVos = new ArrayList<>();
//		if(queryParam.getParams().get("categoryId")!=null){
//			if(StringUtils.isNotBlank(queryParam.getParams().get("categoryId").getValue().toString())){
				queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
				customerVos = customerService.queryExportList(queryParam);
//			}
//		}
		Map<String, Object> beans = new HashMap<String, Object>();
		beans.put("records", customerVos);
		ExcelExport.getInstance().export("customer-export.xlsx", beans, response);
	}


	/**
	 * @Author mrsir_wxp
	 * @Date 2020/5/22  客户参照
	 * @Description refer
	 * @Param [pageNumber, pageSize, searchText]
	 * @Return com.alibaba.fastjson.JSONObject
	 */
	@RequestMapping(value = "/refer", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<IPage<CustomerVO>> refer(	@RequestParam(defaultValue = "1") Integer pageNumber,
													@RequestParam(defaultValue = "10") Integer pageSize,
												   	@RequestParam(required=false) String relyCondition,
												   	@RequestParam(required=false) String searchText,
												   	@RequestParam(required=false) String condition) {
		QueryParam queryParam = new QueryParam();
		if(StringUtils.isNotBlank(relyCondition)) {
			Long categoryId = Long.parseLong(relyCondition.split("=")[1]);
			queryParam.getParams().put("categoryId",new Parameter(QueryParam.EQ,categoryId));
		}
		queryParam.setPageIndex(pageNumber);
		queryParam.setPageSize(pageSize);
		queryParam.setSearchText(searchText);

		queryParam.getFuzzyFields().add("code");
		queryParam.getFuzzyFields().add("name");
		queryParam.getFuzzyFields().add("socialCreditCode");
		queryParam.getParams().put("range",new Parameter(QueryParam.EQ,"outside"));//外部客户
		IPage<CustomerVO> pageData = customerService.queryPageList(queryParam);
		return CommonResponse.success("查询数表参照成功", pageData);
	}

	/**
	 * @Author mrsir_wxp
	 * @Date 2020/5/22  客户参照
	 * @Description refer
	 * @Param [pageNumber, pageSize, searchText]
	 * @Return com.alibaba.fastjson.JSONObject
	 */
	@RequestMapping(value = "/referInsideCustomer", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<IPage<CustomerVO>> referInsideCustomer(	@RequestParam(defaultValue = "1") Integer pageNumber,
													@RequestParam(defaultValue = "10") Integer pageSize,
												   	@RequestParam(required=false) String relyCondition,
												   	@RequestParam(required=false) String searchText,
												   	@RequestParam(required=false) String condition) {
		QueryParam queryParam = new QueryParam();
		if(StringUtils.isNotBlank(relyCondition)) {
			Long categoryId = Long.parseLong(relyCondition.split("=")[1]);
			queryParam.getParams().put("categoryId",new Parameter(QueryParam.EQ,categoryId));
		}
		queryParam.setPageIndex(pageNumber);
		queryParam.setPageSize(pageSize);
		queryParam.setSearchText(searchText);

		queryParam.getFuzzyFields().add("code");
		queryParam.getFuzzyFields().add("name");
		queryParam.getFuzzyFields().add("socialCreditCode");
		queryParam.getParams().put("range",new Parameter(QueryParam.EQ,"inside"));//内部客户
		IPage<CustomerVO> pageData = customerService.queryPageList(queryParam);
		return CommonResponse.success("查询数表参照成功", pageData);
	}

}
