package com.ejianc.foundation.share.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.bean.PriceDepotPowerSetEntity;
import com.ejianc.foundation.share.service.IPriceDepotPowerSetService;
import com.ejianc.foundation.share.vo.PriceDepotPowerSetVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 价格库权限设置
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("/api/priceDepotPowerSet/")
public class PriceDepotPowerSetApi implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IPriceDepotPowerSetService service;

    @GetMapping("queryOrgList")
    @ResponseBody
    public CommonResponse<List<Long>> queryOrgList(Long orgId){
        logger.info("接受到的参数,orgId:"+orgId);
        // 根据innercode 获取的所有上级 (未过滤)
        List<Long> topOrg = new ArrayList<>();
        CommonResponse<OrgVO> oneById = iOrgApi.getOneById(orgId);
        if(!oneById.isSuccess() || oneById.getData() == null) {
            return CommonResponse.error("查询组织信息失败！");
        }
        OrgVO data = oneById.getData();
        String innerCode = data.getInnerCode();
        String[] split = innerCode.split("\\|");
        for (String s : split) {
            Long org = Long.valueOf(s);
            topOrg.add(org);
        }
        logger.info("topOrg:"+topOrg);
        // 查询上级符合条件的（未设置保密）
        QueryWrapper<PriceDepotPowerSetEntity> wrapper = new QueryWrapper<>();
        wrapper.in("org_id",topOrg);
        List<PriceDepotPowerSetEntity> entitys = service.list(wrapper);
        Map<Long, PriceDepotPowerSetEntity> entityMap = new HashMap<>();
        //Map<Long, PriceDepotPowerSetEntity> entityMap = entitys.stream().collect(Collectors.toMap(PriceDepotPowerSetEntity::getOrgId, PriceDepotPowerSetEntity->PriceDepotPowerSetEntity));
        entitys.forEach(item->{
            entityMap.put(item.getOrgId(),item);
        });
        int index = 1;
        // 20221009修改：本级组织设置保密，也需要进行过滤
//        if(topOrg.size() > 1){
//            index = 2;
//        }
        // 倒叙topOrg 从最下级(本级的上级单位)开始找 找到设置保密的上级组织
        // 如果innerCode长度大于1 直接从上级开始找
        Long powerTopOrg = null;
        for (int i = topOrg.size()-index; i >= 0; i--) {
            powerTopOrg = topOrg.get(i);
            PriceDepotPowerSetEntity tEntity = entityMap.get(topOrg.get(i));
            if(null != tEntity && tEntity.getEnabled() == 1){
                powerTopOrg = topOrg.get(i);
                break;
            }
        }
        logger.info("最上级的orgId:"+powerTopOrg);
        // 依据最高等级组织获取本下
        List<Long> downOrgids = iOrgApi.findChildrenByParentId(powerTopOrg).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        if(downOrgids.size() > 1) {
            downOrgids.remove(powerTopOrg);
        }
        // 循环本下，获取需要剔除掉的org 并且剔除这些org的本下
        List<Long> excludeOrg = new ArrayList<>();
        Set<Long> excludeSet = new HashSet<>();
        wrapper = new QueryWrapper<>();
        wrapper.in("org_id",downOrgids);
        List<PriceDepotPowerSetEntity> downEntitys = service.list(wrapper);
        downEntitys.forEach(item->{
            if(item.getEnabled() == 1){
                excludeOrg.add(item.getOrgId());
            }
        });
        logger.info("需要排除的org(上级):"+excludeOrg);
        excludeOrg.forEach(item->{
            List<Long> collect = iOrgApi.findChildrenByParentId(item).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
            excludeSet.addAll(collect);
        });
        logger.info("排除之前的org数量:"+downOrgids.size()+","+downOrgids);
        logger.info("排除的org数量:"+excludeSet.size()+","+excludeSet);
        downOrgids.removeAll(excludeSet);
        Set<Long> resultSet = new HashSet<>(downOrgids);
        resultSet.add(powerTopOrg);
        // 排除之后加上本下
        List<Long> collect = iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        resultSet.addAll(collect);
        logger.info("最终返回的org集合："+resultSet);
        return CommonResponse.success(new ArrayList<>(resultSet));
    }
}
