package com.ejianc.foundation.share.service;

import java.util.List;
import java.util.Map;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.share.bean.MaterialEntity;
import com.ejianc.foundation.share.controller.param.YnsbjMaterialAndEquipCategoryParam;
import com.ejianc.foundation.share.controller.param.YnsbjMaterialAndEquipParam;
import com.ejianc.foundation.share.controller.resp.YnsbjDataInfo;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;

public interface IMaterialService {

	/**
	 * 根据分类ID查询其下物料
	 *
	 * @param categoryId
	 * @return
	 */
	List<MaterialVO> queryListByCategoryId(Long categoryId);


	/**
	 * 根据分类ID更改其下物料成本科目
	 *
	 * @param categoryId
	 * @return
	 */
	CommonResponse updateByCategoryId(Long categoryId, Long subjectId, String subjectName);

	CommonResponse updateCategoryCodeByCategoryId(Long categoryId, String categoryCode);
    CommonResponse updateCategoryCodeByCategoryId(Long categoryId, String categoryCode, Long financialId, String financialName);

    /**
	 * 查询详情
	 *
	 * @param id
	 * @return
	 */
	MaterialVO queryDetail(Long id);


	/**
	 * 查询详情list
	 *
	 * @param ids
	 * @return
	 */
	List<MaterialVO> queryItem(List<Long> ids);


	/**
	 * 修改
	 *
	 * @param uniqueBean
	 */
	void update(MaterialVO uniqueBean);

	/**
	 * 绑定科目
	 * @param subjectId
	 * @param subjectName
	 * @param ids
	 */
	void updateSubject(Long subjectId, String subjectName, List<Long> ids);

	/**
	 * 绑定财务科目
	 * @param financialId
	 * @param financialName
	 * @param ids
	 */
	void updateFinancial(Long financialId, String financialName, List<Long> ids);

	/**
	 * 批量修改
	 *
	 * @param
	 */
	void amend(Long id, Long property, String propertyName);

	/**
	 * 保存
	 *
	 * @param materialVo
	 */
	void save(MaterialVO materialVo);

	/**
	 * 批量保存
	 *
	 * @param materialVo
	 */
	void insertBatch(List<MaterialVO> materialVo);

	/**
	 * 删除
	 *
	 * @param ids
	 */
	void delete(List<Long> ids);

	/**
	 * 查询翻页
	 *
	 * @param queryParam
	 * @return
	 */
	IPage<MaterialEntity> queryPage(QueryParam queryParam);

	/**
	 * 查询是否已经存在
	 *
	 * @param name
	 * @param spec
	 * @param unitName
	 * @return
	 */
	MaterialVO queryExitFlag(String name, String spec, String unitName, Long categoryId);

	/**
	 * 根据code查询物料
	 *
	 * @param code
	 * @return
	 */
	MaterialVO queryByCode(String code);

	/**
	 * 查询列表
	 *
	 * @param queryParam
	 * @return
	 */
	List<MaterialEntity> queryList(QueryParam queryParam);

	/**
	 * 从平台中拷贝
	 */
	void insertMaterialListFromPlatform();

	/**
	 * 查询材料参照
	 *
	 * @param params
	 * @return
	 */
	IPage<MaterialVO> queryRefMaterialPage(Map<String, Object> params);

	/**
	 * 根据sourceId查询物资详情
	 *
	 * @param sourceId
	 * @return
	 */
	MaterialEntity queryBySourceId(String sourceId);

	/**
	 * 根据ids查询物资列表（包括物资来源id，物资分类来源id）
	 *
	 * @param ids
	 * @return
	 */
	List<MaterialEntity> queryMaterialByIds(List<Long> ids);

    IPage<MaterialEntity> queryZjwjRefMaterialPage(Map<String, Object> params);

	/**
	 * 根据物料名称，规格型号，单位，分类名称查询是否存在
	 * @param name
	 * @param spec
	 * @param unitName
	 * @param categoryName
	 * @return
	 */
	List<MaterialVO> queryExcelFlag(String name, String spec, String unitName, String categoryName);

	/**
	 * 保存或修改物料和设备分类
	 *
	 * @param categoryParam
	 * @return
	 */
	YnsbjDataInfo saveOrUpdateYnsbjMaterialAndEquipCategory(YnsbjMaterialAndEquipCategoryParam categoryParam);

	/**
	 * 保存或修改物料和设备
	 *
	 * @param ynsbjMaterialAndEquipParam
	 * @return
	 */
	YnsbjDataInfo saveOrUpdateYnsbjMaterialAndEquip(YnsbjMaterialAndEquipParam ynsbjMaterialAndEquipParam);

    List<MaterialVO> queryMaterialListByCodes(List<String> codeList);

	/**
	 *  批量更新物料档案的财务科目信息
	 * @param financialId
	 * @param financialName
	 * @param categoryIds
	 */
	void updateFinancialByCategoryIds(Long financialId, String financialName, List<Long> categoryIds);
}
