/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.consumer;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.share.bean.MaterialCategoryEntity;
import com.ejianc.foundation.share.bean.SupplierEntity;
import com.ejianc.foundation.share.bean.UnitEntity;
import com.ejianc.foundation.share.service.IMaterialCategoryService;
import com.ejianc.foundation.share.service.IMaterialService;
import com.ejianc.foundation.share.service.ISupplierService;
import com.ejianc.foundation.share.service.IUnitService;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.support.bean.BankEntity;
import com.ejianc.foundation.support.service.IBankService;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jms.annotation.JmsListener;
import org.springframework.stereotype.Component;

@Component
public class ZhHtCommonListener {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IMaterialService materialService;
    @Autowired
    private IMaterialCategoryService categoryService;
    @Autowired
    private IUnitService unitService;
    @Autowired
    private ISupplierService supplierService;
    @Autowired
    private IBankService bankService;

    @JmsListener(destination="cnecht.zh.itemcode")
    public void receive_cnecht_zh_itemcode(String message) throws IOException {
        List<MaterialCategoryEntity> list;
        List<MaterialVO> list2;
        String msg = URLDecoder.decode(message, "utf-8");
        msg = msg.substring(12);
        this.logger.info("cnecht.zh.itemcode message: " + msg);
        JSONObject json = JSONObject.parseObject((String)msg);
        JSONArray array = json.getJSONArray("data");
        List<String> codes = array.stream().map(x -> ((JSONObject)x).getString("CODE")).collect(Collectors.toList());
        Map<Object, Object> map = new HashMap();
        if (CollectionUtils.isNotEmpty(codes) && CollectionUtils.isNotEmpty(list2 = this.materialService.queryMaterialListByCodes(codes, 999999L))) {
            map = list2.stream().collect(Collectors.toMap(x -> x.getCode(), x -> x));
        }
        List<String> categoryCodes = array.stream().map(x -> ((JSONObject)x).getString("CATEGORYCODE")).collect(Collectors.toList());
        Map<Object, Object> categoryMap = new HashMap();
        if (CollectionUtils.isNotEmpty(codes) && CollectionUtils.isNotEmpty(list = this.categoryService.queryCategoryListByCodes(categoryCodes, 999999L))) {
            categoryMap = list.stream().collect(Collectors.toMap(x -> x.getCode(), x -> x));
        }
        List unitNames = array.stream().map(x -> ((JSONObject)x).getString("DESC11")).distinct().collect(Collectors.toList());
        Map<Object, Object> unitMap = new HashMap();
        if (CollectionUtils.isNotEmpty(unitNames)) {
            QueryParam param = new QueryParam();
            param.getParams().put("unitName", new Parameter("in", unitNames));
            param.getParams().put("tenantId", new Parameter("eq", (Object)999999L));
            List list3 = this.unitService.queryList(param);
            if (CollectionUtils.isNotEmpty((Collection)list3)) {
                unitMap = list3.stream().collect(Collectors.toMap(x -> x.getUnitName(), x -> x));
            }
        }
        ArrayList<MaterialVO> saveList = new ArrayList<MaterialVO>();
        for (Object o : array) {
            JSONObject obj = (JSONObject)o;
            String code = obj.getString("CODE");
            MaterialVO vo = new MaterialVO();
            vo.setCreateUserCode("adminzhht");
            vo.setCreateTime(new Date());
            vo.setTenantId(Long.valueOf(999999L));
            if (map.containsKey(code)) {
                vo = (MaterialVO)map.get(code);
            }
            vo.setCode(code);
            vo.setName(obj.getString("NAME"));
            vo.setCategoryCode(obj.getString("CATEGORYCODE"));
            vo.setCategoryName(obj.getString("CATEGORYNAME"));
            if (categoryMap.containsKey(vo.getCategoryName())) {
                MaterialCategoryEntity category = (MaterialCategoryEntity)categoryMap.get(vo.getCategoryName());
                vo.setUnitId(category.getId());
                vo.setSubjectId(category.getSubjectId());
                vo.setSubjectName(category.getSubjectName());
                vo.setFinancialId(category.getFinancialId());
                vo.setFinancialName(category.getFinancialName());
            }
            vo.setUnitName(obj.getString("DESC11"));
            if (unitMap.containsKey(vo.getUnitName())) {
                vo.setUnitId(((UnitEntity)((Object)unitMap.get(vo.getUnitName()))).getId());
            }
            vo.setSpec(obj.getString("SPECS"));
            vo.setDef1(obj.getString("MATERIAL"));
            vo.setDef4(obj.getString("STANDARD "));
            vo.setDef5(obj.getString("MATERIAL"));
            vo.setDef7(obj.getString("DESCLONG"));
            vo.setDef8(obj.getString("DESCSHORT"));
            vo.setDef9(obj.getString("DESC10"));
            vo.setDef10(obj.getString("DESC11"));
            vo.setEnabled(Integer.valueOf("\u505c\u7528".equals(obj.getString("DESC20")) ? 2 : 1));
            vo.setSourceId(obj.getString("UUID"));
            vo.setSystemId("cnecht.zh.itemcode");
            saveList.add(vo);
        }
        if (CollectionUtils.isNotEmpty(saveList)) {
            this.materialService.insertBatch(saveList);
        }
    }

    @JmsListener(destination="cnecht.zh.itemtype")
    public void receive_cnecht_zh_itemtype(String message) throws IOException {
        String msg = URLDecoder.decode(message, "utf-8");
        msg = msg.substring(12);
        this.logger.info("cnecht.zh.itemtype message: " + msg);
        JSONObject json = JSONObject.parseObject((String)msg);
        JSONArray array = json.getJSONArray("data");
        List<MaterialCategoryEntity> list = this.categoryService.queryCategoryListByCodes(null);
        Map<Object, Object> map = new HashMap();
        if (CollectionUtils.isNotEmpty(list)) {
            map = list.stream().collect(Collectors.toMap(x -> x.getCode(), x -> x));
        }
        ArrayList<MaterialCategoryEntity> saveList = new ArrayList<MaterialCategoryEntity>();
        for (Object o : array) {
            JSONObject obj = (JSONObject)o;
            String code = obj.getString("CODE");
            MaterialCategoryEntity vo = new MaterialCategoryEntity();
            vo.setId(IdWorker.getId());
            vo.setCreateUserCode("adminzhht");
            vo.setCreateTime(new Date());
            vo.setTenantId(999999L);
            if (map.containsKey(code)) {
                vo = (MaterialCategoryEntity)map.get(code);
            }
            vo.setCode(code);
            vo.setUnitName(obj.getString("PARENTCODE"));
            vo.setName(obj.getString("DESC1"));
            vo.setDescription(obj.getString("DESC2"));
            vo.setEnabled("\u505c\u7528".equals(obj.getString("DESC3")) ? 2 : 1);
            vo.setSourceId(obj.getString("UUID"));
            vo.setSystemId("cnecht.zh.itemtype");
            if (!"\u7269\u8d44".equals(obj.getString("DESC4"))) continue;
            saveList.add(vo);
        }
        list.addAll(saveList);
        map = list.stream().collect(Collectors.toMap(x -> x.getCode(), x -> x));
        for (MaterialCategoryEntity vo : saveList) {
            String parentCode = vo.getUnitName();
            if (map.containsKey(parentCode)) {
                vo.setParentId(((MaterialCategoryEntity)map.get(parentCode)).getId());
                vo.setInnerCode(((MaterialCategoryEntity)map.get(parentCode)).getInnerCode() + "|" + vo.getId());
                continue;
            }
            vo.setInnerCode(vo.getId().toString());
        }
        if (CollectionUtils.isNotEmpty(saveList)) {
            this.categoryService.insertBatch(saveList);
        }
    }

    @JmsListener(destination="cnecht.zh.supplier")
    public void receive_cnecht_zh_supplier(String message) throws IOException {
        String msg = URLDecoder.decode(message, "utf-8");
        msg = msg.substring(12);
        this.logger.info("cnecht.zh.supplier message: " + msg);
        JSONObject json = JSONObject.parseObject((String)msg);
        JSONArray content = json.getJSONArray("content");
        List codes = content.stream().map(x -> ((JSONObject)x).getJSONObject("basic").getString("companyNum")).collect(Collectors.toList());
        Map<Object, Object> map = new HashMap();
        if (CollectionUtils.isNotEmpty(codes)) {
            QueryParam param = new QueryParam();
            param.getParams().put("code", new Parameter("in", codes));
            List list = this.supplierService.queryList(param);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                map = list.stream().collect(Collectors.toMap(x -> x.getCode(), x -> x));
            }
        }
        ArrayList<SupplierEntity> saveList = new ArrayList<SupplierEntity>();
        for (Object o : content) {
            JSONArray invoice;
            JSONObject obj = (JSONObject)o;
            JSONObject basic = obj.getJSONObject("basic");
            String code = basic.getString("companyNum");
            SupplierEntity vo = new SupplierEntity();
            vo.setSourceId(basic.getString("companyId"));
            vo.setBillState(1);
            vo.setSupplierFlag(1);
            vo.setBlacklistFlag(0);
            vo.setRedlistFlag(0);
            vo.setInsideOrg(false);
            vo.setCoordination(false);
            vo.setInException(false);
            vo.setSupplyQueryType("laborSub,materialEquipment,other");
            vo.setSupplyType("major,labor,material,other");
            vo.setSupplyTypeName("\u4e13\u4e1a\u4f9b\u5e94\u5546,\u52b3\u52a1\u4f9b\u5e94\u5546,\u8d27\u7269\u7c7b\u4f9b\u5e94\u5546,\u5176\u4ed6\u4f9b\u5e94\u5546");
            vo.setPersonal("e");
            vo.setApplyOrgId(1247777316689256450L);
            vo.setApplyOrgName("\u4e2d\u6838\u534e\u6cf0\u5efa\u8bbe\u6709\u9650\u516c\u53f8");
            vo.setEnabled(1);
            vo.setCreateUserCode("adminzhht");
            vo.setCreateTime(new Date());
            vo.setTenantId(999999L);
            if (map.containsKey(code)) {
                vo = (SupplierEntity)((Object)map.get(code));
            }
            vo.setCode(basic.getString("companyNum"));
            vo.setName(basic.getString("companyName"));
            vo.setSocialCreditCode(basic.getString("unifiedSocialCode"));
            vo.setLegal(basic.getString("legalRepName"));
            vo.setLegalPhone(basic.getString("organizationType"));
            vo.setAddress(basic.getString("addressDetail"));
            vo.setTaxPayerIdentifier(basic.getString("unifiedSocialCode"));
            vo.setRegisterTime(basic.getDate("buildDate"));
            vo.setRegisteredCapital(basic.getBigDecimal("registeredCapital"));
            vo.setBusinessScope(basic.getString("businessScope"));
            vo.setInOrOut(!"\u5883\u5185".equals(basic.getString("domesticForeignRelation")) ? 2 : 1);
            vo.setTaxpayerType(!"\u4e00\u822c\u7eb3\u7a0e\u4eba".equals(basic.getString("taxpayerType")) ? "smallScale" : "commonly");
            vo.setRegisterCountryName(basic.getString("registeredCountryName"));
            vo.setArea(basic.getString("registeredRegionName"));
            JSONArray contacts = obj.getJSONArray("contacts");
            if (CollectionUtils.isNotEmpty((Collection)contacts)) {
                vo.setBusinessPerson(contacts.getJSONObject(0).getString("name"));
                vo.setBusinessPhone(contacts.getJSONObject(0).getString("mobilephone"));
            }
            if (CollectionUtils.isNotEmpty((Collection)(invoice = obj.getJSONArray("invoice")))) {
                vo.setBillingAddress(invoice.getJSONObject(0).getString("taxRegistrationAddress"));
                vo.setBillingPhone(invoice.getJSONObject(0).getString("taxRegistrationPhone"));
                vo.setBankAccountCode(invoice.getJSONObject(0).getString("bankAccountNum"));
                vo.setBankAccountName(invoice.getJSONObject(0).getString("depositBank"));
                BankEntity bank = this.getBankByName(vo.getBankAccountName());
                vo.setBankAccountId(bank.getId());
            }
            vo.setUnitI8Code(basic.getString("companyId"));
            vo.setSystemId("cnecht.zh.supplier");
            saveList.add(vo);
        }
        if (CollectionUtils.isNotEmpty(saveList)) {
            this.supplierService.saveOrUpdateBatch(saveList, saveList.size(), false);
        }
    }

    private BankEntity getBankByName(String bankName) {
        QueryParam param = new QueryParam();
        param.getParams().put("name", new Parameter("eq", (Object)bankName));
        List bankList = this.bankService.queryList(param);
        if (CollectionUtils.isNotEmpty((Collection)bankList)) {
            return (BankEntity)((Object)bankList.get(0));
        }
        return new BankEntity();
    }
}

