/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.permission.api.IRoleApi;
import com.ejianc.foundation.permission.vo.RoleUserRelationVO;
import com.ejianc.foundation.share.bean.CommonMsgSendEntity;
import com.ejianc.foundation.share.service.ICommonMsgSendService;
import com.ejianc.foundation.share.vo.CommonMsgSendVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.util.DateUtil;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"commonMsgSend"})
public class CommonMsgSendController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IRoleApi roleApi;
    private static final String BILL_CODE = "COMMON_MSG_SEND_RULE";
    @Autowired
    private ICommonMsgSendService service;
    @Value(value="${common.env.base-host}")
    private String BaseHost;
    @Value(value="${weChat.cgdd-agentid:#{NULL}}")
    private String cgddAgentid;
    @Value(value="${weChat.cgdd-secret:#{NULL}}")
    private String cgddSecret;
    @Autowired
    private IPushMessageApi pushMessageApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    public CommonResponse<CommonMsgSendVO> saveOrUpdate(@RequestBody CommonMsgSendVO saveOrUpdateVO) {
        CommonMsgSendEntity entity = (CommonMsgSendEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, CommonMsgSendEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        CommonMsgSendVO vo = (CommonMsgSendVO)BeanMapper.map((Object)((Object)entity), CommonMsgSendVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    public CommonResponse<CommonMsgSendVO> queryDetail(Long id) {
        CommonMsgSendEntity entity = (CommonMsgSendEntity)((Object)this.service.selectById(id));
        CommonMsgSendVO vo = (CommonMsgSendVO)BeanMapper.map((Object)((Object)entity), CommonMsgSendVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    public CommonResponse<String> delete(@RequestBody List<CommonMsgSendVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @PostMapping(value={"/autoSendMsg"})
    public CommonResponse<String> autoSendMsg() {
        this.logger.info("\u5b9a\u65f6\u53d1\u9001\u6d88\u606f\u4efb\u52a1\u542f\u52a8----------START---------------");
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"enable_status", (Object)1);
        query.eq((Object)"dr", (Object)0);
        List sendMsgList = this.service.list((Wrapper)query);
        if (CollectionUtils.isEmpty((Collection)sendMsgList)) {
            this.logger.info("\u5b9a\u65f6\u53d1\u9001\u6d88\u606f\u4efb\u52a1\u7ed3\u675f----------END---------------\u4efb\u52a1\u6267\u884c\u6210\u529f\uff0c\u5f85\u53d1\u9001\u6d88\u606f\u5217\u8868\u4e3a\u7a7a\uff01");
            return CommonResponse.success((String)"\u4efb\u52a1\u6267\u884c\u6210\u529f\uff0c\u5f85\u53d1\u9001\u6d88\u606f\u5217\u8868\u4e3a\u7a7a\uff01");
        }
        ArrayList<Long> roleIds = new ArrayList<Long>();
        List<CommonMsgSendEntity> waitSendMsgList = this.getCanSendList(sendMsgList, roleIds);
        if (CollectionUtils.isEmpty(waitSendMsgList)) {
            this.logger.info("\u5b9a\u65f6\u53d1\u9001\u6d88\u606f\u4efb\u52a1\u7ed3\u675f----------END---------------\u4efb\u52a1\u6267\u884c\u6210\u529f\uff0c\u5f85\u53d1\u9001\u6d88\u606f\u5217\u8868\u4e3a\u7a7a\uff01");
            return CommonResponse.success((String)"\u4efb\u52a1\u6267\u884c\u6210\u529f\uff0c\u5f85\u53d1\u9001\u6d88\u606f\u5217\u8868\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty(roleIds)) {
            this.logger.info("\u5b9a\u65f6\u53d1\u9001\u6d88\u606f\u4efb\u52a1\u7ed3\u675f----------END---------------\u4efb\u52a1\u6267\u884c\u6210\u529f\uff0c\u63a5\u6536\u6d88\u606f\u89d2\u8272\u5217\u8868\u4e3a\u7a7a\uff01");
            return CommonResponse.success((String)"\u4efb\u52a1\u6267\u884c\u6210\u529f\uff0c\u63a5\u6536\u6d88\u606f\u89d2\u8272\u5217\u8868\u4e3a\u7a7a\uff01");
        }
        CommonResponse rolesReps = this.roleApi.getRoleUser(roleIds, null);
        if (!rolesReps.isSuccess()) {
            this.logger.info("\u5b9a\u65f6\u53d1\u9001\u6d88\u606f\u4efb\u52a1\u7ed3\u675f----------END---------------\u4efb\u52a1\u6267\u884c\u6210\u529f\uff0c\u63a5\u6536\u6d88\u606f\u89d2\u8272\u5217\u8868\u4e3a\u7a7a\uff01");
            return CommonResponse.success((String)"\u4efb\u52a1\u6267\u884c\u5931\u8d25\uff0c\u83b7\u53d6\u6d88\u606f\u63a5\u6536\u89d2\u8272\u5217\u8868\u5931\u8d25, {}", (Object)JSONObject.toJSONString((Object)rolesReps));
        }
        Map roleUserMap = ((List)rolesReps.getData()).stream().collect(Collectors.groupingBy(RoleUserRelationVO::getRoleId, Collectors.mapping(item -> item.getUserId().toString(), Collectors.toSet())));
        PushMsgParameter tmp = null;
        HashSet userIds = new HashSet();
        for (CommonMsgSendEntity item2 : waitSendMsgList) {
            userIds.clear();
            tmp = new PushMsgParameter();
            tmp.setChannel(item2.getSendChannel().split(","));
            tmp.setSaveFlag(true);
            tmp.setSendUserId(Long.valueOf(303581417601122400L));
            tmp.setMsgType("notice");
            tmp.setTenantId(item2.getTenantId().toString());
            tmp.setSubject(item2.getContent());
            tmp.setContent(item2.getContent());
            tmp.setPcUrl(item2.getPcUrl());
            tmp.setMobileUrl(item2.getMobileUrl());
            if (item2.getSendChannel().contains("weixinee")) {
                if (StringUtils.isNotBlank((CharSequence)this.cgddAgentid) && StringUtils.isNotBlank((CharSequence)this.cgddSecret)) {
                    JSONObject weixineeParams = new JSONObject();
                    weixineeParams.put("agentid", (Object)this.cgddAgentid);
                    weixineeParams.put("secret", (Object)this.cgddSecret);
                    weixineeParams.put("msgtype", (Object)"textcard");
                    weixineeParams.put("title", (Object)"\u6d88\u606f\u63d0\u9192");
                    weixineeParams.put("description", (Object)tmp.getMobileContent());
                    weixineeParams.put("url", (Object)(tmp.getMobileUrl() + "&userid={userid}"));
                    weixineeParams.put("btntxt", (Object)"\u70b9\u51fb\u67e5\u770b");
                    tmp.setWeixineeParams(weixineeParams);
                } else {
                    this.logger.info("cgddAgentid-{} \u6216\u8005 cgddSecret-{}\u4e3a\u7a7a\uff0c\u8df3\u8fc7\u53d1\u9001\u4f01\u4e1a\u5fae\u4fe1\u6d88\u606f\uff01", (Object)this.cgddAgentid, (Object)this.cgddSecret);
                }
            }
            for (JSONObject roleId : item2.getRecRoleIds().split(",")) {
                userIds.addAll(roleUserMap.get(Long.valueOf((String)roleId)));
            }
            tmp.setReceivers(userIds.toArray(new String[userIds.size()]));
            CommonResponse msgSendResp = this.pushMessageApi.pushMessage(tmp);
            if (msgSendResp.isSuccess()) {
                this.logger.info("\u5b9a\u65f6\u6d88\u606f-{}\u53d1\u9001\u6210\u529f\uff01", (Object)item2.getId());
                continue;
            }
            this.logger.error("\u5b9a\u65f6\u6d88\u606f-{}\u53d1\u9001\u5931\u8d25, {}", (Object)item2.getId(), (Object)JSONObject.toJSONString((Object)msgSendResp));
        }
        this.logger.info("\u5b9a\u65f6\u53d1\u9001\u6d88\u606f\u4efb\u52a1\u7ed3\u675f----------END---------------");
        return CommonResponse.success((String)"\u5b9a\u65f6\u53d1\u9001\u6d88\u606f\u4efb\u52a1\u6210\u529f\uff01");
    }

    private List<CommonMsgSendEntity> getCanSendList(List<CommonMsgSendEntity> msgSendInfoList, List<Long> roleIds) {
        String curDay = DateUtil.getCurrentDay("yyyy-MM-dd");
        String[] dateArr = curDay.split("-");
        ArrayList tmp = new ArrayList();
        return msgSendInfoList.stream().filter(msgSendInfo -> {
            tmp.clear();
            tmp.addAll(Arrays.asList(msgSendInfo.getSendMonthOfYear().split(",")));
            switch (msgSendInfo.getSendperiodtype()) {
                case "byMonth": {
                    if (!"all".equals(msgSendInfo.getSendMonthOfYear()) && !tmp.contains(dateArr[1])) {
                        return false;
                    }
                    tmp.clear();
                    tmp.addAll(Arrays.asList(msgSendInfo.getSendDayOfMonth().split(",")));
                    if (!"all".equals(msgSendInfo.getSendDayOfMonth()) && !tmp.contains(dateArr[2])) {
                        return false;
                    }
                    roleIds.addAll(Arrays.stream(msgSendInfo.getRecRoleIds().split(",")).map(item -> Long.valueOf(item)).collect(Collectors.toList()));
                    return true;
                }
            }
            return false;
        }).collect(Collectors.toList());
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    public CommonResponse<IPage<CommonMsgSendVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("title");
        fuzzyFields.add("recRoleNames");
        fuzzyFields.add("content");
        fuzzyFields.add("billCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CommonMsgSendVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/refCommonMsgSendData"}, method={RequestMethod.GET})
    public CommonResponse<IPage<CommonMsgSendVO>> refCommonMsgSendData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CommonMsgSendVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

