package com.ejianc.foundation.share.consumer;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.share.bean.MaterialCategoryEntity;
import com.ejianc.foundation.share.bean.SupplierEntity;
import com.ejianc.foundation.share.bean.UnitEntity;
import com.ejianc.foundation.share.mapper.MaterialCategoryMapper;
import com.ejianc.foundation.share.service.IMaterialCategoryService;
import com.ejianc.foundation.share.service.IMaterialService;
import com.ejianc.foundation.share.service.ISupplierService;
import com.ejianc.foundation.share.service.IUnitService;
import com.ejianc.foundation.share.vo.MaterialVO;
//import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.bean.BankEntity;
import com.ejianc.foundation.support.service.IBankService;
//import com.ejianc.foundation.support.vo.DefdocDetailVO;
//import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jms.annotation.JmsListener;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 中核华泰消息拉取监听类
 */
@Component
public class ZhHtCommonListener {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private final static Long TENANT_ID = 999999L;
    private final static String USER_CODE = "adminzhht";

    @Autowired
    private IMaterialService materialService;

    @Autowired
    private IMaterialCategoryService categoryService;

    @Autowired
    private MaterialCategoryMapper categoryMapper;

    @Autowired
    private IUnitService unitService;

    @Autowired
    private ISupplierService supplierService;

    @Autowired
    private IBankService bankService;

//    @Autowired
//    private IDefdocApi defdocApi;

    /**
     * 监听物料同步
     * @param message
     * @throws IOException
     */
    @JmsListener(destination="cnecht.zh.itemcode")
    public void receive_cnecht_zh_itemcode(String message){
        logger.info("cnecht.zh.itemcode message: " + message);
//        String msg = this.transferMessage(message);
        String msg = message.substring(12);   // outputValue={....} 去除字符串中的outputValue=
        JSONObject json = JSONObject.parseObject(msg);
        JSONArray array = json.getJSONArray("data");
        List<String> codes = array.stream().map(x->((JSONObject)x).getString("CODE")).collect(Collectors.toList());
        Map<String, MaterialVO> map = new HashMap<>();
        if(CollectionUtils.isNotEmpty(codes)){
            List<MaterialVO> list = materialService.queryMaterialListByCodes(codes, TENANT_ID);
            if(CollectionUtils.isNotEmpty(list)){
                map = list.stream().collect(Collectors.toMap(x->x.getCode(), x->x));
            }
        }

        List<String> categoryCodes = array.stream().map(x->((JSONObject)x).getString("CATEGORYCODE")).collect(Collectors.toList());
        Map<String, MaterialCategoryEntity> categoryMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(categoryCodes)){
            List<MaterialCategoryEntity> list = categoryService.queryCategoryListByCodes(categoryCodes, TENANT_ID);
            if(CollectionUtils.isNotEmpty(list)){
                categoryMap = list.stream().collect(Collectors.toMap(x->x.getCode(), x->x));
            }
        }

        List<String> unitNames = array.stream().map(x->((JSONObject)x).getString("DESC11")).distinct().collect(Collectors.toList());
        Map<String, UnitEntity> unitMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(unitNames)){
            QueryParam param = new QueryParam();
            param.getParams().put("unitName", new Parameter(QueryParam.IN, unitNames));
            param.getParams().put("tenantId", new Parameter(QueryParam.EQ, TENANT_ID));
            List<UnitEntity> list = unitService.queryList(param);
            if(CollectionUtils.isNotEmpty(list)){
                unitMap = list.stream().collect(Collectors.toMap(x->x.getUnitName(), x->x));
            }
            // 如果单位档案没有则新增
            this.saveUnit(unitNames, unitMap);
        }

        List<MaterialVO> saveList = new ArrayList<>();
        List<MaterialVO> updateList = new ArrayList<>();
        for(Object o : array){
            JSONObject obj = (JSONObject)o;
            String code = obj.getString("CODE");
            MaterialVO vo = new MaterialVO();
            vo.setId(IdWorker.getId());
            vo.setCreateUserCode(USER_CODE);
            vo.setCreateTime(new Date());
            vo.setTenantId(TENANT_ID);
            if(map.containsKey(code)){
                vo = map.get(code);
                vo.setUpdateUserCode(USER_CODE);
                vo.setUpdateTime(new Date());
            }
            vo.setCode(code);// 编码
            vo.setName(obj.getString("NAME"));// 名称
            vo.setCategoryCode(obj.getString("CATEGORYCODE"));// 分类名称
            vo.setCategoryName(obj.getString("CATEGORYNAME"));// 分类名称
            if(categoryMap.containsKey(vo.getCategoryCode())){
                MaterialCategoryEntity category = categoryMap.get(vo.getCategoryCode());
                vo.setCategoryId(category.getId());// 分类主键
                vo.setSubjectId(category.getSubjectId());// 成本科目主键
                vo.setSubjectName(category.getSubjectName());// 成本科目名称
                vo.setFinancialId(category.getFinancialId());// 财务科目主键
                vo.setFinancialName(category.getFinancialName());// 财务科目名称
            }
            vo.setUnitName(obj.getString("DESC11"));// 单位名称
            if(unitMap.containsKey(vo.getUnitName())){
                vo.setUnitId(unitMap.get(vo.getUnitName()).getId());// 单位主键
            }
            vo.setSpec(obj.getString("SPECS"));// 规格/型号
            vo.setDef1(obj.getString("MATERIAL"));// 材质
            vo.setDef4(obj.getString("STANDARD "));// 标准
            vo.setDef5(obj.getString("MATERIAL"));// 材质
//            vo.setDef6(obj.getString("FEATURECODE"));// 特征
            vo.setDef7(obj.getString("DESCLONG"));// 长描述
            vo.setDef8(obj.getString("DESCSHORT"));// 短描述
            vo.setDef9(obj.getString("DESC10"));// 单位编码
            vo.setDef10(obj.getString("DESC11"));// 单位名称
            vo.setEnabled("停用".equals(obj.getString("DESC20")) ? 2 : 1);
            vo.setSourceId(obj.getString("UUID"));// 来源主键
            vo.setSystemId("cnecht.zh.itemcode");// 来源系统主键
            if(map.containsKey(code)){
                updateList.add(vo);
            } else {
                saveList.add(vo);
            }
        }
        if(CollectionUtils.isNotEmpty(saveList)){
            materialService.insertBatch(saveList, TENANT_ID);
        }
        if(CollectionUtils.isNotEmpty(updateList)){
            updateList.forEach(vo -> {
                materialService.update(vo);
            });
        }
        logger.info("监听物料同步执行成功-{}条！", saveList.size());
    }

    /**
     * 监听物料分类同步
     * @param message
     * @throws IOException
     */
    @JmsListener(destination="cnecht.zh.itemtype")
    public void receive_cnecht_zh_itemtype(String message){
        logger.info("cnecht.zh.itemtype message: " + message);
//        String msg = this.transferMessage(message);
        String msg = message.substring(12);   // outputValue={....} 去除字符串中的outputValue=
        JSONObject json = JSONObject.parseObject(msg);
        JSONArray array = json.getJSONArray("data");
        List<MaterialCategoryEntity> list = categoryService.queryCategoryListByCodes(null);
        Map<String, MaterialCategoryEntity> map = new HashMap<>();
        if(CollectionUtils.isNotEmpty(list)){
            map = list.stream().collect(Collectors.toMap(x->x.getCode(), x->x));
        }
        List<MaterialCategoryEntity> saveList = new ArrayList<>();
        List<MaterialCategoryEntity> updateList = new ArrayList<>();
        for(Object o : array){
            JSONObject obj = (JSONObject)o;
            String code = obj.getString("CODE");
            MaterialCategoryEntity vo = new MaterialCategoryEntity();
            vo.setId(IdWorker.getId());
            vo.setCreateUserCode(USER_CODE);
            vo.setCreateTime(new Date());
            vo.setTenantId(TENANT_ID);
            if(map.containsKey(code)){
                vo = map.get(code);
                vo.setUpdateUserCode(USER_CODE);
                vo.setUpdateTime(new Date());
            }
            vo.setCode(code);// 编码
            // 父级编码临时存储到单位名称
            vo.setUnitName(obj.getString("PARENTCODE"));
            vo.setName(obj.getString("DESC1"));// 名称
            vo.setDescription(obj.getString("DESC2"));// 描述
            vo.setEnabled("停用".equals(obj.getString("DESC3")) ? 2 : 1);
            vo.setSourceId(obj.getString("UUID"));// 来源主键
            vo.setSystemId("cnecht.zh.itemtype");// 来源系统主键
//            if(!"物资".equals(obj.getString("DESC4"))){
//                continue;
//            }
            if(map.containsKey(code)){
                updateList.add(vo);
            } else {
                saveList.add(vo);
            }
        }
        // 处理树形结构
        list.addAll(saveList);
        map = list.stream().collect(Collectors.toMap(x->x.getCode(), x->x));
        for(MaterialCategoryEntity vo : saveList){
            String parentCode = vo.getUnitName();
            if(map.containsKey(parentCode)){
                vo.setParentId(map.get(parentCode).getId());
                vo.setInnerCode(map.get(parentCode).getInnerCode() + "|" + vo.getId());
            } else {
                vo.setInnerCode(vo.getId().toString());
            }
        }
        if(CollectionUtils.isNotEmpty(saveList)){
            categoryService.insertBatch(saveList, TENANT_ID);
        }
        if(CollectionUtils.isNotEmpty(updateList)){
            updateList.forEach(vo -> {
                categoryMapper.update(vo);
            });
        }
        logger.info("监听物料分类同步执行成功-{}条！", saveList.size());
    }

    /**
     * 监听供应商同步
     * @param message
     * @throws IOException
     */
    @JmsListener(destination="cnechc.zh.supplier")
    public void receive_cnecht_zh_supplier(String message){
        logger.info("cnecht.zh.supplier message: " + message);
//        String msg = this.transferMessage(message);
//        msg = msg.substring(12);   // outputValue={....} 去除字符串中的outputValue=
        JSONArray content = JSONObject.parseArray(message);
        List<String> codes = content.stream().map(x->((JSONObject)x).getJSONObject("basic").getString("companyNum")).collect(Collectors.toList());
        Map<String, SupplierEntity> map = new HashMap<>();
        if(CollectionUtils.isNotEmpty(codes)){
            QueryParam param = new QueryParam();
            param.getParams().put("code", new Parameter(QueryParam.IN, codes));
            List<SupplierEntity> list = supplierService.queryList(param);
            if(CollectionUtils.isNotEmpty(list)){
                map = list.stream().collect(Collectors.toMap(x->x.getCode(), x->x, (v1, v2)->v2));
            }
        }

//        CommonResponse<List<DefdocDetailVO>> response = defdocApi.getDefDocByDefId(489892533129330724L);
//        Map<String, Long> defMap = new HashMap<>();
//        if(!response.isSuccess()) {
//            defMap = response.getData().stream().collect(Collectors.toMap(DefdocDetailVO::getName, DefdocDetailVO::getId));
//        } else {
//            logger.error(response.getMsg());
//        }

        List<SupplierEntity> saveList = new ArrayList<>();
        for(Object o : content){
            JSONObject obj = (JSONObject)o;
            JSONObject basic = obj.getJSONObject("basic");// 基本信息
            String code = basic.getString("companyNum");// 供应商编号
            SupplierEntity vo = new SupplierEntity();
            vo.setSourceId(basic.getString("companyId"));// 供应商来源主键
            vo.setBillState(1);// 默认已提交
            vo.setSupplierFlag(1);// 客商属性：1供应商，2客户，3客商
            vo.setBlacklistFlag(0);// 是否黑名单，0-否，1-是
            vo.setRedlistFlag(0);// 是否红名单，0-否，1-是
            vo.setInsideOrg(false);// 内外部客商 true：内部，false：外部
            vo.setCoordination(false);// 是否协同
            vo.setInException(false);// 是否异常
            vo.setSupplyQueryType("laborSub,materialEquipment,other");// 供应商分类
            vo.setSupplyType("major,labor,material,other");// 供方类别
            vo.setSupplyTypeName("专业供应商,劳务供应商,货物类供应商,其他供应商");// 供方类别名称
            vo.setPersonal("e");// 个人：p，企业：e
            vo.setApplyOrgId(1247777316689256450L);// 申请单位id
            vo.setApplyOrgName("中核华泰建设有限公司");// 申请单位
            vo.setEnabled(1);// 启用
            vo.setGradeId(918885557151469613L);// 默认B级
            vo.setGradeName("B");
            vo.setId(IdWorker.getId());
            vo.setCreateUserCode(USER_CODE);
            vo.setCreateTime(new Date());
            vo.setTenantId(TENANT_ID);
            if(map.containsKey(code)){
                vo = map.get(code);
                vo.setUpdateUserCode(USER_CODE);
                vo.setUpdateTime(new Date());
            }
            vo.setCode(basic.getString("companyNum"));// 供应商编码
            vo.setName(basic.getString("companyName"));// 供应商名称
            vo.setSocialCreditCode(basic.getString("unifiedSocialCode"));// 统一社会信用代码
            vo.setLegal(basic.getString("legalRepName"));// 法人
            vo.setLegalPhone(basic.getString("corporateTelephone"));// 法人电话
            vo.setAddress(basic.getString("addressDetail"));// 详细地址
            vo.setTaxPayerIdentifier(basic.getString("unifiedSocialCode"));// 纳税人识别号
            vo.setRegisterTime(basic.getDate("buildDate"));// 注册日期
            vo.setRegisteredCapital(basic.getBigDecimal("registeredCapital"));// 注册资金
            vo.setBusinessScope(basic.getString("businessScope"));// 经营范围
            vo.setInOrOut(!"境内".equals(basic.getString("domesticForeignRelation")) ? 2 : 1);// 国内外：1国内，2国外
            vo.setTaxpayerType(!"一般纳税人".equals(basic.getString("taxpayerType")) ? "smallScale" : "commonly");// 纳税人类型 commonly 一般纳税人 smallScale 小规模纳税
            vo.setRegisterCountryName(basic.getString("registeredCountryName"));// 注册国家名称
//            if(defMap.containsKey(vo.getRegisterCountryName())){
//                vo.setRegisterCountryId(defMap.get(vo.getRegisterCountryName()));
//            }
//            vo.setArea(basic.getString("registeredRegionName"));// 地区

            JSONArray contactsList = obj.getJSONArray("contactsList");// 联系人信息
            if(CollectionUtils.isNotEmpty(contactsList)){
                vo.setBusinessPerson(contactsList.getJSONObject(0).getString("name"));// 业务代表
                vo.setBusinessPhone(contactsList.getJSONObject(0).getString("mobilephone"));// 业务代表电话
            }

            JSONArray invoiceList = obj.getJSONArray("invoiceList");// 开票信息
            if(CollectionUtils.isNotEmpty(invoiceList)){
                vo.setBillingAddress(invoiceList.getJSONObject(0).getString("taxRegistrationAddress"));// 开票地址
                vo.setBillingPhone(invoiceList.getJSONObject(0).getString("taxRegistrationPhone"));// 开票电话
                vo.setBankAccountCode(invoiceList.getJSONObject(0).getString("bankAccountNum"));// 银行账号
                vo.setBankAccountName(invoiceList.getJSONObject(0).getString("depositBank"));// 开户银行
                BankEntity bank = this.getBankByName(vo.getBankAccountName());
                vo.setBankAccountId(bank.getId());
            }

            // 临时存储companyId
            vo.setUnitI8Code(basic.getString("companyId"));
//            vo.setSourceId(basic.getString("companyId"));// 供应商来源主键
            vo.setSystemId("cnecht.zh.supplier");// 来源系统主键
            saveList.add(vo);
        }
        if(CollectionUtils.isNotEmpty(saveList)){
            supplierService.saveOrUpdateBatch(saveList, saveList.size(), false);
        }
        logger.info("监听供应商同步执行成功-{}条！", saveList.size());
    }

    /**
     * 根据银行名称获取银行实体
     * @param bankName
     * @return
     */
    private BankEntity getBankByName(String bankName) {
        QueryParam param = new QueryParam();
        param.getParams().put("name", new Parameter(QueryParam.EQ, bankName));
        List<BankEntity> bankList = bankService.queryList(param);
        if(CollectionUtils.isNotEmpty(bankList)){
            return bankList.get(0);
        }
        return new BankEntity();
    }

    /**
     * message转换
     * @param message
     * @return
     */
    public static String transferMessage(String message) {
        message = message.replaceAll("%(![0-9a-fA-F]{2})", "%25");
        message = message.replaceAll("\\+", "%2B");
        String msg= null;
        try {
            msg = URLDecoder.decode(message, "utf-8");
        } catch (UnsupportedEncodingException e) {
            throw new BusinessException(e.getMessage());
        }
        return msg;
    }

    /**
     * 如果单位档案没有则新增
     * @param unitNames
     * @param unitMap
     */
    private void saveUnit(List<String> unitNames, Map<String, UnitEntity> unitMap) {
        // 没有的单位则新增
        unitNames.removeAll(unitMap.keySet());
        if(CollectionUtils.isEmpty(unitNames)){
            return;
        }
        List<UnitEntity> saveList = new ArrayList<>();
        for(String name : unitNames){
            UnitEntity vo = new UnitEntity();
            vo.setUnitName(name);
            vo.setUnitCode(name);
            vo.setEnabled(1);
            vo.setId(IdWorker.getId());
            vo.setCreateUserCode(USER_CODE);
            vo.setCreateTime(new Date());
            vo.setTenantId(TENANT_ID);
            saveList.add(vo);
        }
        if(CollectionUtils.isEmpty(saveList)){
            return;
        }
        unitService.saveOrUpdateBatch(saveList);
        Map<String, UnitEntity> saveMap = saveList.stream().collect(Collectors.toMap(x->x.getUnitName(), x->x));
        unitMap.putAll(saveMap);
    }

    public static void main(String[] args) {
//        String str = "施工合格率100%，优良率85%，";
//        System.out.println(transferMessage(str));
        String msg = "[{\"basic\":{\"companyId\":44792,\"companyNum\":\"G00088997\",\"domesticForeignRelation\":\"境内\",\"unifiedSocialCode\":\"91341322152460452W\",\"organizingInstitutionCode\":\"91341322152460452W\",\"businessLicenseNum\":\"91341322152460452W\",\"taxRegistrationNum\":\"91341322152460452W\",\"isThreeCertificatesInOne\":1,\"companyName\":\"安徽申达建设工程有限公司\",\"companyType\":\"有限责任公司\",\"registeredCountryName\":\"中国\",\"registeredRegionName\":\"萧县\",\"addressDetail\":\"萧县龙城镇民治街26#\",\"taxpayerType\":\"一般纳税人\",\"buildDate\":\"1994-05-23 00:00:00\",\"registeredCapital\":6500.000000,\"currencyName\":\"人民币\",\"businessScope\":\"防水防腐保温工程、建筑装修装饰工程、亮化工程、机电安装工程、石油化工工程、建筑工程、电力工程施工、地基基础工程、钢结构工程、消防设施工程、土石方工程施工、施工劳务、模板脚手架搭设、国内劳务派遣；工业设备、建筑（不含石料和黄沙）及防腐保温材料的销售；管道和设备化学清洗；金属和非金属热喷涂；工业设备检维修；公交站亭生产制作安装；机械设备及汽车租赁；售电及售电服务；计算机信息系统集成、建筑智能化系统、自动化控制系统、计算机网络及软硬件产品的开发与销售；音响设备、校园广播设备、电子设备、数码产品、通讯产品、数学设备仪器、安防监控设备、计算机相关产品的销售；体育设施设计与施工；路灯、照明设备、新能源设备的安装；货物（不含危险化学品）的仓储、装卸、运输、包装服务；机电设备维修、维护。（依法须经批准的项目，经相关部门批准后方可开展经营活动）\",\"longTermFlag\":1,\"licenceUrl\":\"https://www.cnncsrm.com/minio/hz-private-bucket/spfm-comp/39520/bd9ae1aeca404d9f80df850d96068b9b@营业执照-20201217（副本）.jpg\",\"organizationType\":\"法人\",\"legalRepName\":\"杜开颜\",\"legalRepNumber\":\"341322197808092039\",\"authorizedName\":\"鲁峰\",\"institutionType\":\"111\",\"corporateTelephone\":\"05575023987\",\"employeesNum\":2150,\"isStateOwnedEnterprise\":0,\"isForeignEquity\":0,\"operationNature\":\"制造商\",\"companyProfile\":\"安徽申达建设工程有限公司系国家一级施工企业，是在原国有企业安徽申达防腐保温工程公司基础上改制而成的集科研、生产、施工、服务与一体的工程施工企业。多年来公司全体员工团结一致，艰苦奋斗，始终以\\\"以质量求生存，以信誉求发展\\\"的企业宗旨，取得了良好的经济效益和社会效益，在国内外市场享有较高的声誉。\\n目前，公司总资产9276万元，从业人员2500余人，其中工程技术和经济管理人员460人，拥有各种类型的先进施工设备和质量检测仪器656台(件)，技术装备率4116元/人，是同行业中实力较强的综合性施工企业，公司下设党委、工会、安全技术部、材料供应部、机械设备部、财务部、工程部、市场开发部、质量管理部、办公室和防腐技术研究所，10个分公司及26个项目部。\\n我公司以中国工业防腐蚀技术协会、天津大学、北京科技大学为技术依托，依靠科技进步，注重新技术、新工艺、新材料的开发和推广应用，能够独立承担石油、化工、电力、冶炼、机械、医药、纺织、有色金属等诸多行业的防腐保温、喷涂、橡胶衬里、砖板贴衬、化工耐酸、碱、盐及化工石油设备管道安装，机电电气仪表安装、防水及建筑装饰装修工程施工。并建立规范化的现代企业制度和科学管理体制，具有雄厚的技术力量和施工力量，先进的施工工艺和完善的质量保证体系，成为以防腐安装为主的综合性大型施工企业。\\n经过二十多年的艰苦奋斗，施工足迹遍布全国二十多个省、市、自治区，我们始终恪守企业经营理念，即:精心组织，建客户满意工程;持续改进,铸行业一流品牌。\\n公司始终坚持\\\"百年大计、质量第一、顾客至上\\\"的原则，特别注重工程质量和安全跟踪调查，为不断提高企业的管理水平和业务素质，公司长期开展职工教育及新技术讲座，积极引进新技术、新工艺、新设备、每年选派精干人员到专业院校进修、学习，并与中国工业防腐蚀技术协会等多家单位建立长期协作关系。为公司的发展提供技术支持。\\n企业在改革中发展，实力在竞争中增强，公司施工的主要工程项目有:国家西气东输、涩宁兰输气管道、西南成品油管道等工程;塔里木、克拉玛依、吐哈等各大油田的管道、储油罐安装防腐保温工程;乌鲁木齐、安庆、扬子等国家大型炼化企业的设备、储油罐防腐保温工程;上海、江苏、安徽等大型电厂的防腐保温工程;新疆、大庆、中原等化工管线安装防腐保温工程;天津、太原、大连等煤气公司的气柜、管道防腐工程;南京、徐州等污水处理厂防腐工程;萧县经济开发区办公楼、淮北地税局办公楼装修装饰工程;徐州国家粮食储备库、郑州直属库等屋面防水工程以及利比亚炼油厂、沙特达曼化工厂等国内外重点项目，施工合格率100%，优良率85%，并获奖杯、奖旗等200多面(枚)，久泰能源20万吨/年甲醚替代石油项目防腐保温工程荣获2008年度全国十大防腐蚀精品工程。\\n由于公司重合同守信用，并严格执行国家及行业规范、规程和标准，多次受到建设单位和行业主管部门好评和奖励，先后荣获\\\"全国质量安全先进施工企业\\\",多次被省委、省政府命名为\\\"明星企业\\\"\\\"五十强企业\\\"\\\"优秀建筑业企业\\\"\\\"安全生产先进集体\\\"连续十年被省工商行政管理局评为\\\"重合同守信用单位\\\"并被中国建设银行安徽省分行评为AAA级信用企业，公司的先进事迹先后见诸国内多家新闻媒体。\\n公司在同行业率先通过ISO9001《质量管理体系》、ISO14001《环境管理体系》、GB/T28001《职业健康安全管理体系》QEO三标一体管理体系认证，为确保工程质量及环境保护、为顾客提供优质服务发挥积极作用，并使公司的管理更加规范，企业更具市场竞争力。\",\"majorIndustries\":\"499\",\"sysdataid\":\"4c17f0ad93d44451827d10662a36c0f7\",\"sysid\":\"9b1319bc324e4ef6bc309b83bf192e9c\",\"version\":\"1\",\"versionstatus\":\"0\",\"isusedcode\":\"0\",\"createuser\":\"\",\"createtime\":\"2025-02-25 19:29:23\",\"modifytime\":\"2025-02-25 19:29:23\",\"sourceappcode\":\"srm\"},\"contactsList\":[{\"companyId\":44792,\"companyContactId\":44780,\"name\":\"严丽婷\",\"mail\":\"yueda2006@163.com\",\"mobilephone\":\"15215943971\",\"idType\":\"身份证\",\"idNum\":\"330424199505090049\",\"defaultFlag\":0,\"sysdataid\":\"d7e7f001db20470490c630839f4ff53f\",\"sysid\":\"48a81210cd2545a39379ec56f5b12ebf\",\"version\":\"1\",\"versionstatus\":\"0\",\"isusedcode\":\"0\",\"createuser\":\"\",\"createtime\":\"2025-02-25 19:29:23\",\"modifytime\":\"2025-02-25 19:29:23\",\"sourceappcode\":\"srm\"},{\"companyId\":44792,\"companyContactId\":174181,\"name\":\"鲁峰\",\"mail\":\"yueda2006@163.com\",\"mobilephone\":\"13600568110\",\"telephone\":\"0557-5023987\",\"idType\":\"身份证\",\"idNum\":\"220104196806171570\",\"defaultFlag\":1,\"sysdataid\":\"0ad058854e03420b8328a7d9dc8eb83e\",\"sysid\":\"5b9497cc3c554ba78b40997c389f6bda\",\"version\":\"1\",\"versionstatus\":\"0\",\"isusedcode\":\"0\",\"createuser\":\"\",\"createtime\":\"2025-02-25 19:29:23\",\"modifytime\":\"2025-02-25 19:29:23\",\"sourceappcode\":\"srm\"}],\"addressList\":[{\"companyId\":44792,\"companyAddressId\":44779,\"country\":\"中国\",\"region\":\"缺省\",\"postalCode\":\"235200\",\"addressType\":\"register\",\"sysdataid\":\"eeed942d54ce4cefbb899a9bc14cae80\",\"sysid\":\"bf6401af08c840ac8dda8a2ecddb28e1\",\"version\":\"1\",\"versionstatus\":\"0\",\"isusedcode\":\"0\",\"createuser\":\"\",\"createtime\":\"2025-02-25 19:29:23\",\"modifytime\":\"2025-02-25 19:29:23\",\"sourceappcode\":\"srm\"},{\"companyId\":44792,\"companyAddressId\":149489,\"country\":\"中国\",\"region\":\"萧县\",\"postalCode\":\"235200\",\"addressType\":\"operate\",\"sysdataid\":\"1173172ffa11442d994c4aba34319be6\",\"sysid\":\"acb4ff11aec4471cbdf74037fbba4a6d\",\"version\":\"1\",\"versionstatus\":\"0\",\"isusedcode\":\"0\",\"createuser\":\"\",\"createtime\":\"2025-02-25 19:29:23\",\"modifytime\":\"2025-02-25 19:29:23\",\"sourceappcode\":\"srm\"}],\"bankList\":[{\"companyId\":44792,\"companyBankAccountId\":40603,\"bankBranchName\":\"中国建设银行股份有限公司萧县支行\",\"bankAccountName\":\"安徽申达建设工程有限公司\",\"bankAccountNum\":\"34001727308053000332\",\"masterFlag\":1,\"bankFirm\":\"105374350014\",\"iban\":\"安徽申达建设工程有限公司\",\"sysdataid\":\"87d2999cc25244609d10855810c8479c\",\"sysid\":\"d7876db93d2843b9aa03c66b4fe4a68c\",\"version\":\"1\",\"versionstatus\":\"0\",\"isusedcode\":\"0\",\"createuser\":\"\",\"createtime\":\"2025-02-25 19:29:23\",\"modifytime\":\"2025-02-25 19:29:23\",\"sourceappcode\":\"srm\"},{\"companyId\":44792,\"companyBankAccountId\":205559,\"bankBranchName\":\"中国建设银行股份有限公司海盐秦山支行\",\"bankAccountName\":\"安徽申达建设工程有限公司\",\"bankAccountNum\":\"33050163715200000005\",\"masterFlag\":0,\"bankFirm\":\"105335300649\",\"iban\":\"安徽申达建设工程有限公司\",\"sysdataid\":\"032a0880d95f4004a799bf86f7c4433d\",\"sysid\":\"0a2b753fb25b4bab883b0910b57a88d6\",\"version\":\"1\",\"versionstatus\":\"0\",\"isusedcode\":\"0\",\"createuser\":\"\",\"createtime\":\"2025-02-25 19:29:23\",\"modifytime\":\"2025-02-25 19:29:23\",\"sourceappcode\":\"srm\"}],\"financeList\":[{\"year\":\"2023\",\"revenue\":112000.24,\"companyId\":44792,\"companyFinanceId\":140622,\"totalAssets\":23388.20,\"totalLiabilities\":12949.86,\"currentAssets\":22902.88,\"currentLiabilities\":12949.86,\"netProfit\":2120.05,\"sysdataid\":\"30ef5d77f3dd4d89960a650cae832195\",\"sysid\":\"ab027b97bc694910a818a4d6c808b863\",\"version\":\"1\",\"versionstatus\":\"0\",\"isusedcode\":\"0\",\"createuser\":\"\",\"createtime\":\"2025-02-25 19:29:23\",\"modifytime\":\"2025-02-25 19:29:23\",\"sourceappcode\":\"srm\"}],\"invoiceList\":[{\"companyInvoiceId\":40601,\"companyId\":44792,\"invoiceHeader\":\"安徽申达建设工程有限公司\",\"taxRegistrationNumber\":\"91341322152460452W\",\"depositBank\":\"中国建设银行\",\"bankAccountNum\":\"34001727308053000332\",\"taxRegistrationAddress\":\"安徽省萧县龙城镇民治街26#\",\"taxRegistrationPhone\":\"05575023987\",\"receiveMail\":\"yueda2006@163.com\",\"receivePhone\":\"13600568110\",\"sysdataid\":\"aee28e66fb98401ba75056113381d100\",\"sysid\":\"98c462c62ff9461dac29a11783987a98\",\"version\":\"1\",\"versionstatus\":\"0\",\"isusedcode\":\"0\",\"createuser\":\"\",\"createtime\":\"2025-02-25 19:29:23\",\"modifytime\":\"2025-02-25 19:29:23\",\"sourceappcode\":\"srm\"}],\"qualificationList\":[],\"statusList\":[{\"companyId\":44792,\"status\":\"注册\",\"belongCompanyCode\":\"10000\",\"belongCompanyName\":\"中国核工业集团有限公司\",\"sysdataid\":\"810f3eb3e49347aea7429dcd48471497\",\"sysid\":\"b5c780719de24934bc9bc31a9614b6e1\",\"version\":\"1\",\"versionstatus\":\"0\",\"isusedcode\":\"0\",\"createuser\":\"\",\"createtime\":\"2025-02-25 19:29:23\",\"modifytime\":\"2025-02-25 19:29:23\",\"sourceappcode\":\"srm\"},{\"listId\":70991,\"companyId\":44792,\"status\":\"合格\",\"belongCompanyCode\":\"99280563919161110119\",\"belongCompanyName\":\"中国核工业二三建设有限公司\",\"validityDateFrom\":\"2023-02-15 00:00:00\",\"validityDateTo\":\"2025-12-01 00:00:00\",\"evaluationScope\":\"二类：管道、机械、非核、预制罐专业劳务分包。\",\"sysdataid\":\"e78ee971c11c4554a9d79866d11298ee\",\"sysid\":\"d89a1e0932564efea2077c0f0ee50fe6\",\"version\":\"1\",\"versionstatus\":\"0\",\"isusedcode\":\"0\",\"createuser\":\"\",\"createtime\":\"2025-02-25 19:29:23\",\"modifytime\":\"2025-02-25 19:29:23\",\"sourceappcode\":\"srm\"},{\"listId\":2071520,\"companyId\":44792,\"status\":\"合格\",\"belongCompanyCode\":\"99280563919161110121\",\"belongCompanyName\":\"中国核工业第五建设有限公司\",\"validityDateFrom\":\"2024-05-24 00:00:00\",\"validityDateTo\":\"2027-05-17 00:00:00\",\"evaluationScope\":\"劳务分包（按工程量计算）（漳州核电 2027.05.17）\",\"sysdataid\":\"54b0755b219147468ab135b413be3a68\",\"sysid\":\"b263aad5daaa425b859080a94ea76b32\",\"version\":\"1\",\"versionstatus\":\"0\",\"isusedcode\":\"0\",\"createuser\":\"\",\"createtime\":\"2025-02-25 19:29:23\",\"modifytime\":\"2025-02-25 19:29:23\",\"sourceappcode\":\"srm\"},{\"listId\":69577,\"companyId\":44792,\"status\":\"合格\",\"belongCompanyCode\":\"99280563919161110120\",\"belongCompanyName\":\"中国核工业二四建设有限公司\",\"validityDateFrom\":\"2023-01-09 00:00:00\",\"validityDateTo\":\"2026-01-10 00:00:00\",\"evaluationScope\":\"挡土墙建设\",\"sysdataid\":\"bed07447bd0a4d8cb64714053fd43755\",\"sysid\":\"3e9c534290fd49f8b5700d7b3e4cdd48\",\"version\":\"1\",\"versionstatus\":\"0\",\"isusedcode\":\"0\",\"createuser\":\"\",\"createtime\":\"2025-02-25 19:29:23\",\"modifytime\":\"2025-02-25 19:29:23\",\"sourceappcode\":\"srm\"},{\"listId\":69578,\"companyId\":44792,\"status\":\"合格\",\"belongCompanyCode\":\"99280563919161110120\",\"belongCompanyName\":\"中国核工业二四建设有限公司\",\"validityDateFrom\":\"2023-01-09 00:00:00\",\"validityDateTo\":\"2026-01-10 00:00:00\",\"evaluationScope\":\"前期临建工程\",\"sysdataid\":\"5b773e2deaeb47a389a79b9ca0906e56\",\"sysid\":\"f698c9eebfb3458f866fd8776539cd03\",\"version\":\"1\",\"versionstatus\":\"0\",\"isusedcode\":\"0\",\"createuser\":\"\",\"createtime\":\"2025-02-25 19:29:23\",\"modifytime\":\"2025-02-25 19:29:23\",\"sourceappcode\":\"srm\"},{\"listId\":879450,\"companyId\":44792,\"status\":\"合格\",\"belongCompanyCode\":\"99280563919161110118\",\"belongCompanyName\":\"中国核工业第二二建设有限公司\",\"validityDateFrom\":\"2023-11-25 00:00:00\",\"validityDateTo\":\"2026-11-14 00:00:00\",\"evaluationScope\":\"劳务分包\\n\",\"sysdataid\":\"f65d06e394f34438aa8e4ba757a04d08\",\"sysid\":\"859da91fb65e489fb12a72dec60b1559\",\"version\":\"1\",\"versionstatus\":\"0\",\"isusedcode\":\"0\",\"createuser\":\"\",\"createtime\":\"2025-02-25 19:29:23\",\"modifytime\":\"2025-02-25 19:29:23\",\"sourceappcode\":\"srm\"},{\"listId\":2108890,\"companyId\":44792,\"status\":\"合格\",\"belongCompanyCode\":\"99280563919161110392\",\"belongCompanyName\":\"中核二十五建设有限公司\",\"validityDateFrom\":\"2024-07-08 00:00:00\",\"validityDateTo\":\"2025-07-08 00:00:00\",\"evaluationScope\":\"防水防腐涂料工程专业分包\",\"sysdataid\":\"206e33ce793244c8a2df281eaa1ac90a\",\"sysid\":\"9d7ac661caaa40cba5459770b7d49b08\",\"version\":\"1\",\"versionstatus\":\"0\",\"isusedcode\":\"0\",\"createuser\":\"\",\"createtime\":\"2025-02-25 19:29:23\",\"modifytime\":\"2025-02-25 19:29:23\",\"sourceappcode\":\"srm\"},{\"listId\":2391561,\"companyId\":44792,\"status\":\"合格\",\"belongCompanyCode\":\"99280563919161110005\",\"belongCompanyName\":\"中国核工业建设股份有限公司\",\"validityDateFrom\":\"2024-05-24 00:00:00\",\"validityDateTo\":\"2027-05-17 00:00:00\",\"evaluationScope\":\"劳务分包\",\"sysdataid\":\"4b8ed38f51144a0b8de48a245b706001\",\"sysid\":\"7732b672688d463a88eded2153c1d5cb\",\"version\":\"1\",\"versionstatus\":\"0\",\"isusedcode\":\"0\",\"createuser\":\"\",\"createtime\":\"2025-02-25 19:29:23\",\"modifytime\":\"2025-02-25 19:29:23\",\"sourceappcode\":\"srm\"},{\"listId\":2578495,\"companyId\":44792,\"status\":\"合格\",\"belongCompanyCode\":\"99280563919161110005\",\"belongCompanyName\":\"中国核工业建设股份有限公司\",\"validityDateFrom\":\"2024-05-24 00:00:00\",\"validityDateTo\":\"2027-05-17 00:00:00\",\"evaluationScope\":\"防水防腐涂料工程专业分包，劳务分包，地基基础工程\",\"sysdataid\":\"c83b606afc604175a776819239a6c44e\",\"sysid\":\"b4240351873f43e5a83ca555c5b1d4e2\",\"version\":\"1\",\"versionstatus\":\"0\",\"isusedcode\":\"0\",\"createuser\":\"\",\"createtime\":\"2025-02-25 19:29:23\",\"modifytime\":\"2025-02-25 19:29:23\",\"sourceappcode\":\"srm\"}]}]";
//        String msg = transferMessage(message);
        JSONArray content = JSONObject.parseArray(msg);
        List<String> codes = content.stream().map(x->((JSONObject)x).getJSONObject("basic").getString("companyNum")).collect(Collectors.toList());
        List<SupplierEntity> saveList = new ArrayList<>();
        for(Object o : content){
            JSONObject obj = (JSONObject)o;
            JSONObject basic = obj.getJSONObject("basic");// 基本信息
            String code = basic.getString("companyNum");// 供应商编号
            SupplierEntity vo = new SupplierEntity();
            vo.setSourceId(basic.getString("companyId"));// 供应商来源主键
            vo.setBillState(1);// 默认已提交
            vo.setSupplierFlag(1);// 客商属性：1供应商，2客户，3客商
            vo.setBlacklistFlag(0);// 是否黑名单，0-否，1-是
            vo.setRedlistFlag(0);// 是否红名单，0-否，1-是
            vo.setInsideOrg(false);// 内外部客商 true：内部，false：外部
            vo.setCoordination(false);// 是否协同
            vo.setInException(false);// 是否异常
            vo.setSupplyQueryType("laborSub,materialEquipment,other");// 供应商分类
            vo.setSupplyType("major,labor,material,other");// 供方类别
            vo.setSupplyTypeName("专业供应商,劳务供应商,货物类供应商,其他供应商");// 供方类别名称
            vo.setPersonal("e");// 个人：p，企业：e
            vo.setApplyOrgId(1247777316689256450L);// 申请单位id
            vo.setApplyOrgName("中核华泰建设有限公司");// 申请单位
            vo.setEnabled(1);// 启用
            vo.setId(IdWorker.getId());
            vo.setCreateUserCode(USER_CODE);
            vo.setCreateTime(new Date());
            vo.setTenantId(TENANT_ID);
            vo.setCode(basic.getString("companyNum"));// 供应商编码
            vo.setName(basic.getString("companyName"));// 供应商名称
            vo.setSocialCreditCode(basic.getString("unifiedSocialCode"));// 统一社会信用代码
            vo.setLegal(basic.getString("legalRepName"));// 法人
            vo.setLegalPhone(basic.getString("corporateTelephone"));// 法人电话
            vo.setAddress(basic.getString("addressDetail"));// 详细地址
            vo.setTaxPayerIdentifier(basic.getString("unifiedSocialCode"));// 纳税人识别号
            vo.setRegisterTime(basic.getDate("buildDate"));// 注册日期
            vo.setRegisteredCapital(basic.getBigDecimal("registeredCapital"));// 注册资金
            vo.setBusinessScope(basic.getString("businessScope"));// 经营范围
            vo.setInOrOut(!"境内".equals(basic.getString("domesticForeignRelation")) ? 2 : 1);// 国内外：1国内，2国外
            vo.setTaxpayerType(!"一般纳税人".equals(basic.getString("taxpayerType")) ? "smallScale" : "commonly");// 纳税人类型 commonly 一般纳税人 smallScale 小规模纳税
            vo.setRegisterCountryName(basic.getString("registeredCountryName"));// 注册国家名称
//            if(defMap.containsKey(vo.getRegisterCountryName())){
//                vo.setRegisterCountryId(defMap.get(vo.getRegisterCountryName()));
//            }
            vo.setArea(basic.getString("registeredRegionName"));// 地区

            JSONArray contacts = obj.getJSONArray("contactsList");// 联系人信息
            if(CollectionUtils.isNotEmpty(contacts)){
                vo.setBusinessPerson(contacts.getJSONObject(0).getString("name"));// 业务代表
                vo.setBusinessPhone(contacts.getJSONObject(0).getString("mobilephone"));// 业务代表电话
            }

            JSONArray invoice = obj.getJSONArray("invoiceList");// 开票信息
            if(CollectionUtils.isNotEmpty(invoice)){
                vo.setBillingAddress(invoice.getJSONObject(0).getString("taxRegistrationAddress"));// 开票地址
                vo.setBillingPhone(invoice.getJSONObject(0).getString("taxRegistrationPhone"));// 开票电话
                vo.setBankAccountCode(invoice.getJSONObject(0).getString("bankAccountNum"));// 银行账号
                vo.setBankAccountName(invoice.getJSONObject(0).getString("depositBank"));// 开户银行
//                BankEntity bank = this.getBankByName(vo.getBankAccountName());
//                vo.setBankAccountId(bank.getId());
            }

            // 临时存储companyId
            vo.setUnitI8Code(basic.getString("companyId"));
//            vo.setSourceId(basic.getString("companyId"));// 供应商来源主键
            vo.setSystemId("cnecht.zh.supplier");// 来源系统主键
            saveList.add(vo);
        }
        System.out.println(JSONObject.toJSONString(saveList));
    }
}
