/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.init.service.impl;

import com.ejianc.foundation.init.mapper.InitMapper;
import com.ejianc.foundation.init.service.InitService;
import com.ejianc.foundation.initData.vo.EnterpriseInitVO;
import com.ejianc.foundation.share.bean.CustomerCategoryEntity;
import com.ejianc.foundation.share.bean.CustomerEntity;
import com.ejianc.foundation.share.bean.SupplierCategoryEntity;
import com.ejianc.foundation.share.bean.SupplierEntity;
import com.ejianc.foundation.share.service.ICustomerCategoryService;
import com.ejianc.foundation.share.service.ICustomerService;
import com.ejianc.foundation.share.service.ISupplierCategoryService;
import com.ejianc.foundation.share.service.ISupplierService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class InitServiceImpl
implements InitService {
    @Autowired
    InitMapper initMapper;
    @Autowired
    ISupplierCategoryService iSupplierCategoryService;
    @Autowired
    ISupplierService iSupplierService;
    @Autowired
    private ICustomerCategoryService iCustomerCategoryService;
    @Autowired
    private ICustomerService iCustomerService;

    @Override
    public void initData(EnterpriseInitVO vo) {
        if (this.isNotAdmin().booleanValue()) {
            throw new BusinessException("\u65e0\u6743\u64cd\u4f5c!");
        }
        if (vo.getTenantId() == null) {
            throw new BusinessException("\u79df\u6237id\u4e0d\u5b58\u5728!");
        }
        this.initMapper.createThreeTables(vo.getTenantId());
        CustomerCategoryEntity customerCategoryEntity = new CustomerCategoryEntity();
        customerCategoryEntity.setId(IdWorker.getId());
        customerCategoryEntity.setName("\u5185\u90e8\u5ba2\u6237");
        customerCategoryEntity.setCode("CC-" + customerCategoryEntity.getId());
        customerCategoryEntity.setInnerCode(customerCategoryEntity.getId().toString());
        customerCategoryEntity.setSequence(1);
        customerCategoryEntity.setDescription("\u7cfb\u7edf\u521b\u5efa\uff01");
        customerCategoryEntity.setTenantId(vo.getTenantId());
        this.iCustomerCategoryService.saveOrUpdate((Object)customerCategoryEntity, false);
        CustomerEntity customerEntity = new CustomerEntity();
        customerEntity.setId(IdWorker.getId());
        customerEntity.setSocialCreditCode(vo.getSocialCreditCode());
        customerEntity.setCode("CUS-" + customerEntity.getId());
        customerEntity.setName(vo.getName());
        customerEntity.setCategoryId(customerCategoryEntity.getId());
        customerEntity.setTenantId(vo.getTenantId());
        customerEntity.setLegal(vo.getLegalName());
        customerEntity.setTelephone(vo.getTelephone());
        customerEntity.setDescription("\u7cfb\u7edf\u521b\u5efa!");
        this.iCustomerService.saveOrUpdate((Object)customerEntity, false);
        SupplierCategoryEntity supplierCategoryEntity = new SupplierCategoryEntity();
        supplierCategoryEntity.setId(IdWorker.getId());
        supplierCategoryEntity.setCode("SPC-" + supplierCategoryEntity.getId());
        supplierCategoryEntity.setTenantId(vo.getTenantId());
        supplierCategoryEntity.setDescription("\u7cfb\u7edf\u521b\u5efa!");
        supplierCategoryEntity.setInnerCode(supplierCategoryEntity.getId().toString());
        supplierCategoryEntity.setName("\u5185\u90e8\u4f9b\u5e94\u5546");
        supplierCategoryEntity.setSequence(1);
        this.iSupplierCategoryService.saveOrUpdate((Object)supplierCategoryEntity, false);
        SupplierEntity supplierEntity = new SupplierEntity();
        supplierEntity.setId(IdWorker.getId());
        supplierEntity.setSocialCreditCode(vo.getSocialCreditCode());
        supplierEntity.setCategoryId(supplierCategoryEntity.getId());
        supplierEntity.setCode("SP-" + supplierEntity.getId());
        supplierEntity.setTenantId(vo.getTenantId());
        supplierEntity.setName(vo.getName());
        supplierEntity.setLegal(vo.getLegalName());
        supplierEntity.setTelephone(vo.getTelephone());
        supplierEntity.setDescription("\u7cfb\u7edf\u521b\u5efa!");
        supplierEntity.setEnabled(1);
        this.iSupplierService.saveOrUpdate((Object)supplierEntity, false);
    }

    @Override
    public void rollBack(Long tenantId) {
        List customerEntities;
        List customerCategoryEntities;
        List supplierEntityList;
        if (this.isNotAdmin().booleanValue()) {
            throw new BusinessException("\u65e0\u6743\u64cd\u4f5c!");
        }
        if (tenantId == null) {
            throw new BusinessException("\u79df\u6237id\u4e0d\u5b58\u5728!");
        }
        this.initMapper.dropThreeTables(tenantId);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)tenantId));
        List s = this.iSupplierCategoryService.queryList(queryParam, false);
        if (ListUtil.isNotEmpty((List)s)) {
            this.iSupplierCategoryService.removeByIds(s.stream().map(BaseEntity::getId).collect(Collectors.toList()));
        }
        if (ListUtil.isNotEmpty((List)(supplierEntityList = this.iSupplierService.queryList(queryParam, false)))) {
            this.iSupplierService.removeByIds(supplierEntityList.stream().map(BaseEntity::getId).collect(Collectors.toList()));
        }
        if (ListUtil.isNotEmpty((List)(customerCategoryEntities = this.iCustomerCategoryService.queryList(queryParam, false)))) {
            this.iCustomerCategoryService.removeByIds(customerCategoryEntities.stream().map(BaseEntity::getId).collect(Collectors.toList()));
        }
        if (ListUtil.isNotEmpty((List)(customerEntities = this.iCustomerService.queryList(queryParam, false)))) {
            this.iCustomerService.removeByIds(customerEntities.stream().map(BaseEntity::getId).collect(Collectors.toList()));
        }
    }

    public Boolean isNotAdmin() {
        return !InvocationInfoProxy.getTenantid().equals(999999L);
    }
}

