/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.bean.PriceDepotParamSetEntity;
import com.ejianc.foundation.share.consts.PrinceDepotEnum;
import com.ejianc.foundation.share.service.IpriceDepotParamSetService;
import com.ejianc.foundation.share.utils.TreeNodeBUtil;
import com.ejianc.foundation.share.vo.PriceDepotParamSetVO;
import com.ejianc.foundation.share.vo.dto.PriceDepotParamSetDTO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"priceDepotParamSet"})
public class PriceDepotParamSetController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IpriceDepotParamSetService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PriceDepotParamSetVO> saveOrUpdate(@RequestBody PriceDepotParamSetVO saveOrUpdateVO) {
        BillCodeParam billCodeParam;
        CommonResponse billCode;
        PriceDepotParamSetEntity entity = (PriceDepotParamSetEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, PriceDepotParamSetEntity.class));
        if (!(entity.getId() != null && entity.getId() != 0L || (billCode = this.billCodeApi.generateBillCode(billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO))).isSuccess())) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        this.service.saveOrUpdate((Object)entity, false);
        PriceDepotParamSetVO vo = (PriceDepotParamSetVO)BeanMapper.map((Object)((Object)entity), PriceDepotParamSetVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PriceDepotParamSetVO> queryDetail(Long id) {
        PriceDepotParamSetEntity entity = (PriceDepotParamSetEntity)((Object)this.service.selectById(id));
        PriceDepotParamSetVO vo = (PriceDepotParamSetVO)BeanMapper.map((Object)((Object)entity), PriceDepotParamSetVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PriceDepotParamSetVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (PriceDepotParamSetVO priceDepotParamSetVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PriceDepotParamSetVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("leafFlag", new Parameter("eq", (Object)0));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List records = page.getRecords();
        List parentIds = records.stream().map(BaseEntity::getId).collect(Collectors.toList());
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("leafFlag", new Parameter("eq", (Object)1));
        queryParam.getParams().put("parentId", new Parameter("in", parentIds));
        List priceDepotParamSetEntities = this.service.queryList(queryParam);
        records.addAll(priceDepotParamSetEntities);
        List priceDepotParamSetVOS = BeanMapper.mapList((Iterable)records, PriceDepotParamSetVO.class);
        for (PriceDepotParamSetVO record : priceDepotParamSetVOS) {
            record.setTid(record.getId().toString());
            record.setTpid(record.getParentId() != null && record.getParentId() > 0L ? record.getParentId().toString() : "");
            if (record.getSource() == 1) {
                record.setSourceName("\u5408\u540c");
            }
            if (record.getSource() == 2) {
                record.setSourceName("\u7ed3\u7b97");
            }
            if (record.getSource() == 3) {
                record.setSourceName("\u9a8c\u6536");
            }
            if (PrinceDepotEnum.getByCode((Integer)record.getPriceDepotType()) == null) continue;
            String priceDepotTypeName = PrinceDepotEnum.getByCode((Integer)record.getPriceDepotType()).getName();
            record.setPriceDepotTypeName(priceDepotTypeName);
        }
        priceDepotParamSetVOS = TreeNodeBUtil.buildTree((List)priceDepotParamSetVOS);
        pageData.setRecords(priceDepotParamSetVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("priceDepotParamSet-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refpriceDepotParamSetData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<PriceDepotParamSetVO>> refpriceDepotParamSetData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PriceDepotParamSetVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/modifyParentContent"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PriceDepotParamSetVO> modifyParentContent(@RequestBody PriceDepotParamSetVO priceDepotParamSetVo) {
        LambdaUpdateWrapper updateParentWrapper = new LambdaUpdateWrapper();
        updateParentWrapper.set(PriceDepotParamSetEntity::getCycle, (Object)priceDepotParamSetVo.getCycle());
        updateParentWrapper.set(PriceDepotParamSetEntity::getSource, (Object)priceDepotParamSetVo.getSource());
        updateParentWrapper.eq(BaseEntity::getId, (Object)priceDepotParamSetVo.getId());
        updateParentWrapper.or();
        updateParentWrapper.eq(PriceDepotParamSetEntity::getParentId, (Object)priceDepotParamSetVo.getId());
        this.service.update((Wrapper)updateParentWrapper);
        PriceDepotParamSetEntity entity = (PriceDepotParamSetEntity)((Object)BeanMapper.map((Object)priceDepotParamSetVo, PriceDepotParamSetEntity.class));
        PriceDepotParamSetVO vo = (PriceDepotParamSetVO)BeanMapper.map((Object)((Object)entity), PriceDepotParamSetVO.class);
        return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/saveOrUpdateChildrenContent"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PriceDepotParamSetVO> saveOrUpdateChildrenContent(@RequestBody PriceDepotParamSetVO priceDepotParamSetVo) {
        PriceDepotParamSetEntity entity = (PriceDepotParamSetEntity)((Object)BeanMapper.map((Object)priceDepotParamSetVo, PriceDepotParamSetEntity.class));
        if (entity.getId() == null) {
            this.service.saveOrUpdate((Object)entity);
        } else {
            LambdaUpdateWrapper updateParentWrapper = new LambdaUpdateWrapper();
            updateParentWrapper.eq(BaseEntity::getId, (Object)priceDepotParamSetVo.getId());
            updateParentWrapper.set(PriceDepotParamSetEntity::getSource, (Object)priceDepotParamSetVo.getSource());
            updateParentWrapper.set(PriceDepotParamSetEntity::getCategoryId, (Object)priceDepotParamSetVo.getCategoryId());
            updateParentWrapper.set(PriceDepotParamSetEntity::getCategoryName, (Object)priceDepotParamSetVo.getCategoryName());
            this.service.update((Wrapper)updateParentWrapper);
        }
        PriceDepotParamSetVO vo = (PriceDepotParamSetVO)BeanMapper.map((Object)((Object)entity), PriceDepotParamSetVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u4fee\u6539\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryPriceDepotParamSetList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<PriceDepotParamSetDTO>> queryPriceDepotParamSetList(@RequestBody PriceDepotParamSetVO priceDepotParamSetVO) {
        ArrayList<PriceDepotParamSetDTO> priceDepotParamSetList = new ArrayList<PriceDepotParamSetDTO>();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        queryWrapper.eq((Object)"price_depot_type", (Object)priceDepotParamSetVO.getPriceDepotType());
        queryWrapper.eq((Object)"leaf_flag", (Object)new Parameter("eq", (Object)0));
        PriceDepotParamSetEntity priceDepotParamSetEntity = (PriceDepotParamSetEntity)((Object)this.service.getOne((Wrapper)queryWrapper));
        if (priceDepotParamSetEntity != null && CollectionUtils.isNotEmpty((Collection)priceDepotParamSetVO.getMaterialTypeIdList())) {
            Long id = priceDepotParamSetEntity.getId();
            QueryWrapper paramSetEntityQueryWrapper = new QueryWrapper();
            paramSetEntityQueryWrapper.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
            paramSetEntityQueryWrapper.eq((Object)"price_depot_type", (Object)priceDepotParamSetVO.getPriceDepotType());
            paramSetEntityQueryWrapper.eq((Object)"parent_id", (Object)priceDepotParamSetEntity.getId());
            List list = this.service.list((Wrapper)paramSetEntityQueryWrapper);
            HashMap<Long, Integer> sourceMap = new HashMap<Long, Integer>();
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                for (PriceDepotParamSetEntity depotParamSetEntity : list) {
                    String[] categoryIdArray;
                    if (!StringUtils.isNotBlank((CharSequence)depotParamSetEntity.getCategoryId())) continue;
                    for (String categoryId : categoryIdArray = depotParamSetEntity.getCategoryId().split(",")) {
                        sourceMap.put(Long.parseLong(categoryId), depotParamSetEntity.getSource());
                    }
                }
            }
            for (Long materialTypeId : priceDepotParamSetVO.getMaterialTypeIdList()) {
                PriceDepotParamSetDTO vo;
                if (sourceMap.containsKey(materialTypeId)) {
                    vo = new PriceDepotParamSetDTO();
                    vo.setCategoryId(materialTypeId.toString());
                    vo.setSource((Integer)sourceMap.get(materialTypeId));
                    priceDepotParamSetList.add(vo);
                    continue;
                }
                vo = new PriceDepotParamSetDTO();
                vo.setCategoryId(materialTypeId.toString());
                vo.setSource(priceDepotParamSetEntity.getSource());
                priceDepotParamSetList.add(vo);
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", priceDepotParamSetList);
    }
}

