/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.service.impl;

import com.ejianc.foundation.share.bean.MaterialCategoryEntity;
import com.ejianc.foundation.share.bean.MaterialEntity;
import com.ejianc.foundation.share.mapper.MaterialCategoryMapper;
import com.ejianc.foundation.share.service.IMaterialCategoryService;
import com.ejianc.foundation.share.service.IMaterialService;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MaterialCategoryServiceImpl
implements IMaterialCategoryService {
    @Autowired
    private MaterialCategoryMapper materialCategoryMapper;
    @Autowired
    private IMaterialService materialService;

    @Override
    public List<MaterialCategoryEntity> queryList(QueryParam queryParam) {
        Map paramMap = queryParam.getParams();
        HashMap<String, Object> condition = new HashMap<String, Object>();
        for (Map.Entry entry : paramMap.entrySet()) {
            condition.put((String)entry.getKey(), ((Parameter)entry.getValue()).getValue());
        }
        condition.put("tenantId", InvocationInfoProxy.getTenantid());
        List<MaterialCategoryEntity> resultList = this.materialCategoryMapper.queryList(condition);
        return resultList;
    }

    @Override
    public MaterialCategoryVO queryDetail(Long id) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MaterialCategoryEntity entity = this.materialCategoryMapper.queryDetail(tenantId, id);
        if (entity != null) {
            return (MaterialCategoryVO)BeanMapper.map((Object)entity, MaterialCategoryVO.class);
        }
        return null;
    }

    @Override
    public void update(MaterialCategoryEntity entity) {
        this.materialCategoryMapper.update(entity);
        Long tenantId = InvocationInfoProxy.getTenantid();
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(entity.getId());
        List<MaterialCategoryEntity> materialCategoryEntities = this.materialCategoryMapper.queryByInnerCodes(tenantId, ids);
        ids.clear();
        materialCategoryEntities.forEach(item -> {
            ids.add(item.getId());
            this.materialService.updateByCategoryId(item.getId(), entity.getSubjectId(), entity.getSubjectName());
        });
        this.materialCategoryMapper.updateSubject(tenantId, entity.getSubjectId(), entity.getSubjectName(), ids);
    }

    @Override
    public void updateSubject(Long subjectId, String subjectName, List<Long> ids) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<MaterialCategoryEntity> materialCategoryEntities = this.materialCategoryMapper.queryByInnerCodes(tenantId, ids);
        ids.clear();
        materialCategoryEntities.forEach(item -> {
            ids.add(item.getId());
            this.materialService.updateByCategoryId(item.getId(), subjectId, subjectName);
        });
        this.materialCategoryMapper.updateSubject(tenantId, subjectId, subjectName, ids);
    }

    @Override
    public void save(MaterialCategoryEntity entity) {
        this.materialCategoryMapper.insert(entity);
    }

    @Override
    public void insertBatch(List<MaterialCategoryEntity> categoryEntityList) {
        if (ListUtil.isNotEmpty(categoryEntityList)) {
            ArrayList<MaterialCategoryEntity> toInsert = new ArrayList<MaterialCategoryEntity>();
            for (MaterialCategoryEntity entity : categoryEntityList) {
                if (toInsert.size() > 0 && toInsert.size() % 1000 == 0) {
                    this.materialCategoryMapper.insertBatch(InvocationInfoProxy.getTenantid(), toInsert);
                    toInsert = new ArrayList();
                }
                toInsert.add(entity);
            }
            if (toInsert.size() > 0) {
                this.materialCategoryMapper.insertBatch(InvocationInfoProxy.getTenantid(), toInsert);
            }
        }
    }

    @Override
    public void insertBatch(List<MaterialCategoryEntity> categoryEntityList, Long tenantId) {
        if (ListUtil.isNotEmpty(categoryEntityList)) {
            ArrayList<MaterialCategoryEntity> toInsert = new ArrayList<MaterialCategoryEntity>();
            for (MaterialCategoryEntity entity : categoryEntityList) {
                if (toInsert.size() > 0 && toInsert.size() % 1000 == 0) {
                    this.materialCategoryMapper.insertBatch(tenantId, toInsert);
                    toInsert = new ArrayList();
                }
                toInsert.add(entity);
            }
            if (toInsert.size() > 0) {
                this.materialCategoryMapper.insertBatch(tenantId, toInsert);
            }
        }
    }

    @Override
    public List<MaterialCategoryVO> queryListByPid(Long id) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<MaterialCategoryEntity> materialCategoryList = this.materialCategoryMapper.queryListByPid(tenantId, id);
        if (materialCategoryList != null && materialCategoryList.size() > 0) {
            return BeanMapper.mapList(materialCategoryList, MaterialCategoryVO.class);
        }
        return null;
    }

    @Override
    public List<MaterialCategoryVO> queryListAllByPid(Long id) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<MaterialCategoryEntity> materialCategoryList = this.materialCategoryMapper.queryListAllByPid(tenantId, id);
        if (materialCategoryList != null && materialCategoryList.size() > 0) {
            return BeanMapper.mapList(materialCategoryList, MaterialCategoryVO.class);
        }
        return null;
    }

    @Override
    public void delete(Long id) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        this.materialCategoryMapper.delete(tenantId, id);
    }

    @Override
    public void updateEnabled(Integer enabled, Long tenantId, String innerCode) {
        this.materialCategoryMapper.updateEnabled(enabled, tenantId, innerCode);
    }

    @Override
    public List<MaterialCategoryEntity> queryByCode(String code) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        return this.materialCategoryMapper.queryByCode(tenantId, code);
    }

    @Override
    public List<MaterialCategoryEntity> queryByName(String name) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        return this.materialCategoryMapper.queryByName(tenantId, name);
    }

    @Override
    public void insertCategoryListFromPlatform() {
        Long tenantId = InvocationInfoProxy.getTenantid();
        this.materialCategoryMapper.insertCategoryListFromPlatform(tenantId);
    }

    @Override
    public List<MaterialCategoryVO> queryListTree(Map<String, Object> params) {
        List<MaterialCategoryEntity> materialCategoryList = this.materialCategoryMapper.queryListTree(params);
        if (materialCategoryList != null && materialCategoryList.size() > 0) {
            return BeanMapper.mapList(materialCategoryList, MaterialCategoryVO.class);
        }
        return null;
    }

    @Override
    public List<MaterialCategoryEntity> queryListEntityTree(Map<String, Object> params) {
        List<MaterialCategoryEntity> materialCategoryList = this.materialCategoryMapper.queryListTree(params);
        return materialCategoryList;
    }

    @Override
    public List<MaterialCategoryEntity> queryCategoryListByCodes(List<String> codeList) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        Long tenantId = InvocationInfoProxy.getTenantid();
        params.put("tenantId", tenantId);
        params.put("codeList", codeList);
        List<MaterialCategoryEntity> list = this.materialCategoryMapper.queryListByCodes(params);
        return list;
    }

    @Override
    public List<MaterialCategoryEntity> queryCategoryListByCodes(List<String> codeList, Long tenantId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tenantId", tenantId);
        params.put("codeList", codeList);
        List<MaterialCategoryEntity> list = this.materialCategoryMapper.queryListByCodes(params);
        return list;
    }

    @Override
    public MaterialCategoryVO queryBySourceId(String sourceId) {
        MaterialCategoryEntity entity = this.materialCategoryMapper.queryBySourceId(sourceId, InvocationInfoProxy.getTenantid());
        if (entity != null && entity.getId() != null) {
            return (MaterialCategoryVO)BeanMapper.map((Object)entity, MaterialCategoryVO.class);
        }
        return null;
    }

    @Override
    public List<MaterialCategoryVO> queryListByInnerCode(Map<String, Object> params) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        params.put("tenantId", tenantId);
        List<MaterialCategoryEntity> materialCategoryList = this.materialCategoryMapper.queryListByInnerCode(params);
        if (materialCategoryList != null && materialCategoryList.size() > 0) {
            return BeanMapper.mapList(materialCategoryList, MaterialCategoryVO.class);
        }
        return null;
    }

    @Override
    public List<MaterialCategoryVO> queryCategoryListByChildren(List<Long> ids) {
        ArrayList<MaterialCategoryVO> result = new ArrayList<MaterialCategoryVO>();
        HashMap<String, Object> params = new HashMap<String, Object>();
        Long tenantId = InvocationInfoProxy.getTenantid();
        params.put("tenantId", tenantId);
        List<MaterialCategoryEntity> materialCategoryList = this.materialCategoryMapper.queryListTree(params);
        if (materialCategoryList != null && materialCategoryList.size() > 0) {
            HashSet<Long> keySet = new HashSet<Long>();
            List materialCategoryVOS = BeanMapper.mapList(materialCategoryList, MaterialCategoryVO.class);
            Map categoryVOMap = materialCategoryVOS.stream().collect(Collectors.toMap(MaterialCategoryVO::getId, Function.identity(), (key1, key2) -> key2));
            for (Long id : ids) {
                String[] keyArray;
                MaterialCategoryVO categoryVO = (MaterialCategoryVO)categoryVOMap.get(id);
                String innerCode = categoryVO.getInnerCode();
                for (String keyStr : keyArray = innerCode.split("\\|")) {
                    Long key = Long.valueOf(keyStr);
                    if (keySet.contains(key)) continue;
                    keySet.add(key);
                    result.add((MaterialCategoryVO)categoryVOMap.get(key));
                }
            }
        }
        return result;
    }

    @Override
    public Map<Long, List<MaterialCategoryVO>> queryCategoryListByMaterialId(List<Long> ids) {
        List<MaterialEntity> materialEntityList = this.materialService.queryMaterialByIds(ids);
        HashMap<Long, List<MaterialCategoryVO>> resMap = new HashMap<Long, List<MaterialCategoryVO>>();
        HashMap<String, Object> params = new HashMap<String, Object>();
        Long tenantId = InvocationInfoProxy.getTenantid();
        params.put("tenantId", tenantId);
        List<MaterialCategoryEntity> materialCategoryList = this.materialCategoryMapper.queryListTree(params);
        if (materialCategoryList != null && materialCategoryList.size() > 0) {
            List materialCategoryVOS = BeanMapper.mapList(materialCategoryList, MaterialCategoryVO.class);
            Map categoryVOMap = materialCategoryVOS.stream().collect(Collectors.toMap(MaterialCategoryVO::getId, Function.identity(), (key1, key2) -> key2));
            for (MaterialEntity mentity : materialEntityList) {
                Long categoryId = mentity.getCategoryId();
                MaterialCategoryVO categoryVO = (MaterialCategoryVO)categoryVOMap.get(categoryId);
                String innerCode = categoryVO.getInnerCode();
                String[] keyArray = innerCode.split("\\|");
                ArrayList result = new ArrayList();
                for (int i = keyArray.length - 1; i >= 0; --i) {
                    Long key = Long.valueOf(keyArray[i]);
                    result.add(categoryVOMap.get(key));
                }
                resMap.put(mentity.getId(), result);
            }
        }
        return resMap;
    }

    @Override
    public List<MaterialCategoryVO> queryCategoryListByIds(List<Long> ids) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        Long tenantId = InvocationInfoProxy.getTenantid();
        params.put("tenantId", tenantId);
        params.put("ids", ids);
        List<MaterialCategoryEntity> materialCategoryList = this.materialCategoryMapper.queryListByIds(params);
        if (materialCategoryList != null && materialCategoryList.size() > 0) {
            return BeanMapper.mapList(materialCategoryList, MaterialCategoryVO.class);
        }
        return null;
    }

    @Override
    public void delete(List<Long> ids) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        for (Long id : ids) {
            this.materialCategoryMapper.delete(tenantId, id);
        }
    }
}

