package com.ejianc.foundation.share.controller.api;

import com.ejianc.foundation.share.bean.FinancialOrgEntity;
import com.ejianc.foundation.share.service.IFinancialOrgService;
import com.ejianc.foundation.share.vo.FinancialOrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/api/financialOrgApi/")
public class FinancialOrgApi {

    @Autowired
    private IFinancialOrgService financialService;

    /**
     *
     * @Author
     * @param
     * @return
     */
    @GetMapping("queryFinancialOrgTree")
    public CommonResponse<List<FinancialOrgVO>> queryFinancialOrgTree() {
        QueryParam param = new QueryParam();
        param.getParams().put("enabled", new Parameter(QueryParam.EQ, 1));
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("code", "asc");
        List<FinancialOrgEntity> list = financialService.queryList(param,false);
        List<FinancialOrgVO> voList = BeanMapper.mapList(list, FinancialOrgVO.class);
        return CommonResponse.success("查询成功！", voList);
    }

    /**
     * 查询
     * @param param
     * @return
     */
    @PostMapping("queryFinancialOrg")
    @ResponseBody
    public CommonResponse<List<FinancialOrgVO>> queryFinancialOrg(@RequestBody QueryParam param) {
        param.getParams().put("enabled", new Parameter(QueryParam.EQ, 1));
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("code", "asc");
        List<FinancialOrgEntity> list = financialService.queryList(param,false);
        List<FinancialOrgVO> voList = BeanMapper.mapList(list, FinancialOrgVO.class);
        return CommonResponse.success("查询成功！", voList);
    }

    /**
     * 查询
     * @param name
     * @return
     */
    @GetMapping("queryFinancialOrgIds")
    public CommonResponse<List<Long>> queryFinancialOrgIds(@RequestParam String name) {
        List<Long> longs = financialService.queryFinancialOrgIds(name);
        return CommonResponse.success("查询成功！", longs);
    }
}
