package com.ejianc.foundation.share.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.share.bean.CooperateEntity;
import com.ejianc.foundation.share.mapper.CooperateMapper;
import com.ejianc.foundation.share.service.ICooperateService;
import com.ejianc.foundation.share.vo.CooperateVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.stereotype.Service;

/**
 * 协同设置
 * 
 * @author generator
 * 
 */
@Service("cooperateService")
public class CooperateServiceImpl extends BaseServiceImpl<CooperateMapper, CooperateEntity> implements ICooperateService{

    @Override
    public CooperateVO queryCooperateByBillTypeCode(String billTypeCode) {
        QueryWrapper<CooperateEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("bill_type_code",billTypeCode);
        CooperateEntity cooperateEntity = super.getOne(queryWrapper);
        CooperateVO vo = null;
        if (cooperateEntity != null){
            vo = BeanMapper.map(cooperateEntity, CooperateVO.class);
        }
        return vo;
    }
}
