package com.ejianc.foundation.share.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.share.bean.EquipmentCategoryEntity;
import com.ejianc.foundation.share.bean.MaterialCategoryEntity;
import com.ejianc.foundation.share.mapper.EquipmentCategoryMapper;
import com.ejianc.foundation.share.mapper.MaterialCategoryMapper;
import com.ejianc.foundation.share.service.IEquipmentCategoryService;
import com.ejianc.foundation.share.service.IMaterialService;
import com.ejianc.foundation.share.vo.EquipmentCategoryVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.google.gson.JsonObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class EquipmentCategoryServiceImpl implements IEquipmentCategoryService {
	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private EquipmentCategoryMapper equipmentCategoryMapper;
	@Autowired
	private MaterialCategoryMapper materialCategoryMapper;
	@Autowired
	private IMaterialService materialService;

	@Override
	public List<EquipmentCategoryEntity> queryList(QueryParam queryParam) {
		Map<String, Parameter> paramMap = queryParam.getParams();

		Map<String,Object> condition = new HashMap<String, Object>();
		for(Map.Entry<String, Parameter> entry:paramMap.entrySet()) {
			condition.put(entry.getKey(), entry.getValue().getValue());
		}
		//放入租户ID进map
		condition.put("tenantId", InvocationInfoProxy.getTenantid());
		List<EquipmentCategoryEntity> resultList = equipmentCategoryMapper.queryList(condition);
		return resultList;
	}


	@Override
	public EquipmentCategoryVO queryDetail(Long id) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		EquipmentCategoryEntity entity = equipmentCategoryMapper.queryDetail(tenantId, id);
		if(entity != null) {
			return BeanMapper.map(entity, EquipmentCategoryVO.class);
		}
		return null;
	}


	@Override
	public void update(EquipmentCategoryEntity entity) {
		equipmentCategoryMapper.update(entity);
		Long tenantId = InvocationInfoProxy.getTenantid();
		List<Long> ids = new ArrayList<>();
		ids.add(entity.getId());
		List<MaterialCategoryEntity> materialCategoryEntities = materialCategoryMapper.queryByInnerCodes(tenantId,ids);
		ids.clear();
		materialCategoryEntities.forEach(item->{
			ids.add(item.getId());
			// 更新字表的数据
			materialService.updateByCategoryId(item.getId(),entity.getSubjectId(),entity.getSubjectName());
		});
		materialCategoryMapper.updateSubject(tenantId,entity.getSubjectId(),entity.getSubjectName(),ids);
	}


	@Override
	public void save(EquipmentCategoryEntity entity) {
		equipmentCategoryMapper.insert(entity);
	}

	/**
	 * 批量新增
	 *
	 * @param categoryEntityList
	 */
	@Override
	public void insertBatch(List<EquipmentCategoryEntity> categoryEntityList) {
		if(ListUtil.isNotEmpty(categoryEntityList)){
			List<EquipmentCategoryEntity> toInsert = new ArrayList<>();
			for (EquipmentCategoryEntity entity : categoryEntityList){
				if (toInsert.size()>0 && toInsert.size() % 1000 == 0) {
					equipmentCategoryMapper.insertBatch(InvocationInfoProxy.getTenantid(),toInsert);
					toInsert = new ArrayList<>();
				}
				toInsert.add(entity);
			}
			if(toInsert.size()>0){
				equipmentCategoryMapper.insertBatch(InvocationInfoProxy.getTenantid(),toInsert);
			}
		}
	}


	@Override
	public List<EquipmentCategoryVO> queryListByPid(Long id) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		List<EquipmentCategoryEntity> EquipmentCategoryList = equipmentCategoryMapper.queryListByPid(tenantId, id);
		if(EquipmentCategoryList != null && EquipmentCategoryList.size() > 0) {
			return BeanMapper.mapList(EquipmentCategoryList, EquipmentCategoryVO.class);
		}
		return null;
	}


	@Override
	public void delete(Long id) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		equipmentCategoryMapper.delete(tenantId,id);
	}


	@Override
	public void updateEnabled(Integer enabled, Long tenantId, String innerCode) {
		equipmentCategoryMapper.updateEnabled(enabled,tenantId,innerCode);
	}


	@Override
	public List<EquipmentCategoryEntity> queryByCode(String code) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		List<EquipmentCategoryEntity> EquipmentCategoryVo = equipmentCategoryMapper.queryByCode(tenantId, code);
		return EquipmentCategoryVo;
	}

	@Override
	public List<EquipmentCategoryEntity>  queryByName(String name) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		return equipmentCategoryMapper.queryByName(tenantId, name);
	}


	@Override
	public void insertCategoryListFromPlatform() {
		Long tenantId = InvocationInfoProxy.getTenantid();
		equipmentCategoryMapper.insertCategoryListFromPlatform(tenantId);
	}


	@Override
	public List<EquipmentCategoryVO> queryListTree(Map<String, Object> params) {
		List<EquipmentCategoryEntity> dataList = equipmentCategoryMapper.queryListTree(params);
		if(dataList != null && dataList.size() > 0) {
			return BeanMapper.mapList(dataList, EquipmentCategoryVO.class);
		}
		return null;
	}

	@Override
	public List<EquipmentCategoryVO> queryCategoryListByIds(List<Long> ids) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		List<EquipmentCategoryEntity> EquipmentCategoryList = equipmentCategoryMapper.queryCategoryListByIds(tenantId, ids);
		if(EquipmentCategoryList != null && EquipmentCategoryList.size() > 0) {
			return BeanMapper.mapList(EquipmentCategoryList, EquipmentCategoryVO.class);
		}
		return null;
	}

	@Override
	public void delete(List<Long> ids) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		for(Long id:ids) {
			equipmentCategoryMapper.delete(tenantId, id);
		}
	}

}
